(ns degree9.es6
  (:refer-clojure :exclude [class])
  (:require [cljs.analyzer :as ana]
            [cljs.compiler :as compiler]))

;; Native ES6 Class compiler extension ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(alter-var-root #'ana/specials #(conj % 'class* 'method* 'super*))

(defmethod ana/parse 'class*
  [op env [_ class extends ctor methods :as form] _ _]
  (let [methods (map (fn [[method params & body]] {:method method :params params :body body}) methods)]
    (prn methods)
    {:env env
     :op :class
     :children [:methods]
     :methods (ana/disallowing-recur
                 (->> (rest methods)
                      (mapv #(ana/analyze (assoc env :context :method) %))))
     :ctor (ana/disallowing-recur
                 (->> (first methods)
                      (mapv #(ana/analyze (assoc env :context :constructor) %))))
     :extends extends
     :form form
     :class class}))

(defmethod compiler/emit* :class
  [{:keys [ctor methods class extends]}]
  (let [[_ args & ctor] ctor
        extends    (when extends (str " extends " extends))]
    (compiler/emitln "class " class extends " {")
    (compiler/emitln "constructor( " (interpose "," (map compiler/munge args)) ") {")
    (doseq [c ctor]
      (compiler/emitln c))
    (compiler/emits "}")
    ; (doseq [m methods]
    ;   (compiler/emitln m))
    (compiler/emits "}")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ES6 Class API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro class
  "Create a named or unnamed javascript class. (es6+)"
  ([constructor-fn]
   (class constructor-fn {}))
  ([constructor-fn method-map]
   (class `(gen-sym) constructor-fn method-map))
  ([name constructor-fn method-map]
   (class name nil constructor-fn method-map))
  ([name extends constructor-fn method-map]
   `(~'class* ~name ~extends ~constructor-fn ~method-map)))

(defmacro defclass
  "Define a named javascript class. (es6+)"
  ([name & body]
   (let [extends (:extends body)]
     `(prn ~extends))))
     ;`(def ~name (~'class ~name ~extends ~ctor ~@body)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
