(ns degree9.es6
  (:require [cljs.analyzer :as ana]
            [cljs.compiler :as compiler]))

;; Native ES6 Class compiler extension ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(alter-var-root #'ana/specials #(conj % 'es6class*))

(defmethod ana/parse 'es6class*
  [op env [_ expr :as form] _ _]
  {:env env
   :op :es6class
   :children [:expr]
   :expr (ana/analyze env expr)
   :form form})

(defmethod compiler/emit* :es6class
  [{:keys [env expr]}]
  (compiler/emits "class ")
  (compiler/emits "{")
  (compiler/emits
    (assoc-in expr [:env :context] :expr))
  (compiler/emits "{"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Public Async/Await API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro defclass
  "Wraps body in native es6 class block."
  [& body]
  `(~'es6class* ~@body))
