(ns degree9.object
  (:refer-clojure :exclude [get get-in])
  (:require [goog.object :as obj]))

(defn get [m k & [default]]
  (obj/get m (name k) default))

(defn get-in [m ks & [default]]
  (let [getValueByKeys (partial obj/getValueByKeys m)]
    (or (apply getValueByKeys (map name ks)) default)))

(defn set [m k v]
  (obj/set m (name k) v))

(defn set-in [m [k & ks] v]
  (when-let [m (get m k)]
    (if (empty? (rest ks)) (set m k v) (set-in m ks v))))
