(ns degree9.service
  "A microservice proxy via websockets."
  (:require ["socket.io-client" :as io]
            ["@feathersjs/feathers" :as feathers]
            ["@feathersjs/socketio-client" :as socketio]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.debug :as dbg]))

(dbg/defdebug debug "degree9:enterprise:service")

(defn wsclient
  "Configure feathers socket.io client"
  [client socket]
  (debug "Configure feathers socket.io client")
  (doto client
    (.configure (socketio socket))))

(defn µservice [uri service & [opts]]
  (let [client (:client opts (feathers))
        conf   (clj->js opts)
        socket (io uri conf)]
    (debug "Initializing remote microservice at %s with %s" uri conf)
    (reify
      Object
      (id [this] (:id opts "id"))
      (setup [this app path]
        (let [proxy (wsclient client socket)]
          ;(debug "Setup remote service to uri" service)
          (obj/set this "socketio" (.service socket service))))
      (find [this params]
        (.find (obj/get this "socketio") params))
      (get [this id params]
        (.get (obj/get this "socketio") id params))
      (create [this data params]
        (.create (obj/get this "socketio") data params))
      (update [this id data params]
        (.update (obj/get this "socketio") id data params))
      (patch [this id data params]
        (.patch (obj/get this "socketio") id data params))
      (remove [this id params]
        (.remove (obj/get this "socketio") id params)))))

(defn api
  "Mount a remote Microservice to a local endpoint."
  ([app path uri service hooks])
  ([app path uri service hooks]
   (debug "Mount remote microservice at %s" path)
   (server/api app path (µservice uri service opts) hooks)))
