(ns degree9.service
 (:require ["socket.io-client" :as io]
           ["@feathersjs/feathers" :as feathers]
           ["@feathersjs/socketio-client" :as socketio]
           [meta.server :as server]
           [degree9.debug :as dbg]))

(dbg/defdebug debug "degree9:enterprise:service")

(defn mksocket
  "Create a websocket connection to remote microservice."
  [client uri]
  (debug "Create websocket connection to remote microservice at %s" uri)
  (let [socket (io uri)]
    (doto client
      (.configure (socketio socket)))))

(defn µservice [uri service]
  (debug "Initializing Remote Microservice at %s/%s" uri service)
  (let [client (feathers)
        proxy (.service (mksocket client uri) service)]
    (reify
      Object
      ;(id [this] "id")
      (setup [this app path]
        (obj/set this "remote"
          (client/service (connection uri) service)))
      (find [this params]
        (svc/find (obj/get this "remote") params))
      (get [this id params]
        (svc/get (obj/get this "remote") id params))
      (create [this data params]
        (svc/create (obj/get this "remote") data params))
      (update [this id data params]
        (svc/update (obj/get this "remote") id data params))
      (patch [this id data params]
        (svc/patch (obj/get this "remote") id data params))
      (remove [this id params]
        (svc/remove (obj/get this "remote") id params)))))

(defn api
  "Mount a remote Microservice to a local endpoint."
  [app path uri service hooks]
  (debug "Mount Remote Microservice at %s" path)
  (server/api app path (µservice uri service) hooks))
