(ns degree9.paysafe.cards
  (:require [degree9.env :as env]
            [clojure.string :as cstr]
            [degree9.paysafe.core :as ps]))

;; Card Payments API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn cardpayments-url [& paths]
  (cstr/join "/" (into ["cardpayments/v1/accounts" (env/get "PAYSAFE_ACCOUNT_ID")] paths)))

(defn create-authorization [data & [opts]]
  (ps/post (cardpayments-url "auths") data opts))

(defn get-authorization [id & [opts]]
  (ps/get (cardpayments-url "auths" id) opts))

(defn update-authorization [id data & [opts]]
  (ps/put (cardpayments-url "auths" id) data opts))

(defn void-authorization [id data & [opts]]
  (ps/post (cardpayments-url "auths" id "voidauths") data opts))

(defn get-void-authorization [id & [opts]]
  (ps/get (cardpayments-url "voidauths" id) opts))

(defn settle-authorization [id data & [opts]]
  (ps/post (cardpayments-url "auths" id "settlements") data opts))

(defn get-settlement [id]
  (ps/get (cardpayments-url "settlements" id) opts))

(defn cancel-settlement [id data]
  (ps/put (cardpayments-url "settlements" id) data opts))

(defn submit-refund [id data]
  (ps/post (cardpayments-url "settlements" id "refunds") data opts))

(defn get-refund [id]
  (ps/get (cardpayments-url "refunds" id) opts))

(defn cancel-refund [id data]
  (ps/put (cardpayments-url "refunds" id) data opts))

(defn create-verification [data]
  (ps/post (cardpayments-url "verifications") data opts))

(defn get-verification [id]
  (ps/get (cardpayments-url "verifications" id) opts))

;; TODO: Standalone & Original Credits have not been implemented

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
