(ns degree9.auth.azureb2c
  (:require [degree9.debug :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            [degree9.es6 :as es6]
            [degree9.auth.oauth :as oauth]))
            ;["./azureb2c.js" :as AzureB2CStrategy]))

(def ^:private debug (dbg/debug "degree9:enterprise:auth:azureb2c"))

; (defn azureb2c []
;   (AzureB2CStrategy.))

; (defn azureb2c []
;   (this-as this
;     (let [old (obj/get oauth/OAuthStrategy "authenticate")]
;       (.setPrototypeOf js/Object this (oauth/OAuthStrategy.))
;       (set! (.. this -authenticate)
;         (fn [auth params]
;           (old (obj/get auth "error") params))))
;     this))

; (es6/defclass azureb2c :extends oauth/OAuthStrategy.prototype
;   (constructor []
;     (es6/super)))
      ;(let [super (partial (.getPrototypeOf js/Object (.. this -prototype -constructor)) this)]
      ;  (super (clj->js args)))))

      ;(.base azureb2c this "constructor" (clj->js args)))))
  ; (authenticate [this data params]
  ;   (prn data params)
  ;   (if-let [error (obj/get data "error")]
  ;     (.base this "authenticate" error params)
  ;     (.base this "authenticate" data params))))
;     oauth))
;    (es6/extend-class AzureB2CStrategy oauth
;      {:authenticate
;        (fn [data params]
;          (debug "Authentication data:" data)
;          (debug "Authentication params:" params)
;          (this-as this
;            (es6/super-as super
;              (if-let [error (obj/get data "error")]
;                (.authenticate super error params)
;                (.authenticate super data params))

(defn with-azureb2c [app & opts]
  (let [auth (.service app "/authentication")
        svc  (oauth/OAuthStrategy.)]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" svc)
    app))
