(ns degree9.auth.azureb2c
  (:require [degree9.debug :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            [degree9.es6 :as es6]
            [degree9.auth.oauth :as oauth]))

(def ^:private debug (dbg/debug "degree9:enterprise:auth:azureb2c"))

;(es6/defclass azureb2c :extends (oauth/OAuthStrategy))



(defn azureb2c [& opts]
  (let [oauth (oauth/OAuthStrategy)]
    oauth))
;    (es6/extend-class AzureB2CStrategy oauth
;      {:authenticate
;        (fn [data params]
;          (debug "Authentication data:" data)
;          (debug "Authentication params:" params)
;          (this-as this
;            (es6/super-as super
;              (if-let [error (obj/get data "error")]
;                (.authenticate super error params)
;                (.authenticate super data params))

(defn with-azureb2c [app & opts]
  (let [auth (.service app "/authentication")
        svc  (azureb2c)]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" svc)
    app))
