(ns degree9.es6)

(defmacro ^:private js-super []
  `('js* "super"))

(defmacro super-as
  [name & body]
  `(let [~name (js-super)]
     ~@body))

(defn parse-args [args]
  (loop [opts (transient {})
         body (transient [])
         [arg & args] args]
    (if-not (or arg args)
      [(persistent! opts) (persistent! body)]
      (cond (map? arg)     (recur (reduce-kv assoc! opts arg) body args)
            (keyword? arg) (recur (assoc! opts arg (first args)) body (rest args))
            :else          (recur opts (conj! body arg) args)))))

(defmacro defclass [class & args]
  (let [[{:keys [extends mixin]} impl] (parse-args args)]
    `(let [mixin# ~mixin
           extends# (.-prototype ~extends)
           ctor# (degree9.es6/mk-constructor)]

      (def ~class ctor#)

      (set! (.-cljs$lang$ctorStr ctor#) ~class)
      (set! (.-cljs$lang$ctorPrWriter ctor#)
            (fn [this writer opt]
              (cljs.core/-write writer ~class)))
      ;(set! (.-cljs$lang$type ctor#) true)
      ;(set! (.. ctor# -prototype -constructor) ctor#)

      ;; extend class via prototype
      (when extends#
        (goog/inherits ~class extends#))

      ;; extend class via mixins
      (when mixin#
        (let [class# (.create js/Object ~class)
              mixins# (if (map? mixin#) [mixin#] mixin#)]
          (doseq [m# mixins#]
            (.assign js/Object class# (cljs.core/clj->js m#)))))

      ;; export class symbol
      (goog/exportSymbol ~(str (ns-name *ns*) "." class) ~class))))


;(defmacro extend-class [name class impl]
;  `(let ['super (.create js/Object ~class)
;         proto# (.-prototype 'super)))
;    (.setPrototypeOf js/Object ~name ~class)
;    (.setPrototypeOf js/Object ~name ~class)))
  ;`(.assign js/Object (.create js/Object ~class) (cljs.core/clj->js ~impl)))
