(ns degree9.auth.azureb2c
  (:require [degree9.debug :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            [degree9.es6 :as es6]
            [degree9.auth.oauth :as oauth]))

(def ^:private debug (dbg/debug "degree9:enterprise:auth:azureb2c"))

(defprotocol OAuthStrategy
  (getRedirect [this data] "")
  (authenticate [this data params] ""))

(defn azureb2c [& opts]
  (let [oauth (oauth/OAuthStrategy)]
    (es6/extend-class oauth
      {:authenticate
        (fn [data params]
          (debug "Authentication data:" data)
          (debug "Authentication params:" params)
          (this-as this
            (if-let [error (obj/get data "error")]
              (.authenticate this error params)
              (.authenticate this data params))))})))

(defn with-azureb2c [app & opts]
  (let [auth (.service app "/authentication")
        svc  (azureb2c)]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" svc)
    app))
