(ns degree9.auth.azureb2c
  (:require ["debug" :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            ["@feathersjs/authentication-oauth" :as oauth]))

(def ^:private debug (dbg "degree9:enterprise:auth:azureb2c"))

(defn azureb2c [& opts]
  (let [oauth (obj/get oauth "OAuthStrategy")]
    (reify Object
      (entityId [this]
        (let [id (.entityId oauth)]
          (debug "entity id:" id)
          id))
      (getEntityQuery [this profile params]
        (debug "Authentication entity query profile:" profile)
        (debug "Authentication entity query params:" params)
        (.getEntityQuery oauth profile params))
      (getEntityData [this profile entity params]
        (debug "Authentication entity data profile:" profile)
        (debug "Authentication entity data entity:" entity)
        (debug "Authentication entity data params:" params)
        (.getEntityData oauth profile entity params))
      (getProfile [this data params]
        (debug "Authentication profile data:" data)
        (debug "Authentication profile params:" params)
        (.getProfile oauth data params))
      (getRedirect [this data]
        (let [redirect (obj/get oauth "getRedirect")]
          (debug "Authentication redirect data:" data)
          (redirect data)))
      (getCurrentEntity [this params]
        (debug "Authentication current entity params:" params)
        (.getRedirect oauth params))
      (findEntity [this profile params]
        (debug "Authentication find entity profile:" profile)
        (debug "Authentication find entity params:" params)
        (.findEntity oauth profile params))
      (createEntity [this profile params]
        (debug "Authentication create entity profile:" profile)
        (debug "Authentication create entity params:" params)
        (.createEntity oauth profile params))
      (updateEntity [this entity profile params]
        (debug "Authentication update entity:" entity)
        (debug "Authentication update entity profile:" profile)
        (debug "Authentication update entity params:" params)
        (.updateEntity oauth entity profile params))
      (authenticate [this data params]
        (let [data (obj/get data "error" data)
              authenticate (obj/get oauth "authenticate")]
          (debug "Authentication data:" data)
          (debug "Authentication params:" params)
          (authenticate data params))))))

(defn with-azureb2c [app & opts]
  (let [auth (.service app "/authentication")
        svc  (azureb2c)]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" svc)
    app))
