(ns degree9.auth.azureb2c
  (:require ["debug" :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            ["@feathersjs/authentication-oauth" :as oauth]))

(def ^:private debug (dbg "degree9:enterprise:auth:azureb2c"))

(defn azureb2c [& opts]
  (let [oauth (obj/get oauth "OAuthStrategy")]
    (reify Object
      (authenticate [this data params strategy]
        (debug "AzureB2C Authenticate" data params)
        (.authenticate oauth data params strategy)))))

(defn with-azureb2c [app & opts]
  (let [auth (.service app "/authentication")
        svc  (azureb2c)]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" svc)
    app))
