(ns degree9.idle
  (:require [javelin.core :as j]))

(def ^:dynamic *away* (j/cell nil))

(def ^:dynamic *timeout* (j/cell 30000))

(def ^:dynamic *timestamp* (j/cell nil))

(defn- detect-activity! [event]
  (reset! *timestamp* (js/Date.)))

(defn idle! [& opts]
  (let [timeout (:timeout opts @*timeout*)
        active  (:active opts detect-activity!)]
    (.addEventListener js/window "click" active)))
