(ns degree9.azure.insights.client
  "Azure Application Insights JS Client"
  (:require ["applicationinsights-js" :as insights]
            [degree9.env :as env]))

(def ^:private APPINSIGHTS_INSTRUMENTATIONKEY
  (env/get "APPINSIGHTS_INSTRUMENTATIONKEY"))

(defn- setup [config]
  (.downloadAndSetup insights config))

(defn init!
  ([] (init! APPINSIGHTS_INSTRUMENTATIONKEY))
  ([ikey] (setup #js{:instrumentationKey ikey})))
