(ns degree9.azure.insights.client
  "Provides application insights and telemetry using Azure Application Insights."
  (:require ["applicationinsights-js" :as insights]))

(def ^:private APPINSIGHTS_INSTRUMENTATIONKEY
  (env/get "APPINSIGHTS_INSTRUMENTATIONKEY"))

(defn- setup [config]
  (.downloadAndSetup insights config))

(defn init!
  ([] (init! APPINSIGHTS_INSTRUMENTATIONKEY))
  ([ikey] (setup #js{:instrumentationKey ikey})))
