(ns degree9.insights
  "Provides application insights and telemetry using Azure Application Insights."
  (:require ["applicationinsights" :as insights]
            [degree9.env :as env]
            [goog.object :as obj]))

(defn setup
  ([] (.setup insights))
  ([ikey] (.setup insights ikey)))

(defn start [client]
  (.start client))

(defn init!
  ([] (init! (env/get "APPINSIGHTS_INSTRUMENTATIONKEY")))
  ([ikey] (start (setup ikey))))

(defn client []
  (obj/get insights "defaultClient"))

(defn event! [client event]
  (.trackEvent client (clj->js event)))
