(ns degree9.server
 (:require
   ["debug" :as dbg]
   [meta.server :as server]
   [degree9.env :as env]
   [degree9.security :as sec]))

(def debug (dbg "degree9:enterprise:server"))

(defn app []
 (debug "Starting D9 enterprise server...")
 (-> (server/app)
     server/with-defaults
     server/with-rest
     server/with-socketio
     server/with-authentication
     sec/with-security))

(defn start! [app]
  (debug "D9 server listening on %s" (env/get "APP_PORT"))
  (server/listen app (env/get "APP_PORT")))
