(ns degree9.server
 (:require
   ["debug" :as dbg]
   [meta.server :as server]
   [degree9.env :as env]
   [degree9.security :as sec]))

(def debug (dbg "degree9:enterprise:server"))

(debug "Starting D9 Enterprise Server...")

(defn app []
  (-> server/app
      server/with-defaults
      server/with-rest
      server/with-socketio
      server/with-authentication
      sec/with-security))

(defn start! [app]
  (debug "App Port: %s" (env/get "APP_PORT"))
  (server/listen app (env/get "APP_PORT")))
