(ns degree9.server
 (:require
   ["debug" :as dbg]
   [meta.server :as server]
   [degree9.env :as env]
   [degree9.security :as sec]))

(def app
  (-> server/app
      server/with-defaults
      server/with-rest
      server/with-socketio
      server/with-authentication
      sec/with-security))

(defn start! []
  (prn "Starting Degree9 Server...")
  (prn "App Port: %s" (env/get "APP_PORT"))
  (server/listen app (env/get "APP_PORT")))
