(ns degree9.server
 (:require
   ["debug" :as debug]
   [meta.server :as server]
   [degree9.env :as env]
   [degree9.security :as sec]))

(def app server/app)

(def debug (debug. "degree9:server"))

(-> app
    server/with-defaults
    server/with-rest
    server/with-socketio
    server/with-authentication
    sec/with-security)

(defn start! []
  (debug "Starting Degree9 Server...")
  (debug "App Port: %s" (env/get "APP_PORT"))
  (server/listen app (env/get "APP_PORT")))
