(ns skalar.image
  (:require [failjure.core :as f]
            [skalar.mogrify :as mogrify]))

(defn verify [{:keys [sizes] :as req} available-sizes]
  (let [unknown (filter #(not (available-sizes %)) sizes)]
    (if (empty? unknown)
      req
      (f/fail (str "Unknown '" (first unknown) "' size.")))))

(defn rescale [{:keys [file sizes]} available-sizes pool]
  (map #(mogrify/mogrify-resize file % available-sizes pool) sizes))
