(ns skalar.core
  (:require [clojure.java.io :as io]
            [failjure.core :as f]
            [skalar.image :as image]
            [skalar.pool :as pool]))

(def ^:dynamic *allowed-sizes* {:medium "640x320"
                                :small  "320x180"
                                :thumb  "120x120"})

(def default-pool (memoize pool/create-pool))

(defmacro with-allowed-sizes
  [allowed-sizes & body]
  `(binding [*allowed-sizes* ~allowed-sizes] ~@body))

(defn resize-image
  "Resizes image according to the vector of defined sizes.
  Returns list of promises which resolve to either rescaled image data
  or (in case of failure) to an error."

  [file sizes & pool]
  (let [gm-pool (or pool (default-pool 3 6 8))]
    (-> {:file file :sizes sizes}
        (image/verify *allowed-sizes*)
        (image/rescale *allowed-sizes* gm-pool))))

(defn file-from-url [url]
  (let [tmpfile (java.io.File/createTempFile "img-" nil)]
    (with-open [in (io/input-stream url)
                out (io/output-stream tmpfile)]
      (io/copy in out))
    tmpfile))
