(ns revolt.catapulte.gpg
  (:require [digest :as sec]
            [revolt.shell]
            [clojure.tools.logging :as log]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(defmacro gpg
  [& args]
  `(revolt.shell/sh "gpg" ~@args))

(defn digest-sha1
  [asc-file out-file]
  (when-let [digest (sec/sha (io/as-file asc-file))]
    (let [checksum-file (str asc-file ".sha1")]
      (spit out-file (str/trimr digest))
      out-file)))

(defn sign!
  [sign-key files]
  (if sign-key
    (do
      (log/infof "signing %s with key %s" files sign-key)
      (let [signed (for [f files]
                     (let
                         [asc-file (if (= f "pom.xml") "revolt-catapulte-task-0.1.0.pom.asc" (str f ".asc"))]
                         #_[asc-file (str f ".asc")]
                       (gpg --yes --armour --detach-sign -o asc-file -u sign-key f)
                       asc-file))
            result (into files signed)]
        (println result)
        result
        ))
    files))
