goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__52605){
var vec__52606 = p__52605;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52606,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52606,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__52610 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__52610__$1 = (((G__52610 instanceof cljs.core.Keyword))?G__52610.fqn:null);
switch (G__52610__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__52612 = (function (){
var seq__52613 = cljs.core.seq(vars__$1);
var chunk__52614 = null;
var count__52615 = (0);
var i__52616 = (0);
while(true){
if((i__52616 < count__52615)){
var v = chunk__52614.cljs$core$IIndexed$_nth$arity$2(null,i__52616);
var temp__5753__auto___52765 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___52765)){
var t_52766 = temp__5753__auto___52765;
var G__52625_52767 = ((function (seq__52613,chunk__52614,count__52615,i__52616,t_52766,temp__5753__auto___52765,v,each_fixture_fn,G__52610,G__52610__$1,env,once_fixtures,each_fixtures,vec__52606,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_52766)));
});})(seq__52613,chunk__52614,count__52615,i__52616,t_52766,temp__5753__auto___52765,v,each_fixture_fn,G__52610,G__52610__$1,env,once_fixtures,each_fixtures,vec__52606,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__52625_52767) : each_fixture_fn.call(null,G__52625_52767));
} else {
}


var G__52768 = seq__52613;
var G__52769 = chunk__52614;
var G__52770 = count__52615;
var G__52771 = (i__52616 + (1));
seq__52613 = G__52768;
chunk__52614 = G__52769;
count__52615 = G__52770;
i__52616 = G__52771;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__52613);
if(temp__5753__auto__){
var seq__52613__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52613__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__52613__$1);
var G__52772 = cljs.core.chunk_rest(seq__52613__$1);
var G__52773 = c__4638__auto__;
var G__52774 = cljs.core.count(c__4638__auto__);
var G__52775 = (0);
seq__52613 = G__52772;
chunk__52614 = G__52773;
count__52615 = G__52774;
i__52616 = G__52775;
continue;
} else {
var v = cljs.core.first(seq__52613__$1);
var temp__5753__auto___52777__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___52777__$1)){
var t_52778 = temp__5753__auto___52777__$1;
var G__52631_52779 = ((function (seq__52613,chunk__52614,count__52615,i__52616,t_52778,temp__5753__auto___52777__$1,v,seq__52613__$1,temp__5753__auto__,each_fixture_fn,G__52610,G__52610__$1,env,once_fixtures,each_fixtures,vec__52606,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_52778)));
});})(seq__52613,chunk__52614,count__52615,i__52616,t_52778,temp__5753__auto___52777__$1,v,seq__52613__$1,temp__5753__auto__,each_fixture_fn,G__52610,G__52610__$1,env,once_fixtures,each_fixtures,vec__52606,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__52631_52779) : each_fixture_fn.call(null,G__52631_52779));
} else {
}


var G__52782 = cljs.core.next(seq__52613__$1);
var G__52783 = null;
var G__52784 = (0);
var G__52785 = (0);
seq__52613 = G__52782;
chunk__52614 = G__52783;
count__52615 = G__52784;
i__52616 = G__52785;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__52611 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__52611.cljs$core$IFn$_invoke$arity$1 ? fexpr__52611.cljs$core$IFn$_invoke$arity$1(G__52612) : fexpr__52611.call(null,G__52612));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52610__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__52601_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__52601_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__52639 = shadow.test.env.get_test_ns_info(ns);
var map__52639__$1 = cljs.core.__destructure_map(map__52639);
var test_ns = map__52639__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52639__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__52646,vars){
var map__52647 = p__52646;
var map__52647__$1 = cljs.core.__destructure_map(map__52647);
var env = map__52647__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52647__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__52648_52799 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__52650_52800 = null;
var count__52651_52801 = (0);
var i__52652_52802 = (0);
while(true){
if((i__52652_52802 < count__52651_52801)){
var vec__52676_52803 = chunk__52650_52800.cljs$core$IIndexed$_nth$arity$2(null,i__52652_52802);
var test_ns_52804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52676_52803,(0),null);
var ns_info_52805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52676_52803,(1),null);
var map__52685_52806 = ns_info_52805;
var map__52685_52807__$1 = cljs.core.__destructure_map(map__52685_52806);
var fixtures_52808 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52685_52807__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___52809 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_52808);
if(cljs.core.truth_(temp__5753__auto___52809)){
var fix_52810 = temp__5753__auto___52809;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_52804,fix_52810], 0));
} else {
}

var temp__5753__auto___52811 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_52808);
if(cljs.core.truth_(temp__5753__auto___52811)){
var fix_52812 = temp__5753__auto___52811;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_52804,fix_52812], 0));
} else {
}


var G__52813 = seq__52648_52799;
var G__52814 = chunk__52650_52800;
var G__52815 = count__52651_52801;
var G__52816 = (i__52652_52802 + (1));
seq__52648_52799 = G__52813;
chunk__52650_52800 = G__52814;
count__52651_52801 = G__52815;
i__52652_52802 = G__52816;
continue;
} else {
var temp__5753__auto___52817 = cljs.core.seq(seq__52648_52799);
if(temp__5753__auto___52817){
var seq__52648_52818__$1 = temp__5753__auto___52817;
if(cljs.core.chunked_seq_QMARK_(seq__52648_52818__$1)){
var c__4638__auto___52819 = cljs.core.chunk_first(seq__52648_52818__$1);
var G__52820 = cljs.core.chunk_rest(seq__52648_52818__$1);
var G__52821 = c__4638__auto___52819;
var G__52822 = cljs.core.count(c__4638__auto___52819);
var G__52823 = (0);
seq__52648_52799 = G__52820;
chunk__52650_52800 = G__52821;
count__52651_52801 = G__52822;
i__52652_52802 = G__52823;
continue;
} else {
var vec__52687_52824 = cljs.core.first(seq__52648_52818__$1);
var test_ns_52825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52687_52824,(0),null);
var ns_info_52826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52687_52824,(1),null);
var map__52690_52827 = ns_info_52826;
var map__52690_52828__$1 = cljs.core.__destructure_map(map__52690_52827);
var fixtures_52829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52690_52828__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___52830__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_52829);
if(cljs.core.truth_(temp__5753__auto___52830__$1)){
var fix_52831 = temp__5753__auto___52830__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_52825,fix_52831], 0));
} else {
}

var temp__5753__auto___52832__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_52829);
if(cljs.core.truth_(temp__5753__auto___52832__$1)){
var fix_52833 = temp__5753__auto___52832__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_52825,fix_52833], 0));
} else {
}


var G__52834 = cljs.core.next(seq__52648_52818__$1);
var G__52835 = null;
var G__52836 = (0);
var G__52837 = (0);
seq__52648_52799 = G__52834;
chunk__52650_52800 = G__52835;
count__52651_52801 = G__52836;
i__52652_52802 = G__52837;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__52645_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__52645_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__52700 = cljs.test.get_current_env();
var map__52700__$1 = cljs.core.__destructure_map(map__52700);
var env = map__52700__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52700__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52700__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__52704 = arguments.length;
switch (G__52704) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__52714 = arguments.length;
switch (G__52714) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__52716 = shadow.test.env.get_test_ns_info(ns);
var map__52716__$1 = cljs.core.__destructure_map(map__52716);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52716__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__52720 = arguments.length;
switch (G__52720) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__52717_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__52717_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__52746 = arguments.length;
switch (G__52746) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__52744_SHARP_){
var or__4212__auto__ = (re == null);
if(or__4212__auto__){
return or__4212__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__52744_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
