goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49045 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49045(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49048 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49048(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47868 = coll;
var G__47869 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47868,G__47869) : shadow.dom.lazy_native_coll_seq.call(null,G__47868,G__47869));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4212__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__47917 = arguments.length;
switch (G__47917) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__47929 = arguments.length;
switch (G__47929) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__47938 = arguments.length;
switch (G__47938) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__47947 = arguments.length;
switch (G__47947) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__47971 = arguments.length;
switch (G__47971) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__47988 = arguments.length;
switch (G__47988) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48001){if((e48001 instanceof Object)){
var e = e48001;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48001;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48021 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48022 = null;
var count__48023 = (0);
var i__48024 = (0);
while(true){
if((i__48024 < count__48023)){
var el = chunk__48022.cljs$core$IIndexed$_nth$arity$2(null,i__48024);
var handler_49067__$1 = ((function (seq__48021,chunk__48022,count__48023,i__48024,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48021,chunk__48022,count__48023,i__48024,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49067__$1);


var G__49069 = seq__48021;
var G__49070 = chunk__48022;
var G__49071 = count__48023;
var G__49072 = (i__48024 + (1));
seq__48021 = G__49069;
chunk__48022 = G__49070;
count__48023 = G__49071;
i__48024 = G__49072;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48021);
if(temp__5753__auto__){
var seq__48021__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48021__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__48021__$1);
var G__49074 = cljs.core.chunk_rest(seq__48021__$1);
var G__49075 = c__4638__auto__;
var G__49076 = cljs.core.count(c__4638__auto__);
var G__49077 = (0);
seq__48021 = G__49074;
chunk__48022 = G__49075;
count__48023 = G__49076;
i__48024 = G__49077;
continue;
} else {
var el = cljs.core.first(seq__48021__$1);
var handler_49078__$1 = ((function (seq__48021,chunk__48022,count__48023,i__48024,el,seq__48021__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48021,chunk__48022,count__48023,i__48024,el,seq__48021__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49078__$1);


var G__49079 = cljs.core.next(seq__48021__$1);
var G__49080 = null;
var G__49081 = (0);
var G__49082 = (0);
seq__48021 = G__49079;
chunk__48022 = G__49080;
count__48023 = G__49081;
i__48024 = G__49082;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48046 = arguments.length;
switch (G__48046) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48053 = cljs.core.seq(events);
var chunk__48054 = null;
var count__48055 = (0);
var i__48056 = (0);
while(true){
if((i__48056 < count__48055)){
var vec__48071 = chunk__48054.cljs$core$IIndexed$_nth$arity$2(null,i__48056);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48071,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48071,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49086 = seq__48053;
var G__49087 = chunk__48054;
var G__49088 = count__48055;
var G__49089 = (i__48056 + (1));
seq__48053 = G__49086;
chunk__48054 = G__49087;
count__48055 = G__49088;
i__48056 = G__49089;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48053);
if(temp__5753__auto__){
var seq__48053__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48053__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__48053__$1);
var G__49090 = cljs.core.chunk_rest(seq__48053__$1);
var G__49091 = c__4638__auto__;
var G__49092 = cljs.core.count(c__4638__auto__);
var G__49093 = (0);
seq__48053 = G__49090;
chunk__48054 = G__49091;
count__48055 = G__49092;
i__48056 = G__49093;
continue;
} else {
var vec__48078 = cljs.core.first(seq__48053__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48078,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48078,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49094 = cljs.core.next(seq__48053__$1);
var G__49095 = null;
var G__49096 = (0);
var G__49097 = (0);
seq__48053 = G__49094;
chunk__48054 = G__49095;
count__48055 = G__49096;
i__48056 = G__49097;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__48088 = cljs.core.seq(styles);
var chunk__48089 = null;
var count__48090 = (0);
var i__48091 = (0);
while(true){
if((i__48091 < count__48090)){
var vec__48114 = chunk__48089.cljs$core$IIndexed$_nth$arity$2(null,i__48091);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48114,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48114,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49098 = seq__48088;
var G__49099 = chunk__48089;
var G__49100 = count__48090;
var G__49101 = (i__48091 + (1));
seq__48088 = G__49098;
chunk__48089 = G__49099;
count__48090 = G__49100;
i__48091 = G__49101;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48088);
if(temp__5753__auto__){
var seq__48088__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48088__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__48088__$1);
var G__49102 = cljs.core.chunk_rest(seq__48088__$1);
var G__49103 = c__4638__auto__;
var G__49104 = cljs.core.count(c__4638__auto__);
var G__49105 = (0);
seq__48088 = G__49102;
chunk__48089 = G__49103;
count__48090 = G__49104;
i__48091 = G__49105;
continue;
} else {
var vec__48121 = cljs.core.first(seq__48088__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48121,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48121,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49110 = cljs.core.next(seq__48088__$1);
var G__49111 = null;
var G__49112 = (0);
var G__49113 = (0);
seq__48088 = G__49110;
chunk__48089 = G__49111;
count__48090 = G__49112;
i__48091 = G__49113;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__48126_49114 = key;
var G__48126_49115__$1 = (((G__48126_49114 instanceof cljs.core.Keyword))?G__48126_49114.fqn:null);
switch (G__48126_49115__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49117 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4212__auto__ = goog.string.startsWith(ks_49117,"data-");
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return goog.string.startsWith(ks_49117,"aria-");
}
})())){
el.setAttribute(ks_49117,value);
} else {
(el[ks_49117] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__48153){
var map__48155 = p__48153;
var map__48155__$1 = cljs.core.__destructure_map(map__48155);
var props = map__48155__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48155__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__48157 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48157,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48157,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48157,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__48163 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__48163,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__48163;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__48167 = arguments.length;
switch (G__48167) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__48181){
var vec__48182 = p__48181;
var seq__48183 = cljs.core.seq(vec__48182);
var first__48184 = cljs.core.first(seq__48183);
var seq__48183__$1 = cljs.core.next(seq__48183);
var nn = first__48184;
var first__48184__$1 = cljs.core.first(seq__48183__$1);
var seq__48183__$2 = cljs.core.next(seq__48183__$1);
var np = first__48184__$1;
var nc = seq__48183__$2;
var node = vec__48182;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48188 = nn;
var G__48189 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48188,G__48189) : create_fn.call(null,G__48188,G__48189));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48190 = nn;
var G__48191 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48190,G__48191) : create_fn.call(null,G__48190,G__48191));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__48196 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48196,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48196,(1),null);
var seq__48199_49132 = cljs.core.seq(node_children);
var chunk__48200_49133 = null;
var count__48201_49134 = (0);
var i__48202_49135 = (0);
while(true){
if((i__48202_49135 < count__48201_49134)){
var child_struct_49136 = chunk__48200_49133.cljs$core$IIndexed$_nth$arity$2(null,i__48202_49135);
var children_49137 = shadow.dom.dom_node(child_struct_49136);
if(cljs.core.seq_QMARK_(children_49137)){
var seq__48249_49138 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49137));
var chunk__48251_49139 = null;
var count__48252_49140 = (0);
var i__48253_49141 = (0);
while(true){
if((i__48253_49141 < count__48252_49140)){
var child_49142 = chunk__48251_49139.cljs$core$IIndexed$_nth$arity$2(null,i__48253_49141);
if(cljs.core.truth_(child_49142)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49142);


var G__49143 = seq__48249_49138;
var G__49144 = chunk__48251_49139;
var G__49145 = count__48252_49140;
var G__49146 = (i__48253_49141 + (1));
seq__48249_49138 = G__49143;
chunk__48251_49139 = G__49144;
count__48252_49140 = G__49145;
i__48253_49141 = G__49146;
continue;
} else {
var G__49147 = seq__48249_49138;
var G__49148 = chunk__48251_49139;
var G__49149 = count__48252_49140;
var G__49150 = (i__48253_49141 + (1));
seq__48249_49138 = G__49147;
chunk__48251_49139 = G__49148;
count__48252_49140 = G__49149;
i__48253_49141 = G__49150;
continue;
}
} else {
var temp__5753__auto___49151 = cljs.core.seq(seq__48249_49138);
if(temp__5753__auto___49151){
var seq__48249_49152__$1 = temp__5753__auto___49151;
if(cljs.core.chunked_seq_QMARK_(seq__48249_49152__$1)){
var c__4638__auto___49153 = cljs.core.chunk_first(seq__48249_49152__$1);
var G__49154 = cljs.core.chunk_rest(seq__48249_49152__$1);
var G__49155 = c__4638__auto___49153;
var G__49156 = cljs.core.count(c__4638__auto___49153);
var G__49157 = (0);
seq__48249_49138 = G__49154;
chunk__48251_49139 = G__49155;
count__48252_49140 = G__49156;
i__48253_49141 = G__49157;
continue;
} else {
var child_49159 = cljs.core.first(seq__48249_49152__$1);
if(cljs.core.truth_(child_49159)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49159);


var G__49160 = cljs.core.next(seq__48249_49152__$1);
var G__49161 = null;
var G__49162 = (0);
var G__49163 = (0);
seq__48249_49138 = G__49160;
chunk__48251_49139 = G__49161;
count__48252_49140 = G__49162;
i__48253_49141 = G__49163;
continue;
} else {
var G__49165 = cljs.core.next(seq__48249_49152__$1);
var G__49166 = null;
var G__49167 = (0);
var G__49168 = (0);
seq__48249_49138 = G__49165;
chunk__48251_49139 = G__49166;
count__48252_49140 = G__49167;
i__48253_49141 = G__49168;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49137);
}


var G__49169 = seq__48199_49132;
var G__49170 = chunk__48200_49133;
var G__49171 = count__48201_49134;
var G__49172 = (i__48202_49135 + (1));
seq__48199_49132 = G__49169;
chunk__48200_49133 = G__49170;
count__48201_49134 = G__49171;
i__48202_49135 = G__49172;
continue;
} else {
var temp__5753__auto___49173 = cljs.core.seq(seq__48199_49132);
if(temp__5753__auto___49173){
var seq__48199_49174__$1 = temp__5753__auto___49173;
if(cljs.core.chunked_seq_QMARK_(seq__48199_49174__$1)){
var c__4638__auto___49175 = cljs.core.chunk_first(seq__48199_49174__$1);
var G__49176 = cljs.core.chunk_rest(seq__48199_49174__$1);
var G__49177 = c__4638__auto___49175;
var G__49178 = cljs.core.count(c__4638__auto___49175);
var G__49179 = (0);
seq__48199_49132 = G__49176;
chunk__48200_49133 = G__49177;
count__48201_49134 = G__49178;
i__48202_49135 = G__49179;
continue;
} else {
var child_struct_49180 = cljs.core.first(seq__48199_49174__$1);
var children_49181 = shadow.dom.dom_node(child_struct_49180);
if(cljs.core.seq_QMARK_(children_49181)){
var seq__48260_49182 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49181));
var chunk__48262_49183 = null;
var count__48263_49184 = (0);
var i__48264_49185 = (0);
while(true){
if((i__48264_49185 < count__48263_49184)){
var child_49186 = chunk__48262_49183.cljs$core$IIndexed$_nth$arity$2(null,i__48264_49185);
if(cljs.core.truth_(child_49186)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49186);


var G__49187 = seq__48260_49182;
var G__49188 = chunk__48262_49183;
var G__49189 = count__48263_49184;
var G__49190 = (i__48264_49185 + (1));
seq__48260_49182 = G__49187;
chunk__48262_49183 = G__49188;
count__48263_49184 = G__49189;
i__48264_49185 = G__49190;
continue;
} else {
var G__49191 = seq__48260_49182;
var G__49192 = chunk__48262_49183;
var G__49193 = count__48263_49184;
var G__49194 = (i__48264_49185 + (1));
seq__48260_49182 = G__49191;
chunk__48262_49183 = G__49192;
count__48263_49184 = G__49193;
i__48264_49185 = G__49194;
continue;
}
} else {
var temp__5753__auto___49195__$1 = cljs.core.seq(seq__48260_49182);
if(temp__5753__auto___49195__$1){
var seq__48260_49196__$1 = temp__5753__auto___49195__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48260_49196__$1)){
var c__4638__auto___49197 = cljs.core.chunk_first(seq__48260_49196__$1);
var G__49198 = cljs.core.chunk_rest(seq__48260_49196__$1);
var G__49199 = c__4638__auto___49197;
var G__49200 = cljs.core.count(c__4638__auto___49197);
var G__49201 = (0);
seq__48260_49182 = G__49198;
chunk__48262_49183 = G__49199;
count__48263_49184 = G__49200;
i__48264_49185 = G__49201;
continue;
} else {
var child_49202 = cljs.core.first(seq__48260_49196__$1);
if(cljs.core.truth_(child_49202)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49202);


var G__49203 = cljs.core.next(seq__48260_49196__$1);
var G__49204 = null;
var G__49205 = (0);
var G__49206 = (0);
seq__48260_49182 = G__49203;
chunk__48262_49183 = G__49204;
count__48263_49184 = G__49205;
i__48264_49185 = G__49206;
continue;
} else {
var G__49207 = cljs.core.next(seq__48260_49196__$1);
var G__49208 = null;
var G__49209 = (0);
var G__49210 = (0);
seq__48260_49182 = G__49207;
chunk__48262_49183 = G__49208;
count__48263_49184 = G__49209;
i__48264_49185 = G__49210;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49181);
}


var G__49211 = cljs.core.next(seq__48199_49174__$1);
var G__49212 = null;
var G__49213 = (0);
var G__49214 = (0);
seq__48199_49132 = G__49211;
chunk__48200_49133 = G__49212;
count__48201_49134 = G__49213;
i__48202_49135 = G__49214;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48284 = cljs.core.seq(node);
var chunk__48285 = null;
var count__48286 = (0);
var i__48287 = (0);
while(true){
if((i__48287 < count__48286)){
var n = chunk__48285.cljs$core$IIndexed$_nth$arity$2(null,i__48287);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49219 = seq__48284;
var G__49220 = chunk__48285;
var G__49221 = count__48286;
var G__49222 = (i__48287 + (1));
seq__48284 = G__49219;
chunk__48285 = G__49220;
count__48286 = G__49221;
i__48287 = G__49222;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48284);
if(temp__5753__auto__){
var seq__48284__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48284__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__48284__$1);
var G__49223 = cljs.core.chunk_rest(seq__48284__$1);
var G__49224 = c__4638__auto__;
var G__49225 = cljs.core.count(c__4638__auto__);
var G__49226 = (0);
seq__48284 = G__49223;
chunk__48285 = G__49224;
count__48286 = G__49225;
i__48287 = G__49226;
continue;
} else {
var n = cljs.core.first(seq__48284__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49227 = cljs.core.next(seq__48284__$1);
var G__49228 = null;
var G__49229 = (0);
var G__49230 = (0);
seq__48284 = G__49227;
chunk__48285 = G__49228;
count__48286 = G__49229;
i__48287 = G__49230;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__48306 = arguments.length;
switch (G__48306) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__48314 = arguments.length;
switch (G__48314) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__48321 = arguments.length;
switch (G__48321) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4212__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4824__auto__ = [];
var len__4818__auto___49245 = arguments.length;
var i__4819__auto___49246 = (0);
while(true){
if((i__4819__auto___49246 < len__4818__auto___49245)){
args__4824__auto__.push((arguments[i__4819__auto___49246]));

var G__49247 = (i__4819__auto___49246 + (1));
i__4819__auto___49246 = G__49247;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__48332_49250 = cljs.core.seq(nodes);
var chunk__48333_49251 = null;
var count__48334_49252 = (0);
var i__48335_49253 = (0);
while(true){
if((i__48335_49253 < count__48334_49252)){
var node_49254 = chunk__48333_49251.cljs$core$IIndexed$_nth$arity$2(null,i__48335_49253);
fragment.appendChild(shadow.dom._to_dom(node_49254));


var G__49255 = seq__48332_49250;
var G__49256 = chunk__48333_49251;
var G__49257 = count__48334_49252;
var G__49258 = (i__48335_49253 + (1));
seq__48332_49250 = G__49255;
chunk__48333_49251 = G__49256;
count__48334_49252 = G__49257;
i__48335_49253 = G__49258;
continue;
} else {
var temp__5753__auto___49259 = cljs.core.seq(seq__48332_49250);
if(temp__5753__auto___49259){
var seq__48332_49260__$1 = temp__5753__auto___49259;
if(cljs.core.chunked_seq_QMARK_(seq__48332_49260__$1)){
var c__4638__auto___49261 = cljs.core.chunk_first(seq__48332_49260__$1);
var G__49262 = cljs.core.chunk_rest(seq__48332_49260__$1);
var G__49263 = c__4638__auto___49261;
var G__49264 = cljs.core.count(c__4638__auto___49261);
var G__49265 = (0);
seq__48332_49250 = G__49262;
chunk__48333_49251 = G__49263;
count__48334_49252 = G__49264;
i__48335_49253 = G__49265;
continue;
} else {
var node_49266 = cljs.core.first(seq__48332_49260__$1);
fragment.appendChild(shadow.dom._to_dom(node_49266));


var G__49267 = cljs.core.next(seq__48332_49260__$1);
var G__49268 = null;
var G__49269 = (0);
var G__49270 = (0);
seq__48332_49250 = G__49267;
chunk__48333_49251 = G__49268;
count__48334_49252 = G__49269;
i__48335_49253 = G__49270;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq48323){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48323));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__48354_49271 = cljs.core.seq(scripts);
var chunk__48355_49272 = null;
var count__48356_49273 = (0);
var i__48357_49274 = (0);
while(true){
if((i__48357_49274 < count__48356_49273)){
var vec__48371_49275 = chunk__48355_49272.cljs$core$IIndexed$_nth$arity$2(null,i__48357_49274);
var script_tag_49276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48371_49275,(0),null);
var script_body_49277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48371_49275,(1),null);
eval(script_body_49277);


var G__49278 = seq__48354_49271;
var G__49279 = chunk__48355_49272;
var G__49280 = count__48356_49273;
var G__49281 = (i__48357_49274 + (1));
seq__48354_49271 = G__49278;
chunk__48355_49272 = G__49279;
count__48356_49273 = G__49280;
i__48357_49274 = G__49281;
continue;
} else {
var temp__5753__auto___49282 = cljs.core.seq(seq__48354_49271);
if(temp__5753__auto___49282){
var seq__48354_49283__$1 = temp__5753__auto___49282;
if(cljs.core.chunked_seq_QMARK_(seq__48354_49283__$1)){
var c__4638__auto___49284 = cljs.core.chunk_first(seq__48354_49283__$1);
var G__49285 = cljs.core.chunk_rest(seq__48354_49283__$1);
var G__49286 = c__4638__auto___49284;
var G__49287 = cljs.core.count(c__4638__auto___49284);
var G__49288 = (0);
seq__48354_49271 = G__49285;
chunk__48355_49272 = G__49286;
count__48356_49273 = G__49287;
i__48357_49274 = G__49288;
continue;
} else {
var vec__48378_49289 = cljs.core.first(seq__48354_49283__$1);
var script_tag_49290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48378_49289,(0),null);
var script_body_49291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48378_49289,(1),null);
eval(script_body_49291);


var G__49292 = cljs.core.next(seq__48354_49283__$1);
var G__49293 = null;
var G__49294 = (0);
var G__49295 = (0);
seq__48354_49271 = G__49292;
chunk__48355_49272 = G__49293;
count__48356_49273 = G__49294;
i__48357_49274 = G__49295;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__48384){
var vec__48385 = p__48384;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48385,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48385,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__48398 = arguments.length;
switch (G__48398) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__48429 = cljs.core.seq(style_keys);
var chunk__48430 = null;
var count__48431 = (0);
var i__48432 = (0);
while(true){
if((i__48432 < count__48431)){
var it = chunk__48430.cljs$core$IIndexed$_nth$arity$2(null,i__48432);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49299 = seq__48429;
var G__49300 = chunk__48430;
var G__49301 = count__48431;
var G__49302 = (i__48432 + (1));
seq__48429 = G__49299;
chunk__48430 = G__49300;
count__48431 = G__49301;
i__48432 = G__49302;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48429);
if(temp__5753__auto__){
var seq__48429__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48429__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__48429__$1);
var G__49303 = cljs.core.chunk_rest(seq__48429__$1);
var G__49304 = c__4638__auto__;
var G__49305 = cljs.core.count(c__4638__auto__);
var G__49306 = (0);
seq__48429 = G__49303;
chunk__48430 = G__49304;
count__48431 = G__49305;
i__48432 = G__49306;
continue;
} else {
var it = cljs.core.first(seq__48429__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49308 = cljs.core.next(seq__48429__$1);
var G__49309 = null;
var G__49310 = (0);
var G__49311 = (0);
seq__48429 = G__49308;
chunk__48430 = G__49309;
count__48431 = G__49310;
i__48432 = G__49311;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k48456,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__48475 = k48456;
var G__48475__$1 = (((G__48475 instanceof cljs.core.Keyword))?G__48475.fqn:null);
switch (G__48475__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48456,else__4464__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__48478){
var vec__48480 = p__48478;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48480,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48480,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48455){
var self__ = this;
var G__48455__$1 = this;
return (new cljs.core.RecordIter((0),G__48455__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48458,other48459){
var self__ = this;
var this48458__$1 = this;
return (((!((other48459 == null)))) && ((((this48458__$1.constructor === other48459.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48458__$1.x,other48459.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48458__$1.y,other48459.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48458__$1.__extmap,other48459.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k48456){
var self__ = this;
var this__4468__auto____$1 = this;
var G__48524 = k48456;
var G__48524__$1 = (((G__48524 instanceof cljs.core.Keyword))?G__48524.fqn:null);
switch (G__48524__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k48456);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__48455){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__48539 = cljs.core.keyword_identical_QMARK_;
var expr__48540 = k__4470__auto__;
if(cljs.core.truth_((pred__48539.cljs$core$IFn$_invoke$arity$2 ? pred__48539.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__48540) : pred__48539.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__48540)))){
return (new shadow.dom.Coordinate(G__48455,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48539.cljs$core$IFn$_invoke$arity$2 ? pred__48539.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__48540) : pred__48539.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__48540)))){
return (new shadow.dom.Coordinate(self__.x,G__48455,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__48455),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__48455){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__48455,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__48460){
var extmap__4501__auto__ = (function (){var G__48605 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48460,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__48460)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48605);
} else {
return G__48605;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__48460),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__48460),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k48630,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__48646 = k48630;
var G__48646__$1 = (((G__48646 instanceof cljs.core.Keyword))?G__48646.fqn:null);
switch (G__48646__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48630,else__4464__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__48649){
var vec__48650 = p__48649;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48650,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48650,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Size{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48629){
var self__ = this;
var G__48629__$1 = this;
return (new cljs.core.RecordIter((0),G__48629__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48631,other48632){
var self__ = this;
var this48631__$1 = this;
return (((!((other48632 == null)))) && ((((this48631__$1.constructor === other48632.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48631__$1.w,other48632.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48631__$1.h,other48632.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48631__$1.__extmap,other48632.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k48630){
var self__ = this;
var this__4468__auto____$1 = this;
var G__48716 = k48630;
var G__48716__$1 = (((G__48716 instanceof cljs.core.Keyword))?G__48716.fqn:null);
switch (G__48716__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k48630);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__48629){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__48723 = cljs.core.keyword_identical_QMARK_;
var expr__48724 = k__4470__auto__;
if(cljs.core.truth_((pred__48723.cljs$core$IFn$_invoke$arity$2 ? pred__48723.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__48724) : pred__48723.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__48724)))){
return (new shadow.dom.Size(G__48629,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48723.cljs$core$IFn$_invoke$arity$2 ? pred__48723.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__48724) : pred__48723.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__48724)))){
return (new shadow.dom.Size(self__.w,G__48629,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__48629),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__48629){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__48629,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__48640){
var extmap__4501__auto__ = (function (){var G__48762 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48640,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__48640)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48762);
} else {
return G__48762;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__48640),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__48640),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4692__auto__ = opts;
var l__4693__auto__ = a__4692__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4693__auto__)){
var G__49393 = (i + (1));
var G__49394 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__49393;
ret = G__49394;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__48844){
var vec__48845 = p__48844;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48845,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48845,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__48854 = arguments.length;
switch (G__48854) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__49401 = ps;
var G__49402 = (i + (1));
el__$1 = G__49401;
i = G__49402;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__48902 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48902,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48902,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48902,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__48908_49407 = cljs.core.seq(props);
var chunk__48909_49408 = null;
var count__48910_49409 = (0);
var i__48911_49410 = (0);
while(true){
if((i__48911_49410 < count__48910_49409)){
var vec__48920_49411 = chunk__48909_49408.cljs$core$IIndexed$_nth$arity$2(null,i__48911_49410);
var k_49412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48920_49411,(0),null);
var v_49413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48920_49411,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_49412);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49412),v_49413);


var G__49418 = seq__48908_49407;
var G__49419 = chunk__48909_49408;
var G__49420 = count__48910_49409;
var G__49421 = (i__48911_49410 + (1));
seq__48908_49407 = G__49418;
chunk__48909_49408 = G__49419;
count__48910_49409 = G__49420;
i__48911_49410 = G__49421;
continue;
} else {
var temp__5753__auto___49422 = cljs.core.seq(seq__48908_49407);
if(temp__5753__auto___49422){
var seq__48908_49423__$1 = temp__5753__auto___49422;
if(cljs.core.chunked_seq_QMARK_(seq__48908_49423__$1)){
var c__4638__auto___49424 = cljs.core.chunk_first(seq__48908_49423__$1);
var G__49425 = cljs.core.chunk_rest(seq__48908_49423__$1);
var G__49426 = c__4638__auto___49424;
var G__49427 = cljs.core.count(c__4638__auto___49424);
var G__49428 = (0);
seq__48908_49407 = G__49425;
chunk__48909_49408 = G__49426;
count__48910_49409 = G__49427;
i__48911_49410 = G__49428;
continue;
} else {
var vec__48924_49429 = cljs.core.first(seq__48908_49423__$1);
var k_49430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48924_49429,(0),null);
var v_49431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48924_49429,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_49430);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49430),v_49431);


var G__49432 = cljs.core.next(seq__48908_49423__$1);
var G__49433 = null;
var G__49434 = (0);
var G__49435 = (0);
seq__48908_49407 = G__49432;
chunk__48909_49408 = G__49433;
count__48910_49409 = G__49434;
i__48911_49410 = G__49435;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__48928 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48928,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48928,(1),null);
var seq__48931_49448 = cljs.core.seq(node_children);
var chunk__48933_49449 = null;
var count__48934_49450 = (0);
var i__48935_49451 = (0);
while(true){
if((i__48935_49451 < count__48934_49450)){
var child_struct_49452 = chunk__48933_49449.cljs$core$IIndexed$_nth$arity$2(null,i__48935_49451);
if((!((child_struct_49452 == null)))){
if(typeof child_struct_49452 === 'string'){
var text_49453 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49453),child_struct_49452].join(''));
} else {
var children_49454 = shadow.dom.svg_node(child_struct_49452);
if(cljs.core.seq_QMARK_(children_49454)){
var seq__48968_49455 = cljs.core.seq(children_49454);
var chunk__48970_49456 = null;
var count__48971_49457 = (0);
var i__48972_49458 = (0);
while(true){
if((i__48972_49458 < count__48971_49457)){
var child_49459 = chunk__48970_49456.cljs$core$IIndexed$_nth$arity$2(null,i__48972_49458);
if(cljs.core.truth_(child_49459)){
node.appendChild(child_49459);


var G__49460 = seq__48968_49455;
var G__49461 = chunk__48970_49456;
var G__49462 = count__48971_49457;
var G__49463 = (i__48972_49458 + (1));
seq__48968_49455 = G__49460;
chunk__48970_49456 = G__49461;
count__48971_49457 = G__49462;
i__48972_49458 = G__49463;
continue;
} else {
var G__49464 = seq__48968_49455;
var G__49465 = chunk__48970_49456;
var G__49466 = count__48971_49457;
var G__49467 = (i__48972_49458 + (1));
seq__48968_49455 = G__49464;
chunk__48970_49456 = G__49465;
count__48971_49457 = G__49466;
i__48972_49458 = G__49467;
continue;
}
} else {
var temp__5753__auto___49468 = cljs.core.seq(seq__48968_49455);
if(temp__5753__auto___49468){
var seq__48968_49469__$1 = temp__5753__auto___49468;
if(cljs.core.chunked_seq_QMARK_(seq__48968_49469__$1)){
var c__4638__auto___49470 = cljs.core.chunk_first(seq__48968_49469__$1);
var G__49471 = cljs.core.chunk_rest(seq__48968_49469__$1);
var G__49472 = c__4638__auto___49470;
var G__49473 = cljs.core.count(c__4638__auto___49470);
var G__49474 = (0);
seq__48968_49455 = G__49471;
chunk__48970_49456 = G__49472;
count__48971_49457 = G__49473;
i__48972_49458 = G__49474;
continue;
} else {
var child_49475 = cljs.core.first(seq__48968_49469__$1);
if(cljs.core.truth_(child_49475)){
node.appendChild(child_49475);


var G__49476 = cljs.core.next(seq__48968_49469__$1);
var G__49477 = null;
var G__49478 = (0);
var G__49479 = (0);
seq__48968_49455 = G__49476;
chunk__48970_49456 = G__49477;
count__48971_49457 = G__49478;
i__48972_49458 = G__49479;
continue;
} else {
var G__49480 = cljs.core.next(seq__48968_49469__$1);
var G__49481 = null;
var G__49482 = (0);
var G__49483 = (0);
seq__48968_49455 = G__49480;
chunk__48970_49456 = G__49481;
count__48971_49457 = G__49482;
i__48972_49458 = G__49483;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49454);
}
}


var G__49484 = seq__48931_49448;
var G__49485 = chunk__48933_49449;
var G__49486 = count__48934_49450;
var G__49487 = (i__48935_49451 + (1));
seq__48931_49448 = G__49484;
chunk__48933_49449 = G__49485;
count__48934_49450 = G__49486;
i__48935_49451 = G__49487;
continue;
} else {
var G__49488 = seq__48931_49448;
var G__49489 = chunk__48933_49449;
var G__49490 = count__48934_49450;
var G__49491 = (i__48935_49451 + (1));
seq__48931_49448 = G__49488;
chunk__48933_49449 = G__49489;
count__48934_49450 = G__49490;
i__48935_49451 = G__49491;
continue;
}
} else {
var temp__5753__auto___49492 = cljs.core.seq(seq__48931_49448);
if(temp__5753__auto___49492){
var seq__48931_49493__$1 = temp__5753__auto___49492;
if(cljs.core.chunked_seq_QMARK_(seq__48931_49493__$1)){
var c__4638__auto___49494 = cljs.core.chunk_first(seq__48931_49493__$1);
var G__49495 = cljs.core.chunk_rest(seq__48931_49493__$1);
var G__49496 = c__4638__auto___49494;
var G__49497 = cljs.core.count(c__4638__auto___49494);
var G__49498 = (0);
seq__48931_49448 = G__49495;
chunk__48933_49449 = G__49496;
count__48934_49450 = G__49497;
i__48935_49451 = G__49498;
continue;
} else {
var child_struct_49499 = cljs.core.first(seq__48931_49493__$1);
if((!((child_struct_49499 == null)))){
if(typeof child_struct_49499 === 'string'){
var text_49500 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49500),child_struct_49499].join(''));
} else {
var children_49501 = shadow.dom.svg_node(child_struct_49499);
if(cljs.core.seq_QMARK_(children_49501)){
var seq__48985_49506 = cljs.core.seq(children_49501);
var chunk__48987_49507 = null;
var count__48988_49508 = (0);
var i__48989_49509 = (0);
while(true){
if((i__48989_49509 < count__48988_49508)){
var child_49510 = chunk__48987_49507.cljs$core$IIndexed$_nth$arity$2(null,i__48989_49509);
if(cljs.core.truth_(child_49510)){
node.appendChild(child_49510);


var G__49511 = seq__48985_49506;
var G__49512 = chunk__48987_49507;
var G__49513 = count__48988_49508;
var G__49514 = (i__48989_49509 + (1));
seq__48985_49506 = G__49511;
chunk__48987_49507 = G__49512;
count__48988_49508 = G__49513;
i__48989_49509 = G__49514;
continue;
} else {
var G__49515 = seq__48985_49506;
var G__49516 = chunk__48987_49507;
var G__49517 = count__48988_49508;
var G__49518 = (i__48989_49509 + (1));
seq__48985_49506 = G__49515;
chunk__48987_49507 = G__49516;
count__48988_49508 = G__49517;
i__48989_49509 = G__49518;
continue;
}
} else {
var temp__5753__auto___49519__$1 = cljs.core.seq(seq__48985_49506);
if(temp__5753__auto___49519__$1){
var seq__48985_49520__$1 = temp__5753__auto___49519__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48985_49520__$1)){
var c__4638__auto___49521 = cljs.core.chunk_first(seq__48985_49520__$1);
var G__49522 = cljs.core.chunk_rest(seq__48985_49520__$1);
var G__49523 = c__4638__auto___49521;
var G__49524 = cljs.core.count(c__4638__auto___49521);
var G__49525 = (0);
seq__48985_49506 = G__49522;
chunk__48987_49507 = G__49523;
count__48988_49508 = G__49524;
i__48989_49509 = G__49525;
continue;
} else {
var child_49526 = cljs.core.first(seq__48985_49520__$1);
if(cljs.core.truth_(child_49526)){
node.appendChild(child_49526);


var G__49527 = cljs.core.next(seq__48985_49520__$1);
var G__49528 = null;
var G__49529 = (0);
var G__49530 = (0);
seq__48985_49506 = G__49527;
chunk__48987_49507 = G__49528;
count__48988_49508 = G__49529;
i__48989_49509 = G__49530;
continue;
} else {
var G__49531 = cljs.core.next(seq__48985_49520__$1);
var G__49532 = null;
var G__49533 = (0);
var G__49534 = (0);
seq__48985_49506 = G__49531;
chunk__48987_49507 = G__49532;
count__48988_49508 = G__49533;
i__48989_49509 = G__49534;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49501);
}
}


var G__49535 = cljs.core.next(seq__48931_49493__$1);
var G__49536 = null;
var G__49537 = (0);
var G__49538 = (0);
seq__48931_49448 = G__49535;
chunk__48933_49449 = G__49536;
count__48934_49450 = G__49537;
i__48935_49451 = G__49538;
continue;
} else {
var G__49539 = cljs.core.next(seq__48931_49493__$1);
var G__49540 = null;
var G__49541 = (0);
var G__49542 = (0);
seq__48931_49448 = G__49539;
chunk__48933_49449 = G__49540;
count__48934_49450 = G__49541;
i__48935_49451 = G__49542;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4824__auto__ = [];
var len__4818__auto___49543 = arguments.length;
var i__4819__auto___49544 = (0);
while(true){
if((i__4819__auto___49544 < len__4818__auto___49543)){
args__4824__auto__.push((arguments[i__4819__auto___49544]));

var G__49545 = (i__4819__auto___49544 + (1));
i__4819__auto___49544 = G__49545;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49010){
var G__49011 = cljs.core.first(seq49010);
var seq49010__$1 = cljs.core.next(seq49010);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49011,seq49010__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49023 = arguments.length;
switch (G__49023) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4210__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4210__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4210__auto__;
}
})())){
var c__43957__auto___49550 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_49028){
var state_val_49029 = (state_49028[(1)]);
if((state_val_49029 === (1))){
var state_49028__$1 = state_49028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49028__$1,(2),once_or_cleanup);
} else {
if((state_val_49029 === (2))){
var inst_49025 = (state_49028[(2)]);
var inst_49026 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49028__$1 = (function (){var statearr_49030 = state_49028;
(statearr_49030[(7)] = inst_49025);

return statearr_49030;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49028__$1,inst_49026);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43223__auto__ = null;
var shadow$dom$state_machine__43223__auto____0 = (function (){
var statearr_49034 = [null,null,null,null,null,null,null,null];
(statearr_49034[(0)] = shadow$dom$state_machine__43223__auto__);

(statearr_49034[(1)] = (1));

return statearr_49034;
});
var shadow$dom$state_machine__43223__auto____1 = (function (state_49028){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_49028);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e49035){var ex__43226__auto__ = e49035;
var statearr_49036_49551 = state_49028;
(statearr_49036_49551[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_49028[(4)]))){
var statearr_49038_49552 = state_49028;
(statearr_49038_49552[(1)] = cljs.core.first((state_49028[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49553 = state_49028;
state_49028 = G__49553;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
shadow$dom$state_machine__43223__auto__ = function(state_49028){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43223__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43223__auto____1.call(this,state_49028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43223__auto____0;
shadow$dom$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43223__auto____1;
return shadow$dom$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_49041 = f__43958__auto__();
(statearr_49041[(6)] = c__43957__auto___49550);

return statearr_49041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
