goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44102 = arguments.length;
switch (G__44102) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44113 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44113 = (function (f,blockable,meta44114){
this.f = f;
this.blockable = blockable;
this.meta44114 = meta44114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44115,meta44114__$1){
var self__ = this;
var _44115__$1 = this;
return (new cljs.core.async.t_cljs$core$async44113(self__.f,self__.blockable,meta44114__$1));
}));

(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44115){
var self__ = this;
var _44115__$1 = this;
return self__.meta44114;
}));

(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44113.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44114","meta44114",-233062002,null)], null);
}));

(cljs.core.async.t_cljs$core$async44113.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44113");

(cljs.core.async.t_cljs$core$async44113.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async44113");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44113.
 */
cljs.core.async.__GT_t_cljs$core$async44113 = (function cljs$core$async$__GT_t_cljs$core$async44113(f__$1,blockable__$1,meta44114){
return (new cljs.core.async.t_cljs$core$async44113(f__$1,blockable__$1,meta44114));
});

}

return (new cljs.core.async.t_cljs$core$async44113(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44152 = arguments.length;
switch (G__44152) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44162 = arguments.length;
switch (G__44162) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44179 = arguments.length;
switch (G__44179) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47830 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47830) : fn1.call(null,val_47830));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47830) : fn1.call(null,val_47830));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44183 = arguments.length;
switch (G__44183) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___47845 = n;
var x_47846 = (0);
while(true){
if((x_47846 < n__4695__auto___47845)){
(a[x_47846] = x_47846);

var G__47847 = (x_47846 + (1));
x_47846 = G__47847;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44199 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44199 = (function (flag,meta44200){
this.flag = flag;
this.meta44200 = meta44200;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44201,meta44200__$1){
var self__ = this;
var _44201__$1 = this;
return (new cljs.core.async.t_cljs$core$async44199(self__.flag,meta44200__$1));
}));

(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44201){
var self__ = this;
var _44201__$1 = this;
return self__.meta44200;
}));

(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44199.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44199.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44200","meta44200",708873110,null)], null);
}));

(cljs.core.async.t_cljs$core$async44199.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44199.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44199");

(cljs.core.async.t_cljs$core$async44199.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async44199");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44199.
 */
cljs.core.async.__GT_t_cljs$core$async44199 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44199(flag__$1,meta44200){
return (new cljs.core.async.t_cljs$core$async44199(flag__$1,meta44200));
});

}

return (new cljs.core.async.t_cljs$core$async44199(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44212 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44212 = (function (flag,cb,meta44213){
this.flag = flag;
this.cb = cb;
this.meta44213 = meta44213;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44214,meta44213__$1){
var self__ = this;
var _44214__$1 = this;
return (new cljs.core.async.t_cljs$core$async44212(self__.flag,self__.cb,meta44213__$1));
}));

(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44214){
var self__ = this;
var _44214__$1 = this;
return self__.meta44213;
}));

(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44212.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44212.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44213","meta44213",-1700120102,null)], null);
}));

(cljs.core.async.t_cljs$core$async44212.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44212.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44212");

(cljs.core.async.t_cljs$core$async44212.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async44212");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44212.
 */
cljs.core.async.__GT_t_cljs$core$async44212 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44212(flag__$1,cb__$1,meta44213){
return (new cljs.core.async.t_cljs$core$async44212(flag__$1,cb__$1,meta44213));
});

}

return (new cljs.core.async.t_cljs$core$async44212(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44253_SHARP_){
var G__44265 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44253_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44265) : fret.call(null,G__44265));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44254_SHARP_){
var G__44269 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44254_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44269) : fret.call(null,G__44269));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47855 = (i + (1));
i = G__47855;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47857 = arguments.length;
var i__4819__auto___47858 = (0);
while(true){
if((i__4819__auto___47858 < len__4818__auto___47857)){
args__4824__auto__.push((arguments[i__4819__auto___47858]));

var G__47859 = (i__4819__auto___47858 + (1));
i__4819__auto___47858 = G__47859;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44318){
var map__44324 = p__44318;
var map__44324__$1 = cljs.core.__destructure_map(map__44324);
var opts = map__44324__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44298){
var G__44299 = cljs.core.first(seq44298);
var seq44298__$1 = cljs.core.next(seq44298);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44299,seq44298__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44369 = arguments.length;
switch (G__44369) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43957__auto___47861 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_44476){
var state_val_44478 = (state_44476[(1)]);
if((state_val_44478 === (7))){
var inst_44461 = (state_44476[(2)]);
var state_44476__$1 = state_44476;
var statearr_44492_47862 = state_44476__$1;
(statearr_44492_47862[(2)] = inst_44461);

(statearr_44492_47862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (1))){
var state_44476__$1 = state_44476;
var statearr_44493_47863 = state_44476__$1;
(statearr_44493_47863[(2)] = null);

(statearr_44493_47863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (4))){
var inst_44418 = (state_44476[(7)]);
var inst_44418__$1 = (state_44476[(2)]);
var inst_44440 = (inst_44418__$1 == null);
var state_44476__$1 = (function (){var statearr_44505 = state_44476;
(statearr_44505[(7)] = inst_44418__$1);

return statearr_44505;
})();
if(cljs.core.truth_(inst_44440)){
var statearr_44508_47864 = state_44476__$1;
(statearr_44508_47864[(1)] = (5));

} else {
var statearr_44510_47865 = state_44476__$1;
(statearr_44510_47865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (13))){
var state_44476__$1 = state_44476;
var statearr_44514_47866 = state_44476__$1;
(statearr_44514_47866[(2)] = null);

(statearr_44514_47866[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (6))){
var inst_44418 = (state_44476[(7)]);
var state_44476__$1 = state_44476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44476__$1,(11),to,inst_44418);
} else {
if((state_val_44478 === (3))){
var inst_44465 = (state_44476[(2)]);
var state_44476__$1 = state_44476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44476__$1,inst_44465);
} else {
if((state_val_44478 === (12))){
var state_44476__$1 = state_44476;
var statearr_44518_47867 = state_44476__$1;
(statearr_44518_47867[(2)] = null);

(statearr_44518_47867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (2))){
var state_44476__$1 = state_44476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44476__$1,(4),from);
} else {
if((state_val_44478 === (11))){
var inst_44454 = (state_44476[(2)]);
var state_44476__$1 = state_44476;
if(cljs.core.truth_(inst_44454)){
var statearr_44520_47870 = state_44476__$1;
(statearr_44520_47870[(1)] = (12));

} else {
var statearr_44521_47871 = state_44476__$1;
(statearr_44521_47871[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (9))){
var state_44476__$1 = state_44476;
var statearr_44522_47872 = state_44476__$1;
(statearr_44522_47872[(2)] = null);

(statearr_44522_47872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (5))){
var state_44476__$1 = state_44476;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44523_47873 = state_44476__$1;
(statearr_44523_47873[(1)] = (8));

} else {
var statearr_44524_47874 = state_44476__$1;
(statearr_44524_47874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (14))){
var inst_44459 = (state_44476[(2)]);
var state_44476__$1 = state_44476;
var statearr_44530_47879 = state_44476__$1;
(statearr_44530_47879[(2)] = inst_44459);

(statearr_44530_47879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (10))){
var inst_44451 = (state_44476[(2)]);
var state_44476__$1 = state_44476;
var statearr_44531_47880 = state_44476__$1;
(statearr_44531_47880[(2)] = inst_44451);

(statearr_44531_47880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (8))){
var inst_44445 = cljs.core.async.close_BANG_(to);
var state_44476__$1 = state_44476;
var statearr_44533_47881 = state_44476__$1;
(statearr_44533_47881[(2)] = inst_44445);

(statearr_44533_47881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_44536 = [null,null,null,null,null,null,null,null];
(statearr_44536[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_44536[(1)] = (1));

return statearr_44536;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_44476){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44476);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44538){var ex__43226__auto__ = e44538;
var statearr_44540_47882 = state_44476;
(statearr_44540_47882[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44476[(4)]))){
var statearr_44541_47883 = state_44476;
(statearr_44541_47883[(1)] = cljs.core.first((state_44476[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47885 = state_44476;
state_44476 = G__47885;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_44476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_44476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_44542 = f__43958__auto__();
(statearr_44542[(6)] = c__43957__auto___47861);

return statearr_44542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44549){
var vec__44550 = p__44549;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44550,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44550,(1),null);
var job = vec__44550;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43957__auto___47892 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_44557){
var state_val_44558 = (state_44557[(1)]);
if((state_val_44558 === (1))){
var state_44557__$1 = state_44557;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44557__$1,(2),res,v);
} else {
if((state_val_44558 === (2))){
var inst_44554 = (state_44557[(2)]);
var inst_44555 = cljs.core.async.close_BANG_(res);
var state_44557__$1 = (function (){var statearr_44563 = state_44557;
(statearr_44563[(7)] = inst_44554);

return statearr_44563;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44557__$1,inst_44555);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_44567 = [null,null,null,null,null,null,null,null];
(statearr_44567[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__);

(statearr_44567[(1)] = (1));

return statearr_44567;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1 = (function (state_44557){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44557);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44575){var ex__43226__auto__ = e44575;
var statearr_44576_47900 = state_44557;
(statearr_44576_47900[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44557[(4)]))){
var statearr_44583_47901 = state_44557;
(statearr_44583_47901[(1)] = cljs.core.first((state_44557[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47903 = state_44557;
state_44557 = G__47903;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = function(state_44557){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1.call(this,state_44557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_44588 = f__43958__auto__();
(statearr_44588[(6)] = c__43957__auto___47892);

return statearr_44588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44593){
var vec__44595 = p__44593;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44595,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44595,(1),null);
var job = vec__44595;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___47905 = n;
var __47911 = (0);
while(true){
if((__47911 < n__4695__auto___47905)){
var G__44598_47912 = type;
var G__44598_47913__$1 = (((G__44598_47912 instanceof cljs.core.Keyword))?G__44598_47912.fqn:null);
switch (G__44598_47913__$1) {
case "compute":
var c__43957__auto___47916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47911,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = ((function (__47911,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function (state_44617){
var state_val_44618 = (state_44617[(1)]);
if((state_val_44618 === (1))){
var state_44617__$1 = state_44617;
var statearr_44628_47918 = state_44617__$1;
(statearr_44628_47918[(2)] = null);

(statearr_44628_47918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44618 === (2))){
var state_44617__$1 = state_44617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44617__$1,(4),jobs);
} else {
if((state_val_44618 === (3))){
var inst_44615 = (state_44617[(2)]);
var state_44617__$1 = state_44617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44617__$1,inst_44615);
} else {
if((state_val_44618 === (4))){
var inst_44606 = (state_44617[(2)]);
var inst_44607 = process(inst_44606);
var state_44617__$1 = state_44617;
if(cljs.core.truth_(inst_44607)){
var statearr_44629_47925 = state_44617__$1;
(statearr_44629_47925[(1)] = (5));

} else {
var statearr_44630_47926 = state_44617__$1;
(statearr_44630_47926[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44618 === (5))){
var state_44617__$1 = state_44617;
var statearr_44631_47927 = state_44617__$1;
(statearr_44631_47927[(2)] = null);

(statearr_44631_47927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44618 === (6))){
var state_44617__$1 = state_44617;
var statearr_44635_47930 = state_44617__$1;
(statearr_44635_47930[(2)] = null);

(statearr_44635_47930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44618 === (7))){
var inst_44613 = (state_44617[(2)]);
var state_44617__$1 = state_44617;
var statearr_44637_47931 = state_44617__$1;
(statearr_44637_47931[(2)] = inst_44613);

(statearr_44637_47931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47911,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
;
return ((function (__47911,switch__43222__auto__,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_44638 = [null,null,null,null,null,null,null];
(statearr_44638[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__);

(statearr_44638[(1)] = (1));

return statearr_44638;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1 = (function (state_44617){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44617);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44639){var ex__43226__auto__ = e44639;
var statearr_44640_47932 = state_44617;
(statearr_44640_47932[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44617[(4)]))){
var statearr_44641_47934 = state_44617;
(statearr_44641_47934[(1)] = cljs.core.first((state_44617[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47935 = state_44617;
state_44617 = G__47935;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = function(state_44617){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1.call(this,state_44617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__;
})()
;})(__47911,switch__43222__auto__,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
})();
var state__43959__auto__ = (function (){var statearr_44642 = f__43958__auto__();
(statearr_44642[(6)] = c__43957__auto___47916);

return statearr_44642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
});})(__47911,c__43957__auto___47916,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
);


break;
case "async":
var c__43957__auto___47937 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47911,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = ((function (__47911,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function (state_44661){
var state_val_44662 = (state_44661[(1)]);
if((state_val_44662 === (1))){
var state_44661__$1 = state_44661;
var statearr_44673_47939 = state_44661__$1;
(statearr_44673_47939[(2)] = null);

(statearr_44673_47939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44662 === (2))){
var state_44661__$1 = state_44661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44661__$1,(4),jobs);
} else {
if((state_val_44662 === (3))){
var inst_44659 = (state_44661[(2)]);
var state_44661__$1 = state_44661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44661__$1,inst_44659);
} else {
if((state_val_44662 === (4))){
var inst_44649 = (state_44661[(2)]);
var inst_44651 = async(inst_44649);
var state_44661__$1 = state_44661;
if(cljs.core.truth_(inst_44651)){
var statearr_44681_47941 = state_44661__$1;
(statearr_44681_47941[(1)] = (5));

} else {
var statearr_44682_47942 = state_44661__$1;
(statearr_44682_47942[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44662 === (5))){
var state_44661__$1 = state_44661;
var statearr_44683_47943 = state_44661__$1;
(statearr_44683_47943[(2)] = null);

(statearr_44683_47943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44662 === (6))){
var state_44661__$1 = state_44661;
var statearr_44685_47944 = state_44661__$1;
(statearr_44685_47944[(2)] = null);

(statearr_44685_47944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44662 === (7))){
var inst_44657 = (state_44661[(2)]);
var state_44661__$1 = state_44661;
var statearr_44686_47945 = state_44661__$1;
(statearr_44686_47945[(2)] = inst_44657);

(statearr_44686_47945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47911,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
;
return ((function (__47911,switch__43222__auto__,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_44689 = [null,null,null,null,null,null,null];
(statearr_44689[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__);

(statearr_44689[(1)] = (1));

return statearr_44689;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1 = (function (state_44661){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44661);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44690){var ex__43226__auto__ = e44690;
var statearr_44691_47948 = state_44661;
(statearr_44691_47948[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44661[(4)]))){
var statearr_44693_47949 = state_44661;
(statearr_44693_47949[(1)] = cljs.core.first((state_44661[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47950 = state_44661;
state_44661 = G__47950;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = function(state_44661){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1.call(this,state_44661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__;
})()
;})(__47911,switch__43222__auto__,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
})();
var state__43959__auto__ = (function (){var statearr_44700 = f__43958__auto__();
(statearr_44700[(6)] = c__43957__auto___47937);

return statearr_44700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
});})(__47911,c__43957__auto___47937,G__44598_47912,G__44598_47913__$1,n__4695__auto___47905,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44598_47913__$1)].join('')));

}

var G__47956 = (__47911 + (1));
__47911 = G__47956;
continue;
} else {
}
break;
}

var c__43957__auto___47957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_44727){
var state_val_44728 = (state_44727[(1)]);
if((state_val_44728 === (7))){
var inst_44723 = (state_44727[(2)]);
var state_44727__$1 = state_44727;
var statearr_44731_47958 = state_44727__$1;
(statearr_44731_47958[(2)] = inst_44723);

(statearr_44731_47958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44728 === (1))){
var state_44727__$1 = state_44727;
var statearr_44738_47964 = state_44727__$1;
(statearr_44738_47964[(2)] = null);

(statearr_44738_47964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44728 === (4))){
var inst_44704 = (state_44727[(7)]);
var inst_44704__$1 = (state_44727[(2)]);
var inst_44705 = (inst_44704__$1 == null);
var state_44727__$1 = (function (){var statearr_44745 = state_44727;
(statearr_44745[(7)] = inst_44704__$1);

return statearr_44745;
})();
if(cljs.core.truth_(inst_44705)){
var statearr_44746_47965 = state_44727__$1;
(statearr_44746_47965[(1)] = (5));

} else {
var statearr_44748_47966 = state_44727__$1;
(statearr_44748_47966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44728 === (6))){
var inst_44712 = (state_44727[(8)]);
var inst_44704 = (state_44727[(7)]);
var inst_44712__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44715 = [inst_44704,inst_44712__$1];
var inst_44716 = (new cljs.core.PersistentVector(null,2,(5),inst_44713,inst_44715,null));
var state_44727__$1 = (function (){var statearr_44751 = state_44727;
(statearr_44751[(8)] = inst_44712__$1);

return statearr_44751;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44727__$1,(8),jobs,inst_44716);
} else {
if((state_val_44728 === (3))){
var inst_44725 = (state_44727[(2)]);
var state_44727__$1 = state_44727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44727__$1,inst_44725);
} else {
if((state_val_44728 === (2))){
var state_44727__$1 = state_44727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44727__$1,(4),from);
} else {
if((state_val_44728 === (9))){
var inst_44720 = (state_44727[(2)]);
var state_44727__$1 = (function (){var statearr_44755 = state_44727;
(statearr_44755[(9)] = inst_44720);

return statearr_44755;
})();
var statearr_44756_47967 = state_44727__$1;
(statearr_44756_47967[(2)] = null);

(statearr_44756_47967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44728 === (5))){
var inst_44707 = cljs.core.async.close_BANG_(jobs);
var state_44727__$1 = state_44727;
var statearr_44761_47970 = state_44727__$1;
(statearr_44761_47970[(2)] = inst_44707);

(statearr_44761_47970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44728 === (8))){
var inst_44712 = (state_44727[(8)]);
var inst_44718 = (state_44727[(2)]);
var state_44727__$1 = (function (){var statearr_44762 = state_44727;
(statearr_44762[(10)] = inst_44718);

return statearr_44762;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44727__$1,(9),results,inst_44712);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_44767 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44767[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__);

(statearr_44767[(1)] = (1));

return statearr_44767;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1 = (function (state_44727){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44727);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44770){var ex__43226__auto__ = e44770;
var statearr_44771_47973 = state_44727;
(statearr_44771_47973[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44727[(4)]))){
var statearr_44774_47974 = state_44727;
(statearr_44774_47974[(1)] = cljs.core.first((state_44727[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47975 = state_44727;
state_44727 = G__47975;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = function(state_44727){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1.call(this,state_44727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_44775 = f__43958__auto__();
(statearr_44775[(6)] = c__43957__auto___47957);

return statearr_44775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_44814){
var state_val_44815 = (state_44814[(1)]);
if((state_val_44815 === (7))){
var inst_44810 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
var statearr_44820_47981 = state_44814__$1;
(statearr_44820_47981[(2)] = inst_44810);

(statearr_44820_47981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (20))){
var state_44814__$1 = state_44814;
var statearr_44823_47982 = state_44814__$1;
(statearr_44823_47982[(2)] = null);

(statearr_44823_47982[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (1))){
var state_44814__$1 = state_44814;
var statearr_44824_47983 = state_44814__$1;
(statearr_44824_47983[(2)] = null);

(statearr_44824_47983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (4))){
var inst_44778 = (state_44814[(7)]);
var inst_44778__$1 = (state_44814[(2)]);
var inst_44779 = (inst_44778__$1 == null);
var state_44814__$1 = (function (){var statearr_44834 = state_44814;
(statearr_44834[(7)] = inst_44778__$1);

return statearr_44834;
})();
if(cljs.core.truth_(inst_44779)){
var statearr_44836_47984 = state_44814__$1;
(statearr_44836_47984[(1)] = (5));

} else {
var statearr_44837_47985 = state_44814__$1;
(statearr_44837_47985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (15))){
var inst_44792 = (state_44814[(8)]);
var state_44814__$1 = state_44814;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44814__$1,(18),to,inst_44792);
} else {
if((state_val_44815 === (21))){
var inst_44805 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
var statearr_44842_47987 = state_44814__$1;
(statearr_44842_47987[(2)] = inst_44805);

(statearr_44842_47987[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (13))){
var inst_44807 = (state_44814[(2)]);
var state_44814__$1 = (function (){var statearr_44843 = state_44814;
(statearr_44843[(9)] = inst_44807);

return statearr_44843;
})();
var statearr_44844_47989 = state_44814__$1;
(statearr_44844_47989[(2)] = null);

(statearr_44844_47989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (6))){
var inst_44778 = (state_44814[(7)]);
var state_44814__$1 = state_44814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44814__$1,(11),inst_44778);
} else {
if((state_val_44815 === (17))){
var inst_44800 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
if(cljs.core.truth_(inst_44800)){
var statearr_44851_47990 = state_44814__$1;
(statearr_44851_47990[(1)] = (19));

} else {
var statearr_44852_47991 = state_44814__$1;
(statearr_44852_47991[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (3))){
var inst_44812 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44814__$1,inst_44812);
} else {
if((state_val_44815 === (12))){
var inst_44789 = (state_44814[(10)]);
var state_44814__$1 = state_44814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44814__$1,(14),inst_44789);
} else {
if((state_val_44815 === (2))){
var state_44814__$1 = state_44814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44814__$1,(4),results);
} else {
if((state_val_44815 === (19))){
var state_44814__$1 = state_44814;
var statearr_44854_47996 = state_44814__$1;
(statearr_44854_47996[(2)] = null);

(statearr_44854_47996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (11))){
var inst_44789 = (state_44814[(2)]);
var state_44814__$1 = (function (){var statearr_44855 = state_44814;
(statearr_44855[(10)] = inst_44789);

return statearr_44855;
})();
var statearr_44856_47997 = state_44814__$1;
(statearr_44856_47997[(2)] = null);

(statearr_44856_47997[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (9))){
var state_44814__$1 = state_44814;
var statearr_44857_47998 = state_44814__$1;
(statearr_44857_47998[(2)] = null);

(statearr_44857_47998[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (5))){
var state_44814__$1 = state_44814;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44858_47999 = state_44814__$1;
(statearr_44858_47999[(1)] = (8));

} else {
var statearr_44859_48000 = state_44814__$1;
(statearr_44859_48000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (14))){
var inst_44794 = (state_44814[(11)]);
var inst_44792 = (state_44814[(8)]);
var inst_44792__$1 = (state_44814[(2)]);
var inst_44793 = (inst_44792__$1 == null);
var inst_44794__$1 = cljs.core.not(inst_44793);
var state_44814__$1 = (function (){var statearr_44861 = state_44814;
(statearr_44861[(11)] = inst_44794__$1);

(statearr_44861[(8)] = inst_44792__$1);

return statearr_44861;
})();
if(inst_44794__$1){
var statearr_44862_48002 = state_44814__$1;
(statearr_44862_48002[(1)] = (15));

} else {
var statearr_44863_48003 = state_44814__$1;
(statearr_44863_48003[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (16))){
var inst_44794 = (state_44814[(11)]);
var state_44814__$1 = state_44814;
var statearr_44872_48004 = state_44814__$1;
(statearr_44872_48004[(2)] = inst_44794);

(statearr_44872_48004[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (10))){
var inst_44785 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
var statearr_44873_48005 = state_44814__$1;
(statearr_44873_48005[(2)] = inst_44785);

(statearr_44873_48005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (18))){
var inst_44797 = (state_44814[(2)]);
var state_44814__$1 = state_44814;
var statearr_44874_48010 = state_44814__$1;
(statearr_44874_48010[(2)] = inst_44797);

(statearr_44874_48010[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44815 === (8))){
var inst_44782 = cljs.core.async.close_BANG_(to);
var state_44814__$1 = state_44814;
var statearr_44875_48014 = state_44814__$1;
(statearr_44875_48014[(2)] = inst_44782);

(statearr_44875_48014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_44876 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44876[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__);

(statearr_44876[(1)] = (1));

return statearr_44876;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1 = (function (state_44814){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44814);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44877){var ex__43226__auto__ = e44877;
var statearr_44879_48018 = state_44814;
(statearr_44879_48018[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44814[(4)]))){
var statearr_44880_48019 = state_44814;
(statearr_44880_48019[(1)] = cljs.core.first((state_44814[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48020 = state_44814;
state_44814 = G__48020;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__ = function(state_44814){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1.call(this,state_44814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_44881 = f__43958__auto__();
(statearr_44881[(6)] = c__43957__auto__);

return statearr_44881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44888 = arguments.length;
switch (G__44888) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44900 = arguments.length;
switch (G__44900) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44910 = arguments.length;
switch (G__44910) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43957__auto___48031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_44938){
var state_val_44939 = (state_44938[(1)]);
if((state_val_44939 === (7))){
var inst_44934 = (state_44938[(2)]);
var state_44938__$1 = state_44938;
var statearr_44940_48032 = state_44938__$1;
(statearr_44940_48032[(2)] = inst_44934);

(statearr_44940_48032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (1))){
var state_44938__$1 = state_44938;
var statearr_44942_48033 = state_44938__$1;
(statearr_44942_48033[(2)] = null);

(statearr_44942_48033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (4))){
var inst_44914 = (state_44938[(7)]);
var inst_44914__$1 = (state_44938[(2)]);
var inst_44915 = (inst_44914__$1 == null);
var state_44938__$1 = (function (){var statearr_44947 = state_44938;
(statearr_44947[(7)] = inst_44914__$1);

return statearr_44947;
})();
if(cljs.core.truth_(inst_44915)){
var statearr_44949_48034 = state_44938__$1;
(statearr_44949_48034[(1)] = (5));

} else {
var statearr_44954_48035 = state_44938__$1;
(statearr_44954_48035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (13))){
var state_44938__$1 = state_44938;
var statearr_44957_48036 = state_44938__$1;
(statearr_44957_48036[(2)] = null);

(statearr_44957_48036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (6))){
var inst_44914 = (state_44938[(7)]);
var inst_44921 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44914) : p.call(null,inst_44914));
var state_44938__$1 = state_44938;
if(cljs.core.truth_(inst_44921)){
var statearr_44959_48037 = state_44938__$1;
(statearr_44959_48037[(1)] = (9));

} else {
var statearr_44960_48038 = state_44938__$1;
(statearr_44960_48038[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (3))){
var inst_44936 = (state_44938[(2)]);
var state_44938__$1 = state_44938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44938__$1,inst_44936);
} else {
if((state_val_44939 === (12))){
var state_44938__$1 = state_44938;
var statearr_44961_48039 = state_44938__$1;
(statearr_44961_48039[(2)] = null);

(statearr_44961_48039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (2))){
var state_44938__$1 = state_44938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44938__$1,(4),ch);
} else {
if((state_val_44939 === (11))){
var inst_44914 = (state_44938[(7)]);
var inst_44925 = (state_44938[(2)]);
var state_44938__$1 = state_44938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44938__$1,(8),inst_44925,inst_44914);
} else {
if((state_val_44939 === (9))){
var state_44938__$1 = state_44938;
var statearr_44966_48040 = state_44938__$1;
(statearr_44966_48040[(2)] = tc);

(statearr_44966_48040[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (5))){
var inst_44917 = cljs.core.async.close_BANG_(tc);
var inst_44918 = cljs.core.async.close_BANG_(fc);
var state_44938__$1 = (function (){var statearr_44968 = state_44938;
(statearr_44968[(8)] = inst_44917);

return statearr_44968;
})();
var statearr_44969_48041 = state_44938__$1;
(statearr_44969_48041[(2)] = inst_44918);

(statearr_44969_48041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (14))){
var inst_44932 = (state_44938[(2)]);
var state_44938__$1 = state_44938;
var statearr_44971_48042 = state_44938__$1;
(statearr_44971_48042[(2)] = inst_44932);

(statearr_44971_48042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (10))){
var state_44938__$1 = state_44938;
var statearr_44972_48043 = state_44938__$1;
(statearr_44972_48043[(2)] = fc);

(statearr_44972_48043[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44939 === (8))){
var inst_44927 = (state_44938[(2)]);
var state_44938__$1 = state_44938;
if(cljs.core.truth_(inst_44927)){
var statearr_44973_48045 = state_44938__$1;
(statearr_44973_48045[(1)] = (12));

} else {
var statearr_44974_48047 = state_44938__$1;
(statearr_44974_48047[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_44976 = [null,null,null,null,null,null,null,null,null];
(statearr_44976[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_44976[(1)] = (1));

return statearr_44976;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_44938){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_44938);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e44978){var ex__43226__auto__ = e44978;
var statearr_44979_48048 = state_44938;
(statearr_44979_48048[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_44938[(4)]))){
var statearr_44980_48049 = state_44938;
(statearr_44980_48049[(1)] = cljs.core.first((state_44938[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48050 = state_44938;
state_44938 = G__48050;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_44938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_44938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_44984 = f__43958__auto__();
(statearr_44984[(6)] = c__43957__auto___48031);

return statearr_44984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_45016){
var state_val_45017 = (state_45016[(1)]);
if((state_val_45017 === (7))){
var inst_45012 = (state_45016[(2)]);
var state_45016__$1 = state_45016;
var statearr_45019_48051 = state_45016__$1;
(statearr_45019_48051[(2)] = inst_45012);

(statearr_45019_48051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (1))){
var inst_44994 = init;
var inst_44995 = inst_44994;
var state_45016__$1 = (function (){var statearr_45020 = state_45016;
(statearr_45020[(7)] = inst_44995);

return statearr_45020;
})();
var statearr_45026_48052 = state_45016__$1;
(statearr_45026_48052[(2)] = null);

(statearr_45026_48052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (4))){
var inst_44998 = (state_45016[(8)]);
var inst_44998__$1 = (state_45016[(2)]);
var inst_44999 = (inst_44998__$1 == null);
var state_45016__$1 = (function (){var statearr_45029 = state_45016;
(statearr_45029[(8)] = inst_44998__$1);

return statearr_45029;
})();
if(cljs.core.truth_(inst_44999)){
var statearr_45030_48057 = state_45016__$1;
(statearr_45030_48057[(1)] = (5));

} else {
var statearr_45031_48058 = state_45016__$1;
(statearr_45031_48058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (6))){
var inst_44995 = (state_45016[(7)]);
var inst_45003 = (state_45016[(9)]);
var inst_44998 = (state_45016[(8)]);
var inst_45003__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44995,inst_44998) : f.call(null,inst_44995,inst_44998));
var inst_45004 = cljs.core.reduced_QMARK_(inst_45003__$1);
var state_45016__$1 = (function (){var statearr_45033 = state_45016;
(statearr_45033[(9)] = inst_45003__$1);

return statearr_45033;
})();
if(inst_45004){
var statearr_45034_48062 = state_45016__$1;
(statearr_45034_48062[(1)] = (8));

} else {
var statearr_45039_48063 = state_45016__$1;
(statearr_45039_48063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (3))){
var inst_45014 = (state_45016[(2)]);
var state_45016__$1 = state_45016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45016__$1,inst_45014);
} else {
if((state_val_45017 === (2))){
var state_45016__$1 = state_45016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45016__$1,(4),ch);
} else {
if((state_val_45017 === (9))){
var inst_45003 = (state_45016[(9)]);
var inst_44995 = inst_45003;
var state_45016__$1 = (function (){var statearr_45041 = state_45016;
(statearr_45041[(7)] = inst_44995);

return statearr_45041;
})();
var statearr_45042_48067 = state_45016__$1;
(statearr_45042_48067[(2)] = null);

(statearr_45042_48067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (5))){
var inst_44995 = (state_45016[(7)]);
var state_45016__$1 = state_45016;
var statearr_45043_48068 = state_45016__$1;
(statearr_45043_48068[(2)] = inst_44995);

(statearr_45043_48068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (10))){
var inst_45010 = (state_45016[(2)]);
var state_45016__$1 = state_45016;
var statearr_45044_48069 = state_45016__$1;
(statearr_45044_48069[(2)] = inst_45010);

(statearr_45044_48069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45017 === (8))){
var inst_45003 = (state_45016[(9)]);
var inst_45006 = cljs.core.deref(inst_45003);
var state_45016__$1 = state_45016;
var statearr_45047_48070 = state_45016__$1;
(statearr_45047_48070[(2)] = inst_45006);

(statearr_45047_48070[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43223__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43223__auto____0 = (function (){
var statearr_45056 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45056[(0)] = cljs$core$async$reduce_$_state_machine__43223__auto__);

(statearr_45056[(1)] = (1));

return statearr_45056;
});
var cljs$core$async$reduce_$_state_machine__43223__auto____1 = (function (state_45016){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_45016);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e45064){var ex__43226__auto__ = e45064;
var statearr_45065_48075 = state_45016;
(statearr_45065_48075[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_45016[(4)]))){
var statearr_45066_48076 = state_45016;
(statearr_45066_48076[(1)] = cljs.core.first((state_45016[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48077 = state_45016;
state_45016 = G__48077;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43223__auto__ = function(state_45016){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43223__auto____1.call(this,state_45016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43223__auto____0;
cljs$core$async$reduce_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43223__auto____1;
return cljs$core$async$reduce_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_45067 = f__43958__auto__();
(statearr_45067[(6)] = c__43957__auto__);

return statearr_45067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_45073){
var state_val_45074 = (state_45073[(1)]);
if((state_val_45074 === (1))){
var inst_45068 = cljs.core.async.reduce(f__$1,init,ch);
var state_45073__$1 = state_45073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45073__$1,(2),inst_45068);
} else {
if((state_val_45074 === (2))){
var inst_45070 = (state_45073[(2)]);
var inst_45071 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45070) : f__$1.call(null,inst_45070));
var state_45073__$1 = state_45073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45073__$1,inst_45071);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43223__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43223__auto____0 = (function (){
var statearr_45081 = [null,null,null,null,null,null,null];
(statearr_45081[(0)] = cljs$core$async$transduce_$_state_machine__43223__auto__);

(statearr_45081[(1)] = (1));

return statearr_45081;
});
var cljs$core$async$transduce_$_state_machine__43223__auto____1 = (function (state_45073){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_45073);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e45082){var ex__43226__auto__ = e45082;
var statearr_45083_48081 = state_45073;
(statearr_45083_48081[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_45073[(4)]))){
var statearr_45087_48082 = state_45073;
(statearr_45087_48082[(1)] = cljs.core.first((state_45073[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48083 = state_45073;
state_45073 = G__48083;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43223__auto__ = function(state_45073){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43223__auto____1.call(this,state_45073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43223__auto____0;
cljs$core$async$transduce_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43223__auto____1;
return cljs$core$async$transduce_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_45093 = f__43958__auto__();
(statearr_45093[(6)] = c__43957__auto__);

return statearr_45093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45097 = arguments.length;
switch (G__45097) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_45130){
var state_val_45131 = (state_45130[(1)]);
if((state_val_45131 === (7))){
var inst_45110 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
var statearr_45135_48095 = state_45130__$1;
(statearr_45135_48095[(2)] = inst_45110);

(statearr_45135_48095[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (1))){
var inst_45103 = cljs.core.seq(coll);
var inst_45104 = inst_45103;
var state_45130__$1 = (function (){var statearr_45137 = state_45130;
(statearr_45137[(7)] = inst_45104);

return statearr_45137;
})();
var statearr_45138_48096 = state_45130__$1;
(statearr_45138_48096[(2)] = null);

(statearr_45138_48096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (4))){
var inst_45104 = (state_45130[(7)]);
var inst_45108 = cljs.core.first(inst_45104);
var state_45130__$1 = state_45130;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45130__$1,(7),ch,inst_45108);
} else {
if((state_val_45131 === (13))){
var inst_45124 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
var statearr_45140_48097 = state_45130__$1;
(statearr_45140_48097[(2)] = inst_45124);

(statearr_45140_48097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (6))){
var inst_45113 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
if(cljs.core.truth_(inst_45113)){
var statearr_45141_48098 = state_45130__$1;
(statearr_45141_48098[(1)] = (8));

} else {
var statearr_45142_48099 = state_45130__$1;
(statearr_45142_48099[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (3))){
var inst_45128 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45130__$1,inst_45128);
} else {
if((state_val_45131 === (12))){
var state_45130__$1 = state_45130;
var statearr_45145_48103 = state_45130__$1;
(statearr_45145_48103[(2)] = null);

(statearr_45145_48103[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (2))){
var inst_45104 = (state_45130[(7)]);
var state_45130__$1 = state_45130;
if(cljs.core.truth_(inst_45104)){
var statearr_45149_48104 = state_45130__$1;
(statearr_45149_48104[(1)] = (4));

} else {
var statearr_45151_48108 = state_45130__$1;
(statearr_45151_48108[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (11))){
var inst_45121 = cljs.core.async.close_BANG_(ch);
var state_45130__$1 = state_45130;
var statearr_45152_48109 = state_45130__$1;
(statearr_45152_48109[(2)] = inst_45121);

(statearr_45152_48109[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (9))){
var state_45130__$1 = state_45130;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45153_48110 = state_45130__$1;
(statearr_45153_48110[(1)] = (11));

} else {
var statearr_45154_48111 = state_45130__$1;
(statearr_45154_48111[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (5))){
var inst_45104 = (state_45130[(7)]);
var state_45130__$1 = state_45130;
var statearr_45155_48112 = state_45130__$1;
(statearr_45155_48112[(2)] = inst_45104);

(statearr_45155_48112[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (10))){
var inst_45126 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
var statearr_45157_48113 = state_45130__$1;
(statearr_45157_48113[(2)] = inst_45126);

(statearr_45157_48113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (8))){
var inst_45104 = (state_45130[(7)]);
var inst_45117 = cljs.core.next(inst_45104);
var inst_45104__$1 = inst_45117;
var state_45130__$1 = (function (){var statearr_45158 = state_45130;
(statearr_45158[(7)] = inst_45104__$1);

return statearr_45158;
})();
var statearr_45159_48117 = state_45130__$1;
(statearr_45159_48117[(2)] = null);

(statearr_45159_48117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_45163 = [null,null,null,null,null,null,null,null];
(statearr_45163[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_45163[(1)] = (1));

return statearr_45163;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_45130){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_45130);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e45165){var ex__43226__auto__ = e45165;
var statearr_45166_48118 = state_45130;
(statearr_45166_48118[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_45130[(4)]))){
var statearr_45168_48119 = state_45130;
(statearr_45168_48119[(1)] = cljs.core.first((state_45130[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48120 = state_45130;
state_45130 = G__48120;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_45130){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_45130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_45169 = f__43958__auto__();
(statearr_45169[(6)] = c__43957__auto__);

return statearr_45169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45176 = arguments.length;
switch (G__45176) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_48125 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_48125(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_48127 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_48127(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_48128 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_48128(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_48130 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_48130(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45207 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45207 = (function (ch,cs,meta45208){
this.ch = ch;
this.cs = cs;
this.meta45208 = meta45208;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45209,meta45208__$1){
var self__ = this;
var _45209__$1 = this;
return (new cljs.core.async.t_cljs$core$async45207(self__.ch,self__.cs,meta45208__$1));
}));

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45209){
var self__ = this;
var _45209__$1 = this;
return self__.meta45208;
}));

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45207.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45207.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45208","meta45208",1214940400,null)], null);
}));

(cljs.core.async.t_cljs$core$async45207.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45207.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45207");

(cljs.core.async.t_cljs$core$async45207.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async45207");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45207.
 */
cljs.core.async.__GT_t_cljs$core$async45207 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45207(ch__$1,cs__$1,meta45208){
return (new cljs.core.async.t_cljs$core$async45207(ch__$1,cs__$1,meta45208));
});

}

return (new cljs.core.async.t_cljs$core$async45207(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43957__auto___48131 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_45360){
var state_val_45361 = (state_45360[(1)]);
if((state_val_45361 === (7))){
var inst_45356 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45375_48132 = state_45360__$1;
(statearr_45375_48132[(2)] = inst_45356);

(statearr_45375_48132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (20))){
var inst_45250 = (state_45360[(7)]);
var inst_45264 = cljs.core.first(inst_45250);
var inst_45265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45264,(0),null);
var inst_45266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45264,(1),null);
var state_45360__$1 = (function (){var statearr_45379 = state_45360;
(statearr_45379[(8)] = inst_45265);

return statearr_45379;
})();
if(cljs.core.truth_(inst_45266)){
var statearr_45380_48133 = state_45360__$1;
(statearr_45380_48133[(1)] = (22));

} else {
var statearr_45381_48134 = state_45360__$1;
(statearr_45381_48134[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (27))){
var inst_45303 = (state_45360[(9)]);
var inst_45296 = (state_45360[(10)]);
var inst_45217 = (state_45360[(11)]);
var inst_45298 = (state_45360[(12)]);
var inst_45303__$1 = cljs.core._nth(inst_45296,inst_45298);
var inst_45304 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45303__$1,inst_45217,done);
var state_45360__$1 = (function (){var statearr_45382 = state_45360;
(statearr_45382[(9)] = inst_45303__$1);

return statearr_45382;
})();
if(cljs.core.truth_(inst_45304)){
var statearr_45383_48139 = state_45360__$1;
(statearr_45383_48139[(1)] = (30));

} else {
var statearr_45395_48140 = state_45360__$1;
(statearr_45395_48140[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (1))){
var state_45360__$1 = state_45360;
var statearr_45400_48141 = state_45360__$1;
(statearr_45400_48141[(2)] = null);

(statearr_45400_48141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (24))){
var inst_45250 = (state_45360[(7)]);
var inst_45272 = (state_45360[(2)]);
var inst_45273 = cljs.core.next(inst_45250);
var inst_45226 = inst_45273;
var inst_45227 = null;
var inst_45228 = (0);
var inst_45229 = (0);
var state_45360__$1 = (function (){var statearr_45409 = state_45360;
(statearr_45409[(13)] = inst_45228);

(statearr_45409[(14)] = inst_45229);

(statearr_45409[(15)] = inst_45226);

(statearr_45409[(16)] = inst_45227);

(statearr_45409[(17)] = inst_45272);

return statearr_45409;
})();
var statearr_45413_48146 = state_45360__$1;
(statearr_45413_48146[(2)] = null);

(statearr_45413_48146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (39))){
var state_45360__$1 = state_45360;
var statearr_45432_48147 = state_45360__$1;
(statearr_45432_48147[(2)] = null);

(statearr_45432_48147[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (4))){
var inst_45217 = (state_45360[(11)]);
var inst_45217__$1 = (state_45360[(2)]);
var inst_45218 = (inst_45217__$1 == null);
var state_45360__$1 = (function (){var statearr_45433 = state_45360;
(statearr_45433[(11)] = inst_45217__$1);

return statearr_45433;
})();
if(cljs.core.truth_(inst_45218)){
var statearr_45438_48148 = state_45360__$1;
(statearr_45438_48148[(1)] = (5));

} else {
var statearr_45439_48149 = state_45360__$1;
(statearr_45439_48149[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (15))){
var inst_45228 = (state_45360[(13)]);
var inst_45229 = (state_45360[(14)]);
var inst_45226 = (state_45360[(15)]);
var inst_45227 = (state_45360[(16)]);
var inst_45244 = (state_45360[(2)]);
var inst_45245 = (inst_45229 + (1));
var tmp45426 = inst_45228;
var tmp45427 = inst_45226;
var tmp45428 = inst_45227;
var inst_45226__$1 = tmp45427;
var inst_45227__$1 = tmp45428;
var inst_45228__$1 = tmp45426;
var inst_45229__$1 = inst_45245;
var state_45360__$1 = (function (){var statearr_45445 = state_45360;
(statearr_45445[(18)] = inst_45244);

(statearr_45445[(13)] = inst_45228__$1);

(statearr_45445[(14)] = inst_45229__$1);

(statearr_45445[(15)] = inst_45226__$1);

(statearr_45445[(16)] = inst_45227__$1);

return statearr_45445;
})();
var statearr_45456_48150 = state_45360__$1;
(statearr_45456_48150[(2)] = null);

(statearr_45456_48150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (21))){
var inst_45276 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45463_48151 = state_45360__$1;
(statearr_45463_48151[(2)] = inst_45276);

(statearr_45463_48151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (31))){
var inst_45303 = (state_45360[(9)]);
var inst_45307 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45303);
var state_45360__$1 = state_45360;
var statearr_45466_48152 = state_45360__$1;
(statearr_45466_48152[(2)] = inst_45307);

(statearr_45466_48152[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (32))){
var inst_45295 = (state_45360[(19)]);
var inst_45297 = (state_45360[(20)]);
var inst_45296 = (state_45360[(10)]);
var inst_45298 = (state_45360[(12)]);
var inst_45309 = (state_45360[(2)]);
var inst_45310 = (inst_45298 + (1));
var tmp45458 = inst_45295;
var tmp45459 = inst_45297;
var tmp45460 = inst_45296;
var inst_45295__$1 = tmp45458;
var inst_45296__$1 = tmp45460;
var inst_45297__$1 = tmp45459;
var inst_45298__$1 = inst_45310;
var state_45360__$1 = (function (){var statearr_45473 = state_45360;
(statearr_45473[(19)] = inst_45295__$1);

(statearr_45473[(21)] = inst_45309);

(statearr_45473[(20)] = inst_45297__$1);

(statearr_45473[(10)] = inst_45296__$1);

(statearr_45473[(12)] = inst_45298__$1);

return statearr_45473;
})();
var statearr_45475_48154 = state_45360__$1;
(statearr_45475_48154[(2)] = null);

(statearr_45475_48154[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (40))){
var inst_45324 = (state_45360[(22)]);
var inst_45329 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45324);
var state_45360__$1 = state_45360;
var statearr_45479_48156 = state_45360__$1;
(statearr_45479_48156[(2)] = inst_45329);

(statearr_45479_48156[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (33))){
var inst_45314 = (state_45360[(23)]);
var inst_45317 = cljs.core.chunked_seq_QMARK_(inst_45314);
var state_45360__$1 = state_45360;
if(inst_45317){
var statearr_45486_48160 = state_45360__$1;
(statearr_45486_48160[(1)] = (36));

} else {
var statearr_45488_48161 = state_45360__$1;
(statearr_45488_48161[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (13))){
var inst_45238 = (state_45360[(24)]);
var inst_45241 = cljs.core.async.close_BANG_(inst_45238);
var state_45360__$1 = state_45360;
var statearr_45502_48162 = state_45360__$1;
(statearr_45502_48162[(2)] = inst_45241);

(statearr_45502_48162[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (22))){
var inst_45265 = (state_45360[(8)]);
var inst_45269 = cljs.core.async.close_BANG_(inst_45265);
var state_45360__$1 = state_45360;
var statearr_45505_48164 = state_45360__$1;
(statearr_45505_48164[(2)] = inst_45269);

(statearr_45505_48164[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (36))){
var inst_45314 = (state_45360[(23)]);
var inst_45319 = cljs.core.chunk_first(inst_45314);
var inst_45320 = cljs.core.chunk_rest(inst_45314);
var inst_45321 = cljs.core.count(inst_45319);
var inst_45295 = inst_45320;
var inst_45296 = inst_45319;
var inst_45297 = inst_45321;
var inst_45298 = (0);
var state_45360__$1 = (function (){var statearr_45515 = state_45360;
(statearr_45515[(19)] = inst_45295);

(statearr_45515[(20)] = inst_45297);

(statearr_45515[(10)] = inst_45296);

(statearr_45515[(12)] = inst_45298);

return statearr_45515;
})();
var statearr_45522_48166 = state_45360__$1;
(statearr_45522_48166[(2)] = null);

(statearr_45522_48166[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (41))){
var inst_45314 = (state_45360[(23)]);
var inst_45331 = (state_45360[(2)]);
var inst_45332 = cljs.core.next(inst_45314);
var inst_45295 = inst_45332;
var inst_45296 = null;
var inst_45297 = (0);
var inst_45298 = (0);
var state_45360__$1 = (function (){var statearr_45528 = state_45360;
(statearr_45528[(19)] = inst_45295);

(statearr_45528[(20)] = inst_45297);

(statearr_45528[(10)] = inst_45296);

(statearr_45528[(12)] = inst_45298);

(statearr_45528[(25)] = inst_45331);

return statearr_45528;
})();
var statearr_45534_48169 = state_45360__$1;
(statearr_45534_48169[(2)] = null);

(statearr_45534_48169[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (43))){
var state_45360__$1 = state_45360;
var statearr_45538_48171 = state_45360__$1;
(statearr_45538_48171[(2)] = null);

(statearr_45538_48171[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (29))){
var inst_45341 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45541_48172 = state_45360__$1;
(statearr_45541_48172[(2)] = inst_45341);

(statearr_45541_48172[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (44))){
var inst_45353 = (state_45360[(2)]);
var state_45360__$1 = (function (){var statearr_45548 = state_45360;
(statearr_45548[(26)] = inst_45353);

return statearr_45548;
})();
var statearr_45549_48173 = state_45360__$1;
(statearr_45549_48173[(2)] = null);

(statearr_45549_48173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (6))){
var inst_45287 = (state_45360[(27)]);
var inst_45286 = cljs.core.deref(cs);
var inst_45287__$1 = cljs.core.keys(inst_45286);
var inst_45288 = cljs.core.count(inst_45287__$1);
var inst_45289 = cljs.core.reset_BANG_(dctr,inst_45288);
var inst_45294 = cljs.core.seq(inst_45287__$1);
var inst_45295 = inst_45294;
var inst_45296 = null;
var inst_45297 = (0);
var inst_45298 = (0);
var state_45360__$1 = (function (){var statearr_45557 = state_45360;
(statearr_45557[(19)] = inst_45295);

(statearr_45557[(27)] = inst_45287__$1);

(statearr_45557[(20)] = inst_45297);

(statearr_45557[(10)] = inst_45296);

(statearr_45557[(12)] = inst_45298);

(statearr_45557[(28)] = inst_45289);

return statearr_45557;
})();
var statearr_45565_48174 = state_45360__$1;
(statearr_45565_48174[(2)] = null);

(statearr_45565_48174[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (28))){
var inst_45295 = (state_45360[(19)]);
var inst_45314 = (state_45360[(23)]);
var inst_45314__$1 = cljs.core.seq(inst_45295);
var state_45360__$1 = (function (){var statearr_45570 = state_45360;
(statearr_45570[(23)] = inst_45314__$1);

return statearr_45570;
})();
if(inst_45314__$1){
var statearr_45573_48175 = state_45360__$1;
(statearr_45573_48175[(1)] = (33));

} else {
var statearr_45579_48176 = state_45360__$1;
(statearr_45579_48176[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (25))){
var inst_45297 = (state_45360[(20)]);
var inst_45298 = (state_45360[(12)]);
var inst_45300 = (inst_45298 < inst_45297);
var inst_45301 = inst_45300;
var state_45360__$1 = state_45360;
if(cljs.core.truth_(inst_45301)){
var statearr_45585_48177 = state_45360__$1;
(statearr_45585_48177[(1)] = (27));

} else {
var statearr_45588_48178 = state_45360__$1;
(statearr_45588_48178[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (34))){
var state_45360__$1 = state_45360;
var statearr_45593_48179 = state_45360__$1;
(statearr_45593_48179[(2)] = null);

(statearr_45593_48179[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (17))){
var state_45360__$1 = state_45360;
var statearr_45596_48180 = state_45360__$1;
(statearr_45596_48180[(2)] = null);

(statearr_45596_48180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (3))){
var inst_45358 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45360__$1,inst_45358);
} else {
if((state_val_45361 === (12))){
var inst_45281 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45606_48185 = state_45360__$1;
(statearr_45606_48185[(2)] = inst_45281);

(statearr_45606_48185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (2))){
var state_45360__$1 = state_45360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45360__$1,(4),ch);
} else {
if((state_val_45361 === (23))){
var state_45360__$1 = state_45360;
var statearr_45611_48186 = state_45360__$1;
(statearr_45611_48186[(2)] = null);

(statearr_45611_48186[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (35))){
var inst_45339 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45614_48187 = state_45360__$1;
(statearr_45614_48187[(2)] = inst_45339);

(statearr_45614_48187[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (19))){
var inst_45250 = (state_45360[(7)]);
var inst_45256 = cljs.core.chunk_first(inst_45250);
var inst_45257 = cljs.core.chunk_rest(inst_45250);
var inst_45258 = cljs.core.count(inst_45256);
var inst_45226 = inst_45257;
var inst_45227 = inst_45256;
var inst_45228 = inst_45258;
var inst_45229 = (0);
var state_45360__$1 = (function (){var statearr_45623 = state_45360;
(statearr_45623[(13)] = inst_45228);

(statearr_45623[(14)] = inst_45229);

(statearr_45623[(15)] = inst_45226);

(statearr_45623[(16)] = inst_45227);

return statearr_45623;
})();
var statearr_45625_48192 = state_45360__$1;
(statearr_45625_48192[(2)] = null);

(statearr_45625_48192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (11))){
var inst_45226 = (state_45360[(15)]);
var inst_45250 = (state_45360[(7)]);
var inst_45250__$1 = cljs.core.seq(inst_45226);
var state_45360__$1 = (function (){var statearr_45631 = state_45360;
(statearr_45631[(7)] = inst_45250__$1);

return statearr_45631;
})();
if(inst_45250__$1){
var statearr_45634_48193 = state_45360__$1;
(statearr_45634_48193[(1)] = (16));

} else {
var statearr_45639_48194 = state_45360__$1;
(statearr_45639_48194[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (9))){
var inst_45283 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45644_48195 = state_45360__$1;
(statearr_45644_48195[(2)] = inst_45283);

(statearr_45644_48195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (5))){
var inst_45224 = cljs.core.deref(cs);
var inst_45225 = cljs.core.seq(inst_45224);
var inst_45226 = inst_45225;
var inst_45227 = null;
var inst_45228 = (0);
var inst_45229 = (0);
var state_45360__$1 = (function (){var statearr_45648 = state_45360;
(statearr_45648[(13)] = inst_45228);

(statearr_45648[(14)] = inst_45229);

(statearr_45648[(15)] = inst_45226);

(statearr_45648[(16)] = inst_45227);

return statearr_45648;
})();
var statearr_45649_48203 = state_45360__$1;
(statearr_45649_48203[(2)] = null);

(statearr_45649_48203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (14))){
var state_45360__$1 = state_45360;
var statearr_45660_48204 = state_45360__$1;
(statearr_45660_48204[(2)] = null);

(statearr_45660_48204[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (45))){
var inst_45350 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45666_48211 = state_45360__$1;
(statearr_45666_48211[(2)] = inst_45350);

(statearr_45666_48211[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (26))){
var inst_45287 = (state_45360[(27)]);
var inst_45343 = (state_45360[(2)]);
var inst_45344 = cljs.core.seq(inst_45287);
var state_45360__$1 = (function (){var statearr_45668 = state_45360;
(statearr_45668[(29)] = inst_45343);

return statearr_45668;
})();
if(inst_45344){
var statearr_45669_48212 = state_45360__$1;
(statearr_45669_48212[(1)] = (42));

} else {
var statearr_45674_48213 = state_45360__$1;
(statearr_45674_48213[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (16))){
var inst_45250 = (state_45360[(7)]);
var inst_45254 = cljs.core.chunked_seq_QMARK_(inst_45250);
var state_45360__$1 = state_45360;
if(inst_45254){
var statearr_45678_48214 = state_45360__$1;
(statearr_45678_48214[(1)] = (19));

} else {
var statearr_45681_48215 = state_45360__$1;
(statearr_45681_48215[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (38))){
var inst_45336 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45690_48216 = state_45360__$1;
(statearr_45690_48216[(2)] = inst_45336);

(statearr_45690_48216[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (30))){
var state_45360__$1 = state_45360;
var statearr_45695_48217 = state_45360__$1;
(statearr_45695_48217[(2)] = null);

(statearr_45695_48217[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (10))){
var inst_45229 = (state_45360[(14)]);
var inst_45227 = (state_45360[(16)]);
var inst_45237 = cljs.core._nth(inst_45227,inst_45229);
var inst_45238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45237,(0),null);
var inst_45239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45237,(1),null);
var state_45360__$1 = (function (){var statearr_45703 = state_45360;
(statearr_45703[(24)] = inst_45238);

return statearr_45703;
})();
if(cljs.core.truth_(inst_45239)){
var statearr_45706_48218 = state_45360__$1;
(statearr_45706_48218[(1)] = (13));

} else {
var statearr_45709_48219 = state_45360__$1;
(statearr_45709_48219[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (18))){
var inst_45279 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45716_48220 = state_45360__$1;
(statearr_45716_48220[(2)] = inst_45279);

(statearr_45716_48220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (42))){
var state_45360__$1 = state_45360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45360__$1,(45),dchan);
} else {
if((state_val_45361 === (37))){
var inst_45324 = (state_45360[(22)]);
var inst_45217 = (state_45360[(11)]);
var inst_45314 = (state_45360[(23)]);
var inst_45324__$1 = cljs.core.first(inst_45314);
var inst_45325 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45324__$1,inst_45217,done);
var state_45360__$1 = (function (){var statearr_45732 = state_45360;
(statearr_45732[(22)] = inst_45324__$1);

return statearr_45732;
})();
if(cljs.core.truth_(inst_45325)){
var statearr_45733_48221 = state_45360__$1;
(statearr_45733_48221[(1)] = (39));

} else {
var statearr_45742_48222 = state_45360__$1;
(statearr_45742_48222[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45361 === (8))){
var inst_45228 = (state_45360[(13)]);
var inst_45229 = (state_45360[(14)]);
var inst_45231 = (inst_45229 < inst_45228);
var inst_45232 = inst_45231;
var state_45360__$1 = state_45360;
if(cljs.core.truth_(inst_45232)){
var statearr_45758_48223 = state_45360__$1;
(statearr_45758_48223[(1)] = (10));

} else {
var statearr_45760_48224 = state_45360__$1;
(statearr_45760_48224[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43223__auto__ = null;
var cljs$core$async$mult_$_state_machine__43223__auto____0 = (function (){
var statearr_45773 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45773[(0)] = cljs$core$async$mult_$_state_machine__43223__auto__);

(statearr_45773[(1)] = (1));

return statearr_45773;
});
var cljs$core$async$mult_$_state_machine__43223__auto____1 = (function (state_45360){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_45360);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e45776){var ex__43226__auto__ = e45776;
var statearr_45777_48225 = state_45360;
(statearr_45777_48225[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_45360[(4)]))){
var statearr_45780_48226 = state_45360;
(statearr_45780_48226[(1)] = cljs.core.first((state_45360[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48227 = state_45360;
state_45360 = G__48227;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43223__auto__ = function(state_45360){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43223__auto____1.call(this,state_45360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43223__auto____0;
cljs$core$async$mult_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43223__auto____1;
return cljs$core$async$mult_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_45790 = f__43958__auto__();
(statearr_45790[(6)] = c__43957__auto___48131);

return statearr_45790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45801 = arguments.length;
switch (G__45801) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_48235 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_48235(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_48240 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_48240(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_48244 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_48244(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_48245 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_48245(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_48246 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_48246(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48247 = arguments.length;
var i__4819__auto___48248 = (0);
while(true){
if((i__4819__auto___48248 < len__4818__auto___48247)){
args__4824__auto__.push((arguments[i__4819__auto___48248]));

var G__48255 = (i__4819__auto___48248 + (1));
i__4819__auto___48248 = G__48255;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45944){
var map__45946 = p__45944;
var map__45946__$1 = cljs.core.__destructure_map(map__45946);
var opts = map__45946__$1;
var statearr_45947_48256 = state;
(statearr_45947_48256[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45950_48257 = state;
(statearr_45950_48257[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_45952_48258 = state;
(statearr_45952_48258[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45914){
var G__45915 = cljs.core.first(seq45914);
var seq45914__$1 = cljs.core.next(seq45914);
var G__45916 = cljs.core.first(seq45914__$1);
var seq45914__$2 = cljs.core.next(seq45914__$1);
var G__45917 = cljs.core.first(seq45914__$2);
var seq45914__$3 = cljs.core.next(seq45914__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45915,G__45916,G__45917,seq45914__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45966 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45966 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45967){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45967 = meta45967;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45968,meta45967__$1){
var self__ = this;
var _45968__$1 = this;
return (new cljs.core.async.t_cljs$core$async45966(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45967__$1));
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45968){
var self__ = this;
var _45968__$1 = this;
return self__.meta45967;
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45966.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45966.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45967","meta45967",-71673662,null)], null);
}));

(cljs.core.async.t_cljs$core$async45966.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45966.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45966");

(cljs.core.async.t_cljs$core$async45966.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async45966");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45966.
 */
cljs.core.async.__GT_t_cljs$core$async45966 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45966(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45967){
return (new cljs.core.async.t_cljs$core$async45966(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45967));
});

}

return (new cljs.core.async.t_cljs$core$async45966(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43957__auto___48269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_46083){
var state_val_46084 = (state_46083[(1)]);
if((state_val_46084 === (7))){
var inst_46033 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
if(cljs.core.truth_(inst_46033)){
var statearr_46089_48270 = state_46083__$1;
(statearr_46089_48270[(1)] = (8));

} else {
var statearr_46090_48271 = state_46083__$1;
(statearr_46090_48271[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (20))){
var inst_46021 = (state_46083[(7)]);
var state_46083__$1 = state_46083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46083__$1,(23),out,inst_46021);
} else {
if((state_val_46084 === (1))){
var inst_46004 = calc_state();
var inst_46005 = cljs.core.__destructure_map(inst_46004);
var inst_46006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46005,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46007 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46005,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46005,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46009 = inst_46004;
var state_46083__$1 = (function (){var statearr_46095 = state_46083;
(statearr_46095[(8)] = inst_46006);

(statearr_46095[(9)] = inst_46007);

(statearr_46095[(10)] = inst_46008);

(statearr_46095[(11)] = inst_46009);

return statearr_46095;
})();
var statearr_46096_48272 = state_46083__$1;
(statearr_46096_48272[(2)] = null);

(statearr_46096_48272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (24))){
var inst_46012 = (state_46083[(12)]);
var inst_46009 = inst_46012;
var state_46083__$1 = (function (){var statearr_46099 = state_46083;
(statearr_46099[(11)] = inst_46009);

return statearr_46099;
})();
var statearr_46100_48273 = state_46083__$1;
(statearr_46100_48273[(2)] = null);

(statearr_46100_48273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (4))){
var inst_46028 = (state_46083[(13)]);
var inst_46021 = (state_46083[(7)]);
var inst_46020 = (state_46083[(2)]);
var inst_46021__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46020,(0),null);
var inst_46023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46020,(1),null);
var inst_46028__$1 = (inst_46021__$1 == null);
var state_46083__$1 = (function (){var statearr_46102 = state_46083;
(statearr_46102[(14)] = inst_46023);

(statearr_46102[(13)] = inst_46028__$1);

(statearr_46102[(7)] = inst_46021__$1);

return statearr_46102;
})();
if(cljs.core.truth_(inst_46028__$1)){
var statearr_46109_48274 = state_46083__$1;
(statearr_46109_48274[(1)] = (5));

} else {
var statearr_46114_48275 = state_46083__$1;
(statearr_46114_48275[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (15))){
var inst_46051 = (state_46083[(15)]);
var inst_46013 = (state_46083[(16)]);
var inst_46051__$1 = cljs.core.empty_QMARK_(inst_46013);
var state_46083__$1 = (function (){var statearr_46117 = state_46083;
(statearr_46117[(15)] = inst_46051__$1);

return statearr_46117;
})();
if(inst_46051__$1){
var statearr_46120_48276 = state_46083__$1;
(statearr_46120_48276[(1)] = (17));

} else {
var statearr_46121_48277 = state_46083__$1;
(statearr_46121_48277[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (21))){
var inst_46012 = (state_46083[(12)]);
var inst_46009 = inst_46012;
var state_46083__$1 = (function (){var statearr_46122 = state_46083;
(statearr_46122[(11)] = inst_46009);

return statearr_46122;
})();
var statearr_46123_48278 = state_46083__$1;
(statearr_46123_48278[(2)] = null);

(statearr_46123_48278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (13))){
var inst_46043 = (state_46083[(2)]);
var inst_46044 = calc_state();
var inst_46009 = inst_46044;
var state_46083__$1 = (function (){var statearr_46128 = state_46083;
(statearr_46128[(17)] = inst_46043);

(statearr_46128[(11)] = inst_46009);

return statearr_46128;
})();
var statearr_46130_48279 = state_46083__$1;
(statearr_46130_48279[(2)] = null);

(statearr_46130_48279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (22))){
var inst_46073 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
var statearr_46132_48280 = state_46083__$1;
(statearr_46132_48280[(2)] = inst_46073);

(statearr_46132_48280[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (6))){
var inst_46023 = (state_46083[(14)]);
var inst_46031 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46023,change);
var state_46083__$1 = state_46083;
var statearr_46141_48282 = state_46083__$1;
(statearr_46141_48282[(2)] = inst_46031);

(statearr_46141_48282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (25))){
var state_46083__$1 = state_46083;
var statearr_46151_48283 = state_46083__$1;
(statearr_46151_48283[(2)] = null);

(statearr_46151_48283[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (17))){
var inst_46023 = (state_46083[(14)]);
var inst_46014 = (state_46083[(18)]);
var inst_46055 = (inst_46014.cljs$core$IFn$_invoke$arity$1 ? inst_46014.cljs$core$IFn$_invoke$arity$1(inst_46023) : inst_46014.call(null,inst_46023));
var inst_46056 = cljs.core.not(inst_46055);
var state_46083__$1 = state_46083;
var statearr_46155_48288 = state_46083__$1;
(statearr_46155_48288[(2)] = inst_46056);

(statearr_46155_48288[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (3))){
var inst_46077 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46083__$1,inst_46077);
} else {
if((state_val_46084 === (12))){
var state_46083__$1 = state_46083;
var statearr_46164_48289 = state_46083__$1;
(statearr_46164_48289[(2)] = null);

(statearr_46164_48289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (2))){
var inst_46009 = (state_46083[(11)]);
var inst_46012 = (state_46083[(12)]);
var inst_46012__$1 = cljs.core.__destructure_map(inst_46009);
var inst_46013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46012__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46014 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46012__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46012__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46083__$1 = (function (){var statearr_46165 = state_46083;
(statearr_46165[(18)] = inst_46014);

(statearr_46165[(16)] = inst_46013);

(statearr_46165[(12)] = inst_46012__$1);

return statearr_46165;
})();
return cljs.core.async.ioc_alts_BANG_(state_46083__$1,(4),inst_46015);
} else {
if((state_val_46084 === (23))){
var inst_46064 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
if(cljs.core.truth_(inst_46064)){
var statearr_46168_48290 = state_46083__$1;
(statearr_46168_48290[(1)] = (24));

} else {
var statearr_46169_48291 = state_46083__$1;
(statearr_46169_48291[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (19))){
var inst_46059 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
var statearr_46171_48292 = state_46083__$1;
(statearr_46171_48292[(2)] = inst_46059);

(statearr_46171_48292[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (11))){
var inst_46023 = (state_46083[(14)]);
var inst_46040 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46023);
var state_46083__$1 = state_46083;
var statearr_46172_48293 = state_46083__$1;
(statearr_46172_48293[(2)] = inst_46040);

(statearr_46172_48293[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (9))){
var inst_46023 = (state_46083[(14)]);
var inst_46048 = (state_46083[(19)]);
var inst_46013 = (state_46083[(16)]);
var inst_46048__$1 = (inst_46013.cljs$core$IFn$_invoke$arity$1 ? inst_46013.cljs$core$IFn$_invoke$arity$1(inst_46023) : inst_46013.call(null,inst_46023));
var state_46083__$1 = (function (){var statearr_46181 = state_46083;
(statearr_46181[(19)] = inst_46048__$1);

return statearr_46181;
})();
if(cljs.core.truth_(inst_46048__$1)){
var statearr_46185_48294 = state_46083__$1;
(statearr_46185_48294[(1)] = (14));

} else {
var statearr_46186_48295 = state_46083__$1;
(statearr_46186_48295[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (5))){
var inst_46028 = (state_46083[(13)]);
var state_46083__$1 = state_46083;
var statearr_46188_48296 = state_46083__$1;
(statearr_46188_48296[(2)] = inst_46028);

(statearr_46188_48296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (14))){
var inst_46048 = (state_46083[(19)]);
var state_46083__$1 = state_46083;
var statearr_46189_48297 = state_46083__$1;
(statearr_46189_48297[(2)] = inst_46048);

(statearr_46189_48297[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (26))){
var inst_46069 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
var statearr_46193_48298 = state_46083__$1;
(statearr_46193_48298[(2)] = inst_46069);

(statearr_46193_48298[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (16))){
var inst_46061 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
if(cljs.core.truth_(inst_46061)){
var statearr_46196_48299 = state_46083__$1;
(statearr_46196_48299[(1)] = (20));

} else {
var statearr_46197_48300 = state_46083__$1;
(statearr_46197_48300[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (10))){
var inst_46075 = (state_46083[(2)]);
var state_46083__$1 = state_46083;
var statearr_46204_48301 = state_46083__$1;
(statearr_46204_48301[(2)] = inst_46075);

(statearr_46204_48301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (18))){
var inst_46051 = (state_46083[(15)]);
var state_46083__$1 = state_46083;
var statearr_46205_48302 = state_46083__$1;
(statearr_46205_48302[(2)] = inst_46051);

(statearr_46205_48302[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46084 === (8))){
var inst_46021 = (state_46083[(7)]);
var inst_46038 = (inst_46021 == null);
var state_46083__$1 = state_46083;
if(cljs.core.truth_(inst_46038)){
var statearr_46208_48303 = state_46083__$1;
(statearr_46208_48303[(1)] = (11));

} else {
var statearr_46209_48304 = state_46083__$1;
(statearr_46209_48304[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43223__auto__ = null;
var cljs$core$async$mix_$_state_machine__43223__auto____0 = (function (){
var statearr_46217 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46217[(0)] = cljs$core$async$mix_$_state_machine__43223__auto__);

(statearr_46217[(1)] = (1));

return statearr_46217;
});
var cljs$core$async$mix_$_state_machine__43223__auto____1 = (function (state_46083){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_46083);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e46220){var ex__43226__auto__ = e46220;
var statearr_46225_48307 = state_46083;
(statearr_46225_48307[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_46083[(4)]))){
var statearr_46229_48308 = state_46083;
(statearr_46229_48308[(1)] = cljs.core.first((state_46083[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48310 = state_46083;
state_46083 = G__48310;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43223__auto__ = function(state_46083){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43223__auto____1.call(this,state_46083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43223__auto____0;
cljs$core$async$mix_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43223__auto____1;
return cljs$core$async$mix_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_46241 = f__43958__auto__();
(statearr_46241[(6)] = c__43957__auto___48269);

return statearr_46241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_48315 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_48315(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_48316 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_48316(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_48317 = (function() {
var G__48318 = null;
var G__48318__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__48318__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__48318 = function(p,v){
switch(arguments.length){
case 1:
return G__48318__1.call(this,p);
case 2:
return G__48318__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48318.cljs$core$IFn$_invoke$arity$1 = G__48318__1;
G__48318.cljs$core$IFn$_invoke$arity$2 = G__48318__2;
return G__48318;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46305 = arguments.length;
switch (G__46305) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48317(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48317(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46329 = arguments.length;
switch (G__46329) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46323_SHARP_){
if(cljs.core.truth_((p1__46323_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46323_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46323_SHARP_.call(null,topic)))){
return p1__46323_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46323_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46333 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46333 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46334){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46334 = meta46334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46335,meta46334__$1){
var self__ = this;
var _46335__$1 = this;
return (new cljs.core.async.t_cljs$core$async46333(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46334__$1));
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46335){
var self__ = this;
var _46335__$1 = this;
return self__.meta46334;
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46333.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46334","meta46334",1628736635,null)], null);
}));

(cljs.core.async.t_cljs$core$async46333.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46333");

(cljs.core.async.t_cljs$core$async46333.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async46333");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46333.
 */
cljs.core.async.__GT_t_cljs$core$async46333 = (function cljs$core$async$__GT_t_cljs$core$async46333(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46334){
return (new cljs.core.async.t_cljs$core$async46333(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46334));
});

}

return (new cljs.core.async.t_cljs$core$async46333(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43957__auto___48324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_46441){
var state_val_46442 = (state_46441[(1)]);
if((state_val_46442 === (7))){
var inst_46437 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46445_48329 = state_46441__$1;
(statearr_46445_48329[(2)] = inst_46437);

(statearr_46445_48329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (20))){
var state_46441__$1 = state_46441;
var statearr_46450_48330 = state_46441__$1;
(statearr_46450_48330[(2)] = null);

(statearr_46450_48330[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (1))){
var state_46441__$1 = state_46441;
var statearr_46455_48331 = state_46441__$1;
(statearr_46455_48331[(2)] = null);

(statearr_46455_48331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (24))){
var inst_46420 = (state_46441[(7)]);
var inst_46429 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46420);
var state_46441__$1 = state_46441;
var statearr_46461_48336 = state_46441__$1;
(statearr_46461_48336[(2)] = inst_46429);

(statearr_46461_48336[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (4))){
var inst_46368 = (state_46441[(8)]);
var inst_46368__$1 = (state_46441[(2)]);
var inst_46369 = (inst_46368__$1 == null);
var state_46441__$1 = (function (){var statearr_46463 = state_46441;
(statearr_46463[(8)] = inst_46368__$1);

return statearr_46463;
})();
if(cljs.core.truth_(inst_46369)){
var statearr_46464_48337 = state_46441__$1;
(statearr_46464_48337[(1)] = (5));

} else {
var statearr_46466_48338 = state_46441__$1;
(statearr_46466_48338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (15))){
var inst_46414 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46468_48343 = state_46441__$1;
(statearr_46468_48343[(2)] = inst_46414);

(statearr_46468_48343[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (21))){
var inst_46434 = (state_46441[(2)]);
var state_46441__$1 = (function (){var statearr_46469 = state_46441;
(statearr_46469[(9)] = inst_46434);

return statearr_46469;
})();
var statearr_46471_48344 = state_46441__$1;
(statearr_46471_48344[(2)] = null);

(statearr_46471_48344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (13))){
var inst_46393 = (state_46441[(10)]);
var inst_46395 = cljs.core.chunked_seq_QMARK_(inst_46393);
var state_46441__$1 = state_46441;
if(inst_46395){
var statearr_46474_48345 = state_46441__$1;
(statearr_46474_48345[(1)] = (16));

} else {
var statearr_46475_48346 = state_46441__$1;
(statearr_46475_48346[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (22))){
var inst_46426 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
if(cljs.core.truth_(inst_46426)){
var statearr_46479_48347 = state_46441__$1;
(statearr_46479_48347[(1)] = (23));

} else {
var statearr_46480_48348 = state_46441__$1;
(statearr_46480_48348[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (6))){
var inst_46420 = (state_46441[(7)]);
var inst_46368 = (state_46441[(8)]);
var inst_46422 = (state_46441[(11)]);
var inst_46420__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46368) : topic_fn.call(null,inst_46368));
var inst_46421 = cljs.core.deref(mults);
var inst_46422__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46421,inst_46420__$1);
var state_46441__$1 = (function (){var statearr_46484 = state_46441;
(statearr_46484[(7)] = inst_46420__$1);

(statearr_46484[(11)] = inst_46422__$1);

return statearr_46484;
})();
if(cljs.core.truth_(inst_46422__$1)){
var statearr_46489_48349 = state_46441__$1;
(statearr_46489_48349[(1)] = (19));

} else {
var statearr_46491_48350 = state_46441__$1;
(statearr_46491_48350[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (25))){
var inst_46431 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46494_48351 = state_46441__$1;
(statearr_46494_48351[(2)] = inst_46431);

(statearr_46494_48351[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (17))){
var inst_46393 = (state_46441[(10)]);
var inst_46405 = cljs.core.first(inst_46393);
var inst_46406 = cljs.core.async.muxch_STAR_(inst_46405);
var inst_46407 = cljs.core.async.close_BANG_(inst_46406);
var inst_46408 = cljs.core.next(inst_46393);
var inst_46378 = inst_46408;
var inst_46379 = null;
var inst_46380 = (0);
var inst_46381 = (0);
var state_46441__$1 = (function (){var statearr_46499 = state_46441;
(statearr_46499[(12)] = inst_46378);

(statearr_46499[(13)] = inst_46407);

(statearr_46499[(14)] = inst_46381);

(statearr_46499[(15)] = inst_46380);

(statearr_46499[(16)] = inst_46379);

return statearr_46499;
})();
var statearr_46506_48352 = state_46441__$1;
(statearr_46506_48352[(2)] = null);

(statearr_46506_48352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (3))){
var inst_46439 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46441__$1,inst_46439);
} else {
if((state_val_46442 === (12))){
var inst_46416 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46510_48353 = state_46441__$1;
(statearr_46510_48353[(2)] = inst_46416);

(statearr_46510_48353[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (2))){
var state_46441__$1 = state_46441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46441__$1,(4),ch);
} else {
if((state_val_46442 === (23))){
var state_46441__$1 = state_46441;
var statearr_46513_48358 = state_46441__$1;
(statearr_46513_48358[(2)] = null);

(statearr_46513_48358[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (19))){
var inst_46368 = (state_46441[(8)]);
var inst_46422 = (state_46441[(11)]);
var inst_46424 = cljs.core.async.muxch_STAR_(inst_46422);
var state_46441__$1 = state_46441;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46441__$1,(22),inst_46424,inst_46368);
} else {
if((state_val_46442 === (11))){
var inst_46378 = (state_46441[(12)]);
var inst_46393 = (state_46441[(10)]);
var inst_46393__$1 = cljs.core.seq(inst_46378);
var state_46441__$1 = (function (){var statearr_46514 = state_46441;
(statearr_46514[(10)] = inst_46393__$1);

return statearr_46514;
})();
if(inst_46393__$1){
var statearr_46521_48362 = state_46441__$1;
(statearr_46521_48362[(1)] = (13));

} else {
var statearr_46523_48363 = state_46441__$1;
(statearr_46523_48363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (9))){
var inst_46418 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46530_48364 = state_46441__$1;
(statearr_46530_48364[(2)] = inst_46418);

(statearr_46530_48364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (5))){
var inst_46375 = cljs.core.deref(mults);
var inst_46376 = cljs.core.vals(inst_46375);
var inst_46377 = cljs.core.seq(inst_46376);
var inst_46378 = inst_46377;
var inst_46379 = null;
var inst_46380 = (0);
var inst_46381 = (0);
var state_46441__$1 = (function (){var statearr_46539 = state_46441;
(statearr_46539[(12)] = inst_46378);

(statearr_46539[(14)] = inst_46381);

(statearr_46539[(15)] = inst_46380);

(statearr_46539[(16)] = inst_46379);

return statearr_46539;
})();
var statearr_46540_48365 = state_46441__$1;
(statearr_46540_48365[(2)] = null);

(statearr_46540_48365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (14))){
var state_46441__$1 = state_46441;
var statearr_46545_48369 = state_46441__$1;
(statearr_46545_48369[(2)] = null);

(statearr_46545_48369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (16))){
var inst_46393 = (state_46441[(10)]);
var inst_46398 = cljs.core.chunk_first(inst_46393);
var inst_46399 = cljs.core.chunk_rest(inst_46393);
var inst_46400 = cljs.core.count(inst_46398);
var inst_46378 = inst_46399;
var inst_46379 = inst_46398;
var inst_46380 = inst_46400;
var inst_46381 = (0);
var state_46441__$1 = (function (){var statearr_46553 = state_46441;
(statearr_46553[(12)] = inst_46378);

(statearr_46553[(14)] = inst_46381);

(statearr_46553[(15)] = inst_46380);

(statearr_46553[(16)] = inst_46379);

return statearr_46553;
})();
var statearr_46556_48370 = state_46441__$1;
(statearr_46556_48370[(2)] = null);

(statearr_46556_48370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (10))){
var inst_46378 = (state_46441[(12)]);
var inst_46381 = (state_46441[(14)]);
var inst_46380 = (state_46441[(15)]);
var inst_46379 = (state_46441[(16)]);
var inst_46386 = cljs.core._nth(inst_46379,inst_46381);
var inst_46387 = cljs.core.async.muxch_STAR_(inst_46386);
var inst_46388 = cljs.core.async.close_BANG_(inst_46387);
var inst_46389 = (inst_46381 + (1));
var tmp46542 = inst_46378;
var tmp46543 = inst_46380;
var tmp46544 = inst_46379;
var inst_46378__$1 = tmp46542;
var inst_46379__$1 = tmp46544;
var inst_46380__$1 = tmp46543;
var inst_46381__$1 = inst_46389;
var state_46441__$1 = (function (){var statearr_46560 = state_46441;
(statearr_46560[(12)] = inst_46378__$1);

(statearr_46560[(17)] = inst_46388);

(statearr_46560[(14)] = inst_46381__$1);

(statearr_46560[(15)] = inst_46380__$1);

(statearr_46560[(16)] = inst_46379__$1);

return statearr_46560;
})();
var statearr_46561_48374 = state_46441__$1;
(statearr_46561_48374[(2)] = null);

(statearr_46561_48374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (18))){
var inst_46411 = (state_46441[(2)]);
var state_46441__$1 = state_46441;
var statearr_46570_48375 = state_46441__$1;
(statearr_46570_48375[(2)] = inst_46411);

(statearr_46570_48375[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46442 === (8))){
var inst_46381 = (state_46441[(14)]);
var inst_46380 = (state_46441[(15)]);
var inst_46383 = (inst_46381 < inst_46380);
var inst_46384 = inst_46383;
var state_46441__$1 = state_46441;
if(cljs.core.truth_(inst_46384)){
var statearr_46574_48376 = state_46441__$1;
(statearr_46574_48376[(1)] = (10));

} else {
var statearr_46575_48377 = state_46441__$1;
(statearr_46575_48377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_46576 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46576[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_46576[(1)] = (1));

return statearr_46576;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_46441){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_46441);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e46577){var ex__43226__auto__ = e46577;
var statearr_46578_48381 = state_46441;
(statearr_46578_48381[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_46441[(4)]))){
var statearr_46581_48382 = state_46441;
(statearr_46581_48382[(1)] = cljs.core.first((state_46441[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48383 = state_46441;
state_46441 = G__48383;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_46441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_46441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_46582 = f__43958__auto__();
(statearr_46582[(6)] = c__43957__auto___48324);

return statearr_46582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46590 = arguments.length;
switch (G__46590) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46610 = arguments.length;
switch (G__46610) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46621 = arguments.length;
switch (G__46621) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43957__auto___48391 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_46711){
var state_val_46713 = (state_46711[(1)]);
if((state_val_46713 === (7))){
var state_46711__$1 = state_46711;
var statearr_46720_48392 = state_46711__$1;
(statearr_46720_48392[(2)] = null);

(statearr_46720_48392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (1))){
var state_46711__$1 = state_46711;
var statearr_46723_48393 = state_46711__$1;
(statearr_46723_48393[(2)] = null);

(statearr_46723_48393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (4))){
var inst_46658 = (state_46711[(7)]);
var inst_46657 = (state_46711[(8)]);
var inst_46660 = (inst_46658 < inst_46657);
var state_46711__$1 = state_46711;
if(cljs.core.truth_(inst_46660)){
var statearr_46725_48395 = state_46711__$1;
(statearr_46725_48395[(1)] = (6));

} else {
var statearr_46726_48396 = state_46711__$1;
(statearr_46726_48396[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (15))){
var inst_46697 = (state_46711[(9)]);
var inst_46702 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46697);
var state_46711__$1 = state_46711;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46711__$1,(17),out,inst_46702);
} else {
if((state_val_46713 === (13))){
var inst_46697 = (state_46711[(9)]);
var inst_46697__$1 = (state_46711[(2)]);
var inst_46698 = cljs.core.some(cljs.core.nil_QMARK_,inst_46697__$1);
var state_46711__$1 = (function (){var statearr_46729 = state_46711;
(statearr_46729[(9)] = inst_46697__$1);

return statearr_46729;
})();
if(cljs.core.truth_(inst_46698)){
var statearr_46731_48399 = state_46711__$1;
(statearr_46731_48399[(1)] = (14));

} else {
var statearr_46736_48400 = state_46711__$1;
(statearr_46736_48400[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (6))){
var state_46711__$1 = state_46711;
var statearr_46737_48401 = state_46711__$1;
(statearr_46737_48401[(2)] = null);

(statearr_46737_48401[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (17))){
var inst_46704 = (state_46711[(2)]);
var state_46711__$1 = (function (){var statearr_46746 = state_46711;
(statearr_46746[(10)] = inst_46704);

return statearr_46746;
})();
var statearr_46747_48402 = state_46711__$1;
(statearr_46747_48402[(2)] = null);

(statearr_46747_48402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (3))){
var inst_46709 = (state_46711[(2)]);
var state_46711__$1 = state_46711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46711__$1,inst_46709);
} else {
if((state_val_46713 === (12))){
var _ = (function (){var statearr_46753 = state_46711;
(statearr_46753[(4)] = cljs.core.rest((state_46711[(4)])));

return statearr_46753;
})();
var state_46711__$1 = state_46711;
var ex46742 = (state_46711__$1[(2)]);
var statearr_46754_48405 = state_46711__$1;
(statearr_46754_48405[(5)] = ex46742);


if((ex46742 instanceof Object)){
var statearr_46761_48407 = state_46711__$1;
(statearr_46761_48407[(1)] = (11));

(statearr_46761_48407[(5)] = null);

} else {
throw ex46742;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (2))){
var inst_46656 = cljs.core.reset_BANG_(dctr,cnt);
var inst_46657 = cnt;
var inst_46658 = (0);
var state_46711__$1 = (function (){var statearr_46764 = state_46711;
(statearr_46764[(7)] = inst_46658);

(statearr_46764[(11)] = inst_46656);

(statearr_46764[(8)] = inst_46657);

return statearr_46764;
})();
var statearr_46765_48409 = state_46711__$1;
(statearr_46765_48409[(2)] = null);

(statearr_46765_48409[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (11))){
var inst_46676 = (state_46711[(2)]);
var inst_46677 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46711__$1 = (function (){var statearr_46771 = state_46711;
(statearr_46771[(12)] = inst_46676);

return statearr_46771;
})();
var statearr_46772_48410 = state_46711__$1;
(statearr_46772_48410[(2)] = inst_46677);

(statearr_46772_48410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (9))){
var inst_46658 = (state_46711[(7)]);
var _ = (function (){var statearr_46780 = state_46711;
(statearr_46780[(4)] = cljs.core.cons((12),(state_46711[(4)])));

return statearr_46780;
})();
var inst_46683 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_46658) : chs__$1.call(null,inst_46658));
var inst_46684 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_46658) : done.call(null,inst_46658));
var inst_46685 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46683,inst_46684);
var ___$1 = (function (){var statearr_46792 = state_46711;
(statearr_46792[(4)] = cljs.core.rest((state_46711[(4)])));

return statearr_46792;
})();
var state_46711__$1 = state_46711;
var statearr_46799_48416 = state_46711__$1;
(statearr_46799_48416[(2)] = inst_46685);

(statearr_46799_48416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (5))){
var inst_46695 = (state_46711[(2)]);
var state_46711__$1 = (function (){var statearr_46812 = state_46711;
(statearr_46812[(13)] = inst_46695);

return statearr_46812;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46711__$1,(13),dchan);
} else {
if((state_val_46713 === (14))){
var inst_46700 = cljs.core.async.close_BANG_(out);
var state_46711__$1 = state_46711;
var statearr_46825_48417 = state_46711__$1;
(statearr_46825_48417[(2)] = inst_46700);

(statearr_46825_48417[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (16))){
var inst_46707 = (state_46711[(2)]);
var state_46711__$1 = state_46711;
var statearr_46835_48419 = state_46711__$1;
(statearr_46835_48419[(2)] = inst_46707);

(statearr_46835_48419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (10))){
var inst_46658 = (state_46711[(7)]);
var inst_46688 = (state_46711[(2)]);
var inst_46689 = (inst_46658 + (1));
var inst_46658__$1 = inst_46689;
var state_46711__$1 = (function (){var statearr_46836 = state_46711;
(statearr_46836[(7)] = inst_46658__$1);

(statearr_46836[(14)] = inst_46688);

return statearr_46836;
})();
var statearr_46838_48420 = state_46711__$1;
(statearr_46838_48420[(2)] = null);

(statearr_46838_48420[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46713 === (8))){
var inst_46693 = (state_46711[(2)]);
var state_46711__$1 = state_46711;
var statearr_46839_48421 = state_46711__$1;
(statearr_46839_48421[(2)] = inst_46693);

(statearr_46839_48421[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_46840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46840[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_46840[(1)] = (1));

return statearr_46840;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_46711){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_46711);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e46842){var ex__43226__auto__ = e46842;
var statearr_46845_48423 = state_46711;
(statearr_46845_48423[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_46711[(4)]))){
var statearr_46847_48424 = state_46711;
(statearr_46847_48424[(1)] = cljs.core.first((state_46711[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48426 = state_46711;
state_46711 = G__48426;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_46711){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_46711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_46848 = f__43958__auto__();
(statearr_46848[(6)] = c__43957__auto___48391);

return statearr_46848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46851 = arguments.length;
switch (G__46851) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_46910){
var state_val_46911 = (state_46910[(1)]);
if((state_val_46911 === (7))){
var inst_46878 = (state_46910[(7)]);
var inst_46877 = (state_46910[(8)]);
var inst_46877__$1 = (state_46910[(2)]);
var inst_46878__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46877__$1,(0),null);
var inst_46879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46877__$1,(1),null);
var inst_46880 = (inst_46878__$1 == null);
var state_46910__$1 = (function (){var statearr_46922 = state_46910;
(statearr_46922[(7)] = inst_46878__$1);

(statearr_46922[(8)] = inst_46877__$1);

(statearr_46922[(9)] = inst_46879);

return statearr_46922;
})();
if(cljs.core.truth_(inst_46880)){
var statearr_46924_48433 = state_46910__$1;
(statearr_46924_48433[(1)] = (8));

} else {
var statearr_46925_48434 = state_46910__$1;
(statearr_46925_48434[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (1))){
var inst_46865 = cljs.core.vec(chs);
var inst_46867 = inst_46865;
var state_46910__$1 = (function (){var statearr_46926 = state_46910;
(statearr_46926[(10)] = inst_46867);

return statearr_46926;
})();
var statearr_46927_48439 = state_46910__$1;
(statearr_46927_48439[(2)] = null);

(statearr_46927_48439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (4))){
var inst_46867 = (state_46910[(10)]);
var state_46910__$1 = state_46910;
return cljs.core.async.ioc_alts_BANG_(state_46910__$1,(7),inst_46867);
} else {
if((state_val_46911 === (6))){
var inst_46905 = (state_46910[(2)]);
var state_46910__$1 = state_46910;
var statearr_46930_48444 = state_46910__$1;
(statearr_46930_48444[(2)] = inst_46905);

(statearr_46930_48444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (3))){
var inst_46908 = (state_46910[(2)]);
var state_46910__$1 = state_46910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46910__$1,inst_46908);
} else {
if((state_val_46911 === (2))){
var inst_46867 = (state_46910[(10)]);
var inst_46869 = cljs.core.count(inst_46867);
var inst_46870 = (inst_46869 > (0));
var state_46910__$1 = state_46910;
if(cljs.core.truth_(inst_46870)){
var statearr_46934_48445 = state_46910__$1;
(statearr_46934_48445[(1)] = (4));

} else {
var statearr_46935_48446 = state_46910__$1;
(statearr_46935_48446[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (11))){
var inst_46867 = (state_46910[(10)]);
var inst_46898 = (state_46910[(2)]);
var tmp46932 = inst_46867;
var inst_46867__$1 = tmp46932;
var state_46910__$1 = (function (){var statearr_46936 = state_46910;
(statearr_46936[(11)] = inst_46898);

(statearr_46936[(10)] = inst_46867__$1);

return statearr_46936;
})();
var statearr_46942_48447 = state_46910__$1;
(statearr_46942_48447[(2)] = null);

(statearr_46942_48447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (9))){
var inst_46878 = (state_46910[(7)]);
var state_46910__$1 = state_46910;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46910__$1,(11),out,inst_46878);
} else {
if((state_val_46911 === (5))){
var inst_46903 = cljs.core.async.close_BANG_(out);
var state_46910__$1 = state_46910;
var statearr_46948_48453 = state_46910__$1;
(statearr_46948_48453[(2)] = inst_46903);

(statearr_46948_48453[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (10))){
var inst_46901 = (state_46910[(2)]);
var state_46910__$1 = state_46910;
var statearr_46949_48457 = state_46910__$1;
(statearr_46949_48457[(2)] = inst_46901);

(statearr_46949_48457[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46911 === (8))){
var inst_46878 = (state_46910[(7)]);
var inst_46877 = (state_46910[(8)]);
var inst_46867 = (state_46910[(10)]);
var inst_46879 = (state_46910[(9)]);
var inst_46887 = (function (){var cs = inst_46867;
var vec__46873 = inst_46877;
var v = inst_46878;
var c = inst_46879;
return (function (p1__46849_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46849_SHARP_);
});
})();
var inst_46894 = cljs.core.filterv(inst_46887,inst_46867);
var inst_46867__$1 = inst_46894;
var state_46910__$1 = (function (){var statearr_46951 = state_46910;
(statearr_46951[(10)] = inst_46867__$1);

return statearr_46951;
})();
var statearr_46953_48462 = state_46910__$1;
(statearr_46953_48462[(2)] = null);

(statearr_46953_48462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_46959 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46959[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_46959[(1)] = (1));

return statearr_46959;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_46910){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_46910);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e46961){var ex__43226__auto__ = e46961;
var statearr_46964_48467 = state_46910;
(statearr_46964_48467[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_46910[(4)]))){
var statearr_46966_48468 = state_46910;
(statearr_46966_48468[(1)] = cljs.core.first((state_46910[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48469 = state_46910;
state_46910 = G__48469;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_46910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_46910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_46968 = f__43958__auto__();
(statearr_46968[(6)] = c__43957__auto___48428);

return statearr_46968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46973 = arguments.length;
switch (G__46973) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48476 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47002){
var state_val_47004 = (state_47002[(1)]);
if((state_val_47004 === (7))){
var inst_46984 = (state_47002[(7)]);
var inst_46984__$1 = (state_47002[(2)]);
var inst_46985 = (inst_46984__$1 == null);
var inst_46986 = cljs.core.not(inst_46985);
var state_47002__$1 = (function (){var statearr_47006 = state_47002;
(statearr_47006[(7)] = inst_46984__$1);

return statearr_47006;
})();
if(inst_46986){
var statearr_47007_48479 = state_47002__$1;
(statearr_47007_48479[(1)] = (8));

} else {
var statearr_47008_48483 = state_47002__$1;
(statearr_47008_48483[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (1))){
var inst_46979 = (0);
var state_47002__$1 = (function (){var statearr_47009 = state_47002;
(statearr_47009[(8)] = inst_46979);

return statearr_47009;
})();
var statearr_47010_48489 = state_47002__$1;
(statearr_47010_48489[(2)] = null);

(statearr_47010_48489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (4))){
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47002__$1,(7),ch);
} else {
if((state_val_47004 === (6))){
var inst_46997 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47013_48490 = state_47002__$1;
(statearr_47013_48490[(2)] = inst_46997);

(statearr_47013_48490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (3))){
var inst_46999 = (state_47002[(2)]);
var inst_47000 = cljs.core.async.close_BANG_(out);
var state_47002__$1 = (function (){var statearr_47014 = state_47002;
(statearr_47014[(9)] = inst_46999);

return statearr_47014;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47002__$1,inst_47000);
} else {
if((state_val_47004 === (2))){
var inst_46979 = (state_47002[(8)]);
var inst_46981 = (inst_46979 < n);
var state_47002__$1 = state_47002;
if(cljs.core.truth_(inst_46981)){
var statearr_47016_48491 = state_47002__$1;
(statearr_47016_48491[(1)] = (4));

} else {
var statearr_47017_48492 = state_47002__$1;
(statearr_47017_48492[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (11))){
var inst_46979 = (state_47002[(8)]);
var inst_46989 = (state_47002[(2)]);
var inst_46990 = (inst_46979 + (1));
var inst_46979__$1 = inst_46990;
var state_47002__$1 = (function (){var statearr_47018 = state_47002;
(statearr_47018[(8)] = inst_46979__$1);

(statearr_47018[(10)] = inst_46989);

return statearr_47018;
})();
var statearr_47020_48493 = state_47002__$1;
(statearr_47020_48493[(2)] = null);

(statearr_47020_48493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (9))){
var state_47002__$1 = state_47002;
var statearr_47021_48494 = state_47002__$1;
(statearr_47021_48494[(2)] = null);

(statearr_47021_48494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (5))){
var state_47002__$1 = state_47002;
var statearr_47022_48495 = state_47002__$1;
(statearr_47022_48495[(2)] = null);

(statearr_47022_48495[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (10))){
var inst_46994 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47024_48496 = state_47002__$1;
(statearr_47024_48496[(2)] = inst_46994);

(statearr_47024_48496[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47004 === (8))){
var inst_46984 = (state_47002[(7)]);
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47002__$1,(11),out,inst_46984);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_47025 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47025[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_47025[(1)] = (1));

return statearr_47025;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_47002){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47002);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47026){var ex__43226__auto__ = e47026;
var statearr_47027_48497 = state_47002;
(statearr_47027_48497[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47002[(4)]))){
var statearr_47029_48498 = state_47002;
(statearr_47029_48498[(1)] = cljs.core.first((state_47002[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48499 = state_47002;
state_47002 = G__48499;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_47002){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_47002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47030 = f__43958__auto__();
(statearr_47030[(6)] = c__43957__auto___48476);

return statearr_47030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47032 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47032 = (function (f,ch,meta47033){
this.f = f;
this.ch = ch;
this.meta47033 = meta47033;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47034,meta47033__$1){
var self__ = this;
var _47034__$1 = this;
return (new cljs.core.async.t_cljs$core$async47032(self__.f,self__.ch,meta47033__$1));
}));

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47034){
var self__ = this;
var _47034__$1 = this;
return self__.meta47033;
}));

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47035 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47035 = (function (f,ch,meta47033,_,fn1,meta47036){
this.f = f;
this.ch = ch;
this.meta47033 = meta47033;
this._ = _;
this.fn1 = fn1;
this.meta47036 = meta47036;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47037,meta47036__$1){
var self__ = this;
var _47037__$1 = this;
return (new cljs.core.async.t_cljs$core$async47035(self__.f,self__.ch,self__.meta47033,self__._,self__.fn1,meta47036__$1));
}));

(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47037){
var self__ = this;
var _47037__$1 = this;
return self__.meta47036;
}));

(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47035.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47031_SHARP_){
var G__47039 = (((p1__47031_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47031_SHARP_) : self__.f.call(null,p1__47031_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47039) : f1.call(null,G__47039));
});
}));

(cljs.core.async.t_cljs$core$async47035.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47033","meta47033",-2034917206,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47032","cljs.core.async/t_cljs$core$async47032",994387259,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47036","meta47036",-1478735711,null)], null);
}));

(cljs.core.async.t_cljs$core$async47035.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47035.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47035");

(cljs.core.async.t_cljs$core$async47035.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async47035");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47035.
 */
cljs.core.async.__GT_t_cljs$core$async47035 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47035(f__$1,ch__$1,meta47033__$1,___$2,fn1__$1,meta47036){
return (new cljs.core.async.t_cljs$core$async47035(f__$1,ch__$1,meta47033__$1,___$2,fn1__$1,meta47036));
});

}

return (new cljs.core.async.t_cljs$core$async47035(self__.f,self__.ch,self__.meta47033,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47041 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47041) : self__.f.call(null,G__47041));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47032.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47032.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47033","meta47033",-2034917206,null)], null);
}));

(cljs.core.async.t_cljs$core$async47032.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47032.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47032");

(cljs.core.async.t_cljs$core$async47032.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async47032");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47032.
 */
cljs.core.async.__GT_t_cljs$core$async47032 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47032(f__$1,ch__$1,meta47033){
return (new cljs.core.async.t_cljs$core$async47032(f__$1,ch__$1,meta47033));
});

}

return (new cljs.core.async.t_cljs$core$async47032(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47045 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47045 = (function (f,ch,meta47046){
this.f = f;
this.ch = ch;
this.meta47046 = meta47046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47047,meta47046__$1){
var self__ = this;
var _47047__$1 = this;
return (new cljs.core.async.t_cljs$core$async47045(self__.f,self__.ch,meta47046__$1));
}));

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47047){
var self__ = this;
var _47047__$1 = this;
return self__.meta47046;
}));

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47045.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47045.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47046","meta47046",541558851,null)], null);
}));

(cljs.core.async.t_cljs$core$async47045.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47045.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47045");

(cljs.core.async.t_cljs$core$async47045.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async47045");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47045.
 */
cljs.core.async.__GT_t_cljs$core$async47045 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47045(f__$1,ch__$1,meta47046){
return (new cljs.core.async.t_cljs$core$async47045(f__$1,ch__$1,meta47046));
});

}

return (new cljs.core.async.t_cljs$core$async47045(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47062 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47062 = (function (p,ch,meta47063){
this.p = p;
this.ch = ch;
this.meta47063 = meta47063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47064,meta47063__$1){
var self__ = this;
var _47064__$1 = this;
return (new cljs.core.async.t_cljs$core$async47062(self__.p,self__.ch,meta47063__$1));
}));

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47064){
var self__ = this;
var _47064__$1 = this;
return self__.meta47063;
}));

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47062.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47062.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47063","meta47063",-926790763,null)], null);
}));

(cljs.core.async.t_cljs$core$async47062.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47062.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47062");

(cljs.core.async.t_cljs$core$async47062.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async47062");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47062.
 */
cljs.core.async.__GT_t_cljs$core$async47062 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47062(p__$1,ch__$1,meta47063){
return (new cljs.core.async.t_cljs$core$async47062(p__$1,ch__$1,meta47063));
});

}

return (new cljs.core.async.t_cljs$core$async47062(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47096 = arguments.length;
switch (G__47096) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48606 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47140){
var state_val_47141 = (state_47140[(1)]);
if((state_val_47141 === (7))){
var inst_47136 = (state_47140[(2)]);
var state_47140__$1 = state_47140;
var statearr_47156_48607 = state_47140__$1;
(statearr_47156_48607[(2)] = inst_47136);

(statearr_47156_48607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (1))){
var state_47140__$1 = state_47140;
var statearr_47167_48608 = state_47140__$1;
(statearr_47167_48608[(2)] = null);

(statearr_47167_48608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (4))){
var inst_47122 = (state_47140[(7)]);
var inst_47122__$1 = (state_47140[(2)]);
var inst_47123 = (inst_47122__$1 == null);
var state_47140__$1 = (function (){var statearr_47172 = state_47140;
(statearr_47172[(7)] = inst_47122__$1);

return statearr_47172;
})();
if(cljs.core.truth_(inst_47123)){
var statearr_47174_48614 = state_47140__$1;
(statearr_47174_48614[(1)] = (5));

} else {
var statearr_47176_48615 = state_47140__$1;
(statearr_47176_48615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (6))){
var inst_47122 = (state_47140[(7)]);
var inst_47127 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47122) : p.call(null,inst_47122));
var state_47140__$1 = state_47140;
if(cljs.core.truth_(inst_47127)){
var statearr_47186_48617 = state_47140__$1;
(statearr_47186_48617[(1)] = (8));

} else {
var statearr_47189_48618 = state_47140__$1;
(statearr_47189_48618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (3))){
var inst_47138 = (state_47140[(2)]);
var state_47140__$1 = state_47140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47140__$1,inst_47138);
} else {
if((state_val_47141 === (2))){
var state_47140__$1 = state_47140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47140__$1,(4),ch);
} else {
if((state_val_47141 === (11))){
var inst_47130 = (state_47140[(2)]);
var state_47140__$1 = state_47140;
var statearr_47198_48620 = state_47140__$1;
(statearr_47198_48620[(2)] = inst_47130);

(statearr_47198_48620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (9))){
var state_47140__$1 = state_47140;
var statearr_47202_48624 = state_47140__$1;
(statearr_47202_48624[(2)] = null);

(statearr_47202_48624[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (5))){
var inst_47125 = cljs.core.async.close_BANG_(out);
var state_47140__$1 = state_47140;
var statearr_47206_48627 = state_47140__$1;
(statearr_47206_48627[(2)] = inst_47125);

(statearr_47206_48627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (10))){
var inst_47133 = (state_47140[(2)]);
var state_47140__$1 = (function (){var statearr_47210 = state_47140;
(statearr_47210[(8)] = inst_47133);

return statearr_47210;
})();
var statearr_47219_48628 = state_47140__$1;
(statearr_47219_48628[(2)] = null);

(statearr_47219_48628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47141 === (8))){
var inst_47122 = (state_47140[(7)]);
var state_47140__$1 = state_47140;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47140__$1,(11),out,inst_47122);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_47224 = [null,null,null,null,null,null,null,null,null];
(statearr_47224[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_47224[(1)] = (1));

return statearr_47224;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_47140){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47140);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47226){var ex__43226__auto__ = e47226;
var statearr_47229_48634 = state_47140;
(statearr_47229_48634[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47140[(4)]))){
var statearr_47231_48638 = state_47140;
(statearr_47231_48638[(1)] = cljs.core.first((state_47140[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48639 = state_47140;
state_47140 = G__48639;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_47140){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_47140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47241 = f__43958__auto__();
(statearr_47241[(6)] = c__43957__auto___48606);

return statearr_47241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__47253 = arguments.length;
switch (G__47253) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47368){
var state_val_47369 = (state_47368[(1)]);
if((state_val_47369 === (7))){
var inst_47362 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
var statearr_47380_48645 = state_47368__$1;
(statearr_47380_48645[(2)] = inst_47362);

(statearr_47380_48645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (20))){
var inst_47317 = (state_47368[(7)]);
var inst_47339 = (state_47368[(2)]);
var inst_47344 = cljs.core.next(inst_47317);
var inst_47291 = inst_47344;
var inst_47292 = null;
var inst_47293 = (0);
var inst_47294 = (0);
var state_47368__$1 = (function (){var statearr_47384 = state_47368;
(statearr_47384[(8)] = inst_47294);

(statearr_47384[(9)] = inst_47291);

(statearr_47384[(10)] = inst_47339);

(statearr_47384[(11)] = inst_47293);

(statearr_47384[(12)] = inst_47292);

return statearr_47384;
})();
var statearr_47391_48647 = state_47368__$1;
(statearr_47391_48647[(2)] = null);

(statearr_47391_48647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (1))){
var state_47368__$1 = state_47368;
var statearr_47398_48648 = state_47368__$1;
(statearr_47398_48648[(2)] = null);

(statearr_47398_48648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (4))){
var inst_47277 = (state_47368[(13)]);
var inst_47277__$1 = (state_47368[(2)]);
var inst_47278 = (inst_47277__$1 == null);
var state_47368__$1 = (function (){var statearr_47406 = state_47368;
(statearr_47406[(13)] = inst_47277__$1);

return statearr_47406;
})();
if(cljs.core.truth_(inst_47278)){
var statearr_47407_48656 = state_47368__$1;
(statearr_47407_48656[(1)] = (5));

} else {
var statearr_47410_48657 = state_47368__$1;
(statearr_47410_48657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (15))){
var state_47368__$1 = state_47368;
var statearr_47418_48658 = state_47368__$1;
(statearr_47418_48658[(2)] = null);

(statearr_47418_48658[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (21))){
var state_47368__$1 = state_47368;
var statearr_47419_48661 = state_47368__$1;
(statearr_47419_48661[(2)] = null);

(statearr_47419_48661[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (13))){
var inst_47294 = (state_47368[(8)]);
var inst_47291 = (state_47368[(9)]);
var inst_47293 = (state_47368[(11)]);
var inst_47292 = (state_47368[(12)]);
var inst_47309 = (state_47368[(2)]);
var inst_47310 = (inst_47294 + (1));
var tmp47411 = inst_47291;
var tmp47412 = inst_47293;
var tmp47413 = inst_47292;
var inst_47291__$1 = tmp47411;
var inst_47292__$1 = tmp47413;
var inst_47293__$1 = tmp47412;
var inst_47294__$1 = inst_47310;
var state_47368__$1 = (function (){var statearr_47426 = state_47368;
(statearr_47426[(8)] = inst_47294__$1);

(statearr_47426[(9)] = inst_47291__$1);

(statearr_47426[(11)] = inst_47293__$1);

(statearr_47426[(14)] = inst_47309);

(statearr_47426[(12)] = inst_47292__$1);

return statearr_47426;
})();
var statearr_47430_48663 = state_47368__$1;
(statearr_47430_48663[(2)] = null);

(statearr_47430_48663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (22))){
var state_47368__$1 = state_47368;
var statearr_47437_48664 = state_47368__$1;
(statearr_47437_48664[(2)] = null);

(statearr_47437_48664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (6))){
var inst_47277 = (state_47368[(13)]);
var inst_47289 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47277) : f.call(null,inst_47277));
var inst_47290 = cljs.core.seq(inst_47289);
var inst_47291 = inst_47290;
var inst_47292 = null;
var inst_47293 = (0);
var inst_47294 = (0);
var state_47368__$1 = (function (){var statearr_47440 = state_47368;
(statearr_47440[(8)] = inst_47294);

(statearr_47440[(9)] = inst_47291);

(statearr_47440[(11)] = inst_47293);

(statearr_47440[(12)] = inst_47292);

return statearr_47440;
})();
var statearr_47441_48665 = state_47368__$1;
(statearr_47441_48665[(2)] = null);

(statearr_47441_48665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (17))){
var inst_47317 = (state_47368[(7)]);
var inst_47330 = cljs.core.chunk_first(inst_47317);
var inst_47331 = cljs.core.chunk_rest(inst_47317);
var inst_47332 = cljs.core.count(inst_47330);
var inst_47291 = inst_47331;
var inst_47292 = inst_47330;
var inst_47293 = inst_47332;
var inst_47294 = (0);
var state_47368__$1 = (function (){var statearr_47442 = state_47368;
(statearr_47442[(8)] = inst_47294);

(statearr_47442[(9)] = inst_47291);

(statearr_47442[(11)] = inst_47293);

(statearr_47442[(12)] = inst_47292);

return statearr_47442;
})();
var statearr_47443_48668 = state_47368__$1;
(statearr_47443_48668[(2)] = null);

(statearr_47443_48668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (3))){
var inst_47364 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47368__$1,inst_47364);
} else {
if((state_val_47369 === (12))){
var inst_47352 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
var statearr_47445_48673 = state_47368__$1;
(statearr_47445_48673[(2)] = inst_47352);

(statearr_47445_48673[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (2))){
var state_47368__$1 = state_47368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47368__$1,(4),in$);
} else {
if((state_val_47369 === (23))){
var inst_47360 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
var statearr_47459_48678 = state_47368__$1;
(statearr_47459_48678[(2)] = inst_47360);

(statearr_47459_48678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (19))){
var inst_47347 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
var statearr_47460_48679 = state_47368__$1;
(statearr_47460_48679[(2)] = inst_47347);

(statearr_47460_48679[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (11))){
var inst_47317 = (state_47368[(7)]);
var inst_47291 = (state_47368[(9)]);
var inst_47317__$1 = cljs.core.seq(inst_47291);
var state_47368__$1 = (function (){var statearr_47462 = state_47368;
(statearr_47462[(7)] = inst_47317__$1);

return statearr_47462;
})();
if(inst_47317__$1){
var statearr_47464_48680 = state_47368__$1;
(statearr_47464_48680[(1)] = (14));

} else {
var statearr_47465_48681 = state_47368__$1;
(statearr_47465_48681[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (9))){
var inst_47354 = (state_47368[(2)]);
var inst_47355 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47368__$1 = (function (){var statearr_47466 = state_47368;
(statearr_47466[(15)] = inst_47354);

return statearr_47466;
})();
if(cljs.core.truth_(inst_47355)){
var statearr_47467_48682 = state_47368__$1;
(statearr_47467_48682[(1)] = (21));

} else {
var statearr_47468_48683 = state_47368__$1;
(statearr_47468_48683[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (5))){
var inst_47281 = cljs.core.async.close_BANG_(out);
var state_47368__$1 = state_47368;
var statearr_47470_48684 = state_47368__$1;
(statearr_47470_48684[(2)] = inst_47281);

(statearr_47470_48684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (14))){
var inst_47317 = (state_47368[(7)]);
var inst_47324 = cljs.core.chunked_seq_QMARK_(inst_47317);
var state_47368__$1 = state_47368;
if(inst_47324){
var statearr_47472_48690 = state_47368__$1;
(statearr_47472_48690[(1)] = (17));

} else {
var statearr_47473_48691 = state_47368__$1;
(statearr_47473_48691[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (16))){
var inst_47350 = (state_47368[(2)]);
var state_47368__$1 = state_47368;
var statearr_47474_48692 = state_47368__$1;
(statearr_47474_48692[(2)] = inst_47350);

(statearr_47474_48692[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47369 === (10))){
var inst_47294 = (state_47368[(8)]);
var inst_47292 = (state_47368[(12)]);
var inst_47302 = cljs.core._nth(inst_47292,inst_47294);
var state_47368__$1 = state_47368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47368__$1,(13),out,inst_47302);
} else {
if((state_val_47369 === (18))){
var inst_47317 = (state_47368[(7)]);
var inst_47337 = cljs.core.first(inst_47317);
var state_47368__$1 = state_47368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47368__$1,(20),out,inst_47337);
} else {
if((state_val_47369 === (8))){
var inst_47294 = (state_47368[(8)]);
var inst_47293 = (state_47368[(11)]);
var inst_47297 = (inst_47294 < inst_47293);
var inst_47298 = inst_47297;
var state_47368__$1 = state_47368;
if(cljs.core.truth_(inst_47298)){
var statearr_47478_48703 = state_47368__$1;
(statearr_47478_48703[(1)] = (10));

} else {
var statearr_47479_48704 = state_47368__$1;
(statearr_47479_48704[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____0 = (function (){
var statearr_47481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47481[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__);

(statearr_47481[(1)] = (1));

return statearr_47481;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____1 = (function (state_47368){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47368);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47486){var ex__43226__auto__ = e47486;
var statearr_47487_48709 = state_47368;
(statearr_47487_48709[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47368[(4)]))){
var statearr_47496_48710 = state_47368;
(statearr_47496_48710[(1)] = cljs.core.first((state_47368[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48715 = state_47368;
state_47368 = G__48715;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__ = function(state_47368){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____1.call(this,state_47368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43223__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47497 = f__43958__auto__();
(statearr_47497[(6)] = c__43957__auto__);

return statearr_47497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47499 = arguments.length;
switch (G__47499) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47504 = arguments.length;
switch (G__47504) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47516 = arguments.length;
switch (G__47516) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47553){
var state_val_47554 = (state_47553[(1)]);
if((state_val_47554 === (7))){
var inst_47548 = (state_47553[(2)]);
var state_47553__$1 = state_47553;
var statearr_47572_48737 = state_47553__$1;
(statearr_47572_48737[(2)] = inst_47548);

(statearr_47572_48737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (1))){
var inst_47527 = null;
var state_47553__$1 = (function (){var statearr_47573 = state_47553;
(statearr_47573[(7)] = inst_47527);

return statearr_47573;
})();
var statearr_47574_48738 = state_47553__$1;
(statearr_47574_48738[(2)] = null);

(statearr_47574_48738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (4))){
var inst_47533 = (state_47553[(8)]);
var inst_47533__$1 = (state_47553[(2)]);
var inst_47534 = (inst_47533__$1 == null);
var inst_47535 = cljs.core.not(inst_47534);
var state_47553__$1 = (function (){var statearr_47577 = state_47553;
(statearr_47577[(8)] = inst_47533__$1);

return statearr_47577;
})();
if(inst_47535){
var statearr_47578_48739 = state_47553__$1;
(statearr_47578_48739[(1)] = (5));

} else {
var statearr_47579_48740 = state_47553__$1;
(statearr_47579_48740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (6))){
var state_47553__$1 = state_47553;
var statearr_47580_48741 = state_47553__$1;
(statearr_47580_48741[(2)] = null);

(statearr_47580_48741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (3))){
var inst_47550 = (state_47553[(2)]);
var inst_47551 = cljs.core.async.close_BANG_(out);
var state_47553__$1 = (function (){var statearr_47581 = state_47553;
(statearr_47581[(9)] = inst_47550);

return statearr_47581;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47553__$1,inst_47551);
} else {
if((state_val_47554 === (2))){
var state_47553__$1 = state_47553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47553__$1,(4),ch);
} else {
if((state_val_47554 === (11))){
var inst_47533 = (state_47553[(8)]);
var inst_47542 = (state_47553[(2)]);
var inst_47527 = inst_47533;
var state_47553__$1 = (function (){var statearr_47582 = state_47553;
(statearr_47582[(10)] = inst_47542);

(statearr_47582[(7)] = inst_47527);

return statearr_47582;
})();
var statearr_47583_48742 = state_47553__$1;
(statearr_47583_48742[(2)] = null);

(statearr_47583_48742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (9))){
var inst_47533 = (state_47553[(8)]);
var state_47553__$1 = state_47553;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47553__$1,(11),out,inst_47533);
} else {
if((state_val_47554 === (5))){
var inst_47533 = (state_47553[(8)]);
var inst_47527 = (state_47553[(7)]);
var inst_47537 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47533,inst_47527);
var state_47553__$1 = state_47553;
if(inst_47537){
var statearr_47585_48743 = state_47553__$1;
(statearr_47585_48743[(1)] = (8));

} else {
var statearr_47586_48744 = state_47553__$1;
(statearr_47586_48744[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (10))){
var inst_47545 = (state_47553[(2)]);
var state_47553__$1 = state_47553;
var statearr_47587_48750 = state_47553__$1;
(statearr_47587_48750[(2)] = inst_47545);

(statearr_47587_48750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (8))){
var inst_47527 = (state_47553[(7)]);
var tmp47584 = inst_47527;
var inst_47527__$1 = tmp47584;
var state_47553__$1 = (function (){var statearr_47588 = state_47553;
(statearr_47588[(7)] = inst_47527__$1);

return statearr_47588;
})();
var statearr_47589_48764 = state_47553__$1;
(statearr_47589_48764[(2)] = null);

(statearr_47589_48764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_47590 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47590[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_47590[(1)] = (1));

return statearr_47590;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_47553){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47553);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47591){var ex__43226__auto__ = e47591;
var statearr_47592_48774 = state_47553;
(statearr_47592_48774[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47553[(4)]))){
var statearr_47593_48781 = state_47553;
(statearr_47593_48781[(1)] = cljs.core.first((state_47553[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48782 = state_47553;
state_47553 = G__48782;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_47553){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_47553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47594 = f__43958__auto__();
(statearr_47594[(6)] = c__43957__auto___48734);

return statearr_47594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47596 = arguments.length;
switch (G__47596) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47636){
var state_val_47637 = (state_47636[(1)]);
if((state_val_47637 === (7))){
var inst_47632 = (state_47636[(2)]);
var state_47636__$1 = state_47636;
var statearr_47638_48806 = state_47636__$1;
(statearr_47638_48806[(2)] = inst_47632);

(statearr_47638_48806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (1))){
var inst_47597 = (new Array(n));
var inst_47598 = inst_47597;
var inst_47599 = (0);
var state_47636__$1 = (function (){var statearr_47650 = state_47636;
(statearr_47650[(7)] = inst_47598);

(statearr_47650[(8)] = inst_47599);

return statearr_47650;
})();
var statearr_47651_48807 = state_47636__$1;
(statearr_47651_48807[(2)] = null);

(statearr_47651_48807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (4))){
var inst_47602 = (state_47636[(9)]);
var inst_47602__$1 = (state_47636[(2)]);
var inst_47603 = (inst_47602__$1 == null);
var inst_47604 = cljs.core.not(inst_47603);
var state_47636__$1 = (function (){var statearr_47652 = state_47636;
(statearr_47652[(9)] = inst_47602__$1);

return statearr_47652;
})();
if(inst_47604){
var statearr_47653_48814 = state_47636__$1;
(statearr_47653_48814[(1)] = (5));

} else {
var statearr_47654_48815 = state_47636__$1;
(statearr_47654_48815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (15))){
var inst_47626 = (state_47636[(2)]);
var state_47636__$1 = state_47636;
var statearr_47656_48820 = state_47636__$1;
(statearr_47656_48820[(2)] = inst_47626);

(statearr_47656_48820[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (13))){
var state_47636__$1 = state_47636;
var statearr_47657_48823 = state_47636__$1;
(statearr_47657_48823[(2)] = null);

(statearr_47657_48823[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (6))){
var inst_47599 = (state_47636[(8)]);
var inst_47622 = (inst_47599 > (0));
var state_47636__$1 = state_47636;
if(cljs.core.truth_(inst_47622)){
var statearr_47659_48829 = state_47636__$1;
(statearr_47659_48829[(1)] = (12));

} else {
var statearr_47660_48830 = state_47636__$1;
(statearr_47660_48830[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (3))){
var inst_47634 = (state_47636[(2)]);
var state_47636__$1 = state_47636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47636__$1,inst_47634);
} else {
if((state_val_47637 === (12))){
var inst_47598 = (state_47636[(7)]);
var inst_47624 = cljs.core.vec(inst_47598);
var state_47636__$1 = state_47636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47636__$1,(15),out,inst_47624);
} else {
if((state_val_47637 === (2))){
var state_47636__$1 = state_47636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47636__$1,(4),ch);
} else {
if((state_val_47637 === (11))){
var inst_47615 = (state_47636[(2)]);
var inst_47616 = (new Array(n));
var inst_47598 = inst_47616;
var inst_47599 = (0);
var state_47636__$1 = (function (){var statearr_47661 = state_47636;
(statearr_47661[(7)] = inst_47598);

(statearr_47661[(10)] = inst_47615);

(statearr_47661[(8)] = inst_47599);

return statearr_47661;
})();
var statearr_47662_48833 = state_47636__$1;
(statearr_47662_48833[(2)] = null);

(statearr_47662_48833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (9))){
var inst_47598 = (state_47636[(7)]);
var inst_47613 = cljs.core.vec(inst_47598);
var state_47636__$1 = state_47636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47636__$1,(11),out,inst_47613);
} else {
if((state_val_47637 === (5))){
var inst_47598 = (state_47636[(7)]);
var inst_47607 = (state_47636[(11)]);
var inst_47602 = (state_47636[(9)]);
var inst_47599 = (state_47636[(8)]);
var inst_47606 = (inst_47598[inst_47599] = inst_47602);
var inst_47607__$1 = (inst_47599 + (1));
var inst_47608 = (inst_47607__$1 < n);
var state_47636__$1 = (function (){var statearr_47663 = state_47636;
(statearr_47663[(12)] = inst_47606);

(statearr_47663[(11)] = inst_47607__$1);

return statearr_47663;
})();
if(cljs.core.truth_(inst_47608)){
var statearr_47664_48834 = state_47636__$1;
(statearr_47664_48834[(1)] = (8));

} else {
var statearr_47665_48835 = state_47636__$1;
(statearr_47665_48835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (14))){
var inst_47629 = (state_47636[(2)]);
var inst_47630 = cljs.core.async.close_BANG_(out);
var state_47636__$1 = (function (){var statearr_47667 = state_47636;
(statearr_47667[(13)] = inst_47629);

return statearr_47667;
})();
var statearr_47668_48836 = state_47636__$1;
(statearr_47668_48836[(2)] = inst_47630);

(statearr_47668_48836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (10))){
var inst_47620 = (state_47636[(2)]);
var state_47636__$1 = state_47636;
var statearr_47669_48841 = state_47636__$1;
(statearr_47669_48841[(2)] = inst_47620);

(statearr_47669_48841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47637 === (8))){
var inst_47598 = (state_47636[(7)]);
var inst_47607 = (state_47636[(11)]);
var tmp47666 = inst_47598;
var inst_47598__$1 = tmp47666;
var inst_47599 = inst_47607;
var state_47636__$1 = (function (){var statearr_47670 = state_47636;
(statearr_47670[(7)] = inst_47598__$1);

(statearr_47670[(8)] = inst_47599);

return statearr_47670;
})();
var statearr_47671_48842 = state_47636__$1;
(statearr_47671_48842[(2)] = null);

(statearr_47671_48842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_47672 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47672[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_47672[(1)] = (1));

return statearr_47672;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_47636){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47636);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47673){var ex__43226__auto__ = e47673;
var statearr_47674_48848 = state_47636;
(statearr_47674_48848[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47636[(4)]))){
var statearr_47675_48849 = state_47636;
(statearr_47675_48849[(1)] = cljs.core.first((state_47636[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48850 = state_47636;
state_47636 = G__48850;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_47636){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_47636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47676 = f__43958__auto__();
(statearr_47676[(6)] = c__43957__auto___48801);

return statearr_47676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47680 = arguments.length;
switch (G__47680) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43957__auto___48855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_47726){
var state_val_47727 = (state_47726[(1)]);
if((state_val_47727 === (7))){
var inst_47722 = (state_47726[(2)]);
var state_47726__$1 = state_47726;
var statearr_47728_48860 = state_47726__$1;
(statearr_47728_48860[(2)] = inst_47722);

(statearr_47728_48860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (1))){
var inst_47682 = [];
var inst_47683 = inst_47682;
var inst_47684 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47726__$1 = (function (){var statearr_47738 = state_47726;
(statearr_47738[(7)] = inst_47684);

(statearr_47738[(8)] = inst_47683);

return statearr_47738;
})();
var statearr_47739_48862 = state_47726__$1;
(statearr_47739_48862[(2)] = null);

(statearr_47739_48862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (4))){
var inst_47687 = (state_47726[(9)]);
var inst_47687__$1 = (state_47726[(2)]);
var inst_47688 = (inst_47687__$1 == null);
var inst_47689 = cljs.core.not(inst_47688);
var state_47726__$1 = (function (){var statearr_47740 = state_47726;
(statearr_47740[(9)] = inst_47687__$1);

return statearr_47740;
})();
if(inst_47689){
var statearr_47741_48863 = state_47726__$1;
(statearr_47741_48863[(1)] = (5));

} else {
var statearr_47742_48864 = state_47726__$1;
(statearr_47742_48864[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (15))){
var inst_47683 = (state_47726[(8)]);
var inst_47714 = cljs.core.vec(inst_47683);
var state_47726__$1 = state_47726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47726__$1,(18),out,inst_47714);
} else {
if((state_val_47727 === (13))){
var inst_47709 = (state_47726[(2)]);
var state_47726__$1 = state_47726;
var statearr_47743_48865 = state_47726__$1;
(statearr_47743_48865[(2)] = inst_47709);

(statearr_47743_48865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (6))){
var inst_47683 = (state_47726[(8)]);
var inst_47711 = inst_47683.length;
var inst_47712 = (inst_47711 > (0));
var state_47726__$1 = state_47726;
if(cljs.core.truth_(inst_47712)){
var statearr_47745_48866 = state_47726__$1;
(statearr_47745_48866[(1)] = (15));

} else {
var statearr_47746_48867 = state_47726__$1;
(statearr_47746_48867[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (17))){
var inst_47719 = (state_47726[(2)]);
var inst_47720 = cljs.core.async.close_BANG_(out);
var state_47726__$1 = (function (){var statearr_47747 = state_47726;
(statearr_47747[(10)] = inst_47719);

return statearr_47747;
})();
var statearr_47748_48868 = state_47726__$1;
(statearr_47748_48868[(2)] = inst_47720);

(statearr_47748_48868[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (3))){
var inst_47724 = (state_47726[(2)]);
var state_47726__$1 = state_47726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47726__$1,inst_47724);
} else {
if((state_val_47727 === (12))){
var inst_47683 = (state_47726[(8)]);
var inst_47702 = cljs.core.vec(inst_47683);
var state_47726__$1 = state_47726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47726__$1,(14),out,inst_47702);
} else {
if((state_val_47727 === (2))){
var state_47726__$1 = state_47726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47726__$1,(4),ch);
} else {
if((state_val_47727 === (11))){
var inst_47687 = (state_47726[(9)]);
var inst_47691 = (state_47726[(11)]);
var inst_47683 = (state_47726[(8)]);
var inst_47699 = inst_47683.push(inst_47687);
var tmp47749 = inst_47683;
var inst_47683__$1 = tmp47749;
var inst_47684 = inst_47691;
var state_47726__$1 = (function (){var statearr_47750 = state_47726;
(statearr_47750[(7)] = inst_47684);

(statearr_47750[(12)] = inst_47699);

(statearr_47750[(8)] = inst_47683__$1);

return statearr_47750;
})();
var statearr_47751_48870 = state_47726__$1;
(statearr_47751_48870[(2)] = null);

(statearr_47751_48870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (9))){
var inst_47684 = (state_47726[(7)]);
var inst_47695 = cljs.core.keyword_identical_QMARK_(inst_47684,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_47726__$1 = state_47726;
var statearr_47752_48871 = state_47726__$1;
(statearr_47752_48871[(2)] = inst_47695);

(statearr_47752_48871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (5))){
var inst_47692 = (state_47726[(13)]);
var inst_47687 = (state_47726[(9)]);
var inst_47691 = (state_47726[(11)]);
var inst_47684 = (state_47726[(7)]);
var inst_47691__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47687) : f.call(null,inst_47687));
var inst_47692__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47691__$1,inst_47684);
var state_47726__$1 = (function (){var statearr_47753 = state_47726;
(statearr_47753[(13)] = inst_47692__$1);

(statearr_47753[(11)] = inst_47691__$1);

return statearr_47753;
})();
if(inst_47692__$1){
var statearr_47754_48876 = state_47726__$1;
(statearr_47754_48876[(1)] = (8));

} else {
var statearr_47755_48877 = state_47726__$1;
(statearr_47755_48877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (14))){
var inst_47687 = (state_47726[(9)]);
var inst_47691 = (state_47726[(11)]);
var inst_47704 = (state_47726[(2)]);
var inst_47705 = [];
var inst_47706 = inst_47705.push(inst_47687);
var inst_47683 = inst_47705;
var inst_47684 = inst_47691;
var state_47726__$1 = (function (){var statearr_47756 = state_47726;
(statearr_47756[(14)] = inst_47706);

(statearr_47756[(7)] = inst_47684);

(statearr_47756[(15)] = inst_47704);

(statearr_47756[(8)] = inst_47683);

return statearr_47756;
})();
var statearr_47757_48879 = state_47726__$1;
(statearr_47757_48879[(2)] = null);

(statearr_47757_48879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (16))){
var state_47726__$1 = state_47726;
var statearr_47758_48880 = state_47726__$1;
(statearr_47758_48880[(2)] = null);

(statearr_47758_48880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (10))){
var inst_47697 = (state_47726[(2)]);
var state_47726__$1 = state_47726;
if(cljs.core.truth_(inst_47697)){
var statearr_47759_48885 = state_47726__$1;
(statearr_47759_48885[(1)] = (11));

} else {
var statearr_47760_48886 = state_47726__$1;
(statearr_47760_48886[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (18))){
var inst_47716 = (state_47726[(2)]);
var state_47726__$1 = state_47726;
var statearr_47761_48887 = state_47726__$1;
(statearr_47761_48887[(2)] = inst_47716);

(statearr_47761_48887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47727 === (8))){
var inst_47692 = (state_47726[(13)]);
var state_47726__$1 = state_47726;
var statearr_47762_48888 = state_47726__$1;
(statearr_47762_48888[(2)] = inst_47692);

(statearr_47762_48888[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43223__auto__ = null;
var cljs$core$async$state_machine__43223__auto____0 = (function (){
var statearr_47763 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47763[(0)] = cljs$core$async$state_machine__43223__auto__);

(statearr_47763[(1)] = (1));

return statearr_47763;
});
var cljs$core$async$state_machine__43223__auto____1 = (function (state_47726){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_47726);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e47766){var ex__43226__auto__ = e47766;
var statearr_47767_48889 = state_47726;
(statearr_47767_48889[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_47726[(4)]))){
var statearr_47768_48890 = state_47726;
(statearr_47768_48890[(1)] = cljs.core.first((state_47726[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48891 = state_47726;
state_47726 = G__48891;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
cljs$core$async$state_machine__43223__auto__ = function(state_47726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43223__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43223__auto____1.call(this,state_47726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43223__auto____0;
cljs$core$async$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43223__auto____1;
return cljs$core$async$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_47769 = f__43958__auto__();
(statearr_47769[(6)] = c__43957__auto___48855);

return statearr_47769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
