goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42553 = arguments.length;
switch (G__42553) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42554 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42554 = (function (f,blockable,meta42555){
this.f = f;
this.blockable = blockable;
this.meta42555 = meta42555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42556,meta42555__$1){
var self__ = this;
var _42556__$1 = this;
return (new cljs.core.async.t_cljs$core$async42554(self__.f,self__.blockable,meta42555__$1));
}));

(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42556){
var self__ = this;
var _42556__$1 = this;
return self__.meta42555;
}));

(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42554.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42555","meta42555",264750294,null)], null);
}));

(cljs.core.async.t_cljs$core$async42554.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42554");

(cljs.core.async.t_cljs$core$async42554.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async42554");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42554.
 */
cljs.core.async.__GT_t_cljs$core$async42554 = (function cljs$core$async$__GT_t_cljs$core$async42554(f__$1,blockable__$1,meta42555){
return (new cljs.core.async.t_cljs$core$async42554(f__$1,blockable__$1,meta42555));
});

}

return (new cljs.core.async.t_cljs$core$async42554(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42565 = arguments.length;
switch (G__42565) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42572 = arguments.length;
switch (G__42572) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42580 = arguments.length;
switch (G__42580) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_45899 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_45899) : fn1.call(null,val_45899));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_45899) : fn1.call(null,val_45899));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42594 = arguments.length;
switch (G__42594) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___45914 = n;
var x_45915 = (0);
while(true){
if((x_45915 < n__4648__auto___45914)){
(a[x_45915] = x_45915);

var G__45916 = (x_45915 + (1));
x_45915 = G__45916;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42611 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42611 = (function (flag,meta42612){
this.flag = flag;
this.meta42612 = meta42612;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42613,meta42612__$1){
var self__ = this;
var _42613__$1 = this;
return (new cljs.core.async.t_cljs$core$async42611(self__.flag,meta42612__$1));
}));

(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42613){
var self__ = this;
var _42613__$1 = this;
return self__.meta42612;
}));

(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42611.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async42611.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42612","meta42612",1157197276,null)], null);
}));

(cljs.core.async.t_cljs$core$async42611.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42611.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42611");

(cljs.core.async.t_cljs$core$async42611.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async42611");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42611.
 */
cljs.core.async.__GT_t_cljs$core$async42611 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42611(flag__$1,meta42612){
return (new cljs.core.async.t_cljs$core$async42611(flag__$1,meta42612));
});

}

return (new cljs.core.async.t_cljs$core$async42611(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42619 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42619 = (function (flag,cb,meta42620){
this.flag = flag;
this.cb = cb;
this.meta42620 = meta42620;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42621,meta42620__$1){
var self__ = this;
var _42621__$1 = this;
return (new cljs.core.async.t_cljs$core$async42619(self__.flag,self__.cb,meta42620__$1));
}));

(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42621){
var self__ = this;
var _42621__$1 = this;
return self__.meta42620;
}));

(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42619.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async42619.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42620","meta42620",-1350054721,null)], null);
}));

(cljs.core.async.t_cljs$core$async42619.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42619.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42619");

(cljs.core.async.t_cljs$core$async42619.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async42619");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42619.
 */
cljs.core.async.__GT_t_cljs$core$async42619 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42619(flag__$1,cb__$1,meta42620){
return (new cljs.core.async.t_cljs$core$async42619(flag__$1,cb__$1,meta42620));
});

}

return (new cljs.core.async.t_cljs$core$async42619(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42623_SHARP_){
var G__42629 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42623_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__42629) : fret.call(null,G__42629));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42624_SHARP_){
var G__42630 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42624_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__42630) : fret.call(null,G__42630));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45963 = (i + (1));
i = G__45963;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___45973 = arguments.length;
var i__4772__auto___45974 = (0);
while(true){
if((i__4772__auto___45974 < len__4771__auto___45973)){
args__4777__auto__.push((arguments[i__4772__auto___45974]));

var G__45977 = (i__4772__auto___45974 + (1));
i__4772__auto___45974 = G__45977;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42633){
var map__42634 = p__42633;
var map__42634__$1 = cljs.core.__destructure_map(map__42634);
var opts = map__42634__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42631){
var G__42632 = cljs.core.first(seq42631);
var seq42631__$1 = cljs.core.next(seq42631);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42632,seq42631__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__42644 = arguments.length;
switch (G__42644) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42469__auto___45989 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_42689){
var state_val_42694 = (state_42689[(1)]);
if((state_val_42694 === (7))){
var inst_42683 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
var statearr_42697_45990 = state_42689__$1;
(statearr_42697_45990[(2)] = inst_42683);

(statearr_42697_45990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (1))){
var state_42689__$1 = state_42689;
var statearr_42698_45991 = state_42689__$1;
(statearr_42698_45991[(2)] = null);

(statearr_42698_45991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (4))){
var inst_42659 = (state_42689[(7)]);
var inst_42659__$1 = (state_42689[(2)]);
var inst_42665 = (inst_42659__$1 == null);
var state_42689__$1 = (function (){var statearr_42701 = state_42689;
(statearr_42701[(7)] = inst_42659__$1);

return statearr_42701;
})();
if(cljs.core.truth_(inst_42665)){
var statearr_42702_45992 = state_42689__$1;
(statearr_42702_45992[(1)] = (5));

} else {
var statearr_42703_45993 = state_42689__$1;
(statearr_42703_45993[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (13))){
var state_42689__$1 = state_42689;
var statearr_42708_45996 = state_42689__$1;
(statearr_42708_45996[(2)] = null);

(statearr_42708_45996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (6))){
var inst_42659 = (state_42689[(7)]);
var state_42689__$1 = state_42689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42689__$1,(11),to,inst_42659);
} else {
if((state_val_42694 === (3))){
var inst_42686 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42689__$1,inst_42686);
} else {
if((state_val_42694 === (12))){
var state_42689__$1 = state_42689;
var statearr_42727_46009 = state_42689__$1;
(statearr_42727_46009[(2)] = null);

(statearr_42727_46009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (2))){
var state_42689__$1 = state_42689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42689__$1,(4),from);
} else {
if((state_val_42694 === (11))){
var inst_42676 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
if(cljs.core.truth_(inst_42676)){
var statearr_42740_46011 = state_42689__$1;
(statearr_42740_46011[(1)] = (12));

} else {
var statearr_42741_46012 = state_42689__$1;
(statearr_42741_46012[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (9))){
var state_42689__$1 = state_42689;
var statearr_42742_46022 = state_42689__$1;
(statearr_42742_46022[(2)] = null);

(statearr_42742_46022[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (5))){
var state_42689__$1 = state_42689;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42743_46023 = state_42689__$1;
(statearr_42743_46023[(1)] = (8));

} else {
var statearr_42744_46024 = state_42689__$1;
(statearr_42744_46024[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (14))){
var inst_42681 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
var statearr_42745_46027 = state_42689__$1;
(statearr_42745_46027[(2)] = inst_42681);

(statearr_42745_46027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (10))){
var inst_42673 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
var statearr_42746_46031 = state_42689__$1;
(statearr_42746_46031[(2)] = inst_42673);

(statearr_42746_46031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42694 === (8))){
var inst_42670 = cljs.core.async.close_BANG_(to);
var state_42689__$1 = state_42689;
var statearr_42747_46033 = state_42689__$1;
(statearr_42747_46033[(2)] = inst_42670);

(statearr_42747_46033[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_42748 = [null,null,null,null,null,null,null,null];
(statearr_42748[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_42748[(1)] = (1));

return statearr_42748;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_42689){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42689);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e42749){var ex__42028__auto__ = e42749;
var statearr_42750_46041 = state_42689;
(statearr_42750_46041[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42689[(4)]))){
var statearr_42751_46044 = state_42689;
(statearr_42751_46044[(1)] = cljs.core.first((state_42689[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46047 = state_42689;
state_42689 = G__46047;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_42689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_42689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_42752 = f__42470__auto__();
(statearr_42752[(6)] = c__42469__auto___45989);

return statearr_42752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__42754){
var vec__42755 = p__42754;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42755,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42755,(1),null);
var job = vec__42755;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__42469__auto___46060 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_42762){
var state_val_42763 = (state_42762[(1)]);
if((state_val_42763 === (1))){
var state_42762__$1 = state_42762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42762__$1,(2),res,v);
} else {
if((state_val_42763 === (2))){
var inst_42759 = (state_42762[(2)]);
var inst_42760 = cljs.core.async.close_BANG_(res);
var state_42762__$1 = (function (){var statearr_42770 = state_42762;
(statearr_42770[(7)] = inst_42759);

return statearr_42770;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42762__$1,inst_42760);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_42771 = [null,null,null,null,null,null,null,null];
(statearr_42771[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__);

(statearr_42771[(1)] = (1));

return statearr_42771;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1 = (function (state_42762){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42762);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e42772){var ex__42028__auto__ = e42772;
var statearr_42773_46064 = state_42762;
(statearr_42773_46064[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42762[(4)]))){
var statearr_42774_46065 = state_42762;
(statearr_42774_46065[(1)] = cljs.core.first((state_42762[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46070 = state_42762;
state_42762 = G__46070;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = function(state_42762){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1.call(this,state_42762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_42775 = f__42470__auto__();
(statearr_42775[(6)] = c__42469__auto___46060);

return statearr_42775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__42776){
var vec__42778 = p__42776;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42778,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42778,(1),null);
var job = vec__42778;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___46075 = n;
var __46076 = (0);
while(true){
if((__46076 < n__4648__auto___46075)){
var G__42783_46077 = type;
var G__42783_46078__$1 = (((G__42783_46077 instanceof cljs.core.Keyword))?G__42783_46077.fqn:null);
switch (G__42783_46078__$1) {
case "compute":
var c__42469__auto___46081 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46076,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = ((function (__46076,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function (state_42797){
var state_val_42798 = (state_42797[(1)]);
if((state_val_42798 === (1))){
var state_42797__$1 = state_42797;
var statearr_42814_46091 = state_42797__$1;
(statearr_42814_46091[(2)] = null);

(statearr_42814_46091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42798 === (2))){
var state_42797__$1 = state_42797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42797__$1,(4),jobs);
} else {
if((state_val_42798 === (3))){
var inst_42795 = (state_42797[(2)]);
var state_42797__$1 = state_42797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42797__$1,inst_42795);
} else {
if((state_val_42798 === (4))){
var inst_42787 = (state_42797[(2)]);
var inst_42788 = process(inst_42787);
var state_42797__$1 = state_42797;
if(cljs.core.truth_(inst_42788)){
var statearr_42820_46092 = state_42797__$1;
(statearr_42820_46092[(1)] = (5));

} else {
var statearr_42821_46094 = state_42797__$1;
(statearr_42821_46094[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42798 === (5))){
var state_42797__$1 = state_42797;
var statearr_42822_46095 = state_42797__$1;
(statearr_42822_46095[(2)] = null);

(statearr_42822_46095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42798 === (6))){
var state_42797__$1 = state_42797;
var statearr_42826_46096 = state_42797__$1;
(statearr_42826_46096[(2)] = null);

(statearr_42826_46096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42798 === (7))){
var inst_42793 = (state_42797[(2)]);
var state_42797__$1 = state_42797;
var statearr_42827_46097 = state_42797__$1;
(statearr_42827_46097[(2)] = inst_42793);

(statearr_42827_46097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46076,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
;
return ((function (__46076,switch__42024__auto__,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_42828 = [null,null,null,null,null,null,null];
(statearr_42828[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__);

(statearr_42828[(1)] = (1));

return statearr_42828;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1 = (function (state_42797){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42797);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e42829){var ex__42028__auto__ = e42829;
var statearr_42830_46104 = state_42797;
(statearr_42830_46104[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42797[(4)]))){
var statearr_42831_46108 = state_42797;
(statearr_42831_46108[(1)] = cljs.core.first((state_42797[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46110 = state_42797;
state_42797 = G__46110;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = function(state_42797){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1.call(this,state_42797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__;
})()
;})(__46076,switch__42024__auto__,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
})();
var state__42471__auto__ = (function (){var statearr_42833 = f__42470__auto__();
(statearr_42833[(6)] = c__42469__auto___46081);

return statearr_42833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
});})(__46076,c__42469__auto___46081,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
);


break;
case "async":
var c__42469__auto___46111 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46076,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = ((function (__46076,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function (state_42847){
var state_val_42848 = (state_42847[(1)]);
if((state_val_42848 === (1))){
var state_42847__$1 = state_42847;
var statearr_42854_46113 = state_42847__$1;
(statearr_42854_46113[(2)] = null);

(statearr_42854_46113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42848 === (2))){
var state_42847__$1 = state_42847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42847__$1,(4),jobs);
} else {
if((state_val_42848 === (3))){
var inst_42845 = (state_42847[(2)]);
var state_42847__$1 = state_42847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42847__$1,inst_42845);
} else {
if((state_val_42848 === (4))){
var inst_42836 = (state_42847[(2)]);
var inst_42838 = async(inst_42836);
var state_42847__$1 = state_42847;
if(cljs.core.truth_(inst_42838)){
var statearr_42859_46115 = state_42847__$1;
(statearr_42859_46115[(1)] = (5));

} else {
var statearr_42860_46116 = state_42847__$1;
(statearr_42860_46116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42848 === (5))){
var state_42847__$1 = state_42847;
var statearr_42861_46118 = state_42847__$1;
(statearr_42861_46118[(2)] = null);

(statearr_42861_46118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42848 === (6))){
var state_42847__$1 = state_42847;
var statearr_42862_46120 = state_42847__$1;
(statearr_42862_46120[(2)] = null);

(statearr_42862_46120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42848 === (7))){
var inst_42843 = (state_42847[(2)]);
var state_42847__$1 = state_42847;
var statearr_42863_46124 = state_42847__$1;
(statearr_42863_46124[(2)] = inst_42843);

(statearr_42863_46124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46076,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
;
return ((function (__46076,switch__42024__auto__,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_42867 = [null,null,null,null,null,null,null];
(statearr_42867[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__);

(statearr_42867[(1)] = (1));

return statearr_42867;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1 = (function (state_42847){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42847);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e42869){var ex__42028__auto__ = e42869;
var statearr_42870_46127 = state_42847;
(statearr_42870_46127[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42847[(4)]))){
var statearr_42871_46128 = state_42847;
(statearr_42871_46128[(1)] = cljs.core.first((state_42847[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46129 = state_42847;
state_42847 = G__46129;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = function(state_42847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1.call(this,state_42847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__;
})()
;})(__46076,switch__42024__auto__,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
})();
var state__42471__auto__ = (function (){var statearr_42872 = f__42470__auto__();
(statearr_42872[(6)] = c__42469__auto___46111);

return statearr_42872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
});})(__46076,c__42469__auto___46111,G__42783_46077,G__42783_46078__$1,n__4648__auto___46075,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42783_46078__$1)].join('')));

}

var G__46131 = (__46076 + (1));
__46076 = G__46131;
continue;
} else {
}
break;
}

var c__42469__auto___46132 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_42898){
var state_val_42899 = (state_42898[(1)]);
if((state_val_42899 === (7))){
var inst_42894 = (state_42898[(2)]);
var state_42898__$1 = state_42898;
var statearr_42904_46137 = state_42898__$1;
(statearr_42904_46137[(2)] = inst_42894);

(statearr_42904_46137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42899 === (1))){
var state_42898__$1 = state_42898;
var statearr_42905_46139 = state_42898__$1;
(statearr_42905_46139[(2)] = null);

(statearr_42905_46139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42899 === (4))){
var inst_42879 = (state_42898[(7)]);
var inst_42879__$1 = (state_42898[(2)]);
var inst_42880 = (inst_42879__$1 == null);
var state_42898__$1 = (function (){var statearr_42906 = state_42898;
(statearr_42906[(7)] = inst_42879__$1);

return statearr_42906;
})();
if(cljs.core.truth_(inst_42880)){
var statearr_42907_46142 = state_42898__$1;
(statearr_42907_46142[(1)] = (5));

} else {
var statearr_42908_46143 = state_42898__$1;
(statearr_42908_46143[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42899 === (6))){
var inst_42884 = (state_42898[(8)]);
var inst_42879 = (state_42898[(7)]);
var inst_42884__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_42885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42886 = [inst_42879,inst_42884__$1];
var inst_42887 = (new cljs.core.PersistentVector(null,2,(5),inst_42885,inst_42886,null));
var state_42898__$1 = (function (){var statearr_42910 = state_42898;
(statearr_42910[(8)] = inst_42884__$1);

return statearr_42910;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42898__$1,(8),jobs,inst_42887);
} else {
if((state_val_42899 === (3))){
var inst_42896 = (state_42898[(2)]);
var state_42898__$1 = state_42898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42898__$1,inst_42896);
} else {
if((state_val_42899 === (2))){
var state_42898__$1 = state_42898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42898__$1,(4),from);
} else {
if((state_val_42899 === (9))){
var inst_42891 = (state_42898[(2)]);
var state_42898__$1 = (function (){var statearr_42911 = state_42898;
(statearr_42911[(9)] = inst_42891);

return statearr_42911;
})();
var statearr_42912_46157 = state_42898__$1;
(statearr_42912_46157[(2)] = null);

(statearr_42912_46157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42899 === (5))){
var inst_42882 = cljs.core.async.close_BANG_(jobs);
var state_42898__$1 = state_42898;
var statearr_42913_46162 = state_42898__$1;
(statearr_42913_46162[(2)] = inst_42882);

(statearr_42913_46162[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42899 === (8))){
var inst_42884 = (state_42898[(8)]);
var inst_42889 = (state_42898[(2)]);
var state_42898__$1 = (function (){var statearr_42914 = state_42898;
(statearr_42914[(10)] = inst_42889);

return statearr_42914;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42898__$1,(9),results,inst_42884);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_42918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42918[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__);

(statearr_42918[(1)] = (1));

return statearr_42918;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1 = (function (state_42898){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42898);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e42919){var ex__42028__auto__ = e42919;
var statearr_42920_46167 = state_42898;
(statearr_42920_46167[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42898[(4)]))){
var statearr_42921_46174 = state_42898;
(statearr_42921_46174[(1)] = cljs.core.first((state_42898[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46175 = state_42898;
state_42898 = G__46175;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = function(state_42898){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1.call(this,state_42898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_42925 = f__42470__auto__();
(statearr_42925[(6)] = c__42469__auto___46132);

return statearr_42925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_42981){
var state_val_42987 = (state_42981[(1)]);
if((state_val_42987 === (7))){
var inst_42977 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
var statearr_43007_46185 = state_42981__$1;
(statearr_43007_46185[(2)] = inst_42977);

(statearr_43007_46185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (20))){
var state_42981__$1 = state_42981;
var statearr_43013_46187 = state_42981__$1;
(statearr_43013_46187[(2)] = null);

(statearr_43013_46187[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (1))){
var state_42981__$1 = state_42981;
var statearr_43014_46188 = state_42981__$1;
(statearr_43014_46188[(2)] = null);

(statearr_43014_46188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (4))){
var inst_42939 = (state_42981[(7)]);
var inst_42939__$1 = (state_42981[(2)]);
var inst_42940 = (inst_42939__$1 == null);
var state_42981__$1 = (function (){var statearr_43022 = state_42981;
(statearr_43022[(7)] = inst_42939__$1);

return statearr_43022;
})();
if(cljs.core.truth_(inst_42940)){
var statearr_43024_46190 = state_42981__$1;
(statearr_43024_46190[(1)] = (5));

} else {
var statearr_43025_46191 = state_42981__$1;
(statearr_43025_46191[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (15))){
var inst_42953 = (state_42981[(8)]);
var state_42981__$1 = state_42981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42981__$1,(18),to,inst_42953);
} else {
if((state_val_42987 === (21))){
var inst_42972 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
var statearr_43032_46195 = state_42981__$1;
(statearr_43032_46195[(2)] = inst_42972);

(statearr_43032_46195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (13))){
var inst_42974 = (state_42981[(2)]);
var state_42981__$1 = (function (){var statearr_43033 = state_42981;
(statearr_43033[(9)] = inst_42974);

return statearr_43033;
})();
var statearr_43034_46197 = state_42981__$1;
(statearr_43034_46197[(2)] = null);

(statearr_43034_46197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (6))){
var inst_42939 = (state_42981[(7)]);
var state_42981__$1 = state_42981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42981__$1,(11),inst_42939);
} else {
if((state_val_42987 === (17))){
var inst_42967 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
if(cljs.core.truth_(inst_42967)){
var statearr_43036_46198 = state_42981__$1;
(statearr_43036_46198[(1)] = (19));

} else {
var statearr_43037_46199 = state_42981__$1;
(statearr_43037_46199[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (3))){
var inst_42979 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42981__$1,inst_42979);
} else {
if((state_val_42987 === (12))){
var inst_42950 = (state_42981[(10)]);
var state_42981__$1 = state_42981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42981__$1,(14),inst_42950);
} else {
if((state_val_42987 === (2))){
var state_42981__$1 = state_42981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42981__$1,(4),results);
} else {
if((state_val_42987 === (19))){
var state_42981__$1 = state_42981;
var statearr_43044_46201 = state_42981__$1;
(statearr_43044_46201[(2)] = null);

(statearr_43044_46201[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (11))){
var inst_42950 = (state_42981[(2)]);
var state_42981__$1 = (function (){var statearr_43045 = state_42981;
(statearr_43045[(10)] = inst_42950);

return statearr_43045;
})();
var statearr_43046_46202 = state_42981__$1;
(statearr_43046_46202[(2)] = null);

(statearr_43046_46202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (9))){
var state_42981__$1 = state_42981;
var statearr_43048_46207 = state_42981__$1;
(statearr_43048_46207[(2)] = null);

(statearr_43048_46207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (5))){
var state_42981__$1 = state_42981;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43053_46211 = state_42981__$1;
(statearr_43053_46211[(1)] = (8));

} else {
var statearr_43054_46212 = state_42981__$1;
(statearr_43054_46212[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (14))){
var inst_42953 = (state_42981[(8)]);
var inst_42953__$1 = (state_42981[(2)]);
var inst_42960 = (inst_42953__$1 == null);
var inst_42961 = cljs.core.not(inst_42960);
var state_42981__$1 = (function (){var statearr_43056 = state_42981;
(statearr_43056[(8)] = inst_42953__$1);

return statearr_43056;
})();
if(inst_42961){
var statearr_43060_46214 = state_42981__$1;
(statearr_43060_46214[(1)] = (15));

} else {
var statearr_43062_46215 = state_42981__$1;
(statearr_43062_46215[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (16))){
var state_42981__$1 = state_42981;
var statearr_43064_46219 = state_42981__$1;
(statearr_43064_46219[(2)] = false);

(statearr_43064_46219[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (10))){
var inst_42946 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
var statearr_43071_46223 = state_42981__$1;
(statearr_43071_46223[(2)] = inst_42946);

(statearr_43071_46223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (18))){
var inst_42964 = (state_42981[(2)]);
var state_42981__$1 = state_42981;
var statearr_43080_46224 = state_42981__$1;
(statearr_43080_46224[(2)] = inst_42964);

(statearr_43080_46224[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42987 === (8))){
var inst_42943 = cljs.core.async.close_BANG_(to);
var state_42981__$1 = state_42981;
var statearr_43081_46230 = state_42981__$1;
(statearr_43081_46230[(2)] = inst_42943);

(statearr_43081_46230[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_43086 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43086[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__);

(statearr_43086[(1)] = (1));

return statearr_43086;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1 = (function (state_42981){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_42981);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43087){var ex__42028__auto__ = e43087;
var statearr_43088_46235 = state_42981;
(statearr_43088_46235[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_42981[(4)]))){
var statearr_43089_46236 = state_42981;
(statearr_43089_46236[(1)] = cljs.core.first((state_42981[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46243 = state_42981;
state_42981 = G__46243;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__ = function(state_42981){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1.call(this,state_42981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43090 = f__42470__auto__();
(statearr_43090[(6)] = c__42469__auto__);

return statearr_43090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__43101 = arguments.length;
switch (G__43101) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__43133 = arguments.length;
switch (G__43133) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__43163 = arguments.length;
switch (G__43163) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__42469__auto___46274 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_43215){
var state_val_43216 = (state_43215[(1)]);
if((state_val_43216 === (7))){
var inst_43211 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43217_46277 = state_43215__$1;
(statearr_43217_46277[(2)] = inst_43211);

(statearr_43217_46277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (1))){
var state_43215__$1 = state_43215;
var statearr_43218_46278 = state_43215__$1;
(statearr_43218_46278[(2)] = null);

(statearr_43218_46278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (4))){
var inst_43187 = (state_43215[(7)]);
var inst_43187__$1 = (state_43215[(2)]);
var inst_43190 = (inst_43187__$1 == null);
var state_43215__$1 = (function (){var statearr_43219 = state_43215;
(statearr_43219[(7)] = inst_43187__$1);

return statearr_43219;
})();
if(cljs.core.truth_(inst_43190)){
var statearr_43220_46279 = state_43215__$1;
(statearr_43220_46279[(1)] = (5));

} else {
var statearr_43221_46280 = state_43215__$1;
(statearr_43221_46280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (13))){
var state_43215__$1 = state_43215;
var statearr_43222_46287 = state_43215__$1;
(statearr_43222_46287[(2)] = null);

(statearr_43222_46287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (6))){
var inst_43187 = (state_43215[(7)]);
var inst_43197 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_43187) : p.call(null,inst_43187));
var state_43215__$1 = state_43215;
if(cljs.core.truth_(inst_43197)){
var statearr_43223_46288 = state_43215__$1;
(statearr_43223_46288[(1)] = (9));

} else {
var statearr_43224_46289 = state_43215__$1;
(statearr_43224_46289[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (3))){
var inst_43213 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43215__$1,inst_43213);
} else {
if((state_val_43216 === (12))){
var state_43215__$1 = state_43215;
var statearr_43227_46297 = state_43215__$1;
(statearr_43227_46297[(2)] = null);

(statearr_43227_46297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (2))){
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43215__$1,(4),ch);
} else {
if((state_val_43216 === (11))){
var inst_43187 = (state_43215[(7)]);
var inst_43201 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43215__$1,(8),inst_43201,inst_43187);
} else {
if((state_val_43216 === (9))){
var state_43215__$1 = state_43215;
var statearr_43232_46300 = state_43215__$1;
(statearr_43232_46300[(2)] = tc);

(statearr_43232_46300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (5))){
var inst_43193 = cljs.core.async.close_BANG_(tc);
var inst_43194 = cljs.core.async.close_BANG_(fc);
var state_43215__$1 = (function (){var statearr_43237 = state_43215;
(statearr_43237[(8)] = inst_43193);

return statearr_43237;
})();
var statearr_43238_46304 = state_43215__$1;
(statearr_43238_46304[(2)] = inst_43194);

(statearr_43238_46304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (14))){
var inst_43208 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43239_46305 = state_43215__$1;
(statearr_43239_46305[(2)] = inst_43208);

(statearr_43239_46305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (10))){
var state_43215__$1 = state_43215;
var statearr_43244_46307 = state_43215__$1;
(statearr_43244_46307[(2)] = fc);

(statearr_43244_46307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (8))){
var inst_43203 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
if(cljs.core.truth_(inst_43203)){
var statearr_43246_46314 = state_43215__$1;
(statearr_43246_46314[(1)] = (12));

} else {
var statearr_43247_46315 = state_43215__$1;
(statearr_43247_46315[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_43251 = [null,null,null,null,null,null,null,null,null];
(statearr_43251[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_43251[(1)] = (1));

return statearr_43251;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_43215){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_43215);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43253){var ex__42028__auto__ = e43253;
var statearr_43254_46316 = state_43215;
(statearr_43254_46316[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_43215[(4)]))){
var statearr_43255_46317 = state_43215;
(statearr_43255_46317[(1)] = cljs.core.first((state_43215[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46318 = state_43215;
state_43215 = G__46318;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_43215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_43215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43257 = f__42470__auto__();
(statearr_43257[(6)] = c__42469__auto___46274);

return statearr_43257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_43282){
var state_val_43283 = (state_43282[(1)]);
if((state_val_43283 === (7))){
var inst_43278 = (state_43282[(2)]);
var state_43282__$1 = state_43282;
var statearr_43284_46334 = state_43282__$1;
(statearr_43284_46334[(2)] = inst_43278);

(statearr_43284_46334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (1))){
var inst_43260 = init;
var inst_43261 = inst_43260;
var state_43282__$1 = (function (){var statearr_43285 = state_43282;
(statearr_43285[(7)] = inst_43261);

return statearr_43285;
})();
var statearr_43286_46340 = state_43282__$1;
(statearr_43286_46340[(2)] = null);

(statearr_43286_46340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (4))){
var inst_43264 = (state_43282[(8)]);
var inst_43264__$1 = (state_43282[(2)]);
var inst_43265 = (inst_43264__$1 == null);
var state_43282__$1 = (function (){var statearr_43287 = state_43282;
(statearr_43287[(8)] = inst_43264__$1);

return statearr_43287;
})();
if(cljs.core.truth_(inst_43265)){
var statearr_43290_46345 = state_43282__$1;
(statearr_43290_46345[(1)] = (5));

} else {
var statearr_43291_46346 = state_43282__$1;
(statearr_43291_46346[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (6))){
var inst_43268 = (state_43282[(9)]);
var inst_43261 = (state_43282[(7)]);
var inst_43264 = (state_43282[(8)]);
var inst_43268__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_43261,inst_43264) : f.call(null,inst_43261,inst_43264));
var inst_43270 = cljs.core.reduced_QMARK_(inst_43268__$1);
var state_43282__$1 = (function (){var statearr_43293 = state_43282;
(statearr_43293[(9)] = inst_43268__$1);

return statearr_43293;
})();
if(inst_43270){
var statearr_43294_46349 = state_43282__$1;
(statearr_43294_46349[(1)] = (8));

} else {
var statearr_43296_46350 = state_43282__$1;
(statearr_43296_46350[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (3))){
var inst_43280 = (state_43282[(2)]);
var state_43282__$1 = state_43282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43282__$1,inst_43280);
} else {
if((state_val_43283 === (2))){
var state_43282__$1 = state_43282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43282__$1,(4),ch);
} else {
if((state_val_43283 === (9))){
var inst_43268 = (state_43282[(9)]);
var inst_43261 = inst_43268;
var state_43282__$1 = (function (){var statearr_43297 = state_43282;
(statearr_43297[(7)] = inst_43261);

return statearr_43297;
})();
var statearr_43298_46362 = state_43282__$1;
(statearr_43298_46362[(2)] = null);

(statearr_43298_46362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (5))){
var inst_43261 = (state_43282[(7)]);
var state_43282__$1 = state_43282;
var statearr_43299_46364 = state_43282__$1;
(statearr_43299_46364[(2)] = inst_43261);

(statearr_43299_46364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (10))){
var inst_43276 = (state_43282[(2)]);
var state_43282__$1 = state_43282;
var statearr_43300_46365 = state_43282__$1;
(statearr_43300_46365[(2)] = inst_43276);

(statearr_43300_46365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43283 === (8))){
var inst_43268 = (state_43282[(9)]);
var inst_43272 = cljs.core.deref(inst_43268);
var state_43282__$1 = state_43282;
var statearr_43301_46369 = state_43282__$1;
(statearr_43301_46369[(2)] = inst_43272);

(statearr_43301_46369[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42025__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42025__auto____0 = (function (){
var statearr_43303 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43303[(0)] = cljs$core$async$reduce_$_state_machine__42025__auto__);

(statearr_43303[(1)] = (1));

return statearr_43303;
});
var cljs$core$async$reduce_$_state_machine__42025__auto____1 = (function (state_43282){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_43282);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43307){var ex__42028__auto__ = e43307;
var statearr_43308_46374 = state_43282;
(statearr_43308_46374[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_43282[(4)]))){
var statearr_43309_46375 = state_43282;
(statearr_43309_46375[(1)] = cljs.core.first((state_43282[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46378 = state_43282;
state_43282 = G__46378;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42025__auto__ = function(state_43282){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42025__auto____1.call(this,state_43282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42025__auto____0;
cljs$core$async$reduce_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42025__auto____1;
return cljs$core$async$reduce_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43317 = f__42470__auto__();
(statearr_43317[(6)] = c__42469__auto__);

return statearr_43317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_43326){
var state_val_43327 = (state_43326[(1)]);
if((state_val_43327 === (1))){
var inst_43321 = cljs.core.async.reduce(f__$1,init,ch);
var state_43326__$1 = state_43326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43326__$1,(2),inst_43321);
} else {
if((state_val_43327 === (2))){
var inst_43323 = (state_43326[(2)]);
var inst_43324 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_43323) : f__$1.call(null,inst_43323));
var state_43326__$1 = state_43326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43326__$1,inst_43324);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42025__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42025__auto____0 = (function (){
var statearr_43329 = [null,null,null,null,null,null,null];
(statearr_43329[(0)] = cljs$core$async$transduce_$_state_machine__42025__auto__);

(statearr_43329[(1)] = (1));

return statearr_43329;
});
var cljs$core$async$transduce_$_state_machine__42025__auto____1 = (function (state_43326){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_43326);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43330){var ex__42028__auto__ = e43330;
var statearr_43331_46390 = state_43326;
(statearr_43331_46390[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_43326[(4)]))){
var statearr_43332_46391 = state_43326;
(statearr_43332_46391[(1)] = cljs.core.first((state_43326[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46398 = state_43326;
state_43326 = G__46398;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42025__auto__ = function(state_43326){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42025__auto____1.call(this,state_43326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42025__auto____0;
cljs$core$async$transduce_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42025__auto____1;
return cljs$core$async$transduce_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43333 = f__42470__auto__();
(statearr_43333[(6)] = c__42469__auto__);

return statearr_43333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__43336 = arguments.length;
switch (G__43336) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_43367){
var state_val_43368 = (state_43367[(1)]);
if((state_val_43368 === (7))){
var inst_43347 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
var statearr_43373_46400 = state_43367__$1;
(statearr_43373_46400[(2)] = inst_43347);

(statearr_43373_46400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (1))){
var inst_43341 = cljs.core.seq(coll);
var inst_43342 = inst_43341;
var state_43367__$1 = (function (){var statearr_43379 = state_43367;
(statearr_43379[(7)] = inst_43342);

return statearr_43379;
})();
var statearr_43380_46401 = state_43367__$1;
(statearr_43380_46401[(2)] = null);

(statearr_43380_46401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (4))){
var inst_43342 = (state_43367[(7)]);
var inst_43345 = cljs.core.first(inst_43342);
var state_43367__$1 = state_43367;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43367__$1,(7),ch,inst_43345);
} else {
if((state_val_43368 === (13))){
var inst_43361 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
var statearr_43383_46404 = state_43367__$1;
(statearr_43383_46404[(2)] = inst_43361);

(statearr_43383_46404[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (6))){
var inst_43350 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
if(cljs.core.truth_(inst_43350)){
var statearr_43384_46405 = state_43367__$1;
(statearr_43384_46405[(1)] = (8));

} else {
var statearr_43385_46406 = state_43367__$1;
(statearr_43385_46406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (3))){
var inst_43365 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43367__$1,inst_43365);
} else {
if((state_val_43368 === (12))){
var state_43367__$1 = state_43367;
var statearr_43399_46408 = state_43367__$1;
(statearr_43399_46408[(2)] = null);

(statearr_43399_46408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (2))){
var inst_43342 = (state_43367[(7)]);
var state_43367__$1 = state_43367;
if(cljs.core.truth_(inst_43342)){
var statearr_43400_46415 = state_43367__$1;
(statearr_43400_46415[(1)] = (4));

} else {
var statearr_43401_46416 = state_43367__$1;
(statearr_43401_46416[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (11))){
var inst_43358 = cljs.core.async.close_BANG_(ch);
var state_43367__$1 = state_43367;
var statearr_43403_46419 = state_43367__$1;
(statearr_43403_46419[(2)] = inst_43358);

(statearr_43403_46419[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (9))){
var state_43367__$1 = state_43367;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43409_46423 = state_43367__$1;
(statearr_43409_46423[(1)] = (11));

} else {
var statearr_43411_46424 = state_43367__$1;
(statearr_43411_46424[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (5))){
var inst_43342 = (state_43367[(7)]);
var state_43367__$1 = state_43367;
var statearr_43414_46425 = state_43367__$1;
(statearr_43414_46425[(2)] = inst_43342);

(statearr_43414_46425[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (10))){
var inst_43363 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
var statearr_43418_46426 = state_43367__$1;
(statearr_43418_46426[(2)] = inst_43363);

(statearr_43418_46426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43368 === (8))){
var inst_43342 = (state_43367[(7)]);
var inst_43352 = cljs.core.next(inst_43342);
var inst_43342__$1 = inst_43352;
var state_43367__$1 = (function (){var statearr_43419 = state_43367;
(statearr_43419[(7)] = inst_43342__$1);

return statearr_43419;
})();
var statearr_43420_46430 = state_43367__$1;
(statearr_43420_46430[(2)] = null);

(statearr_43420_46430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_43423 = [null,null,null,null,null,null,null,null];
(statearr_43423[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_43423[(1)] = (1));

return statearr_43423;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_43367){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_43367);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43426){var ex__42028__auto__ = e43426;
var statearr_43428_46431 = state_43367;
(statearr_43428_46431[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_43367[(4)]))){
var statearr_43429_46432 = state_43367;
(statearr_43429_46432[(1)] = cljs.core.first((state_43367[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46442 = state_43367;
state_43367 = G__46442;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_43367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_43367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43433 = f__42470__auto__();
(statearr_43433[(6)] = c__42469__auto__);

return statearr_43433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43458 = arguments.length;
switch (G__43458) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46445 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46445(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46458 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46458(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46462 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46462(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46495 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46495(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43522 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43522 = (function (ch,cs,meta43523){
this.ch = ch;
this.cs = cs;
this.meta43523 = meta43523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43524,meta43523__$1){
var self__ = this;
var _43524__$1 = this;
return (new cljs.core.async.t_cljs$core$async43522(self__.ch,self__.cs,meta43523__$1));
}));

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43524){
var self__ = this;
var _43524__$1 = this;
return self__.meta43523;
}));

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async43522.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async43522.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43523","meta43523",-1703308799,null)], null);
}));

(cljs.core.async.t_cljs$core$async43522.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43522.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43522");

(cljs.core.async.t_cljs$core$async43522.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43522");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43522.
 */
cljs.core.async.__GT_t_cljs$core$async43522 = (function cljs$core$async$mult_$___GT_t_cljs$core$async43522(ch__$1,cs__$1,meta43523){
return (new cljs.core.async.t_cljs$core$async43522(ch__$1,cs__$1,meta43523));
});

}

return (new cljs.core.async.t_cljs$core$async43522(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__42469__auto___46519 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_43700){
var state_val_43701 = (state_43700[(1)]);
if((state_val_43701 === (7))){
var inst_43695 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43707_46522 = state_43700__$1;
(statearr_43707_46522[(2)] = inst_43695);

(statearr_43707_46522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (20))){
var inst_43577 = (state_43700[(7)]);
var inst_43594 = cljs.core.first(inst_43577);
var inst_43595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43594,(0),null);
var inst_43596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43594,(1),null);
var state_43700__$1 = (function (){var statearr_43710 = state_43700;
(statearr_43710[(8)] = inst_43595);

return statearr_43710;
})();
if(cljs.core.truth_(inst_43596)){
var statearr_43715_46523 = state_43700__$1;
(statearr_43715_46523[(1)] = (22));

} else {
var statearr_43716_46524 = state_43700__$1;
(statearr_43716_46524[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (27))){
var inst_43635 = (state_43700[(9)]);
var inst_43546 = (state_43700[(10)]);
var inst_43625 = (state_43700[(11)]);
var inst_43627 = (state_43700[(12)]);
var inst_43635__$1 = cljs.core._nth(inst_43625,inst_43627);
var inst_43644 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_43635__$1,inst_43546,done);
var state_43700__$1 = (function (){var statearr_43717 = state_43700;
(statearr_43717[(9)] = inst_43635__$1);

return statearr_43717;
})();
if(cljs.core.truth_(inst_43644)){
var statearr_43718_46527 = state_43700__$1;
(statearr_43718_46527[(1)] = (30));

} else {
var statearr_43719_46528 = state_43700__$1;
(statearr_43719_46528[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (1))){
var state_43700__$1 = state_43700;
var statearr_43720_46529 = state_43700__$1;
(statearr_43720_46529[(2)] = null);

(statearr_43720_46529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (24))){
var inst_43577 = (state_43700[(7)]);
var inst_43601 = (state_43700[(2)]);
var inst_43602 = cljs.core.next(inst_43577);
var inst_43555 = inst_43602;
var inst_43556 = null;
var inst_43557 = (0);
var inst_43558 = (0);
var state_43700__$1 = (function (){var statearr_43722 = state_43700;
(statearr_43722[(13)] = inst_43556);

(statearr_43722[(14)] = inst_43601);

(statearr_43722[(15)] = inst_43555);

(statearr_43722[(16)] = inst_43558);

(statearr_43722[(17)] = inst_43557);

return statearr_43722;
})();
var statearr_43723_46530 = state_43700__$1;
(statearr_43723_46530[(2)] = null);

(statearr_43723_46530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (39))){
var state_43700__$1 = state_43700;
var statearr_43727_46531 = state_43700__$1;
(statearr_43727_46531[(2)] = null);

(statearr_43727_46531[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (4))){
var inst_43546 = (state_43700[(10)]);
var inst_43546__$1 = (state_43700[(2)]);
var inst_43547 = (inst_43546__$1 == null);
var state_43700__$1 = (function (){var statearr_43729 = state_43700;
(statearr_43729[(10)] = inst_43546__$1);

return statearr_43729;
})();
if(cljs.core.truth_(inst_43547)){
var statearr_43731_46532 = state_43700__$1;
(statearr_43731_46532[(1)] = (5));

} else {
var statearr_43734_46533 = state_43700__$1;
(statearr_43734_46533[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (15))){
var inst_43556 = (state_43700[(13)]);
var inst_43555 = (state_43700[(15)]);
var inst_43558 = (state_43700[(16)]);
var inst_43557 = (state_43700[(17)]);
var inst_43573 = (state_43700[(2)]);
var inst_43574 = (inst_43558 + (1));
var tmp43724 = inst_43556;
var tmp43725 = inst_43555;
var tmp43726 = inst_43557;
var inst_43555__$1 = tmp43725;
var inst_43556__$1 = tmp43724;
var inst_43557__$1 = tmp43726;
var inst_43558__$1 = inst_43574;
var state_43700__$1 = (function (){var statearr_43737 = state_43700;
(statearr_43737[(13)] = inst_43556__$1);

(statearr_43737[(18)] = inst_43573);

(statearr_43737[(15)] = inst_43555__$1);

(statearr_43737[(16)] = inst_43558__$1);

(statearr_43737[(17)] = inst_43557__$1);

return statearr_43737;
})();
var statearr_43739_46536 = state_43700__$1;
(statearr_43739_46536[(2)] = null);

(statearr_43739_46536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (21))){
var inst_43605 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43746_46541 = state_43700__$1;
(statearr_43746_46541[(2)] = inst_43605);

(statearr_43746_46541[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (31))){
var inst_43635 = (state_43700[(9)]);
var inst_43650 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_43635);
var state_43700__$1 = state_43700;
var statearr_43747_46542 = state_43700__$1;
(statearr_43747_46542[(2)] = inst_43650);

(statearr_43747_46542[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (32))){
var inst_43626 = (state_43700[(19)]);
var inst_43625 = (state_43700[(11)]);
var inst_43624 = (state_43700[(20)]);
var inst_43627 = (state_43700[(12)]);
var inst_43652 = (state_43700[(2)]);
var inst_43653 = (inst_43627 + (1));
var tmp43743 = inst_43626;
var tmp43744 = inst_43625;
var tmp43745 = inst_43624;
var inst_43624__$1 = tmp43745;
var inst_43625__$1 = tmp43744;
var inst_43626__$1 = tmp43743;
var inst_43627__$1 = inst_43653;
var state_43700__$1 = (function (){var statearr_43750 = state_43700;
(statearr_43750[(19)] = inst_43626__$1);

(statearr_43750[(11)] = inst_43625__$1);

(statearr_43750[(21)] = inst_43652);

(statearr_43750[(20)] = inst_43624__$1);

(statearr_43750[(12)] = inst_43627__$1);

return statearr_43750;
})();
var statearr_43752_46543 = state_43700__$1;
(statearr_43752_46543[(2)] = null);

(statearr_43752_46543[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (40))){
var inst_43665 = (state_43700[(22)]);
var inst_43670 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_43665);
var state_43700__$1 = state_43700;
var statearr_43757_46544 = state_43700__$1;
(statearr_43757_46544[(2)] = inst_43670);

(statearr_43757_46544[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (33))){
var inst_43656 = (state_43700[(23)]);
var inst_43658 = cljs.core.chunked_seq_QMARK_(inst_43656);
var state_43700__$1 = state_43700;
if(inst_43658){
var statearr_43759_46549 = state_43700__$1;
(statearr_43759_46549[(1)] = (36));

} else {
var statearr_43760_46550 = state_43700__$1;
(statearr_43760_46550[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (13))){
var inst_43567 = (state_43700[(24)]);
var inst_43570 = cljs.core.async.close_BANG_(inst_43567);
var state_43700__$1 = state_43700;
var statearr_43770_46554 = state_43700__$1;
(statearr_43770_46554[(2)] = inst_43570);

(statearr_43770_46554[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (22))){
var inst_43595 = (state_43700[(8)]);
var inst_43598 = cljs.core.async.close_BANG_(inst_43595);
var state_43700__$1 = state_43700;
var statearr_43772_46555 = state_43700__$1;
(statearr_43772_46555[(2)] = inst_43598);

(statearr_43772_46555[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (36))){
var inst_43656 = (state_43700[(23)]);
var inst_43660 = cljs.core.chunk_first(inst_43656);
var inst_43661 = cljs.core.chunk_rest(inst_43656);
var inst_43662 = cljs.core.count(inst_43660);
var inst_43624 = inst_43661;
var inst_43625 = inst_43660;
var inst_43626 = inst_43662;
var inst_43627 = (0);
var state_43700__$1 = (function (){var statearr_43773 = state_43700;
(statearr_43773[(19)] = inst_43626);

(statearr_43773[(11)] = inst_43625);

(statearr_43773[(20)] = inst_43624);

(statearr_43773[(12)] = inst_43627);

return statearr_43773;
})();
var statearr_43775_46561 = state_43700__$1;
(statearr_43775_46561[(2)] = null);

(statearr_43775_46561[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (41))){
var inst_43656 = (state_43700[(23)]);
var inst_43672 = (state_43700[(2)]);
var inst_43673 = cljs.core.next(inst_43656);
var inst_43624 = inst_43673;
var inst_43625 = null;
var inst_43626 = (0);
var inst_43627 = (0);
var state_43700__$1 = (function (){var statearr_43783 = state_43700;
(statearr_43783[(19)] = inst_43626);

(statearr_43783[(11)] = inst_43625);

(statearr_43783[(25)] = inst_43672);

(statearr_43783[(20)] = inst_43624);

(statearr_43783[(12)] = inst_43627);

return statearr_43783;
})();
var statearr_43784_46568 = state_43700__$1;
(statearr_43784_46568[(2)] = null);

(statearr_43784_46568[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (43))){
var state_43700__$1 = state_43700;
var statearr_43787_46569 = state_43700__$1;
(statearr_43787_46569[(2)] = null);

(statearr_43787_46569[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (29))){
var inst_43681 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43792_46570 = state_43700__$1;
(statearr_43792_46570[(2)] = inst_43681);

(statearr_43792_46570[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (44))){
var inst_43692 = (state_43700[(2)]);
var state_43700__$1 = (function (){var statearr_43796 = state_43700;
(statearr_43796[(26)] = inst_43692);

return statearr_43796;
})();
var statearr_43799_46580 = state_43700__$1;
(statearr_43799_46580[(2)] = null);

(statearr_43799_46580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (6))){
var inst_43615 = (state_43700[(27)]);
var inst_43614 = cljs.core.deref(cs);
var inst_43615__$1 = cljs.core.keys(inst_43614);
var inst_43616 = cljs.core.count(inst_43615__$1);
var inst_43617 = cljs.core.reset_BANG_(dctr,inst_43616);
var inst_43623 = cljs.core.seq(inst_43615__$1);
var inst_43624 = inst_43623;
var inst_43625 = null;
var inst_43626 = (0);
var inst_43627 = (0);
var state_43700__$1 = (function (){var statearr_43815 = state_43700;
(statearr_43815[(27)] = inst_43615__$1);

(statearr_43815[(28)] = inst_43617);

(statearr_43815[(19)] = inst_43626);

(statearr_43815[(11)] = inst_43625);

(statearr_43815[(20)] = inst_43624);

(statearr_43815[(12)] = inst_43627);

return statearr_43815;
})();
var statearr_43819_46593 = state_43700__$1;
(statearr_43819_46593[(2)] = null);

(statearr_43819_46593[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (28))){
var inst_43656 = (state_43700[(23)]);
var inst_43624 = (state_43700[(20)]);
var inst_43656__$1 = cljs.core.seq(inst_43624);
var state_43700__$1 = (function (){var statearr_43822 = state_43700;
(statearr_43822[(23)] = inst_43656__$1);

return statearr_43822;
})();
if(inst_43656__$1){
var statearr_43827_46597 = state_43700__$1;
(statearr_43827_46597[(1)] = (33));

} else {
var statearr_43828_46598 = state_43700__$1;
(statearr_43828_46598[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (25))){
var inst_43626 = (state_43700[(19)]);
var inst_43627 = (state_43700[(12)]);
var inst_43632 = (inst_43627 < inst_43626);
var inst_43633 = inst_43632;
var state_43700__$1 = state_43700;
if(cljs.core.truth_(inst_43633)){
var statearr_43829_46602 = state_43700__$1;
(statearr_43829_46602[(1)] = (27));

} else {
var statearr_43831_46604 = state_43700__$1;
(statearr_43831_46604[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (34))){
var state_43700__$1 = state_43700;
var statearr_43839_46610 = state_43700__$1;
(statearr_43839_46610[(2)] = null);

(statearr_43839_46610[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (17))){
var state_43700__$1 = state_43700;
var statearr_43840_46611 = state_43700__$1;
(statearr_43840_46611[(2)] = null);

(statearr_43840_46611[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (3))){
var inst_43697 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43700__$1,inst_43697);
} else {
if((state_val_43701 === (12))){
var inst_43610 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43841_46613 = state_43700__$1;
(statearr_43841_46613[(2)] = inst_43610);

(statearr_43841_46613[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (2))){
var state_43700__$1 = state_43700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43700__$1,(4),ch);
} else {
if((state_val_43701 === (23))){
var state_43700__$1 = state_43700;
var statearr_43842_46615 = state_43700__$1;
(statearr_43842_46615[(2)] = null);

(statearr_43842_46615[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (35))){
var inst_43679 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43843_46616 = state_43700__$1;
(statearr_43843_46616[(2)] = inst_43679);

(statearr_43843_46616[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (19))){
var inst_43577 = (state_43700[(7)]);
var inst_43582 = cljs.core.chunk_first(inst_43577);
var inst_43584 = cljs.core.chunk_rest(inst_43577);
var inst_43586 = cljs.core.count(inst_43582);
var inst_43555 = inst_43584;
var inst_43556 = inst_43582;
var inst_43557 = inst_43586;
var inst_43558 = (0);
var state_43700__$1 = (function (){var statearr_43848 = state_43700;
(statearr_43848[(13)] = inst_43556);

(statearr_43848[(15)] = inst_43555);

(statearr_43848[(16)] = inst_43558);

(statearr_43848[(17)] = inst_43557);

return statearr_43848;
})();
var statearr_43849_46620 = state_43700__$1;
(statearr_43849_46620[(2)] = null);

(statearr_43849_46620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (11))){
var inst_43577 = (state_43700[(7)]);
var inst_43555 = (state_43700[(15)]);
var inst_43577__$1 = cljs.core.seq(inst_43555);
var state_43700__$1 = (function (){var statearr_43850 = state_43700;
(statearr_43850[(7)] = inst_43577__$1);

return statearr_43850;
})();
if(inst_43577__$1){
var statearr_43851_46624 = state_43700__$1;
(statearr_43851_46624[(1)] = (16));

} else {
var statearr_43852_46625 = state_43700__$1;
(statearr_43852_46625[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (9))){
var inst_43612 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43853_46626 = state_43700__$1;
(statearr_43853_46626[(2)] = inst_43612);

(statearr_43853_46626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (5))){
var inst_43553 = cljs.core.deref(cs);
var inst_43554 = cljs.core.seq(inst_43553);
var inst_43555 = inst_43554;
var inst_43556 = null;
var inst_43557 = (0);
var inst_43558 = (0);
var state_43700__$1 = (function (){var statearr_43854 = state_43700;
(statearr_43854[(13)] = inst_43556);

(statearr_43854[(15)] = inst_43555);

(statearr_43854[(16)] = inst_43558);

(statearr_43854[(17)] = inst_43557);

return statearr_43854;
})();
var statearr_43856_46627 = state_43700__$1;
(statearr_43856_46627[(2)] = null);

(statearr_43856_46627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (14))){
var state_43700__$1 = state_43700;
var statearr_43858_46628 = state_43700__$1;
(statearr_43858_46628[(2)] = null);

(statearr_43858_46628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (45))){
var inst_43689 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43861_46629 = state_43700__$1;
(statearr_43861_46629[(2)] = inst_43689);

(statearr_43861_46629[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (26))){
var inst_43615 = (state_43700[(27)]);
var inst_43684 = (state_43700[(2)]);
var inst_43686 = cljs.core.seq(inst_43615);
var state_43700__$1 = (function (){var statearr_43865 = state_43700;
(statearr_43865[(29)] = inst_43684);

return statearr_43865;
})();
if(inst_43686){
var statearr_43867_46630 = state_43700__$1;
(statearr_43867_46630[(1)] = (42));

} else {
var statearr_43868_46631 = state_43700__$1;
(statearr_43868_46631[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (16))){
var inst_43577 = (state_43700[(7)]);
var inst_43580 = cljs.core.chunked_seq_QMARK_(inst_43577);
var state_43700__$1 = state_43700;
if(inst_43580){
var statearr_43870_46636 = state_43700__$1;
(statearr_43870_46636[(1)] = (19));

} else {
var statearr_43871_46637 = state_43700__$1;
(statearr_43871_46637[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (38))){
var inst_43676 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43872_46645 = state_43700__$1;
(statearr_43872_46645[(2)] = inst_43676);

(statearr_43872_46645[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (30))){
var state_43700__$1 = state_43700;
var statearr_43878_46650 = state_43700__$1;
(statearr_43878_46650[(2)] = null);

(statearr_43878_46650[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (10))){
var inst_43556 = (state_43700[(13)]);
var inst_43558 = (state_43700[(16)]);
var inst_43566 = cljs.core._nth(inst_43556,inst_43558);
var inst_43567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43566,(0),null);
var inst_43568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43566,(1),null);
var state_43700__$1 = (function (){var statearr_43879 = state_43700;
(statearr_43879[(24)] = inst_43567);

return statearr_43879;
})();
if(cljs.core.truth_(inst_43568)){
var statearr_43880_46651 = state_43700__$1;
(statearr_43880_46651[(1)] = (13));

} else {
var statearr_43881_46652 = state_43700__$1;
(statearr_43881_46652[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (18))){
var inst_43608 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
var statearr_43882_46653 = state_43700__$1;
(statearr_43882_46653[(2)] = inst_43608);

(statearr_43882_46653[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (42))){
var state_43700__$1 = state_43700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43700__$1,(45),dchan);
} else {
if((state_val_43701 === (37))){
var inst_43546 = (state_43700[(10)]);
var inst_43665 = (state_43700[(22)]);
var inst_43656 = (state_43700[(23)]);
var inst_43665__$1 = cljs.core.first(inst_43656);
var inst_43666 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_43665__$1,inst_43546,done);
var state_43700__$1 = (function (){var statearr_43883 = state_43700;
(statearr_43883[(22)] = inst_43665__$1);

return statearr_43883;
})();
if(cljs.core.truth_(inst_43666)){
var statearr_43884_46659 = state_43700__$1;
(statearr_43884_46659[(1)] = (39));

} else {
var statearr_43886_46661 = state_43700__$1;
(statearr_43886_46661[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (8))){
var inst_43558 = (state_43700[(16)]);
var inst_43557 = (state_43700[(17)]);
var inst_43560 = (inst_43558 < inst_43557);
var inst_43561 = inst_43560;
var state_43700__$1 = state_43700;
if(cljs.core.truth_(inst_43561)){
var statearr_43887_46662 = state_43700__$1;
(statearr_43887_46662[(1)] = (10));

} else {
var statearr_43888_46663 = state_43700__$1;
(statearr_43888_46663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42025__auto__ = null;
var cljs$core$async$mult_$_state_machine__42025__auto____0 = (function (){
var statearr_43889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43889[(0)] = cljs$core$async$mult_$_state_machine__42025__auto__);

(statearr_43889[(1)] = (1));

return statearr_43889;
});
var cljs$core$async$mult_$_state_machine__42025__auto____1 = (function (state_43700){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_43700);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e43890){var ex__42028__auto__ = e43890;
var statearr_43891_46664 = state_43700;
(statearr_43891_46664[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_43700[(4)]))){
var statearr_43892_46665 = state_43700;
(statearr_43892_46665[(1)] = cljs.core.first((state_43700[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46666 = state_43700;
state_43700 = G__46666;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42025__auto__ = function(state_43700){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42025__auto____1.call(this,state_43700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42025__auto____0;
cljs$core$async$mult_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42025__auto____1;
return cljs$core$async$mult_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_43894 = f__42470__auto__();
(statearr_43894[(6)] = c__42469__auto___46519);

return statearr_43894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__43900 = arguments.length;
switch (G__43900) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46675 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46675(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_46676 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_46676(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_46680 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_46680(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_46682 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_46682(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_46685 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_46685(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___46689 = arguments.length;
var i__4772__auto___46690 = (0);
while(true){
if((i__4772__auto___46690 < len__4771__auto___46689)){
args__4777__auto__.push((arguments[i__4772__auto___46690]));

var G__46695 = (i__4772__auto___46690 + (1));
i__4772__auto___46690 = G__46695;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__43947){
var map__43948 = p__43947;
var map__43948__$1 = cljs.core.__destructure_map(map__43948);
var opts = map__43948__$1;
var statearr_43949_46696 = state;
(statearr_43949_46696[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_43950_46697 = state;
(statearr_43950_46697[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_43951_46703 = state;
(statearr_43951_46703[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq43943){
var G__43944 = cljs.core.first(seq43943);
var seq43943__$1 = cljs.core.next(seq43943);
var G__43945 = cljs.core.first(seq43943__$1);
var seq43943__$2 = cljs.core.next(seq43943__$1);
var G__43946 = cljs.core.first(seq43943__$2);
var seq43943__$3 = cljs.core.next(seq43943__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43944,G__43945,G__43946,seq43943__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43955 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43955 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta43956){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta43956 = meta43956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43957,meta43956__$1){
var self__ = this;
var _43957__$1 = this;
return (new cljs.core.async.t_cljs$core$async43955(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta43956__$1));
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43957){
var self__ = this;
var _43957__$1 = this;
return self__.meta43956;
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async43955.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async43955.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta43956","meta43956",1457052178,null)], null);
}));

(cljs.core.async.t_cljs$core$async43955.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43955.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43955");

(cljs.core.async.t_cljs$core$async43955.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43955");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43955.
 */
cljs.core.async.__GT_t_cljs$core$async43955 = (function cljs$core$async$mix_$___GT_t_cljs$core$async43955(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43956){
return (new cljs.core.async.t_cljs$core$async43955(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43956));
});

}

return (new cljs.core.async.t_cljs$core$async43955(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42469__auto___46736 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_44035){
var state_val_44036 = (state_44035[(1)]);
if((state_val_44036 === (7))){
var inst_44031 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
var statearr_44040_46737 = state_44035__$1;
(statearr_44040_46737[(2)] = inst_44031);

(statearr_44040_46737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (20))){
var inst_44025 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
var statearr_44056_46738 = state_44035__$1;
(statearr_44056_46738[(2)] = inst_44025);

(statearr_44056_46738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (1))){
var inst_43977 = calc_state();
var inst_43978 = cljs.core.__destructure_map(inst_43977);
var inst_43979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43978,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43980 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43978,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43978,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_43982 = inst_43977;
var state_44035__$1 = (function (){var statearr_44061 = state_44035;
(statearr_44061[(7)] = inst_43982);

(statearr_44061[(8)] = inst_43979);

(statearr_44061[(9)] = inst_43980);

(statearr_44061[(10)] = inst_43981);

return statearr_44061;
})();
var statearr_44063_46739 = state_44035__$1;
(statearr_44063_46739[(2)] = null);

(statearr_44063_46739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (4))){
var inst_43994 = (state_44035[(11)]);
var inst_43995 = (state_44035[(12)]);
var inst_43993 = (state_44035[(2)]);
var inst_43994__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43993,(0),null);
var inst_43995__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43993,(1),null);
var inst_43996 = (inst_43994__$1 == null);
var inst_43997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43995__$1,change);
var inst_43998 = ((inst_43996) || (inst_43997));
var state_44035__$1 = (function (){var statearr_44064 = state_44035;
(statearr_44064[(11)] = inst_43994__$1);

(statearr_44064[(12)] = inst_43995__$1);

return statearr_44064;
})();
if(cljs.core.truth_(inst_43998)){
var statearr_44065_46740 = state_44035__$1;
(statearr_44065_46740[(1)] = (5));

} else {
var statearr_44068_46741 = state_44035__$1;
(statearr_44068_46741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (15))){
var inst_43985 = (state_44035[(13)]);
var inst_43982 = inst_43985;
var state_44035__$1 = (function (){var statearr_44070 = state_44035;
(statearr_44070[(7)] = inst_43982);

return statearr_44070;
})();
var statearr_44071_46745 = state_44035__$1;
(statearr_44071_46745[(2)] = null);

(statearr_44071_46745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (13))){
var inst_44017 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
if(cljs.core.truth_(inst_44017)){
var statearr_44073_46746 = state_44035__$1;
(statearr_44073_46746[(1)] = (14));

} else {
var statearr_44074_46747 = state_44035__$1;
(statearr_44074_46747[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (6))){
var inst_44009 = (state_44035[(14)]);
var inst_43986 = (state_44035[(15)]);
var inst_43995 = (state_44035[(12)]);
var inst_44009__$1 = (inst_43986.cljs$core$IFn$_invoke$arity$1 ? inst_43986.cljs$core$IFn$_invoke$arity$1(inst_43995) : inst_43986.call(null,inst_43995));
var state_44035__$1 = (function (){var statearr_44077 = state_44035;
(statearr_44077[(14)] = inst_44009__$1);

return statearr_44077;
})();
if(cljs.core.truth_(inst_44009__$1)){
var statearr_44079_46748 = state_44035__$1;
(statearr_44079_46748[(1)] = (11));

} else {
var statearr_44080_46751 = state_44035__$1;
(statearr_44080_46751[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (17))){
var inst_44020 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
if(cljs.core.truth_(inst_44020)){
var statearr_44081_46753 = state_44035__$1;
(statearr_44081_46753[(1)] = (18));

} else {
var statearr_44082_46754 = state_44035__$1;
(statearr_44082_46754[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (3))){
var inst_44033 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44035__$1,inst_44033);
} else {
if((state_val_44036 === (12))){
var inst_43987 = (state_44035[(16)]);
var inst_43986 = (state_44035[(15)]);
var inst_43995 = (state_44035[(12)]);
var inst_44012 = cljs.core.empty_QMARK_(inst_43986);
var inst_44013 = (inst_43987.cljs$core$IFn$_invoke$arity$1 ? inst_43987.cljs$core$IFn$_invoke$arity$1(inst_43995) : inst_43987.call(null,inst_43995));
var inst_44014 = cljs.core.not(inst_44013);
var inst_44015 = ((inst_44012) && (inst_44014));
var state_44035__$1 = state_44035;
var statearr_44093_46760 = state_44035__$1;
(statearr_44093_46760[(2)] = inst_44015);

(statearr_44093_46760[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (2))){
var inst_43982 = (state_44035[(7)]);
var inst_43985 = (state_44035[(13)]);
var inst_43985__$1 = cljs.core.__destructure_map(inst_43982);
var inst_43986 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43985__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43987 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43985__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43985__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44035__$1 = (function (){var statearr_44098 = state_44035;
(statearr_44098[(16)] = inst_43987);

(statearr_44098[(13)] = inst_43985__$1);

(statearr_44098[(15)] = inst_43986);

return statearr_44098;
})();
return cljs.core.async.ioc_alts_BANG_(state_44035__$1,(4),inst_43988);
} else {
if((state_val_44036 === (19))){
var state_44035__$1 = state_44035;
var statearr_44102_46763 = state_44035__$1;
(statearr_44102_46763[(2)] = null);

(statearr_44102_46763[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (11))){
var inst_44009 = (state_44035[(14)]);
var state_44035__$1 = state_44035;
var statearr_44104_46764 = state_44035__$1;
(statearr_44104_46764[(2)] = inst_44009);

(statearr_44104_46764[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (9))){
var state_44035__$1 = state_44035;
var statearr_44106_46765 = state_44035__$1;
(statearr_44106_46765[(2)] = null);

(statearr_44106_46765[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (5))){
var inst_43994 = (state_44035[(11)]);
var inst_44000 = (inst_43994 == null);
var state_44035__$1 = state_44035;
if(cljs.core.truth_(inst_44000)){
var statearr_44107_46767 = state_44035__$1;
(statearr_44107_46767[(1)] = (8));

} else {
var statearr_44110_46768 = state_44035__$1;
(statearr_44110_46768[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (14))){
var inst_43994 = (state_44035[(11)]);
var state_44035__$1 = state_44035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44035__$1,(17),out,inst_43994);
} else {
if((state_val_44036 === (16))){
var inst_44029 = (state_44035[(2)]);
var state_44035__$1 = state_44035;
var statearr_44118_46772 = state_44035__$1;
(statearr_44118_46772[(2)] = inst_44029);

(statearr_44118_46772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (10))){
var inst_44005 = (state_44035[(2)]);
var inst_44006 = calc_state();
var inst_43982 = inst_44006;
var state_44035__$1 = (function (){var statearr_44125 = state_44035;
(statearr_44125[(7)] = inst_43982);

(statearr_44125[(17)] = inst_44005);

return statearr_44125;
})();
var statearr_44127_46774 = state_44035__$1;
(statearr_44127_46774[(2)] = null);

(statearr_44127_46774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (18))){
var inst_43985 = (state_44035[(13)]);
var inst_43982 = inst_43985;
var state_44035__$1 = (function (){var statearr_44129 = state_44035;
(statearr_44129[(7)] = inst_43982);

return statearr_44129;
})();
var statearr_44131_46779 = state_44035__$1;
(statearr_44131_46779[(2)] = null);

(statearr_44131_46779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44036 === (8))){
var inst_43995 = (state_44035[(12)]);
var inst_44002 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_43995);
var state_44035__$1 = state_44035;
var statearr_44134_46785 = state_44035__$1;
(statearr_44134_46785[(2)] = inst_44002);

(statearr_44134_46785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42025__auto__ = null;
var cljs$core$async$mix_$_state_machine__42025__auto____0 = (function (){
var statearr_44136 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44136[(0)] = cljs$core$async$mix_$_state_machine__42025__auto__);

(statearr_44136[(1)] = (1));

return statearr_44136;
});
var cljs$core$async$mix_$_state_machine__42025__auto____1 = (function (state_44035){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_44035);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e44137){var ex__42028__auto__ = e44137;
var statearr_44141_46794 = state_44035;
(statearr_44141_46794[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_44035[(4)]))){
var statearr_44147_46795 = state_44035;
(statearr_44147_46795[(1)] = cljs.core.first((state_44035[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46796 = state_44035;
state_44035 = G__46796;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42025__auto__ = function(state_44035){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42025__auto____1.call(this,state_44035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42025__auto____0;
cljs$core$async$mix_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42025__auto____1;
return cljs$core$async$mix_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_44172 = f__42470__auto__();
(statearr_44172[(6)] = c__42469__auto___46736);

return statearr_44172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_46807 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_46807(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_46821 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_46821(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_46828 = (function() {
var G__46829 = null;
var G__46829__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__46829__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__46829 = function(p,v){
switch(arguments.length){
case 1:
return G__46829__1.call(this,p);
case 2:
return G__46829__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46829.cljs$core$IFn$_invoke$arity$1 = G__46829__1;
G__46829.cljs$core$IFn$_invoke$arity$2 = G__46829__2;
return G__46829;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__44248 = arguments.length;
switch (G__44248) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46828(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46828(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__44264 = arguments.length;
switch (G__44264) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__44259_SHARP_){
if(cljs.core.truth_((p1__44259_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__44259_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__44259_SHARP_.call(null,topic)))){
return p1__44259_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44259_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44281 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44281 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44282){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44282 = meta44282;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44283,meta44282__$1){
var self__ = this;
var _44283__$1 = this;
return (new cljs.core.async.t_cljs$core$async44281(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44282__$1));
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44283){
var self__ = this;
var _44283__$1 = this;
return self__.meta44282;
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async44281.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async44281.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44282","meta44282",1653028317,null)], null);
}));

(cljs.core.async.t_cljs$core$async44281.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44281.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44281");

(cljs.core.async.t_cljs$core$async44281.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async44281");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44281.
 */
cljs.core.async.__GT_t_cljs$core$async44281 = (function cljs$core$async$__GT_t_cljs$core$async44281(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44282){
return (new cljs.core.async.t_cljs$core$async44281(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44282));
});

}

return (new cljs.core.async.t_cljs$core$async44281(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42469__auto___46841 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_44410){
var state_val_44411 = (state_44410[(1)]);
if((state_val_44411 === (7))){
var inst_44406 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44419_46842 = state_44410__$1;
(statearr_44419_46842[(2)] = inst_44406);

(statearr_44419_46842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (20))){
var state_44410__$1 = state_44410;
var statearr_44423_46846 = state_44410__$1;
(statearr_44423_46846[(2)] = null);

(statearr_44423_46846[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (1))){
var state_44410__$1 = state_44410;
var statearr_44425_46848 = state_44410__$1;
(statearr_44425_46848[(2)] = null);

(statearr_44425_46848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (24))){
var inst_44388 = (state_44410[(7)]);
var inst_44398 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_44388);
var state_44410__$1 = state_44410;
var statearr_44428_46849 = state_44410__$1;
(statearr_44428_46849[(2)] = inst_44398);

(statearr_44428_46849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (4))){
var inst_44329 = (state_44410[(8)]);
var inst_44329__$1 = (state_44410[(2)]);
var inst_44330 = (inst_44329__$1 == null);
var state_44410__$1 = (function (){var statearr_44433 = state_44410;
(statearr_44433[(8)] = inst_44329__$1);

return statearr_44433;
})();
if(cljs.core.truth_(inst_44330)){
var statearr_44434_46855 = state_44410__$1;
(statearr_44434_46855[(1)] = (5));

} else {
var statearr_44435_46860 = state_44410__$1;
(statearr_44435_46860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (15))){
var inst_44382 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44440_46862 = state_44410__$1;
(statearr_44440_46862[(2)] = inst_44382);

(statearr_44440_46862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (21))){
var inst_44403 = (state_44410[(2)]);
var state_44410__$1 = (function (){var statearr_44442 = state_44410;
(statearr_44442[(9)] = inst_44403);

return statearr_44442;
})();
var statearr_44443_46866 = state_44410__$1;
(statearr_44443_46866[(2)] = null);

(statearr_44443_46866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (13))){
var inst_44360 = (state_44410[(10)]);
var inst_44364 = cljs.core.chunked_seq_QMARK_(inst_44360);
var state_44410__$1 = state_44410;
if(inst_44364){
var statearr_44452_46872 = state_44410__$1;
(statearr_44452_46872[(1)] = (16));

} else {
var statearr_44455_46873 = state_44410__$1;
(statearr_44455_46873[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (22))){
var inst_44394 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
if(cljs.core.truth_(inst_44394)){
var statearr_44461_46888 = state_44410__$1;
(statearr_44461_46888[(1)] = (23));

} else {
var statearr_44462_46889 = state_44410__$1;
(statearr_44462_46889[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (6))){
var inst_44388 = (state_44410[(7)]);
var inst_44329 = (state_44410[(8)]);
var inst_44390 = (state_44410[(11)]);
var inst_44388__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_44329) : topic_fn.call(null,inst_44329));
var inst_44389 = cljs.core.deref(mults);
var inst_44390__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44389,inst_44388__$1);
var state_44410__$1 = (function (){var statearr_44470 = state_44410;
(statearr_44470[(7)] = inst_44388__$1);

(statearr_44470[(11)] = inst_44390__$1);

return statearr_44470;
})();
if(cljs.core.truth_(inst_44390__$1)){
var statearr_44472_46895 = state_44410__$1;
(statearr_44472_46895[(1)] = (19));

} else {
var statearr_44474_46899 = state_44410__$1;
(statearr_44474_46899[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (25))){
var inst_44400 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44475_46904 = state_44410__$1;
(statearr_44475_46904[(2)] = inst_44400);

(statearr_44475_46904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (17))){
var inst_44360 = (state_44410[(10)]);
var inst_44372 = cljs.core.first(inst_44360);
var inst_44373 = cljs.core.async.muxch_STAR_(inst_44372);
var inst_44374 = cljs.core.async.close_BANG_(inst_44373);
var inst_44375 = cljs.core.next(inst_44360);
var inst_44340 = inst_44375;
var inst_44341 = null;
var inst_44342 = (0);
var inst_44343 = (0);
var state_44410__$1 = (function (){var statearr_44476 = state_44410;
(statearr_44476[(12)] = inst_44343);

(statearr_44476[(13)] = inst_44341);

(statearr_44476[(14)] = inst_44342);

(statearr_44476[(15)] = inst_44340);

(statearr_44476[(16)] = inst_44374);

return statearr_44476;
})();
var statearr_44481_46915 = state_44410__$1;
(statearr_44481_46915[(2)] = null);

(statearr_44481_46915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (3))){
var inst_44408 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44410__$1,inst_44408);
} else {
if((state_val_44411 === (12))){
var inst_44384 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44486_46925 = state_44410__$1;
(statearr_44486_46925[(2)] = inst_44384);

(statearr_44486_46925[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (2))){
var state_44410__$1 = state_44410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44410__$1,(4),ch);
} else {
if((state_val_44411 === (23))){
var state_44410__$1 = state_44410;
var statearr_44488_46937 = state_44410__$1;
(statearr_44488_46937[(2)] = null);

(statearr_44488_46937[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (19))){
var inst_44329 = (state_44410[(8)]);
var inst_44390 = (state_44410[(11)]);
var inst_44392 = cljs.core.async.muxch_STAR_(inst_44390);
var state_44410__$1 = state_44410;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44410__$1,(22),inst_44392,inst_44329);
} else {
if((state_val_44411 === (11))){
var inst_44340 = (state_44410[(15)]);
var inst_44360 = (state_44410[(10)]);
var inst_44360__$1 = cljs.core.seq(inst_44340);
var state_44410__$1 = (function (){var statearr_44496 = state_44410;
(statearr_44496[(10)] = inst_44360__$1);

return statearr_44496;
})();
if(inst_44360__$1){
var statearr_44500_46947 = state_44410__$1;
(statearr_44500_46947[(1)] = (13));

} else {
var statearr_44502_46953 = state_44410__$1;
(statearr_44502_46953[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (9))){
var inst_44386 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44504_46961 = state_44410__$1;
(statearr_44504_46961[(2)] = inst_44386);

(statearr_44504_46961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (5))){
var inst_44337 = cljs.core.deref(mults);
var inst_44338 = cljs.core.vals(inst_44337);
var inst_44339 = cljs.core.seq(inst_44338);
var inst_44340 = inst_44339;
var inst_44341 = null;
var inst_44342 = (0);
var inst_44343 = (0);
var state_44410__$1 = (function (){var statearr_44508 = state_44410;
(statearr_44508[(12)] = inst_44343);

(statearr_44508[(13)] = inst_44341);

(statearr_44508[(14)] = inst_44342);

(statearr_44508[(15)] = inst_44340);

return statearr_44508;
})();
var statearr_44513_46973 = state_44410__$1;
(statearr_44513_46973[(2)] = null);

(statearr_44513_46973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (14))){
var state_44410__$1 = state_44410;
var statearr_44519_46977 = state_44410__$1;
(statearr_44519_46977[(2)] = null);

(statearr_44519_46977[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (16))){
var inst_44360 = (state_44410[(10)]);
var inst_44366 = cljs.core.chunk_first(inst_44360);
var inst_44367 = cljs.core.chunk_rest(inst_44360);
var inst_44369 = cljs.core.count(inst_44366);
var inst_44340 = inst_44367;
var inst_44341 = inst_44366;
var inst_44342 = inst_44369;
var inst_44343 = (0);
var state_44410__$1 = (function (){var statearr_44523 = state_44410;
(statearr_44523[(12)] = inst_44343);

(statearr_44523[(13)] = inst_44341);

(statearr_44523[(14)] = inst_44342);

(statearr_44523[(15)] = inst_44340);

return statearr_44523;
})();
var statearr_44524_46994 = state_44410__$1;
(statearr_44524_46994[(2)] = null);

(statearr_44524_46994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (10))){
var inst_44343 = (state_44410[(12)]);
var inst_44341 = (state_44410[(13)]);
var inst_44342 = (state_44410[(14)]);
var inst_44340 = (state_44410[(15)]);
var inst_44353 = cljs.core._nth(inst_44341,inst_44343);
var inst_44354 = cljs.core.async.muxch_STAR_(inst_44353);
var inst_44355 = cljs.core.async.close_BANG_(inst_44354);
var inst_44356 = (inst_44343 + (1));
var tmp44515 = inst_44341;
var tmp44516 = inst_44342;
var tmp44517 = inst_44340;
var inst_44340__$1 = tmp44517;
var inst_44341__$1 = tmp44515;
var inst_44342__$1 = tmp44516;
var inst_44343__$1 = inst_44356;
var state_44410__$1 = (function (){var statearr_44563 = state_44410;
(statearr_44563[(12)] = inst_44343__$1);

(statearr_44563[(13)] = inst_44341__$1);

(statearr_44563[(14)] = inst_44342__$1);

(statearr_44563[(17)] = inst_44355);

(statearr_44563[(15)] = inst_44340__$1);

return statearr_44563;
})();
var statearr_44568_47017 = state_44410__$1;
(statearr_44568_47017[(2)] = null);

(statearr_44568_47017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (18))){
var inst_44379 = (state_44410[(2)]);
var state_44410__$1 = state_44410;
var statearr_44572_47018 = state_44410__$1;
(statearr_44572_47018[(2)] = inst_44379);

(statearr_44572_47018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44411 === (8))){
var inst_44343 = (state_44410[(12)]);
var inst_44342 = (state_44410[(14)]);
var inst_44345 = (inst_44343 < inst_44342);
var inst_44346 = inst_44345;
var state_44410__$1 = state_44410;
if(cljs.core.truth_(inst_44346)){
var statearr_44575_47024 = state_44410__$1;
(statearr_44575_47024[(1)] = (10));

} else {
var statearr_44576_47029 = state_44410__$1;
(statearr_44576_47029[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_44580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44580[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_44580[(1)] = (1));

return statearr_44580;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_44410){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_44410);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e44585){var ex__42028__auto__ = e44585;
var statearr_44586_47039 = state_44410;
(statearr_44586_47039[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_44410[(4)]))){
var statearr_44587_47040 = state_44410;
(statearr_44587_47040[(1)] = cljs.core.first((state_44410[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47045 = state_44410;
state_44410 = G__47045;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_44410){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_44410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_44595 = f__42470__auto__();
(statearr_44595[(6)] = c__42469__auto___46841);

return statearr_44595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__44602 = arguments.length;
switch (G__44602) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__44612 = arguments.length;
switch (G__44612) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__44618 = arguments.length;
switch (G__44618) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__42469__auto___47085 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_44726){
var state_val_44727 = (state_44726[(1)]);
if((state_val_44727 === (7))){
var state_44726__$1 = state_44726;
var statearr_44730_47086 = state_44726__$1;
(statearr_44730_47086[(2)] = null);

(statearr_44730_47086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (1))){
var state_44726__$1 = state_44726;
var statearr_44737_47087 = state_44726__$1;
(statearr_44737_47087[(2)] = null);

(statearr_44737_47087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (4))){
var inst_44633 = (state_44726[(7)]);
var inst_44632 = (state_44726[(8)]);
var inst_44636 = (inst_44633 < inst_44632);
var state_44726__$1 = state_44726;
if(cljs.core.truth_(inst_44636)){
var statearr_44740_47099 = state_44726__$1;
(statearr_44740_47099[(1)] = (6));

} else {
var statearr_44742_47104 = state_44726__$1;
(statearr_44742_47104[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (15))){
var inst_44709 = (state_44726[(9)]);
var inst_44716 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_44709);
var state_44726__$1 = state_44726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44726__$1,(17),out,inst_44716);
} else {
if((state_val_44727 === (13))){
var inst_44709 = (state_44726[(9)]);
var inst_44709__$1 = (state_44726[(2)]);
var inst_44712 = cljs.core.some(cljs.core.nil_QMARK_,inst_44709__$1);
var state_44726__$1 = (function (){var statearr_44744 = state_44726;
(statearr_44744[(9)] = inst_44709__$1);

return statearr_44744;
})();
if(cljs.core.truth_(inst_44712)){
var statearr_44746_47118 = state_44726__$1;
(statearr_44746_47118[(1)] = (14));

} else {
var statearr_44747_47119 = state_44726__$1;
(statearr_44747_47119[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (6))){
var state_44726__$1 = state_44726;
var statearr_44748_47121 = state_44726__$1;
(statearr_44748_47121[(2)] = null);

(statearr_44748_47121[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (17))){
var inst_44718 = (state_44726[(2)]);
var state_44726__$1 = (function (){var statearr_44818 = state_44726;
(statearr_44818[(10)] = inst_44718);

return statearr_44818;
})();
var statearr_44821_47123 = state_44726__$1;
(statearr_44821_47123[(2)] = null);

(statearr_44821_47123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (3))){
var inst_44723 = (state_44726[(2)]);
var state_44726__$1 = state_44726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44726__$1,inst_44723);
} else {
if((state_val_44727 === (12))){
var _ = (function (){var statearr_44829 = state_44726;
(statearr_44829[(4)] = cljs.core.rest((state_44726[(4)])));

return statearr_44829;
})();
var state_44726__$1 = state_44726;
var ex44813 = (state_44726__$1[(2)]);
var statearr_44830_47126 = state_44726__$1;
(statearr_44830_47126[(5)] = ex44813);


if((ex44813 instanceof Object)){
var statearr_44844_47127 = state_44726__$1;
(statearr_44844_47127[(1)] = (11));

(statearr_44844_47127[(5)] = null);

} else {
throw ex44813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (2))){
var inst_44631 = cljs.core.reset_BANG_(dctr,cnt);
var inst_44632 = cnt;
var inst_44633 = (0);
var state_44726__$1 = (function (){var statearr_44867 = state_44726;
(statearr_44867[(11)] = inst_44631);

(statearr_44867[(7)] = inst_44633);

(statearr_44867[(8)] = inst_44632);

return statearr_44867;
})();
var statearr_44868_47141 = state_44726__$1;
(statearr_44868_47141[(2)] = null);

(statearr_44868_47141[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (11))){
var inst_44683 = (state_44726[(2)]);
var inst_44684 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_44726__$1 = (function (){var statearr_44870 = state_44726;
(statearr_44870[(12)] = inst_44683);

return statearr_44870;
})();
var statearr_44871_47154 = state_44726__$1;
(statearr_44871_47154[(2)] = inst_44684);

(statearr_44871_47154[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (9))){
var inst_44633 = (state_44726[(7)]);
var _ = (function (){var statearr_44879 = state_44726;
(statearr_44879[(4)] = cljs.core.cons((12),(state_44726[(4)])));

return statearr_44879;
})();
var inst_44693 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_44633) : chs__$1.call(null,inst_44633));
var inst_44694 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_44633) : done.call(null,inst_44633));
var inst_44695 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_44693,inst_44694);
var ___$1 = (function (){var statearr_44883 = state_44726;
(statearr_44883[(4)] = cljs.core.rest((state_44726[(4)])));

return statearr_44883;
})();
var state_44726__$1 = state_44726;
var statearr_44885_47169 = state_44726__$1;
(statearr_44885_47169[(2)] = inst_44695);

(statearr_44885_47169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (5))){
var inst_44705 = (state_44726[(2)]);
var state_44726__$1 = (function (){var statearr_44889 = state_44726;
(statearr_44889[(13)] = inst_44705);

return statearr_44889;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44726__$1,(13),dchan);
} else {
if((state_val_44727 === (14))){
var inst_44714 = cljs.core.async.close_BANG_(out);
var state_44726__$1 = state_44726;
var statearr_44890_47176 = state_44726__$1;
(statearr_44890_47176[(2)] = inst_44714);

(statearr_44890_47176[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (16))){
var inst_44721 = (state_44726[(2)]);
var state_44726__$1 = state_44726;
var statearr_44891_47178 = state_44726__$1;
(statearr_44891_47178[(2)] = inst_44721);

(statearr_44891_47178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (10))){
var inst_44633 = (state_44726[(7)]);
var inst_44698 = (state_44726[(2)]);
var inst_44699 = (inst_44633 + (1));
var inst_44633__$1 = inst_44699;
var state_44726__$1 = (function (){var statearr_44897 = state_44726;
(statearr_44897[(7)] = inst_44633__$1);

(statearr_44897[(14)] = inst_44698);

return statearr_44897;
})();
var statearr_44898_47196 = state_44726__$1;
(statearr_44898_47196[(2)] = null);

(statearr_44898_47196[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44727 === (8))){
var inst_44703 = (state_44726[(2)]);
var state_44726__$1 = state_44726;
var statearr_44899_47200 = state_44726__$1;
(statearr_44899_47200[(2)] = inst_44703);

(statearr_44899_47200[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_44901 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44901[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_44901[(1)] = (1));

return statearr_44901;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_44726){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_44726);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e44904){var ex__42028__auto__ = e44904;
var statearr_44905_47205 = state_44726;
(statearr_44905_47205[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_44726[(4)]))){
var statearr_44906_47206 = state_44726;
(statearr_44906_47206[(1)] = cljs.core.first((state_44726[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47207 = state_44726;
state_44726 = G__47207;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_44726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_44726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_44909 = f__42470__auto__();
(statearr_44909[(6)] = c__42469__auto___47085);

return statearr_44909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__44921 = arguments.length;
switch (G__44921) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47218 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45000){
var state_val_45001 = (state_45000[(1)]);
if((state_val_45001 === (7))){
var inst_44947 = (state_45000[(7)]);
var inst_44948 = (state_45000[(8)]);
var inst_44947__$1 = (state_45000[(2)]);
var inst_44948__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44947__$1,(0),null);
var inst_44949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44947__$1,(1),null);
var inst_44950 = (inst_44948__$1 == null);
var state_45000__$1 = (function (){var statearr_45007 = state_45000;
(statearr_45007[(7)] = inst_44947__$1);

(statearr_45007[(9)] = inst_44949);

(statearr_45007[(8)] = inst_44948__$1);

return statearr_45007;
})();
if(cljs.core.truth_(inst_44950)){
var statearr_45008_47227 = state_45000__$1;
(statearr_45008_47227[(1)] = (8));

} else {
var statearr_45009_47228 = state_45000__$1;
(statearr_45009_47228[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (1))){
var inst_44932 = cljs.core.vec(chs);
var inst_44934 = inst_44932;
var state_45000__$1 = (function (){var statearr_45010 = state_45000;
(statearr_45010[(10)] = inst_44934);

return statearr_45010;
})();
var statearr_45014_47230 = state_45000__$1;
(statearr_45014_47230[(2)] = null);

(statearr_45014_47230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (4))){
var inst_44934 = (state_45000[(10)]);
var state_45000__$1 = state_45000;
return cljs.core.async.ioc_alts_BANG_(state_45000__$1,(7),inst_44934);
} else {
if((state_val_45001 === (6))){
var inst_44992 = (state_45000[(2)]);
var state_45000__$1 = state_45000;
var statearr_45016_47237 = state_45000__$1;
(statearr_45016_47237[(2)] = inst_44992);

(statearr_45016_47237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (3))){
var inst_44994 = (state_45000[(2)]);
var state_45000__$1 = state_45000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45000__$1,inst_44994);
} else {
if((state_val_45001 === (2))){
var inst_44934 = (state_45000[(10)]);
var inst_44936 = cljs.core.count(inst_44934);
var inst_44937 = (inst_44936 > (0));
var state_45000__$1 = state_45000;
if(cljs.core.truth_(inst_44937)){
var statearr_45018_47246 = state_45000__$1;
(statearr_45018_47246[(1)] = (4));

} else {
var statearr_45019_47247 = state_45000__$1;
(statearr_45019_47247[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (11))){
var inst_44934 = (state_45000[(10)]);
var inst_44985 = (state_45000[(2)]);
var tmp45017 = inst_44934;
var inst_44934__$1 = tmp45017;
var state_45000__$1 = (function (){var statearr_45020 = state_45000;
(statearr_45020[(11)] = inst_44985);

(statearr_45020[(10)] = inst_44934__$1);

return statearr_45020;
})();
var statearr_45021_47250 = state_45000__$1;
(statearr_45021_47250[(2)] = null);

(statearr_45021_47250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (9))){
var inst_44948 = (state_45000[(8)]);
var state_45000__$1 = state_45000;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45000__$1,(11),out,inst_44948);
} else {
if((state_val_45001 === (5))){
var inst_44990 = cljs.core.async.close_BANG_(out);
var state_45000__$1 = state_45000;
var statearr_45022_47255 = state_45000__$1;
(statearr_45022_47255[(2)] = inst_44990);

(statearr_45022_47255[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (10))){
var inst_44988 = (state_45000[(2)]);
var state_45000__$1 = state_45000;
var statearr_45024_47258 = state_45000__$1;
(statearr_45024_47258[(2)] = inst_44988);

(statearr_45024_47258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45001 === (8))){
var inst_44947 = (state_45000[(7)]);
var inst_44949 = (state_45000[(9)]);
var inst_44948 = (state_45000[(8)]);
var inst_44934 = (state_45000[(10)]);
var inst_44958 = (function (){var cs = inst_44934;
var vec__44943 = inst_44947;
var v = inst_44948;
var c = inst_44949;
return (function (p1__44916_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__44916_SHARP_);
});
})();
var inst_44967 = cljs.core.filterv(inst_44958,inst_44934);
var inst_44934__$1 = inst_44967;
var state_45000__$1 = (function (){var statearr_45035 = state_45000;
(statearr_45035[(10)] = inst_44934__$1);

return statearr_45035;
})();
var statearr_45036_47267 = state_45000__$1;
(statearr_45036_47267[(2)] = null);

(statearr_45036_47267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45045 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45045[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45045[(1)] = (1));

return statearr_45045;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45000){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45000);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45050){var ex__42028__auto__ = e45050;
var statearr_45051_47281 = state_45000;
(statearr_45051_47281[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45000[(4)]))){
var statearr_45053_47282 = state_45000;
(statearr_45053_47282[(1)] = cljs.core.first((state_45000[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47285 = state_45000;
state_45000 = G__47285;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45000){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45055 = f__42470__auto__();
(statearr_45055[(6)] = c__42469__auto___47218);

return statearr_45055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45060 = arguments.length;
switch (G__45060) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45085){
var state_val_45086 = (state_45085[(1)]);
if((state_val_45086 === (7))){
var inst_45067 = (state_45085[(7)]);
var inst_45067__$1 = (state_45085[(2)]);
var inst_45068 = (inst_45067__$1 == null);
var inst_45069 = cljs.core.not(inst_45068);
var state_45085__$1 = (function (){var statearr_45087 = state_45085;
(statearr_45087[(7)] = inst_45067__$1);

return statearr_45087;
})();
if(inst_45069){
var statearr_45088_47302 = state_45085__$1;
(statearr_45088_47302[(1)] = (8));

} else {
var statearr_45089_47303 = state_45085__$1;
(statearr_45089_47303[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (1))){
var inst_45062 = (0);
var state_45085__$1 = (function (){var statearr_45106 = state_45085;
(statearr_45106[(8)] = inst_45062);

return statearr_45106;
})();
var statearr_45107_47304 = state_45085__$1;
(statearr_45107_47304[(2)] = null);

(statearr_45107_47304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (4))){
var state_45085__$1 = state_45085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45085__$1,(7),ch);
} else {
if((state_val_45086 === (6))){
var inst_45080 = (state_45085[(2)]);
var state_45085__$1 = state_45085;
var statearr_45108_47306 = state_45085__$1;
(statearr_45108_47306[(2)] = inst_45080);

(statearr_45108_47306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (3))){
var inst_45082 = (state_45085[(2)]);
var inst_45083 = cljs.core.async.close_BANG_(out);
var state_45085__$1 = (function (){var statearr_45109 = state_45085;
(statearr_45109[(9)] = inst_45082);

return statearr_45109;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45085__$1,inst_45083);
} else {
if((state_val_45086 === (2))){
var inst_45062 = (state_45085[(8)]);
var inst_45064 = (inst_45062 < n);
var state_45085__$1 = state_45085;
if(cljs.core.truth_(inst_45064)){
var statearr_45110_47310 = state_45085__$1;
(statearr_45110_47310[(1)] = (4));

} else {
var statearr_45111_47311 = state_45085__$1;
(statearr_45111_47311[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (11))){
var inst_45062 = (state_45085[(8)]);
var inst_45072 = (state_45085[(2)]);
var inst_45073 = (inst_45062 + (1));
var inst_45062__$1 = inst_45073;
var state_45085__$1 = (function (){var statearr_45112 = state_45085;
(statearr_45112[(10)] = inst_45072);

(statearr_45112[(8)] = inst_45062__$1);

return statearr_45112;
})();
var statearr_45114_47316 = state_45085__$1;
(statearr_45114_47316[(2)] = null);

(statearr_45114_47316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (9))){
var state_45085__$1 = state_45085;
var statearr_45119_47317 = state_45085__$1;
(statearr_45119_47317[(2)] = null);

(statearr_45119_47317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (5))){
var state_45085__$1 = state_45085;
var statearr_45120_47318 = state_45085__$1;
(statearr_45120_47318[(2)] = null);

(statearr_45120_47318[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (10))){
var inst_45077 = (state_45085[(2)]);
var state_45085__$1 = state_45085;
var statearr_45126_47320 = state_45085__$1;
(statearr_45126_47320[(2)] = inst_45077);

(statearr_45126_47320[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45086 === (8))){
var inst_45067 = (state_45085[(7)]);
var state_45085__$1 = state_45085;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45085__$1,(11),out,inst_45067);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45135 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45135[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45135[(1)] = (1));

return statearr_45135;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45085){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45085);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45136){var ex__42028__auto__ = e45136;
var statearr_45140_47323 = state_45085;
(statearr_45140_47323[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45085[(4)]))){
var statearr_45141_47324 = state_45085;
(statearr_45141_47324[(1)] = cljs.core.first((state_45085[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47325 = state_45085;
state_45085 = G__47325;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45085){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45142 = f__42470__auto__();
(statearr_45142[(6)] = c__42469__auto___47300);

return statearr_45142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45147 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45147 = (function (f,ch,meta45148){
this.f = f;
this.ch = ch;
this.meta45148 = meta45148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45149,meta45148__$1){
var self__ = this;
var _45149__$1 = this;
return (new cljs.core.async.t_cljs$core$async45147(self__.f,self__.ch,meta45148__$1));
}));

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45149){
var self__ = this;
var _45149__$1 = this;
return self__.meta45148;
}));

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45167 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45167 = (function (f,ch,meta45148,_,fn1,meta45168){
this.f = f;
this.ch = ch;
this.meta45148 = meta45148;
this._ = _;
this.fn1 = fn1;
this.meta45168 = meta45168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45169,meta45168__$1){
var self__ = this;
var _45169__$1 = this;
return (new cljs.core.async.t_cljs$core$async45167(self__.f,self__.ch,self__.meta45148,self__._,self__.fn1,meta45168__$1));
}));

(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45169){
var self__ = this;
var _45169__$1 = this;
return self__.meta45168;
}));

(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45167.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45146_SHARP_){
var G__45178 = (((p1__45146_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45146_SHARP_) : self__.f.call(null,p1__45146_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45178) : f1.call(null,G__45178));
});
}));

(cljs.core.async.t_cljs$core$async45167.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45148","meta45148",1970397807,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45147","cljs.core.async/t_cljs$core$async45147",-401631135,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45168","meta45168",347409220,null)], null);
}));

(cljs.core.async.t_cljs$core$async45167.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45167.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45167");

(cljs.core.async.t_cljs$core$async45167.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45167");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45167.
 */
cljs.core.async.__GT_t_cljs$core$async45167 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45167(f__$1,ch__$1,meta45148__$1,___$2,fn1__$1,meta45168){
return (new cljs.core.async.t_cljs$core$async45167(f__$1,ch__$1,meta45148__$1,___$2,fn1__$1,meta45168));
});

}

return (new cljs.core.async.t_cljs$core$async45167(self__.f,self__.ch,self__.meta45148,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45180 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45180) : self__.f.call(null,G__45180));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45147.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45147.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45148","meta45148",1970397807,null)], null);
}));

(cljs.core.async.t_cljs$core$async45147.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45147");

(cljs.core.async.t_cljs$core$async45147.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45147");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45147.
 */
cljs.core.async.__GT_t_cljs$core$async45147 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45147(f__$1,ch__$1,meta45148){
return (new cljs.core.async.t_cljs$core$async45147(f__$1,ch__$1,meta45148));
});

}

return (new cljs.core.async.t_cljs$core$async45147(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45183 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45183 = (function (f,ch,meta45184){
this.f = f;
this.ch = ch;
this.meta45184 = meta45184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45185,meta45184__$1){
var self__ = this;
var _45185__$1 = this;
return (new cljs.core.async.t_cljs$core$async45183(self__.f,self__.ch,meta45184__$1));
}));

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45185){
var self__ = this;
var _45185__$1 = this;
return self__.meta45184;
}));

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45183.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45184","meta45184",-2002536000,null)], null);
}));

(cljs.core.async.t_cljs$core$async45183.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45183");

(cljs.core.async.t_cljs$core$async45183.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45183");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45183.
 */
cljs.core.async.__GT_t_cljs$core$async45183 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45183(f__$1,ch__$1,meta45184){
return (new cljs.core.async.t_cljs$core$async45183(f__$1,ch__$1,meta45184));
});

}

return (new cljs.core.async.t_cljs$core$async45183(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45198 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45198 = (function (p,ch,meta45199){
this.p = p;
this.ch = ch;
this.meta45199 = meta45199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45200,meta45199__$1){
var self__ = this;
var _45200__$1 = this;
return (new cljs.core.async.t_cljs$core$async45198(self__.p,self__.ch,meta45199__$1));
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45200){
var self__ = this;
var _45200__$1 = this;
return self__.meta45199;
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45198.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45199","meta45199",1541849713,null)], null);
}));

(cljs.core.async.t_cljs$core$async45198.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45198");

(cljs.core.async.t_cljs$core$async45198.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45198");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45198.
 */
cljs.core.async.__GT_t_cljs$core$async45198 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45198(p__$1,ch__$1,meta45199){
return (new cljs.core.async.t_cljs$core$async45198(p__$1,ch__$1,meta45199));
});

}

return (new cljs.core.async.t_cljs$core$async45198(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45219 = arguments.length;
switch (G__45219) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47449 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45244){
var state_val_45245 = (state_45244[(1)]);
if((state_val_45245 === (7))){
var inst_45240 = (state_45244[(2)]);
var state_45244__$1 = state_45244;
var statearr_45246_47452 = state_45244__$1;
(statearr_45246_47452[(2)] = inst_45240);

(statearr_45246_47452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (1))){
var state_45244__$1 = state_45244;
var statearr_45247_47459 = state_45244__$1;
(statearr_45247_47459[(2)] = null);

(statearr_45247_47459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (4))){
var inst_45226 = (state_45244[(7)]);
var inst_45226__$1 = (state_45244[(2)]);
var inst_45227 = (inst_45226__$1 == null);
var state_45244__$1 = (function (){var statearr_45248 = state_45244;
(statearr_45248[(7)] = inst_45226__$1);

return statearr_45248;
})();
if(cljs.core.truth_(inst_45227)){
var statearr_45249_47470 = state_45244__$1;
(statearr_45249_47470[(1)] = (5));

} else {
var statearr_45255_47471 = state_45244__$1;
(statearr_45255_47471[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (6))){
var inst_45226 = (state_45244[(7)]);
var inst_45231 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45226) : p.call(null,inst_45226));
var state_45244__$1 = state_45244;
if(cljs.core.truth_(inst_45231)){
var statearr_45257_47483 = state_45244__$1;
(statearr_45257_47483[(1)] = (8));

} else {
var statearr_45258_47486 = state_45244__$1;
(statearr_45258_47486[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (3))){
var inst_45242 = (state_45244[(2)]);
var state_45244__$1 = state_45244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45244__$1,inst_45242);
} else {
if((state_val_45245 === (2))){
var state_45244__$1 = state_45244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45244__$1,(4),ch);
} else {
if((state_val_45245 === (11))){
var inst_45234 = (state_45244[(2)]);
var state_45244__$1 = state_45244;
var statearr_45260_47495 = state_45244__$1;
(statearr_45260_47495[(2)] = inst_45234);

(statearr_45260_47495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (9))){
var state_45244__$1 = state_45244;
var statearr_45263_47497 = state_45244__$1;
(statearr_45263_47497[(2)] = null);

(statearr_45263_47497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (5))){
var inst_45229 = cljs.core.async.close_BANG_(out);
var state_45244__$1 = state_45244;
var statearr_45265_47506 = state_45244__$1;
(statearr_45265_47506[(2)] = inst_45229);

(statearr_45265_47506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (10))){
var inst_45237 = (state_45244[(2)]);
var state_45244__$1 = (function (){var statearr_45267 = state_45244;
(statearr_45267[(8)] = inst_45237);

return statearr_45267;
})();
var statearr_45269_47516 = state_45244__$1;
(statearr_45269_47516[(2)] = null);

(statearr_45269_47516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45245 === (8))){
var inst_45226 = (state_45244[(7)]);
var state_45244__$1 = state_45244;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45244__$1,(11),out,inst_45226);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45270 = [null,null,null,null,null,null,null,null,null];
(statearr_45270[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45270[(1)] = (1));

return statearr_45270;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45244){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45244);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45273){var ex__42028__auto__ = e45273;
var statearr_45274_47534 = state_45244;
(statearr_45274_47534[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45244[(4)]))){
var statearr_45276_47536 = state_45244;
(statearr_45276_47536[(1)] = cljs.core.first((state_45244[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47540 = state_45244;
state_45244 = G__47540;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45244){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45283 = f__42470__auto__();
(statearr_45283[(6)] = c__42469__auto___47449);

return statearr_45283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45286 = arguments.length;
switch (G__45286) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45376){
var state_val_45377 = (state_45376[(1)]);
if((state_val_45377 === (7))){
var inst_45372 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
var statearr_45378_47554 = state_45376__$1;
(statearr_45378_47554[(2)] = inst_45372);

(statearr_45378_47554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (20))){
var inst_45338 = (state_45376[(7)]);
var inst_45353 = (state_45376[(2)]);
var inst_45354 = cljs.core.next(inst_45338);
var inst_45320 = inst_45354;
var inst_45321 = null;
var inst_45322 = (0);
var inst_45323 = (0);
var state_45376__$1 = (function (){var statearr_45379 = state_45376;
(statearr_45379[(8)] = inst_45320);

(statearr_45379[(9)] = inst_45323);

(statearr_45379[(10)] = inst_45322);

(statearr_45379[(11)] = inst_45353);

(statearr_45379[(12)] = inst_45321);

return statearr_45379;
})();
var statearr_45382_47564 = state_45376__$1;
(statearr_45382_47564[(2)] = null);

(statearr_45382_47564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (1))){
var state_45376__$1 = state_45376;
var statearr_45392_47566 = state_45376__$1;
(statearr_45392_47566[(2)] = null);

(statearr_45392_47566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (4))){
var inst_45309 = (state_45376[(13)]);
var inst_45309__$1 = (state_45376[(2)]);
var inst_45310 = (inst_45309__$1 == null);
var state_45376__$1 = (function (){var statearr_45399 = state_45376;
(statearr_45399[(13)] = inst_45309__$1);

return statearr_45399;
})();
if(cljs.core.truth_(inst_45310)){
var statearr_45400_47575 = state_45376__$1;
(statearr_45400_47575[(1)] = (5));

} else {
var statearr_45401_47576 = state_45376__$1;
(statearr_45401_47576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (15))){
var state_45376__$1 = state_45376;
var statearr_45411_47577 = state_45376__$1;
(statearr_45411_47577[(2)] = null);

(statearr_45411_47577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (21))){
var state_45376__$1 = state_45376;
var statearr_45413_47582 = state_45376__$1;
(statearr_45413_47582[(2)] = null);

(statearr_45413_47582[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (13))){
var inst_45320 = (state_45376[(8)]);
var inst_45323 = (state_45376[(9)]);
var inst_45322 = (state_45376[(10)]);
var inst_45321 = (state_45376[(12)]);
var inst_45333 = (state_45376[(2)]);
var inst_45334 = (inst_45323 + (1));
var tmp45408 = inst_45320;
var tmp45409 = inst_45322;
var tmp45410 = inst_45321;
var inst_45320__$1 = tmp45408;
var inst_45321__$1 = tmp45410;
var inst_45322__$1 = tmp45409;
var inst_45323__$1 = inst_45334;
var state_45376__$1 = (function (){var statearr_45415 = state_45376;
(statearr_45415[(8)] = inst_45320__$1);

(statearr_45415[(9)] = inst_45323__$1);

(statearr_45415[(10)] = inst_45322__$1);

(statearr_45415[(12)] = inst_45321__$1);

(statearr_45415[(14)] = inst_45333);

return statearr_45415;
})();
var statearr_45416_47594 = state_45376__$1;
(statearr_45416_47594[(2)] = null);

(statearr_45416_47594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (22))){
var state_45376__$1 = state_45376;
var statearr_45417_47596 = state_45376__$1;
(statearr_45417_47596[(2)] = null);

(statearr_45417_47596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (6))){
var inst_45309 = (state_45376[(13)]);
var inst_45318 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45309) : f.call(null,inst_45309));
var inst_45319 = cljs.core.seq(inst_45318);
var inst_45320 = inst_45319;
var inst_45321 = null;
var inst_45322 = (0);
var inst_45323 = (0);
var state_45376__$1 = (function (){var statearr_45420 = state_45376;
(statearr_45420[(8)] = inst_45320);

(statearr_45420[(9)] = inst_45323);

(statearr_45420[(10)] = inst_45322);

(statearr_45420[(12)] = inst_45321);

return statearr_45420;
})();
var statearr_45437_47604 = state_45376__$1;
(statearr_45437_47604[(2)] = null);

(statearr_45437_47604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (17))){
var inst_45338 = (state_45376[(7)]);
var inst_45344 = cljs.core.chunk_first(inst_45338);
var inst_45345 = cljs.core.chunk_rest(inst_45338);
var inst_45346 = cljs.core.count(inst_45344);
var inst_45320 = inst_45345;
var inst_45321 = inst_45344;
var inst_45322 = inst_45346;
var inst_45323 = (0);
var state_45376__$1 = (function (){var statearr_45444 = state_45376;
(statearr_45444[(8)] = inst_45320);

(statearr_45444[(9)] = inst_45323);

(statearr_45444[(10)] = inst_45322);

(statearr_45444[(12)] = inst_45321);

return statearr_45444;
})();
var statearr_45445_47610 = state_45376__$1;
(statearr_45445_47610[(2)] = null);

(statearr_45445_47610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (3))){
var inst_45374 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45376__$1,inst_45374);
} else {
if((state_val_45377 === (12))){
var inst_45362 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
var statearr_45448_47620 = state_45376__$1;
(statearr_45448_47620[(2)] = inst_45362);

(statearr_45448_47620[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (2))){
var state_45376__$1 = state_45376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45376__$1,(4),in$);
} else {
if((state_val_45377 === (23))){
var inst_45370 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
var statearr_45458_47630 = state_45376__$1;
(statearr_45458_47630[(2)] = inst_45370);

(statearr_45458_47630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (19))){
var inst_45357 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
var statearr_45459_47638 = state_45376__$1;
(statearr_45459_47638[(2)] = inst_45357);

(statearr_45459_47638[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (11))){
var inst_45320 = (state_45376[(8)]);
var inst_45338 = (state_45376[(7)]);
var inst_45338__$1 = cljs.core.seq(inst_45320);
var state_45376__$1 = (function (){var statearr_45465 = state_45376;
(statearr_45465[(7)] = inst_45338__$1);

return statearr_45465;
})();
if(inst_45338__$1){
var statearr_45466_47654 = state_45376__$1;
(statearr_45466_47654[(1)] = (14));

} else {
var statearr_45467_47656 = state_45376__$1;
(statearr_45467_47656[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (9))){
var inst_45364 = (state_45376[(2)]);
var inst_45365 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_45376__$1 = (function (){var statearr_45468 = state_45376;
(statearr_45468[(15)] = inst_45364);

return statearr_45468;
})();
if(cljs.core.truth_(inst_45365)){
var statearr_45469_47673 = state_45376__$1;
(statearr_45469_47673[(1)] = (21));

} else {
var statearr_45470_47676 = state_45376__$1;
(statearr_45470_47676[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (5))){
var inst_45312 = cljs.core.async.close_BANG_(out);
var state_45376__$1 = state_45376;
var statearr_45471_47682 = state_45376__$1;
(statearr_45471_47682[(2)] = inst_45312);

(statearr_45471_47682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (14))){
var inst_45338 = (state_45376[(7)]);
var inst_45340 = cljs.core.chunked_seq_QMARK_(inst_45338);
var state_45376__$1 = state_45376;
if(inst_45340){
var statearr_45472_47690 = state_45376__$1;
(statearr_45472_47690[(1)] = (17));

} else {
var statearr_45480_47694 = state_45376__$1;
(statearr_45480_47694[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (16))){
var inst_45360 = (state_45376[(2)]);
var state_45376__$1 = state_45376;
var statearr_45481_47700 = state_45376__$1;
(statearr_45481_47700[(2)] = inst_45360);

(statearr_45481_47700[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45377 === (10))){
var inst_45323 = (state_45376[(9)]);
var inst_45321 = (state_45376[(12)]);
var inst_45329 = cljs.core._nth(inst_45321,inst_45323);
var state_45376__$1 = state_45376;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45376__$1,(13),out,inst_45329);
} else {
if((state_val_45377 === (18))){
var inst_45338 = (state_45376[(7)]);
var inst_45351 = cljs.core.first(inst_45338);
var state_45376__$1 = state_45376;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45376__$1,(20),out,inst_45351);
} else {
if((state_val_45377 === (8))){
var inst_45323 = (state_45376[(9)]);
var inst_45322 = (state_45376[(10)]);
var inst_45325 = (inst_45323 < inst_45322);
var inst_45326 = inst_45325;
var state_45376__$1 = state_45376;
if(cljs.core.truth_(inst_45326)){
var statearr_45482_47726 = state_45376__$1;
(statearr_45482_47726[(1)] = (10));

} else {
var statearr_45483_47734 = state_45376__$1;
(statearr_45483_47734[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____0 = (function (){
var statearr_45485 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45485[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__);

(statearr_45485[(1)] = (1));

return statearr_45485;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____1 = (function (state_45376){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45376);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45488){var ex__42028__auto__ = e45488;
var statearr_45490_47752 = state_45376;
(statearr_45490_47752[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45376[(4)]))){
var statearr_45491_47755 = state_45376;
(statearr_45491_47755[(1)] = cljs.core.first((state_45376[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47759 = state_45376;
state_45376 = G__47759;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__ = function(state_45376){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____1.call(this,state_45376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42025__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45492 = f__42470__auto__();
(statearr_45492[(6)] = c__42469__auto__);

return statearr_45492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45494 = arguments.length;
switch (G__45494) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45500 = arguments.length;
switch (G__45500) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45503 = arguments.length;
switch (G__45503) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47797 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45530){
var state_val_45531 = (state_45530[(1)]);
if((state_val_45531 === (7))){
var inst_45522 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45541_47800 = state_45530__$1;
(statearr_45541_47800[(2)] = inst_45522);

(statearr_45541_47800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (1))){
var inst_45504 = null;
var state_45530__$1 = (function (){var statearr_45543 = state_45530;
(statearr_45543[(7)] = inst_45504);

return statearr_45543;
})();
var statearr_45544_47804 = state_45530__$1;
(statearr_45544_47804[(2)] = null);

(statearr_45544_47804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (4))){
var inst_45507 = (state_45530[(8)]);
var inst_45507__$1 = (state_45530[(2)]);
var inst_45508 = (inst_45507__$1 == null);
var inst_45509 = cljs.core.not(inst_45508);
var state_45530__$1 = (function (){var statearr_45545 = state_45530;
(statearr_45545[(8)] = inst_45507__$1);

return statearr_45545;
})();
if(inst_45509){
var statearr_45546_47813 = state_45530__$1;
(statearr_45546_47813[(1)] = (5));

} else {
var statearr_45547_47814 = state_45530__$1;
(statearr_45547_47814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (6))){
var state_45530__$1 = state_45530;
var statearr_45548_47816 = state_45530__$1;
(statearr_45548_47816[(2)] = null);

(statearr_45548_47816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (3))){
var inst_45524 = (state_45530[(2)]);
var inst_45526 = cljs.core.async.close_BANG_(out);
var state_45530__$1 = (function (){var statearr_45549 = state_45530;
(statearr_45549[(9)] = inst_45524);

return statearr_45549;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45530__$1,inst_45526);
} else {
if((state_val_45531 === (2))){
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45530__$1,(4),ch);
} else {
if((state_val_45531 === (11))){
var inst_45507 = (state_45530[(8)]);
var inst_45516 = (state_45530[(2)]);
var inst_45504 = inst_45507;
var state_45530__$1 = (function (){var statearr_45553 = state_45530;
(statearr_45553[(10)] = inst_45516);

(statearr_45553[(7)] = inst_45504);

return statearr_45553;
})();
var statearr_45555_47821 = state_45530__$1;
(statearr_45555_47821[(2)] = null);

(statearr_45555_47821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (9))){
var inst_45507 = (state_45530[(8)]);
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45530__$1,(11),out,inst_45507);
} else {
if((state_val_45531 === (5))){
var inst_45507 = (state_45530[(8)]);
var inst_45504 = (state_45530[(7)]);
var inst_45511 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45507,inst_45504);
var state_45530__$1 = state_45530;
if(inst_45511){
var statearr_45557_47831 = state_45530__$1;
(statearr_45557_47831[(1)] = (8));

} else {
var statearr_45558_47832 = state_45530__$1;
(statearr_45558_47832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (10))){
var inst_45519 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45559_47841 = state_45530__$1;
(statearr_45559_47841[(2)] = inst_45519);

(statearr_45559_47841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (8))){
var inst_45504 = (state_45530[(7)]);
var tmp45556 = inst_45504;
var inst_45504__$1 = tmp45556;
var state_45530__$1 = (function (){var statearr_45561 = state_45530;
(statearr_45561[(7)] = inst_45504__$1);

return statearr_45561;
})();
var statearr_45562_47849 = state_45530__$1;
(statearr_45562_47849[(2)] = null);

(statearr_45562_47849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45566 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45566[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45566[(1)] = (1));

return statearr_45566;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45530){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45530);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45567){var ex__42028__auto__ = e45567;
var statearr_45568_47863 = state_45530;
(statearr_45568_47863[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45530[(4)]))){
var statearr_45569_47869 = state_45530;
(statearr_45569_47869[(1)] = cljs.core.first((state_45530[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47874 = state_45530;
state_45530 = G__47874;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45571 = f__42470__auto__();
(statearr_45571[(6)] = c__42469__auto___47797);

return statearr_45571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45584 = arguments.length;
switch (G__45584) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47901 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45636){
var state_val_45637 = (state_45636[(1)]);
if((state_val_45637 === (7))){
var inst_45632 = (state_45636[(2)]);
var state_45636__$1 = state_45636;
var statearr_45638_47903 = state_45636__$1;
(statearr_45638_47903[(2)] = inst_45632);

(statearr_45638_47903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (1))){
var inst_45590 = (new Array(n));
var inst_45591 = inst_45590;
var inst_45592 = (0);
var state_45636__$1 = (function (){var statearr_45641 = state_45636;
(statearr_45641[(7)] = inst_45591);

(statearr_45641[(8)] = inst_45592);

return statearr_45641;
})();
var statearr_45642_47911 = state_45636__$1;
(statearr_45642_47911[(2)] = null);

(statearr_45642_47911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (4))){
var inst_45595 = (state_45636[(9)]);
var inst_45595__$1 = (state_45636[(2)]);
var inst_45596 = (inst_45595__$1 == null);
var inst_45597 = cljs.core.not(inst_45596);
var state_45636__$1 = (function (){var statearr_45644 = state_45636;
(statearr_45644[(9)] = inst_45595__$1);

return statearr_45644;
})();
if(inst_45597){
var statearr_45645_47914 = state_45636__$1;
(statearr_45645_47914[(1)] = (5));

} else {
var statearr_45646_47915 = state_45636__$1;
(statearr_45646_47915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (15))){
var inst_45626 = (state_45636[(2)]);
var state_45636__$1 = state_45636;
var statearr_45651_47917 = state_45636__$1;
(statearr_45651_47917[(2)] = inst_45626);

(statearr_45651_47917[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (13))){
var state_45636__$1 = state_45636;
var statearr_45657_47918 = state_45636__$1;
(statearr_45657_47918[(2)] = null);

(statearr_45657_47918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (6))){
var inst_45592 = (state_45636[(8)]);
var inst_45613 = (inst_45592 > (0));
var state_45636__$1 = state_45636;
if(cljs.core.truth_(inst_45613)){
var statearr_45659_47923 = state_45636__$1;
(statearr_45659_47923[(1)] = (12));

} else {
var statearr_45660_47924 = state_45636__$1;
(statearr_45660_47924[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (3))){
var inst_45634 = (state_45636[(2)]);
var state_45636__$1 = state_45636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45636__$1,inst_45634);
} else {
if((state_val_45637 === (12))){
var inst_45591 = (state_45636[(7)]);
var inst_45624 = cljs.core.vec(inst_45591);
var state_45636__$1 = state_45636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45636__$1,(15),out,inst_45624);
} else {
if((state_val_45637 === (2))){
var state_45636__$1 = state_45636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45636__$1,(4),ch);
} else {
if((state_val_45637 === (11))){
var inst_45607 = (state_45636[(2)]);
var inst_45608 = (new Array(n));
var inst_45591 = inst_45608;
var inst_45592 = (0);
var state_45636__$1 = (function (){var statearr_45671 = state_45636;
(statearr_45671[(10)] = inst_45607);

(statearr_45671[(7)] = inst_45591);

(statearr_45671[(8)] = inst_45592);

return statearr_45671;
})();
var statearr_45672_47934 = state_45636__$1;
(statearr_45672_47934[(2)] = null);

(statearr_45672_47934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (9))){
var inst_45591 = (state_45636[(7)]);
var inst_45605 = cljs.core.vec(inst_45591);
var state_45636__$1 = state_45636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45636__$1,(11),out,inst_45605);
} else {
if((state_val_45637 === (5))){
var inst_45591 = (state_45636[(7)]);
var inst_45595 = (state_45636[(9)]);
var inst_45592 = (state_45636[(8)]);
var inst_45600 = (state_45636[(11)]);
var inst_45599 = (inst_45591[inst_45592] = inst_45595);
var inst_45600__$1 = (inst_45592 + (1));
var inst_45601 = (inst_45600__$1 < n);
var state_45636__$1 = (function (){var statearr_45676 = state_45636;
(statearr_45676[(12)] = inst_45599);

(statearr_45676[(11)] = inst_45600__$1);

return statearr_45676;
})();
if(cljs.core.truth_(inst_45601)){
var statearr_45678_47947 = state_45636__$1;
(statearr_45678_47947[(1)] = (8));

} else {
var statearr_45679_47948 = state_45636__$1;
(statearr_45679_47948[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (14))){
var inst_45629 = (state_45636[(2)]);
var inst_45630 = cljs.core.async.close_BANG_(out);
var state_45636__$1 = (function (){var statearr_45681 = state_45636;
(statearr_45681[(13)] = inst_45629);

return statearr_45681;
})();
var statearr_45682_47962 = state_45636__$1;
(statearr_45682_47962[(2)] = inst_45630);

(statearr_45682_47962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (10))){
var inst_45611 = (state_45636[(2)]);
var state_45636__$1 = state_45636;
var statearr_45685_47968 = state_45636__$1;
(statearr_45685_47968[(2)] = inst_45611);

(statearr_45685_47968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45637 === (8))){
var inst_45591 = (state_45636[(7)]);
var inst_45600 = (state_45636[(11)]);
var tmp45680 = inst_45591;
var inst_45591__$1 = tmp45680;
var inst_45592 = inst_45600;
var state_45636__$1 = (function (){var statearr_45686 = state_45636;
(statearr_45686[(7)] = inst_45591__$1);

(statearr_45686[(8)] = inst_45592);

return statearr_45686;
})();
var statearr_45689_47975 = state_45636__$1;
(statearr_45689_47975[(2)] = null);

(statearr_45689_47975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45690 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45690[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45690[(1)] = (1));

return statearr_45690;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45636){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45636);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45694){var ex__42028__auto__ = e45694;
var statearr_45699_47980 = state_45636;
(statearr_45699_47980[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45636[(4)]))){
var statearr_45704_47981 = state_45636;
(statearr_45704_47981[(1)] = cljs.core.first((state_45636[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47982 = state_45636;
state_45636 = G__47982;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45636){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45711 = f__42470__auto__();
(statearr_45711[(6)] = c__42469__auto___47901);

return statearr_45711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45721 = arguments.length;
switch (G__45721) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__42469__auto___47986 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_45789){
var state_val_45790 = (state_45789[(1)]);
if((state_val_45790 === (7))){
var inst_45785 = (state_45789[(2)]);
var state_45789__$1 = state_45789;
var statearr_45795_47988 = state_45789__$1;
(statearr_45795_47988[(2)] = inst_45785);

(statearr_45795_47988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (1))){
var inst_45732 = [];
var inst_45738 = inst_45732;
var inst_45739 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45789__$1 = (function (){var statearr_45796 = state_45789;
(statearr_45796[(7)] = inst_45739);

(statearr_45796[(8)] = inst_45738);

return statearr_45796;
})();
var statearr_45797_47990 = state_45789__$1;
(statearr_45797_47990[(2)] = null);

(statearr_45797_47990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (4))){
var inst_45743 = (state_45789[(9)]);
var inst_45743__$1 = (state_45789[(2)]);
var inst_45747 = (inst_45743__$1 == null);
var inst_45748 = cljs.core.not(inst_45747);
var state_45789__$1 = (function (){var statearr_45800 = state_45789;
(statearr_45800[(9)] = inst_45743__$1);

return statearr_45800;
})();
if(inst_45748){
var statearr_45801_47998 = state_45789__$1;
(statearr_45801_47998[(1)] = (5));

} else {
var statearr_45803_48000 = state_45789__$1;
(statearr_45803_48000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (15))){
var inst_45779 = (state_45789[(2)]);
var state_45789__$1 = state_45789;
var statearr_45805_48002 = state_45789__$1;
(statearr_45805_48002[(2)] = inst_45779);

(statearr_45805_48002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (13))){
var state_45789__$1 = state_45789;
var statearr_45806_48005 = state_45789__$1;
(statearr_45806_48005[(2)] = null);

(statearr_45806_48005[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (6))){
var inst_45738 = (state_45789[(8)]);
var inst_45774 = inst_45738.length;
var inst_45775 = (inst_45774 > (0));
var state_45789__$1 = state_45789;
if(cljs.core.truth_(inst_45775)){
var statearr_45807_48006 = state_45789__$1;
(statearr_45807_48006[(1)] = (12));

} else {
var statearr_45808_48007 = state_45789__$1;
(statearr_45808_48007[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (3))){
var inst_45787 = (state_45789[(2)]);
var state_45789__$1 = state_45789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45789__$1,inst_45787);
} else {
if((state_val_45790 === (12))){
var inst_45738 = (state_45789[(8)]);
var inst_45777 = cljs.core.vec(inst_45738);
var state_45789__$1 = state_45789;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45789__$1,(15),out,inst_45777);
} else {
if((state_val_45790 === (2))){
var state_45789__$1 = state_45789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45789__$1,(4),ch);
} else {
if((state_val_45790 === (11))){
var inst_45743 = (state_45789[(9)]);
var inst_45750 = (state_45789[(10)]);
var inst_45763 = (state_45789[(2)]);
var inst_45764 = [];
var inst_45765 = inst_45764.push(inst_45743);
var inst_45738 = inst_45764;
var inst_45739 = inst_45750;
var state_45789__$1 = (function (){var statearr_45815 = state_45789;
(statearr_45815[(11)] = inst_45763);

(statearr_45815[(7)] = inst_45739);

(statearr_45815[(8)] = inst_45738);

(statearr_45815[(12)] = inst_45765);

return statearr_45815;
})();
var statearr_45817_48013 = state_45789__$1;
(statearr_45817_48013[(2)] = null);

(statearr_45817_48013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (9))){
var inst_45738 = (state_45789[(8)]);
var inst_45761 = cljs.core.vec(inst_45738);
var state_45789__$1 = state_45789;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45789__$1,(11),out,inst_45761);
} else {
if((state_val_45790 === (5))){
var inst_45739 = (state_45789[(7)]);
var inst_45743 = (state_45789[(9)]);
var inst_45750 = (state_45789[(10)]);
var inst_45750__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45743) : f.call(null,inst_45743));
var inst_45751 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45750__$1,inst_45739);
var inst_45752 = cljs.core.keyword_identical_QMARK_(inst_45739,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45753 = ((inst_45751) || (inst_45752));
var state_45789__$1 = (function (){var statearr_45830 = state_45789;
(statearr_45830[(10)] = inst_45750__$1);

return statearr_45830;
})();
if(cljs.core.truth_(inst_45753)){
var statearr_45831_48018 = state_45789__$1;
(statearr_45831_48018[(1)] = (8));

} else {
var statearr_45834_48019 = state_45789__$1;
(statearr_45834_48019[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (14))){
var inst_45782 = (state_45789[(2)]);
var inst_45783 = cljs.core.async.close_BANG_(out);
var state_45789__$1 = (function (){var statearr_45837 = state_45789;
(statearr_45837[(13)] = inst_45782);

return statearr_45837;
})();
var statearr_45842_48020 = state_45789__$1;
(statearr_45842_48020[(2)] = inst_45783);

(statearr_45842_48020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (10))){
var inst_45768 = (state_45789[(2)]);
var state_45789__$1 = state_45789;
var statearr_45845_48021 = state_45789__$1;
(statearr_45845_48021[(2)] = inst_45768);

(statearr_45845_48021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45790 === (8))){
var inst_45738 = (state_45789[(8)]);
var inst_45743 = (state_45789[(9)]);
var inst_45750 = (state_45789[(10)]);
var inst_45755 = inst_45738.push(inst_45743);
var tmp45836 = inst_45738;
var inst_45738__$1 = tmp45836;
var inst_45739 = inst_45750;
var state_45789__$1 = (function (){var statearr_45846 = state_45789;
(statearr_45846[(7)] = inst_45739);

(statearr_45846[(8)] = inst_45738__$1);

(statearr_45846[(14)] = inst_45755);

return statearr_45846;
})();
var statearr_45847_48025 = state_45789__$1;
(statearr_45847_48025[(2)] = null);

(statearr_45847_48025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42025__auto__ = null;
var cljs$core$async$state_machine__42025__auto____0 = (function (){
var statearr_45848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45848[(0)] = cljs$core$async$state_machine__42025__auto__);

(statearr_45848[(1)] = (1));

return statearr_45848;
});
var cljs$core$async$state_machine__42025__auto____1 = (function (state_45789){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_45789);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e45850){var ex__42028__auto__ = e45850;
var statearr_45851_48027 = state_45789;
(statearr_45851_48027[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_45789[(4)]))){
var statearr_45852_48028 = state_45789;
(statearr_45852_48028[(1)] = cljs.core.first((state_45789[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48033 = state_45789;
state_45789 = G__48033;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
cljs$core$async$state_machine__42025__auto__ = function(state_45789){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42025__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42025__auto____1.call(this,state_45789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42025__auto____0;
cljs$core$async$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42025__auto____1;
return cljs$core$async$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_45855 = f__42470__auto__();
(statearr_45855[(6)] = c__42469__auto___47986);

return statearr_45855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
