goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49698 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49698(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49702 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49702(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47947 = coll;
var G__47948 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47947,G__47948) : shadow.dom.lazy_native_coll_seq.call(null,G__47947,G__47948));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__47984 = arguments.length;
switch (G__47984) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__48000 = arguments.length;
switch (G__48000) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__48034 = arguments.length;
switch (G__48034) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__48057 = arguments.length;
switch (G__48057) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__48087 = arguments.length;
switch (G__48087) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__48104 = arguments.length;
switch (G__48104) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48130){if((e48130 instanceof Object)){
var e = e48130;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48130;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48163 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48164 = null;
var count__48165 = (0);
var i__48166 = (0);
while(true){
if((i__48166 < count__48165)){
var el = chunk__48164.cljs$core$IIndexed$_nth$arity$2(null,i__48166);
var handler_49743__$1 = ((function (seq__48163,chunk__48164,count__48165,i__48166,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48163,chunk__48164,count__48165,i__48166,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49743__$1);


var G__49748 = seq__48163;
var G__49749 = chunk__48164;
var G__49750 = count__48165;
var G__49751 = (i__48166 + (1));
seq__48163 = G__49748;
chunk__48164 = G__49749;
count__48165 = G__49750;
i__48166 = G__49751;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48163);
if(temp__5754__auto__){
var seq__48163__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48163__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48163__$1);
var G__49753 = cljs.core.chunk_rest(seq__48163__$1);
var G__49754 = c__4556__auto__;
var G__49755 = cljs.core.count(c__4556__auto__);
var G__49756 = (0);
seq__48163 = G__49753;
chunk__48164 = G__49754;
count__48165 = G__49755;
i__48166 = G__49756;
continue;
} else {
var el = cljs.core.first(seq__48163__$1);
var handler_49757__$1 = ((function (seq__48163,chunk__48164,count__48165,i__48166,el,seq__48163__$1,temp__5754__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48163,chunk__48164,count__48165,i__48166,el,seq__48163__$1,temp__5754__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49757__$1);


var G__49759 = cljs.core.next(seq__48163__$1);
var G__49760 = null;
var G__49761 = (0);
var G__49762 = (0);
seq__48163 = G__49759;
chunk__48164 = G__49760;
count__48165 = G__49761;
i__48166 = G__49762;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48217 = arguments.length;
switch (G__48217) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48245 = cljs.core.seq(events);
var chunk__48246 = null;
var count__48247 = (0);
var i__48248 = (0);
while(true){
if((i__48248 < count__48247)){
var vec__48282 = chunk__48246.cljs$core$IIndexed$_nth$arity$2(null,i__48248);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48282,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48282,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49770 = seq__48245;
var G__49771 = chunk__48246;
var G__49772 = count__48247;
var G__49773 = (i__48248 + (1));
seq__48245 = G__49770;
chunk__48246 = G__49771;
count__48247 = G__49772;
i__48248 = G__49773;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48245);
if(temp__5754__auto__){
var seq__48245__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48245__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48245__$1);
var G__49776 = cljs.core.chunk_rest(seq__48245__$1);
var G__49777 = c__4556__auto__;
var G__49778 = cljs.core.count(c__4556__auto__);
var G__49779 = (0);
seq__48245 = G__49776;
chunk__48246 = G__49777;
count__48247 = G__49778;
i__48248 = G__49779;
continue;
} else {
var vec__48288 = cljs.core.first(seq__48245__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48288,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48288,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49782 = cljs.core.next(seq__48245__$1);
var G__49783 = null;
var G__49784 = (0);
var G__49785 = (0);
seq__48245 = G__49782;
chunk__48246 = G__49783;
count__48247 = G__49784;
i__48248 = G__49785;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__48300 = cljs.core.seq(styles);
var chunk__48301 = null;
var count__48302 = (0);
var i__48303 = (0);
while(true){
if((i__48303 < count__48302)){
var vec__48327 = chunk__48301.cljs$core$IIndexed$_nth$arity$2(null,i__48303);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48327,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48327,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49791 = seq__48300;
var G__49792 = chunk__48301;
var G__49793 = count__48302;
var G__49794 = (i__48303 + (1));
seq__48300 = G__49791;
chunk__48301 = G__49792;
count__48302 = G__49793;
i__48303 = G__49794;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48300);
if(temp__5754__auto__){
var seq__48300__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48300__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48300__$1);
var G__49796 = cljs.core.chunk_rest(seq__48300__$1);
var G__49797 = c__4556__auto__;
var G__49798 = cljs.core.count(c__4556__auto__);
var G__49799 = (0);
seq__48300 = G__49796;
chunk__48301 = G__49797;
count__48302 = G__49798;
i__48303 = G__49799;
continue;
} else {
var vec__48346 = cljs.core.first(seq__48300__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48346,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48346,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49802 = cljs.core.next(seq__48300__$1);
var G__49803 = null;
var G__49804 = (0);
var G__49805 = (0);
seq__48300 = G__49802;
chunk__48301 = G__49803;
count__48302 = G__49804;
i__48303 = G__49805;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__48355_49806 = key;
var G__48355_49807__$1 = (((G__48355_49806 instanceof cljs.core.Keyword))?G__48355_49806.fqn:null);
switch (G__48355_49807__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49818 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_49818,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_49818,"aria-");
}
})())){
el.setAttribute(ks_49818,value);
} else {
(el[ks_49818] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__48453){
var map__48454 = p__48453;
var map__48454__$1 = (((((!((map__48454 == null))))?(((((map__48454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__48454):map__48454);
var props = map__48454__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48454__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__48462 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48462,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48462,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48462,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__48471 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__48471,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__48471;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__48474 = arguments.length;
switch (G__48474) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__48480){
var vec__48481 = p__48480;
var seq__48482 = cljs.core.seq(vec__48481);
var first__48483 = cljs.core.first(seq__48482);
var seq__48482__$1 = cljs.core.next(seq__48482);
var nn = first__48483;
var first__48483__$1 = cljs.core.first(seq__48482__$1);
var seq__48482__$2 = cljs.core.next(seq__48482__$1);
var np = first__48483__$1;
var nc = seq__48482__$2;
var node = vec__48481;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48494 = nn;
var G__48495 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48494,G__48495) : create_fn.call(null,G__48494,G__48495));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48500 = nn;
var G__48501 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48500,G__48501) : create_fn.call(null,G__48500,G__48501));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__48506 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48506,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48506,(1),null);
var seq__48509_49856 = cljs.core.seq(node_children);
var chunk__48510_49857 = null;
var count__48511_49858 = (0);
var i__48512_49859 = (0);
while(true){
if((i__48512_49859 < count__48511_49858)){
var child_struct_49861 = chunk__48510_49857.cljs$core$IIndexed$_nth$arity$2(null,i__48512_49859);
var children_49862 = shadow.dom.dom_node(child_struct_49861);
if(cljs.core.seq_QMARK_(children_49862)){
var seq__48566_49864 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49862));
var chunk__48568_49865 = null;
var count__48569_49866 = (0);
var i__48570_49867 = (0);
while(true){
if((i__48570_49867 < count__48569_49866)){
var child_49869 = chunk__48568_49865.cljs$core$IIndexed$_nth$arity$2(null,i__48570_49867);
if(cljs.core.truth_(child_49869)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49869);


var G__49870 = seq__48566_49864;
var G__49871 = chunk__48568_49865;
var G__49872 = count__48569_49866;
var G__49873 = (i__48570_49867 + (1));
seq__48566_49864 = G__49870;
chunk__48568_49865 = G__49871;
count__48569_49866 = G__49872;
i__48570_49867 = G__49873;
continue;
} else {
var G__49875 = seq__48566_49864;
var G__49877 = chunk__48568_49865;
var G__49878 = count__48569_49866;
var G__49879 = (i__48570_49867 + (1));
seq__48566_49864 = G__49875;
chunk__48568_49865 = G__49877;
count__48569_49866 = G__49878;
i__48570_49867 = G__49879;
continue;
}
} else {
var temp__5754__auto___49881 = cljs.core.seq(seq__48566_49864);
if(temp__5754__auto___49881){
var seq__48566_49882__$1 = temp__5754__auto___49881;
if(cljs.core.chunked_seq_QMARK_(seq__48566_49882__$1)){
var c__4556__auto___49883 = cljs.core.chunk_first(seq__48566_49882__$1);
var G__49887 = cljs.core.chunk_rest(seq__48566_49882__$1);
var G__49888 = c__4556__auto___49883;
var G__49889 = cljs.core.count(c__4556__auto___49883);
var G__49890 = (0);
seq__48566_49864 = G__49887;
chunk__48568_49865 = G__49888;
count__48569_49866 = G__49889;
i__48570_49867 = G__49890;
continue;
} else {
var child_49892 = cljs.core.first(seq__48566_49882__$1);
if(cljs.core.truth_(child_49892)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49892);


var G__49895 = cljs.core.next(seq__48566_49882__$1);
var G__49896 = null;
var G__49897 = (0);
var G__49898 = (0);
seq__48566_49864 = G__49895;
chunk__48568_49865 = G__49896;
count__48569_49866 = G__49897;
i__48570_49867 = G__49898;
continue;
} else {
var G__49902 = cljs.core.next(seq__48566_49882__$1);
var G__49903 = null;
var G__49904 = (0);
var G__49905 = (0);
seq__48566_49864 = G__49902;
chunk__48568_49865 = G__49903;
count__48569_49866 = G__49904;
i__48570_49867 = G__49905;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49862);
}


var G__49907 = seq__48509_49856;
var G__49908 = chunk__48510_49857;
var G__49909 = count__48511_49858;
var G__49910 = (i__48512_49859 + (1));
seq__48509_49856 = G__49907;
chunk__48510_49857 = G__49908;
count__48511_49858 = G__49909;
i__48512_49859 = G__49910;
continue;
} else {
var temp__5754__auto___49911 = cljs.core.seq(seq__48509_49856);
if(temp__5754__auto___49911){
var seq__48509_49912__$1 = temp__5754__auto___49911;
if(cljs.core.chunked_seq_QMARK_(seq__48509_49912__$1)){
var c__4556__auto___49914 = cljs.core.chunk_first(seq__48509_49912__$1);
var G__49916 = cljs.core.chunk_rest(seq__48509_49912__$1);
var G__49917 = c__4556__auto___49914;
var G__49918 = cljs.core.count(c__4556__auto___49914);
var G__49919 = (0);
seq__48509_49856 = G__49916;
chunk__48510_49857 = G__49917;
count__48511_49858 = G__49918;
i__48512_49859 = G__49919;
continue;
} else {
var child_struct_49924 = cljs.core.first(seq__48509_49912__$1);
var children_49926 = shadow.dom.dom_node(child_struct_49924);
if(cljs.core.seq_QMARK_(children_49926)){
var seq__48590_49927 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49926));
var chunk__48592_49928 = null;
var count__48593_49929 = (0);
var i__48594_49930 = (0);
while(true){
if((i__48594_49930 < count__48593_49929)){
var child_49935 = chunk__48592_49928.cljs$core$IIndexed$_nth$arity$2(null,i__48594_49930);
if(cljs.core.truth_(child_49935)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49935);


var G__49936 = seq__48590_49927;
var G__49937 = chunk__48592_49928;
var G__49938 = count__48593_49929;
var G__49939 = (i__48594_49930 + (1));
seq__48590_49927 = G__49936;
chunk__48592_49928 = G__49937;
count__48593_49929 = G__49938;
i__48594_49930 = G__49939;
continue;
} else {
var G__49945 = seq__48590_49927;
var G__49946 = chunk__48592_49928;
var G__49947 = count__48593_49929;
var G__49948 = (i__48594_49930 + (1));
seq__48590_49927 = G__49945;
chunk__48592_49928 = G__49946;
count__48593_49929 = G__49947;
i__48594_49930 = G__49948;
continue;
}
} else {
var temp__5754__auto___49949__$1 = cljs.core.seq(seq__48590_49927);
if(temp__5754__auto___49949__$1){
var seq__48590_49950__$1 = temp__5754__auto___49949__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48590_49950__$1)){
var c__4556__auto___49951 = cljs.core.chunk_first(seq__48590_49950__$1);
var G__49952 = cljs.core.chunk_rest(seq__48590_49950__$1);
var G__49953 = c__4556__auto___49951;
var G__49954 = cljs.core.count(c__4556__auto___49951);
var G__49955 = (0);
seq__48590_49927 = G__49952;
chunk__48592_49928 = G__49953;
count__48593_49929 = G__49954;
i__48594_49930 = G__49955;
continue;
} else {
var child_49959 = cljs.core.first(seq__48590_49950__$1);
if(cljs.core.truth_(child_49959)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49959);


var G__49960 = cljs.core.next(seq__48590_49950__$1);
var G__49961 = null;
var G__49962 = (0);
var G__49963 = (0);
seq__48590_49927 = G__49960;
chunk__48592_49928 = G__49961;
count__48593_49929 = G__49962;
i__48594_49930 = G__49963;
continue;
} else {
var G__49964 = cljs.core.next(seq__48590_49950__$1);
var G__49965 = null;
var G__49966 = (0);
var G__49967 = (0);
seq__48590_49927 = G__49964;
chunk__48592_49928 = G__49965;
count__48593_49929 = G__49966;
i__48594_49930 = G__49967;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49926);
}


var G__49968 = cljs.core.next(seq__48509_49912__$1);
var G__49969 = null;
var G__49970 = (0);
var G__49971 = (0);
seq__48509_49856 = G__49968;
chunk__48510_49857 = G__49969;
count__48511_49858 = G__49970;
i__48512_49859 = G__49971;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48643 = cljs.core.seq(node);
var chunk__48644 = null;
var count__48645 = (0);
var i__48646 = (0);
while(true){
if((i__48646 < count__48645)){
var n = chunk__48644.cljs$core$IIndexed$_nth$arity$2(null,i__48646);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49981 = seq__48643;
var G__49982 = chunk__48644;
var G__49983 = count__48645;
var G__49984 = (i__48646 + (1));
seq__48643 = G__49981;
chunk__48644 = G__49982;
count__48645 = G__49983;
i__48646 = G__49984;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48643);
if(temp__5754__auto__){
var seq__48643__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48643__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48643__$1);
var G__49985 = cljs.core.chunk_rest(seq__48643__$1);
var G__49986 = c__4556__auto__;
var G__49987 = cljs.core.count(c__4556__auto__);
var G__49988 = (0);
seq__48643 = G__49985;
chunk__48644 = G__49986;
count__48645 = G__49987;
i__48646 = G__49988;
continue;
} else {
var n = cljs.core.first(seq__48643__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49993 = cljs.core.next(seq__48643__$1);
var G__49994 = null;
var G__49995 = (0);
var G__49996 = (0);
seq__48643 = G__49993;
chunk__48644 = G__49994;
count__48645 = G__49995;
i__48646 = G__49996;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__48663 = arguments.length;
switch (G__48663) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__48676 = arguments.length;
switch (G__48676) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__48697 = arguments.length;
switch (G__48697) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50004 = arguments.length;
var i__4737__auto___50005 = (0);
while(true){
if((i__4737__auto___50005 < len__4736__auto___50004)){
args__4742__auto__.push((arguments[i__4737__auto___50005]));

var G__50006 = (i__4737__auto___50005 + (1));
i__4737__auto___50005 = G__50006;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__48729_50011 = cljs.core.seq(nodes);
var chunk__48730_50012 = null;
var count__48731_50013 = (0);
var i__48732_50014 = (0);
while(true){
if((i__48732_50014 < count__48731_50013)){
var node_50015 = chunk__48730_50012.cljs$core$IIndexed$_nth$arity$2(null,i__48732_50014);
fragment.appendChild(shadow.dom._to_dom(node_50015));


var G__50016 = seq__48729_50011;
var G__50017 = chunk__48730_50012;
var G__50018 = count__48731_50013;
var G__50019 = (i__48732_50014 + (1));
seq__48729_50011 = G__50016;
chunk__48730_50012 = G__50017;
count__48731_50013 = G__50018;
i__48732_50014 = G__50019;
continue;
} else {
var temp__5754__auto___50020 = cljs.core.seq(seq__48729_50011);
if(temp__5754__auto___50020){
var seq__48729_50021__$1 = temp__5754__auto___50020;
if(cljs.core.chunked_seq_QMARK_(seq__48729_50021__$1)){
var c__4556__auto___50022 = cljs.core.chunk_first(seq__48729_50021__$1);
var G__50023 = cljs.core.chunk_rest(seq__48729_50021__$1);
var G__50024 = c__4556__auto___50022;
var G__50025 = cljs.core.count(c__4556__auto___50022);
var G__50026 = (0);
seq__48729_50011 = G__50023;
chunk__48730_50012 = G__50024;
count__48731_50013 = G__50025;
i__48732_50014 = G__50026;
continue;
} else {
var node_50027 = cljs.core.first(seq__48729_50021__$1);
fragment.appendChild(shadow.dom._to_dom(node_50027));


var G__50028 = cljs.core.next(seq__48729_50021__$1);
var G__50029 = null;
var G__50030 = (0);
var G__50031 = (0);
seq__48729_50011 = G__50028;
chunk__48730_50012 = G__50029;
count__48731_50013 = G__50030;
i__48732_50014 = G__50031;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq48724){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48724));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__48745_50032 = cljs.core.seq(scripts);
var chunk__48746_50033 = null;
var count__48747_50034 = (0);
var i__48748_50035 = (0);
while(true){
if((i__48748_50035 < count__48747_50034)){
var vec__48765_50036 = chunk__48746_50033.cljs$core$IIndexed$_nth$arity$2(null,i__48748_50035);
var script_tag_50037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48765_50036,(0),null);
var script_body_50038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48765_50036,(1),null);
eval(script_body_50038);


var G__50039 = seq__48745_50032;
var G__50040 = chunk__48746_50033;
var G__50041 = count__48747_50034;
var G__50042 = (i__48748_50035 + (1));
seq__48745_50032 = G__50039;
chunk__48746_50033 = G__50040;
count__48747_50034 = G__50041;
i__48748_50035 = G__50042;
continue;
} else {
var temp__5754__auto___50043 = cljs.core.seq(seq__48745_50032);
if(temp__5754__auto___50043){
var seq__48745_50044__$1 = temp__5754__auto___50043;
if(cljs.core.chunked_seq_QMARK_(seq__48745_50044__$1)){
var c__4556__auto___50045 = cljs.core.chunk_first(seq__48745_50044__$1);
var G__50046 = cljs.core.chunk_rest(seq__48745_50044__$1);
var G__50047 = c__4556__auto___50045;
var G__50048 = cljs.core.count(c__4556__auto___50045);
var G__50049 = (0);
seq__48745_50032 = G__50046;
chunk__48746_50033 = G__50047;
count__48747_50034 = G__50048;
i__48748_50035 = G__50049;
continue;
} else {
var vec__48777_50052 = cljs.core.first(seq__48745_50044__$1);
var script_tag_50053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48777_50052,(0),null);
var script_body_50054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48777_50052,(1),null);
eval(script_body_50054);


var G__50058 = cljs.core.next(seq__48745_50044__$1);
var G__50059 = null;
var G__50060 = (0);
var G__50061 = (0);
seq__48745_50032 = G__50058;
chunk__48746_50033 = G__50059;
count__48747_50034 = G__50060;
i__48748_50035 = G__50061;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__48797){
var vec__48799 = p__48797;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__48868 = arguments.length;
switch (G__48868) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__48953 = cljs.core.seq(style_keys);
var chunk__48954 = null;
var count__48955 = (0);
var i__48956 = (0);
while(true){
if((i__48956 < count__48955)){
var it = chunk__48954.cljs$core$IIndexed$_nth$arity$2(null,i__48956);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50081 = seq__48953;
var G__50082 = chunk__48954;
var G__50083 = count__48955;
var G__50084 = (i__48956 + (1));
seq__48953 = G__50081;
chunk__48954 = G__50082;
count__48955 = G__50083;
i__48956 = G__50084;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__48953);
if(temp__5754__auto__){
var seq__48953__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48953__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48953__$1);
var G__50085 = cljs.core.chunk_rest(seq__48953__$1);
var G__50086 = c__4556__auto__;
var G__50087 = cljs.core.count(c__4556__auto__);
var G__50088 = (0);
seq__48953 = G__50085;
chunk__48954 = G__50086;
count__48955 = G__50087;
i__48956 = G__50088;
continue;
} else {
var it = cljs.core.first(seq__48953__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50089 = cljs.core.next(seq__48953__$1);
var G__50090 = null;
var G__50091 = (0);
var G__50092 = (0);
seq__48953 = G__50089;
chunk__48954 = G__50090;
count__48955 = G__50091;
i__48956 = G__50092;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k48966,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__48985 = k48966;
var G__48985__$1 = (((G__48985 instanceof cljs.core.Keyword))?G__48985.fqn:null);
switch (G__48985__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48966,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49001){
var vec__49007 = p__49001;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49007,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49007,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48965){
var self__ = this;
var G__48965__$1 = this;
return (new cljs.core.RecordIter((0),G__48965__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48968,other48969){
var self__ = this;
var this48968__$1 = this;
return (((!((other48969 == null)))) && ((this48968__$1.constructor === other48969.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48968__$1.x,other48969.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48968__$1.y,other48969.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48968__$1.__extmap,other48969.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__48965){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49059 = cljs.core.keyword_identical_QMARK_;
var expr__49060 = k__4388__auto__;
if(cljs.core.truth_((pred__49059.cljs$core$IFn$_invoke$arity$2 ? pred__49059.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49060) : pred__49059.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49060)))){
return (new shadow.dom.Coordinate(G__48965,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49059.cljs$core$IFn$_invoke$arity$2 ? pred__49059.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49060) : pred__49059.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49060)))){
return (new shadow.dom.Coordinate(self__.x,G__48965,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__48965),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__48965){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__48965,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__48974){
var extmap__4419__auto__ = (function (){var G__49103 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48974,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__48974)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49103);
} else {
return G__49103;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__48974),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__48974),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k49159,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__49179 = k49159;
var G__49179__$1 = (((G__49179 instanceof cljs.core.Keyword))?G__49179.fqn:null);
switch (G__49179__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49159,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49191){
var vec__49193 = p__49191;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49193,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49193,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49158){
var self__ = this;
var G__49158__$1 = this;
return (new cljs.core.RecordIter((0),G__49158__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49160,other49161){
var self__ = this;
var this49160__$1 = this;
return (((!((other49161 == null)))) && ((this49160__$1.constructor === other49161.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49160__$1.w,other49161.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49160__$1.h,other49161.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49160__$1.__extmap,other49161.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__49158){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49227 = cljs.core.keyword_identical_QMARK_;
var expr__49228 = k__4388__auto__;
if(cljs.core.truth_((pred__49227.cljs$core$IFn$_invoke$arity$2 ? pred__49227.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49228) : pred__49227.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49228)))){
return (new shadow.dom.Size(G__49158,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49227.cljs$core$IFn$_invoke$arity$2 ? pred__49227.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49228) : pred__49227.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49228)))){
return (new shadow.dom.Size(self__.w,G__49158,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__49158),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__49158){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49158,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49164){
var extmap__4419__auto__ = (function (){var G__49248 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49164,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49164)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49248);
} else {
return G__49248;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49164),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49164),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__50132 = (i + (1));
var G__50133 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50132;
ret = G__50133;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49299){
var vec__49304 = p__49299;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49304,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49304,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49321 = arguments.length;
switch (G__49321) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5752__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5752__auto__)){
var child = temp__5752__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50140 = ps;
var G__50141 = (i + (1));
el__$1 = G__50140;
i = G__50141;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49362 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49362,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49362,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49362,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49365_50147 = cljs.core.seq(props);
var chunk__49366_50148 = null;
var count__49367_50149 = (0);
var i__49368_50150 = (0);
while(true){
if((i__49368_50150 < count__49367_50149)){
var vec__49385_50153 = chunk__49366_50148.cljs$core$IIndexed$_nth$arity$2(null,i__49368_50150);
var k_50154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49385_50153,(0),null);
var v_50155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49385_50153,(1),null);
el.setAttributeNS((function (){var temp__5754__auto__ = cljs.core.namespace(k_50154);
if(cljs.core.truth_(temp__5754__auto__)){
var ns = temp__5754__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50154),v_50155);


var G__50157 = seq__49365_50147;
var G__50158 = chunk__49366_50148;
var G__50159 = count__49367_50149;
var G__50160 = (i__49368_50150 + (1));
seq__49365_50147 = G__50157;
chunk__49366_50148 = G__50158;
count__49367_50149 = G__50159;
i__49368_50150 = G__50160;
continue;
} else {
var temp__5754__auto___50165 = cljs.core.seq(seq__49365_50147);
if(temp__5754__auto___50165){
var seq__49365_50166__$1 = temp__5754__auto___50165;
if(cljs.core.chunked_seq_QMARK_(seq__49365_50166__$1)){
var c__4556__auto___50167 = cljs.core.chunk_first(seq__49365_50166__$1);
var G__50168 = cljs.core.chunk_rest(seq__49365_50166__$1);
var G__50169 = c__4556__auto___50167;
var G__50170 = cljs.core.count(c__4556__auto___50167);
var G__50171 = (0);
seq__49365_50147 = G__50168;
chunk__49366_50148 = G__50169;
count__49367_50149 = G__50170;
i__49368_50150 = G__50171;
continue;
} else {
var vec__49388_50172 = cljs.core.first(seq__49365_50166__$1);
var k_50173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49388_50172,(0),null);
var v_50174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49388_50172,(1),null);
el.setAttributeNS((function (){var temp__5754__auto____$1 = cljs.core.namespace(k_50173);
if(cljs.core.truth_(temp__5754__auto____$1)){
var ns = temp__5754__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50173),v_50174);


var G__50175 = cljs.core.next(seq__49365_50166__$1);
var G__50176 = null;
var G__50177 = (0);
var G__50178 = (0);
seq__49365_50147 = G__50175;
chunk__49366_50148 = G__50176;
count__49367_50149 = G__50177;
i__49368_50150 = G__50178;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49404 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49404,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49404,(1),null);
var seq__49411_50180 = cljs.core.seq(node_children);
var chunk__49413_50181 = null;
var count__49414_50182 = (0);
var i__49415_50183 = (0);
while(true){
if((i__49415_50183 < count__49414_50182)){
var child_struct_50185 = chunk__49413_50181.cljs$core$IIndexed$_nth$arity$2(null,i__49415_50183);
if((!((child_struct_50185 == null)))){
if(typeof child_struct_50185 === 'string'){
var text_50186 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50186),child_struct_50185].join(''));
} else {
var children_50187 = shadow.dom.svg_node(child_struct_50185);
if(cljs.core.seq_QMARK_(children_50187)){
var seq__49480_50188 = cljs.core.seq(children_50187);
var chunk__49482_50189 = null;
var count__49483_50190 = (0);
var i__49484_50191 = (0);
while(true){
if((i__49484_50191 < count__49483_50190)){
var child_50192 = chunk__49482_50189.cljs$core$IIndexed$_nth$arity$2(null,i__49484_50191);
if(cljs.core.truth_(child_50192)){
node.appendChild(child_50192);


var G__50193 = seq__49480_50188;
var G__50194 = chunk__49482_50189;
var G__50195 = count__49483_50190;
var G__50196 = (i__49484_50191 + (1));
seq__49480_50188 = G__50193;
chunk__49482_50189 = G__50194;
count__49483_50190 = G__50195;
i__49484_50191 = G__50196;
continue;
} else {
var G__50197 = seq__49480_50188;
var G__50198 = chunk__49482_50189;
var G__50199 = count__49483_50190;
var G__50200 = (i__49484_50191 + (1));
seq__49480_50188 = G__50197;
chunk__49482_50189 = G__50198;
count__49483_50190 = G__50199;
i__49484_50191 = G__50200;
continue;
}
} else {
var temp__5754__auto___50201 = cljs.core.seq(seq__49480_50188);
if(temp__5754__auto___50201){
var seq__49480_50202__$1 = temp__5754__auto___50201;
if(cljs.core.chunked_seq_QMARK_(seq__49480_50202__$1)){
var c__4556__auto___50203 = cljs.core.chunk_first(seq__49480_50202__$1);
var G__50206 = cljs.core.chunk_rest(seq__49480_50202__$1);
var G__50207 = c__4556__auto___50203;
var G__50208 = cljs.core.count(c__4556__auto___50203);
var G__50209 = (0);
seq__49480_50188 = G__50206;
chunk__49482_50189 = G__50207;
count__49483_50190 = G__50208;
i__49484_50191 = G__50209;
continue;
} else {
var child_50212 = cljs.core.first(seq__49480_50202__$1);
if(cljs.core.truth_(child_50212)){
node.appendChild(child_50212);


var G__50214 = cljs.core.next(seq__49480_50202__$1);
var G__50215 = null;
var G__50216 = (0);
var G__50217 = (0);
seq__49480_50188 = G__50214;
chunk__49482_50189 = G__50215;
count__49483_50190 = G__50216;
i__49484_50191 = G__50217;
continue;
} else {
var G__50218 = cljs.core.next(seq__49480_50202__$1);
var G__50219 = null;
var G__50220 = (0);
var G__50221 = (0);
seq__49480_50188 = G__50218;
chunk__49482_50189 = G__50219;
count__49483_50190 = G__50220;
i__49484_50191 = G__50221;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50187);
}
}


var G__50222 = seq__49411_50180;
var G__50223 = chunk__49413_50181;
var G__50224 = count__49414_50182;
var G__50225 = (i__49415_50183 + (1));
seq__49411_50180 = G__50222;
chunk__49413_50181 = G__50223;
count__49414_50182 = G__50224;
i__49415_50183 = G__50225;
continue;
} else {
var G__50226 = seq__49411_50180;
var G__50227 = chunk__49413_50181;
var G__50228 = count__49414_50182;
var G__50229 = (i__49415_50183 + (1));
seq__49411_50180 = G__50226;
chunk__49413_50181 = G__50227;
count__49414_50182 = G__50228;
i__49415_50183 = G__50229;
continue;
}
} else {
var temp__5754__auto___50231 = cljs.core.seq(seq__49411_50180);
if(temp__5754__auto___50231){
var seq__49411_50232__$1 = temp__5754__auto___50231;
if(cljs.core.chunked_seq_QMARK_(seq__49411_50232__$1)){
var c__4556__auto___50233 = cljs.core.chunk_first(seq__49411_50232__$1);
var G__50234 = cljs.core.chunk_rest(seq__49411_50232__$1);
var G__50235 = c__4556__auto___50233;
var G__50236 = cljs.core.count(c__4556__auto___50233);
var G__50237 = (0);
seq__49411_50180 = G__50234;
chunk__49413_50181 = G__50235;
count__49414_50182 = G__50236;
i__49415_50183 = G__50237;
continue;
} else {
var child_struct_50238 = cljs.core.first(seq__49411_50232__$1);
if((!((child_struct_50238 == null)))){
if(typeof child_struct_50238 === 'string'){
var text_50239 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50239),child_struct_50238].join(''));
} else {
var children_50240 = shadow.dom.svg_node(child_struct_50238);
if(cljs.core.seq_QMARK_(children_50240)){
var seq__49504_50241 = cljs.core.seq(children_50240);
var chunk__49506_50242 = null;
var count__49507_50243 = (0);
var i__49508_50244 = (0);
while(true){
if((i__49508_50244 < count__49507_50243)){
var child_50250 = chunk__49506_50242.cljs$core$IIndexed$_nth$arity$2(null,i__49508_50244);
if(cljs.core.truth_(child_50250)){
node.appendChild(child_50250);


var G__50251 = seq__49504_50241;
var G__50252 = chunk__49506_50242;
var G__50253 = count__49507_50243;
var G__50254 = (i__49508_50244 + (1));
seq__49504_50241 = G__50251;
chunk__49506_50242 = G__50252;
count__49507_50243 = G__50253;
i__49508_50244 = G__50254;
continue;
} else {
var G__50255 = seq__49504_50241;
var G__50256 = chunk__49506_50242;
var G__50257 = count__49507_50243;
var G__50258 = (i__49508_50244 + (1));
seq__49504_50241 = G__50255;
chunk__49506_50242 = G__50256;
count__49507_50243 = G__50257;
i__49508_50244 = G__50258;
continue;
}
} else {
var temp__5754__auto___50261__$1 = cljs.core.seq(seq__49504_50241);
if(temp__5754__auto___50261__$1){
var seq__49504_50262__$1 = temp__5754__auto___50261__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49504_50262__$1)){
var c__4556__auto___50264 = cljs.core.chunk_first(seq__49504_50262__$1);
var G__50267 = cljs.core.chunk_rest(seq__49504_50262__$1);
var G__50268 = c__4556__auto___50264;
var G__50269 = cljs.core.count(c__4556__auto___50264);
var G__50270 = (0);
seq__49504_50241 = G__50267;
chunk__49506_50242 = G__50268;
count__49507_50243 = G__50269;
i__49508_50244 = G__50270;
continue;
} else {
var child_50271 = cljs.core.first(seq__49504_50262__$1);
if(cljs.core.truth_(child_50271)){
node.appendChild(child_50271);


var G__50273 = cljs.core.next(seq__49504_50262__$1);
var G__50274 = null;
var G__50275 = (0);
var G__50276 = (0);
seq__49504_50241 = G__50273;
chunk__49506_50242 = G__50274;
count__49507_50243 = G__50275;
i__49508_50244 = G__50276;
continue;
} else {
var G__50278 = cljs.core.next(seq__49504_50262__$1);
var G__50279 = null;
var G__50280 = (0);
var G__50281 = (0);
seq__49504_50241 = G__50278;
chunk__49506_50242 = G__50279;
count__49507_50243 = G__50280;
i__49508_50244 = G__50281;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50240);
}
}


var G__50283 = cljs.core.next(seq__49411_50232__$1);
var G__50284 = null;
var G__50285 = (0);
var G__50286 = (0);
seq__49411_50180 = G__50283;
chunk__49413_50181 = G__50284;
count__49414_50182 = G__50285;
i__49415_50183 = G__50286;
continue;
} else {
var G__50288 = cljs.core.next(seq__49411_50232__$1);
var G__50289 = null;
var G__50290 = (0);
var G__50291 = (0);
seq__49411_50180 = G__50288;
chunk__49413_50181 = G__50289;
count__49414_50182 = G__50290;
i__49415_50183 = G__50291;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50297 = arguments.length;
var i__4737__auto___50299 = (0);
while(true){
if((i__4737__auto___50299 < len__4736__auto___50297)){
args__4742__auto__.push((arguments[i__4737__auto___50299]));

var G__50300 = (i__4737__auto___50299 + (1));
i__4737__auto___50299 = G__50300;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49589){
var G__49591 = cljs.core.first(seq49589);
var seq49589__$1 = cljs.core.next(seq49589);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49591,seq49589__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49624 = arguments.length;
switch (G__49624) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__43974__auto___50327 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_49641){
var state_val_49642 = (state_49641[(1)]);
if((state_val_49642 === (1))){
var state_49641__$1 = state_49641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49641__$1,(2),once_or_cleanup);
} else {
if((state_val_49642 === (2))){
var inst_49638 = (state_49641[(2)]);
var inst_49639 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49641__$1 = (function (){var statearr_49653 = state_49641;
(statearr_49653[(7)] = inst_49638);

return statearr_49653;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49641__$1,inst_49639);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43595__auto__ = null;
var shadow$dom$state_machine__43595__auto____0 = (function (){
var statearr_49658 = [null,null,null,null,null,null,null,null];
(statearr_49658[(0)] = shadow$dom$state_machine__43595__auto__);

(statearr_49658[(1)] = (1));

return statearr_49658;
});
var shadow$dom$state_machine__43595__auto____1 = (function (state_49641){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_49641);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e49660){var ex__43598__auto__ = e49660;
var statearr_49662_50332 = state_49641;
(statearr_49662_50332[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_49641[(4)]))){
var statearr_49664_50333 = state_49641;
(statearr_49664_50333[(1)] = cljs.core.first((state_49641[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50335 = state_49641;
state_49641 = G__50335;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
shadow$dom$state_machine__43595__auto__ = function(state_49641){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43595__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43595__auto____1.call(this,state_49641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43595__auto____0;
shadow$dom$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43595__auto____1;
return shadow$dom$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_49668 = f__43975__auto__();
(statearr_49668[(6)] = c__43974__auto___50327);

return statearr_49668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
