goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___54741 = schema.utils.use_fn_validation;
var output_schema54330_54742 = schema.core.Bool;
var input_schema54334_54743 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54335_54744 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54334_54743);
}),null));
var output_checker54336_54745 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54330_54742);
}),null));
var ret__53619__auto___54746 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__54337){
var validate__51710__auto__ = cljs.core.deref(ufv___54741);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54747 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54337], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54354_54748 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54355_54749 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__54356_54750 = input_schema54334_54743;
var G__54357_54751 = cljs.core.deref(input_checker54335_54744);
var G__54358_54752 = args__51711__auto___54747;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54354_54748,G__54355_54749,G__54356_54750,G__54357_54751,G__54358_54752) : schema.core.fn_validator.call(null,G__54354_54748,G__54355_54749,G__54356_54750,G__54357_54751,G__54358_54752));
} else {
var temp__5754__auto___54753 = (function (){var fexpr__54359 = cljs.core.deref(input_checker54335_54744);
return (fexpr__54359.cljs$core$IFn$_invoke$arity$1 ? fexpr__54359.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54747) : fexpr__54359.call(null,args__51711__auto___54747));
})();
if(cljs.core.truth_(temp__5754__auto___54753)){
var error__51712__auto___54754 = temp__5754__auto___54753;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54754], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54334_54743,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54747,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54754], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var arg = G__54337;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54366_54755 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54367_54756 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__54368_54757 = output_schema54330_54742;
var G__54369_54758 = cljs.core.deref(output_checker54336_54745);
var G__54370_54759 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54366_54755,G__54367_54756,G__54368_54757,G__54369_54758,G__54370_54759) : schema.core.fn_validator.call(null,G__54366_54755,G__54367_54756,G__54368_54757,G__54369_54758,G__54370_54759));
} else {
var temp__5754__auto___54760 = (function (){var fexpr__54373 = cljs.core.deref(output_checker54336_54745);
return (fexpr__54373.cljs$core$IFn$_invoke$arity$1 ? fexpr__54373.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54373.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54760)){
var error__51712__auto___54762 = temp__5754__auto___54760;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54762], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54330_54742,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54762], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema54330_54742,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54334_54743], null)));

var ufv___54763 = schema.utils.use_fn_validation;
var output_schema54380_54764 = deercreeklabs.baracus.ByteArray;
var input_schema54382_54765 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema54386_54766 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker54383_54767 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54382_54765);
}),null));
var output_checker54384_54768 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54380_54764);
}),null));
var input_checker54387_54769 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54386_54766);
}),null));
var output_checker54388_54770 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54380_54764);
}),null));
var ret__53619__auto___54771 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__54393 = arguments.length;
switch (G__54393) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__54385){
var validate__51710__auto__ = cljs.core.deref(ufv___54763);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54776 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54385], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54394_54777 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54395_54779 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__54396_54780 = input_schema54382_54765;
var G__54397_54781 = cljs.core.deref(input_checker54383_54767);
var G__54398_54782 = args__51711__auto___54776;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54394_54777,G__54395_54779,G__54396_54780,G__54397_54781,G__54398_54782) : schema.core.fn_validator.call(null,G__54394_54777,G__54395_54779,G__54396_54780,G__54397_54781,G__54398_54782));
} else {
var temp__5754__auto___54784 = (function (){var fexpr__54399 = cljs.core.deref(input_checker54383_54767);
return (fexpr__54399.cljs$core$IFn$_invoke$arity$1 ? fexpr__54399.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54776) : fexpr__54399.call(null,args__51711__auto___54776));
})();
if(cljs.core.truth_(temp__5754__auto___54784)){
var error__51712__auto___54785 = temp__5754__auto___54784;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54785], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54382_54765,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54776,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54785], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var size_or_seq = G__54385;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54400_54789 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54401_54790 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__54402_54791 = output_schema54380_54764;
var G__54403_54792 = cljs.core.deref(output_checker54384_54768);
var G__54404_54793 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54400_54789,G__54401_54790,G__54402_54791,G__54403_54792,G__54404_54793) : schema.core.fn_validator.call(null,G__54400_54789,G__54401_54790,G__54402_54791,G__54403_54792,G__54404_54793));
} else {
var temp__5754__auto___54796 = (function (){var fexpr__54405 = cljs.core.deref(output_checker54384_54768);
return (fexpr__54405.cljs$core$IFn$_invoke$arity$1 ? fexpr__54405.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54405.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54796)){
var error__51712__auto___54798 = temp__5754__auto___54796;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54798], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54380_54764,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54798], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__54389,G__54390){
var validate__51710__auto__ = cljs.core.deref(ufv___54763);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54800 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54389,G__54390], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54407_54801 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54408_54802 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__54409_54803 = input_schema54386_54766;
var G__54410_54804 = cljs.core.deref(input_checker54387_54769);
var G__54411_54805 = args__51711__auto___54800;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54407_54801,G__54408_54802,G__54409_54803,G__54410_54804,G__54411_54805) : schema.core.fn_validator.call(null,G__54407_54801,G__54408_54802,G__54409_54803,G__54410_54804,G__54411_54805));
} else {
var temp__5754__auto___54806 = (function (){var fexpr__54412 = cljs.core.deref(input_checker54387_54769);
return (fexpr__54412.cljs$core$IFn$_invoke$arity$1 ? fexpr__54412.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54800) : fexpr__54412.call(null,args__51711__auto___54800));
})();
if(cljs.core.truth_(temp__5754__auto___54806)){
var error__51712__auto___54807 = temp__5754__auto___54806;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54807], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54386_54766,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54800,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54807], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var size = G__54389;
var init_val_or_seq = G__54390;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54413_54808 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54414_54809 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__54415_54810 = output_schema54380_54764;
var G__54416_54811 = cljs.core.deref(output_checker54388_54770);
var G__54417_54812 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54413_54808,G__54414_54809,G__54415_54810,G__54416_54811,G__54417_54812) : schema.core.fn_validator.call(null,G__54413_54808,G__54414_54809,G__54415_54810,G__54416_54811,G__54417_54812));
} else {
var temp__5754__auto___54813 = (function (){var fexpr__54418 = cljs.core.deref(output_checker54388_54770);
return (fexpr__54418.cljs$core$IFn$_invoke$arity$1 ? fexpr__54418.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54418.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54813)){
var error__51712__auto___54816 = temp__5754__auto___54813;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54816], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54380_54764,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54816], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema54380_54764,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54382_54765,input_schema54386_54766], null)));

var ufv___54819 = schema.utils.use_fn_validation;
var output_schema54419_54820 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54420_54821 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker54421_54822 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54420_54821);
}),null));
var output_checker54422_54823 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54419_54820);
}),null));
var ret__53619__auto___54826 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__54423){
var validate__51710__auto__ = cljs.core.deref(ufv___54819);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54827 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54423], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54424_54828 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54425_54829 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__54426_54830 = input_schema54420_54821;
var G__54427_54831 = cljs.core.deref(input_checker54421_54822);
var G__54428_54832 = args__51711__auto___54827;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54424_54828,G__54425_54829,G__54426_54830,G__54427_54831,G__54428_54832) : schema.core.fn_validator.call(null,G__54424_54828,G__54425_54829,G__54426_54830,G__54427_54831,G__54428_54832));
} else {
var temp__5754__auto___54833 = (function (){var fexpr__54429 = cljs.core.deref(input_checker54421_54822);
return (fexpr__54429.cljs$core$IFn$_invoke$arity$1 ? fexpr__54429.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54827) : fexpr__54429.call(null,args__51711__auto___54827));
})();
if(cljs.core.truth_(temp__5754__auto___54833)){
var error__51712__auto___54834 = temp__5754__auto___54833;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54834], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54420_54821,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54827,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54834], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var arrays = G__54423;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__54430 = cljs.core.count(arrays__$1);
switch (G__54430) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__54430,arrays__$1,validate__51710__auto__,ufv___54819,output_schema54419_54820,input_schema54420_54821,input_checker54421_54822,output_checker54422_54823){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__54430,arrays__$1,validate__51710__auto__,ufv___54819,output_schema54419_54820,input_schema54420_54821,input_checker54421_54822,output_checker54422_54823))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__54430,arrays__$1,validate__51710__auto__,ufv___54819,output_schema54419_54820,input_schema54420_54821,input_checker54421_54822,output_checker54422_54823){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__54430,arrays__$1,validate__51710__auto__,ufv___54819,output_schema54419_54820,input_schema54420_54821,input_checker54421_54822,output_checker54422_54823))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54432_54841 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54433_54842 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__54434_54843 = output_schema54419_54820;
var G__54435_54844 = cljs.core.deref(output_checker54422_54823);
var G__54436_54845 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54432_54841,G__54433_54842,G__54434_54843,G__54435_54844,G__54436_54845) : schema.core.fn_validator.call(null,G__54432_54841,G__54433_54842,G__54434_54843,G__54435_54844,G__54436_54845));
} else {
var temp__5754__auto___54846 = (function (){var fexpr__54437 = cljs.core.deref(output_checker54422_54823);
return (fexpr__54437.cljs$core$IFn$_invoke$arity$1 ? fexpr__54437.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54437.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54846)){
var error__51712__auto___54847 = temp__5754__auto___54846;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54847], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54419_54820,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54847], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema54419_54820,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54420_54821], null)));

var ufv___54859 = schema.utils.use_fn_validation;
var output_schema54438_54860 = schema.core.Bool;
var input_schema54439_54861 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54440_54862 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54439_54861);
}),null));
var output_checker54441_54863 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54438_54860);
}),null));
var ret__53619__auto___54865 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__54442,G__54443){
var validate__51710__auto__ = cljs.core.deref(ufv___54859);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54866 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54442,G__54443], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54444_54867 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54445_54868 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__54446_54869 = input_schema54439_54861;
var G__54447_54870 = cljs.core.deref(input_checker54440_54862);
var G__54448_54871 = args__51711__auto___54866;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54444_54867,G__54445_54868,G__54446_54869,G__54447_54870,G__54448_54871) : schema.core.fn_validator.call(null,G__54444_54867,G__54445_54868,G__54446_54869,G__54447_54870,G__54448_54871));
} else {
var temp__5754__auto___54874 = (function (){var fexpr__54449 = cljs.core.deref(input_checker54440_54862);
return (fexpr__54449.cljs$core$IFn$_invoke$arity$1 ? fexpr__54449.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54866) : fexpr__54449.call(null,args__51711__auto___54866));
})();
if(cljs.core.truth_(temp__5754__auto___54874)){
var error__51712__auto___54875 = temp__5754__auto___54874;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54875], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54439_54861,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54866,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54875], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var a = G__54442;
var b = G__54443;
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b))){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__54886 = ((i + (1)) | (0));
i = G__54886;
continue;
} else {
return false;
}
}
break;
}
} else {
return false;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54450_54887 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54451_54888 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__54452_54889 = output_schema54438_54860;
var G__54453_54890 = cljs.core.deref(output_checker54441_54863);
var G__54454_54891 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54450_54887,G__54451_54888,G__54452_54889,G__54453_54890,G__54454_54891) : schema.core.fn_validator.call(null,G__54450_54887,G__54451_54888,G__54452_54889,G__54453_54890,G__54454_54891));
} else {
var temp__5754__auto___54892 = (function (){var fexpr__54455 = cljs.core.deref(output_checker54441_54863);
return (fexpr__54455.cljs$core$IFn$_invoke$arity$1 ? fexpr__54455.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54455.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54892)){
var error__51712__auto___54893 = temp__5754__auto___54892;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54893], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54438_54860,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54893], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema54438_54860,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54439_54861], null)));

var ufv___54894 = schema.utils.use_fn_validation;
var output_schema54457_54895 = schema.core.Str;
var input_schema54458_54896 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54459_54897 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54458_54896);
}),null));
var output_checker54460_54898 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54457_54895);
}),null));
var ret__53619__auto___54899 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__54461){
var validate__51710__auto__ = cljs.core.deref(ufv___54894);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54900 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54461], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54463_54901 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54464_54902 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__54465_54903 = input_schema54458_54896;
var G__54466_54904 = cljs.core.deref(input_checker54459_54897);
var G__54467_54905 = args__51711__auto___54900;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54463_54901,G__54464_54902,G__54465_54903,G__54466_54904,G__54467_54905) : schema.core.fn_validator.call(null,G__54463_54901,G__54464_54902,G__54465_54903,G__54466_54904,G__54467_54905));
} else {
var temp__5754__auto___54906 = (function (){var fexpr__54468 = cljs.core.deref(input_checker54459_54897);
return (fexpr__54468.cljs$core$IFn$_invoke$arity$1 ? fexpr__54468.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54900) : fexpr__54468.call(null,args__51711__auto___54900));
})();
if(cljs.core.truth_(temp__5754__auto___54906)){
var error__51712__auto___54907 = temp__5754__auto___54906;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54907], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54458_54896,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54900,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54907], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54461;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54469_54921 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54470_54922 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__54471_54923 = output_schema54457_54895;
var G__54472_54924 = cljs.core.deref(output_checker54460_54898);
var G__54473_54925 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54469_54921,G__54470_54922,G__54471_54923,G__54472_54924,G__54473_54925) : schema.core.fn_validator.call(null,G__54469_54921,G__54470_54922,G__54471_54923,G__54472_54924,G__54473_54925));
} else {
var temp__5754__auto___54932 = (function (){var fexpr__54474 = cljs.core.deref(output_checker54460_54898);
return (fexpr__54474.cljs$core$IFn$_invoke$arity$1 ? fexpr__54474.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54474.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54932)){
var error__51712__auto___54934 = temp__5754__auto___54932;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54934], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54457_54895,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54934], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema54457_54895,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54458_54896], null)));

var ufv___54938 = schema.utils.use_fn_validation;
var output_schema54475_54939 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54476_54940 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema54480_54941 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema54485_54942 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker54477_54943 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54476_54940);
}),null));
var output_checker54478_54944 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54475_54939);
}),null));
var input_checker54481_54945 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54480_54941);
}),null));
var output_checker54482_54946 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54475_54939);
}),null));
var input_checker54486_54947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54485_54942);
}),null));
var output_checker54487_54948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54475_54939);
}),null));
var ret__53619__auto___54953 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__54492 = arguments.length;
switch (G__54492) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__54479){
var validate__51710__auto__ = cljs.core.deref(ufv___54938);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54971 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54479], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54496_54973 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54497_54974 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54498_54975 = input_schema54476_54940;
var G__54499_54976 = cljs.core.deref(input_checker54477_54943);
var G__54500_54977 = args__51711__auto___54971;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54496_54973,G__54497_54974,G__54498_54975,G__54499_54976,G__54500_54977) : schema.core.fn_validator.call(null,G__54496_54973,G__54497_54974,G__54498_54975,G__54499_54976,G__54500_54977));
} else {
var temp__5754__auto___54979 = (function (){var fexpr__54501 = cljs.core.deref(input_checker54477_54943);
return (fexpr__54501.cljs$core$IFn$_invoke$arity$1 ? fexpr__54501.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54971) : fexpr__54501.call(null,args__51711__auto___54971));
})();
if(cljs.core.truth_(temp__5754__auto___54979)){
var error__51712__auto___54980 = temp__5754__auto___54979;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54980], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54476_54940,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54971,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54980], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54479;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54503_54981 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54504_54982 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54505_54983 = output_schema54475_54939;
var G__54506_54984 = cljs.core.deref(output_checker54478_54944);
var G__54507_54985 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54503_54981,G__54504_54982,G__54505_54983,G__54506_54984,G__54507_54985) : schema.core.fn_validator.call(null,G__54503_54981,G__54504_54982,G__54505_54983,G__54506_54984,G__54507_54985));
} else {
var temp__5754__auto___54986 = (function (){var fexpr__54508 = cljs.core.deref(output_checker54478_54944);
return (fexpr__54508.cljs$core$IFn$_invoke$arity$1 ? fexpr__54508.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54508.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___54986)){
var error__51712__auto___54987 = temp__5754__auto___54986;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___54987], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54475_54939,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___54987], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__54483,G__54484){
var validate__51710__auto__ = cljs.core.deref(ufv___54938);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___54996 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54483,G__54484], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54509_54997 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54510_54998 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54511_54999 = input_schema54480_54941;
var G__54512_55000 = cljs.core.deref(input_checker54481_54945);
var G__54513_55001 = args__51711__auto___54996;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54509_54997,G__54510_54998,G__54511_54999,G__54512_55000,G__54513_55001) : schema.core.fn_validator.call(null,G__54509_54997,G__54510_54998,G__54511_54999,G__54512_55000,G__54513_55001));
} else {
var temp__5754__auto___55004 = (function (){var fexpr__54514 = cljs.core.deref(input_checker54481_54945);
return (fexpr__54514.cljs$core$IFn$_invoke$arity$1 ? fexpr__54514.cljs$core$IFn$_invoke$arity$1(args__51711__auto___54996) : fexpr__54514.call(null,args__51711__auto___54996));
})();
if(cljs.core.truth_(temp__5754__auto___55004)){
var error__51712__auto___55006 = temp__5754__auto___55004;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55006], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54480_54941,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___54996,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55006], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54483;
var start = G__54484;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54515_55009 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54516_55010 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54517_55011 = output_schema54475_54939;
var G__54518_55012 = cljs.core.deref(output_checker54482_54946);
var G__54519_55013 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54515_55009,G__54516_55010,G__54517_55011,G__54518_55012,G__54519_55013) : schema.core.fn_validator.call(null,G__54515_55009,G__54516_55010,G__54517_55011,G__54518_55012,G__54519_55013));
} else {
var temp__5754__auto___55015 = (function (){var fexpr__54520 = cljs.core.deref(output_checker54482_54946);
return (fexpr__54520.cljs$core$IFn$_invoke$arity$1 ? fexpr__54520.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54520.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55015)){
var error__51712__auto___55024 = temp__5754__auto___55015;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55024], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54475_54939,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55024], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__54488,G__54489,G__54490){
var validate__51710__auto__ = cljs.core.deref(ufv___54938);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55027 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54488,G__54489,G__54490], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54521_55028 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54522_55029 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54523_55030 = input_schema54485_54942;
var G__54524_55031 = cljs.core.deref(input_checker54486_54947);
var G__54525_55032 = args__51711__auto___55027;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54521_55028,G__54522_55029,G__54523_55030,G__54524_55031,G__54525_55032) : schema.core.fn_validator.call(null,G__54521_55028,G__54522_55029,G__54523_55030,G__54524_55031,G__54525_55032));
} else {
var temp__5754__auto___55033 = (function (){var fexpr__54526 = cljs.core.deref(input_checker54486_54947);
return (fexpr__54526.cljs$core$IFn$_invoke$arity$1 ? fexpr__54526.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55027) : fexpr__54526.call(null,args__51711__auto___55027));
})();
if(cljs.core.truth_(temp__5754__auto___55033)){
var error__51712__auto___55035 = temp__5754__auto___55033;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55035], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54485_54942,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55027,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55035], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54488;
var start = G__54489;
var end = G__54490;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4217__auto__ = end;
var y__4218__auto__ = cljs.core.count(ba);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54527_55047 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54528_55048 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54529_55049 = output_schema54475_54939;
var G__54530_55050 = cljs.core.deref(output_checker54487_54948);
var G__54531_55051 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54527_55047,G__54528_55048,G__54529_55049,G__54530_55050,G__54531_55051) : schema.core.fn_validator.call(null,G__54527_55047,G__54528_55048,G__54529_55049,G__54530_55050,G__54531_55051));
} else {
var temp__5754__auto___55053 = (function (){var fexpr__54532 = cljs.core.deref(output_checker54487_54948);
return (fexpr__54532.cljs$core$IFn$_invoke$arity$1 ? fexpr__54532.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54532.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55053)){
var error__51712__auto___55054 = temp__5754__auto___55053;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55054], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54475_54939,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55054], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema54475_54939,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54476_54940,input_schema54480_54941,input_schema54485_54942], null)));

var ufv___55058 = schema.utils.use_fn_validation;
var output_schema54533_55059 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54534_55060 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54535_55061 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54534_55060);
}),null));
var output_checker54536_55062 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54533_55059);
}),null));
var ret__53619__auto___55071 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__54537){
var validate__51710__auto__ = cljs.core.deref(ufv___55058);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55073 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54537], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54539_55075 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54540_55076 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__54541_55077 = input_schema54534_55060;
var G__54542_55078 = cljs.core.deref(input_checker54535_55061);
var G__54543_55079 = args__51711__auto___55073;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54539_55075,G__54540_55076,G__54541_55077,G__54542_55078,G__54543_55079) : schema.core.fn_validator.call(null,G__54539_55075,G__54540_55076,G__54541_55077,G__54542_55078,G__54543_55079));
} else {
var temp__5754__auto___55080 = (function (){var fexpr__54545 = cljs.core.deref(input_checker54535_55061);
return (fexpr__54545.cljs$core$IFn$_invoke$arity$1 ? fexpr__54545.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55073) : fexpr__54545.call(null,args__51711__auto___55073));
})();
if(cljs.core.truth_(temp__5754__auto___55080)){
var error__51712__auto___55081 = temp__5754__auto___55080;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55081], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54534_55060,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55073,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55081], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54537;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4613__auto___55088 = num;
var i_55089 = (0);
while(true){
if((i_55089 < n__4613__auto___55088)){
(new$[i_55089] = (ba[(last - i_55089)]));

var G__55093 = (i_55089 + (1));
i_55089 = G__55093;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54546_55096 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54547_55097 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__54548_55098 = output_schema54533_55059;
var G__54549_55099 = cljs.core.deref(output_checker54536_55062);
var G__54550_55100 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54546_55096,G__54547_55097,G__54548_55098,G__54549_55099,G__54550_55100) : schema.core.fn_validator.call(null,G__54546_55096,G__54547_55097,G__54548_55098,G__54549_55099,G__54550_55100));
} else {
var temp__5754__auto___55102 = (function (){var fexpr__54551 = cljs.core.deref(output_checker54536_55062);
return (fexpr__54551.cljs$core$IFn$_invoke$arity$1 ? fexpr__54551.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54551.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55102)){
var error__51712__auto___55103 = temp__5754__auto___55102;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55103], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54533_55059,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55103], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema54533_55059,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54534_55060], null)));

var ufv___55110 = schema.utils.use_fn_validation;
var output_schema54552_55111 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema54553_55112 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54554_55113 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54553_55112);
}),null));
var output_checker54555_55114 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54552_55111);
}),null));
var ret__53619__auto___55123 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__54556,G__54557){
var validate__51710__auto__ = cljs.core.deref(ufv___55110);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55126 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54556,G__54557], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54558_55127 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54559_55128 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__54560_55129 = input_schema54553_55112;
var G__54561_55130 = cljs.core.deref(input_checker54554_55113);
var G__54562_55131 = args__51711__auto___55126;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54558_55127,G__54559_55128,G__54560_55129,G__54561_55130,G__54562_55131) : schema.core.fn_validator.call(null,G__54558_55127,G__54559_55128,G__54560_55129,G__54561_55130,G__54562_55131));
} else {
var temp__5754__auto___55132 = (function (){var fexpr__54563 = cljs.core.deref(input_checker54554_55113);
return (fexpr__54563.cljs$core$IFn$_invoke$arity$1 ? fexpr__54563.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55126) : fexpr__54563.call(null,args__51711__auto___55126));
})();
if(cljs.core.truth_(temp__5754__auto___55132)){
var error__51712__auto___55133 = temp__5754__auto___55132;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55133], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54553_55112,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55126,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55133], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54556;
var fragment_size = G__54557;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__55150 = (end_offset | (0));
var G__55151 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__55150;
output = G__55151;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54564_55152 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54565_55153 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__54566_55154 = output_schema54552_55111;
var G__54567_55155 = cljs.core.deref(output_checker54555_55114);
var G__54568_55156 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54564_55152,G__54565_55153,G__54566_55154,G__54567_55155,G__54568_55156) : schema.core.fn_validator.call(null,G__54564_55152,G__54565_55153,G__54566_55154,G__54567_55155,G__54568_55156));
} else {
var temp__5754__auto___55162 = (function (){var fexpr__54569 = cljs.core.deref(output_checker54555_55114);
return (fexpr__54569.cljs$core$IFn$_invoke$arity$1 ? fexpr__54569.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54569.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55162)){
var error__51712__auto___55165 = temp__5754__auto___55162;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55165], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54552_55111,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55165], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema54552_55111,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54553_55112], null)));

var ufv___55172 = schema.utils.use_fn_validation;
var output_schema54570_55173 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema54571_55174 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54572_55175 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54571_55174);
}),null));
var output_checker54573_55176 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54570_55173);
}),null));
var ret__53619__auto___55178 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__54574){
var validate__51710__auto__ = cljs.core.deref(ufv___55172);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55179 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54574], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54575_55181 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54576_55182 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__54577_55183 = input_schema54571_55174;
var G__54578_55184 = cljs.core.deref(input_checker54572_55175);
var G__54579_55185 = args__51711__auto___55179;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54575_55181,G__54576_55182,G__54577_55183,G__54578_55184,G__54579_55185) : schema.core.fn_validator.call(null,G__54575_55181,G__54576_55182,G__54577_55183,G__54578_55184,G__54579_55185));
} else {
var temp__5754__auto___55187 = (function (){var fexpr__54581 = cljs.core.deref(input_checker54572_55175);
return (fexpr__54581.cljs$core$IFn$_invoke$arity$1 ? fexpr__54581.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55179) : fexpr__54581.call(null,args__51711__auto___55179));
})();
if(cljs.core.truth_(temp__5754__auto___55187)){
var error__51712__auto___55188 = temp__5754__auto___55187;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55188], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54571_55174,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55179,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55188], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54574;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__55194 = (n + (1));
var G__55195 = (i__$1 | (0));
var G__55196 = (out__$1 | (0));
n = G__55194;
i = G__55195;
out = G__55196;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54582_55215 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54583_55216 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__54584_55217 = output_schema54570_55173;
var G__54585_55218 = cljs.core.deref(output_checker54573_55176);
var G__54586_55219 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54582_55215,G__54583_55216,G__54584_55217,G__54585_55218,G__54586_55219) : schema.core.fn_validator.call(null,G__54582_55215,G__54583_55216,G__54584_55217,G__54585_55218,G__54586_55219));
} else {
var temp__5754__auto___55226 = (function (){var fexpr__54587 = cljs.core.deref(output_checker54573_55176);
return (fexpr__54587.cljs$core$IFn$_invoke$arity$1 ? fexpr__54587.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54587.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55226)){
var error__51712__auto___55227 = temp__5754__auto___55226;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55227], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54570_55173,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55227], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema54570_55173,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54571_55174], null)));

var ufv___55228 = schema.utils.use_fn_validation;
var output_schema54588_55229 = deercreeklabs.baracus.ByteArray;
var input_schema54589_55230 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54590_55231 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54589_55230);
}),null));
var output_checker54591_55232 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54588_55229);
}),null));
var ret__53619__auto___55233 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__54592){
var validate__51710__auto__ = cljs.core.deref(ufv___55228);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55234 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54592], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54593_55235 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54594_55236 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__54595_55237 = input_schema54589_55230;
var G__54596_55238 = cljs.core.deref(input_checker54590_55231);
var G__54597_55239 = args__51711__auto___55234;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54593_55235,G__54594_55236,G__54595_55237,G__54596_55238,G__54597_55239) : schema.core.fn_validator.call(null,G__54593_55235,G__54594_55236,G__54595_55237,G__54596_55238,G__54597_55239));
} else {
var temp__5754__auto___55240 = (function (){var fexpr__54598 = cljs.core.deref(input_checker54590_55231);
return (fexpr__54598.cljs$core$IFn$_invoke$arity$1 ? fexpr__54598.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55234) : fexpr__54598.call(null,args__51711__auto___55234));
})();
if(cljs.core.truth_(temp__5754__auto___55240)){
var error__51712__auto___55241 = temp__5754__auto___55240;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55241], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54589_55230,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55234,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55241], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var i = G__54592;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__55252 = (n >>> (7));
var G__55253 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__55252;
out = G__55253;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54600_55255 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54601_55256 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__54602_55257 = output_schema54588_55229;
var G__54603_55258 = cljs.core.deref(output_checker54591_55232);
var G__54604_55259 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54600_55255,G__54601_55256,G__54602_55257,G__54603_55258,G__54604_55259) : schema.core.fn_validator.call(null,G__54600_55255,G__54601_55256,G__54602_55257,G__54603_55258,G__54604_55259));
} else {
var temp__5754__auto___55260 = (function (){var fexpr__54605 = cljs.core.deref(output_checker54591_55232);
return (fexpr__54605.cljs$core$IFn$_invoke$arity$1 ? fexpr__54605.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54605.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55260)){
var error__51712__auto___55262 = temp__5754__auto___55260;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55262], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54588_55229,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55262], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema54588_55229,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54589_55230], null)));

var ufv___55266 = schema.utils.use_fn_validation;
var output_schema54606_55267 = schema.core.maybe(schema.core.Str);
var input_schema54607_55268 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54608_55269 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54607_55268);
}),null));
var output_checker54609_55270 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54606_55267);
}),null));
var ret__53619__auto___55279 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__54610){
var validate__51710__auto__ = cljs.core.deref(ufv___55266);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55280 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54610], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54611_55282 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54612_55283 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__54613_55284 = input_schema54607_55268;
var G__54614_55285 = cljs.core.deref(input_checker54608_55269);
var G__54615_55286 = args__51711__auto___55280;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54611_55282,G__54612_55283,G__54613_55284,G__54614_55285,G__54615_55286) : schema.core.fn_validator.call(null,G__54611_55282,G__54612_55283,G__54613_55284,G__54614_55285,G__54615_55286));
} else {
var temp__5754__auto___55288 = (function (){var fexpr__54616 = cljs.core.deref(input_checker54608_55269);
return (fexpr__54616.cljs$core$IFn$_invoke$arity$1 ? fexpr__54616.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55280) : fexpr__54616.call(null,args__51711__auto___55280));
})();
if(cljs.core.truth_(temp__5754__auto___55288)){
var error__51712__auto___55289 = temp__5754__auto___55288;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55289], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54607_55268,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55280,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55289], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var b = G__54610;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54617_55290 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54618_55291 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__54619_55292 = output_schema54606_55267;
var G__54620_55293 = cljs.core.deref(output_checker54609_55270);
var G__54621_55294 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54617_55290,G__54618_55291,G__54619_55292,G__54620_55293,G__54621_55294) : schema.core.fn_validator.call(null,G__54617_55290,G__54618_55291,G__54619_55292,G__54620_55293,G__54621_55294));
} else {
var temp__5754__auto___55300 = (function (){var fexpr__54622 = cljs.core.deref(output_checker54609_55270);
return (fexpr__54622.cljs$core$IFn$_invoke$arity$1 ? fexpr__54622.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54622.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55300)){
var error__51712__auto___55302 = temp__5754__auto___55300;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55302], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54606_55267,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55302], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema54606_55267,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54607_55268], null)));

var ufv___55308 = schema.utils.use_fn_validation;
var output_schema54623_55309 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54624_55310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54625_55311 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54624_55310);
}),null));
var output_checker54626_55312 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54623_55309);
}),null));
var ret__53619__auto___55314 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__54627){
var validate__51710__auto__ = cljs.core.deref(ufv___55308);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55315 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54627], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54628_55317 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54629_55318 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54630_55319 = input_schema54624_55310;
var G__54631_55320 = cljs.core.deref(input_checker54625_55311);
var G__54632_55321 = args__51711__auto___55315;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54628_55317,G__54629_55318,G__54630_55319,G__54631_55320,G__54632_55321) : schema.core.fn_validator.call(null,G__54628_55317,G__54629_55318,G__54630_55319,G__54631_55320,G__54632_55321));
} else {
var temp__5754__auto___55326 = (function (){var fexpr__54634 = cljs.core.deref(input_checker54625_55311);
return (fexpr__54634.cljs$core$IFn$_invoke$arity$1 ? fexpr__54634.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55315) : fexpr__54634.call(null,args__51711__auto___55315));
})();
if(cljs.core.truth_(temp__5754__auto___55326)){
var error__51712__auto___55327 = temp__5754__auto___55326;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55327], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54624_55310,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55315,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55327], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var s = G__54627;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54635_55338 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54636_55339 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54637_55340 = output_schema54623_55309;
var G__54638_55341 = cljs.core.deref(output_checker54626_55312);
var G__54639_55342 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54635_55338,G__54636_55339,G__54637_55340,G__54638_55341,G__54639_55342) : schema.core.fn_validator.call(null,G__54635_55338,G__54636_55339,G__54637_55340,G__54638_55341,G__54639_55342));
} else {
var temp__5754__auto___55343 = (function (){var fexpr__54640 = cljs.core.deref(output_checker54626_55312);
return (fexpr__54640.cljs$core$IFn$_invoke$arity$1 ? fexpr__54640.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54640.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55343)){
var error__51712__auto___55344 = temp__5754__auto___55343;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55344], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54623_55309,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55344], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema54623_55309,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54624_55310], null)));

var ufv___55351 = schema.utils.use_fn_validation;
var output_schema54641_55352 = schema.core.maybe(schema.core.Str);
var input_schema54642_55353 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54643_55354 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54642_55353);
}),null));
var output_checker54644_55355 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54641_55352);
}),null));
var ret__53619__auto___55361 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__54645){
var validate__51710__auto__ = cljs.core.deref(ufv___55351);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55362 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54645], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54646_55363 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54647_55364 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54648_55365 = input_schema54642_55353;
var G__54649_55366 = cljs.core.deref(input_checker54643_55354);
var G__54650_55367 = args__51711__auto___55362;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54646_55363,G__54647_55364,G__54648_55365,G__54649_55366,G__54650_55367) : schema.core.fn_validator.call(null,G__54646_55363,G__54647_55364,G__54648_55365,G__54649_55366,G__54650_55367));
} else {
var temp__5754__auto___55370 = (function (){var fexpr__54651 = cljs.core.deref(input_checker54643_55354);
return (fexpr__54651.cljs$core$IFn$_invoke$arity$1 ? fexpr__54651.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55362) : fexpr__54651.call(null,args__51711__auto___55362));
})();
if(cljs.core.truth_(temp__5754__auto___55370)){
var error__51712__auto___55371 = temp__5754__auto___55370;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55371], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54642_55353,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55362,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55371], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54645;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54653_55384 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54654_55385 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54655_55386 = output_schema54641_55352;
var G__54656_55387 = cljs.core.deref(output_checker54644_55355);
var G__54657_55388 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54653_55384,G__54654_55385,G__54655_55386,G__54656_55387,G__54657_55388) : schema.core.fn_validator.call(null,G__54653_55384,G__54654_55385,G__54655_55386,G__54656_55387,G__54657_55388));
} else {
var temp__5754__auto___55392 = (function (){var fexpr__54658 = cljs.core.deref(output_checker54644_55355);
return (fexpr__54658.cljs$core$IFn$_invoke$arity$1 ? fexpr__54658.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54658.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55392)){
var error__51712__auto___55393 = temp__5754__auto___55392;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55393], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54641_55352,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55393], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema54641_55352,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54642_55353], null)));

var ufv___55395 = schema.utils.use_fn_validation;
var output_schema54659_55396 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54660_55397 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54661_55398 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54660_55397);
}),null));
var output_checker54662_55399 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54659_55396);
}),null));
var ret__53619__auto___55401 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__54663){
var validate__51710__auto__ = cljs.core.deref(ufv___55395);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55402 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54663], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54668_55404 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54669_55408 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54670_55409 = input_schema54660_55397;
var G__54671_55410 = cljs.core.deref(input_checker54661_55398);
var G__54672_55411 = args__51711__auto___55402;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54668_55404,G__54669_55408,G__54670_55409,G__54671_55410,G__54672_55411) : schema.core.fn_validator.call(null,G__54668_55404,G__54669_55408,G__54670_55409,G__54671_55410,G__54672_55411));
} else {
var temp__5754__auto___55415 = (function (){var fexpr__54673 = cljs.core.deref(input_checker54661_55398);
return (fexpr__54673.cljs$core$IFn$_invoke$arity$1 ? fexpr__54673.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55402) : fexpr__54673.call(null,args__51711__auto___55402));
})();
if(cljs.core.truth_(temp__5754__auto___55415)){
var error__51712__auto___55418 = temp__5754__auto___55415;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55418], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54660_55397,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55402,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55418], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var s = G__54663;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54674_55422 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54675_55423 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54676_55424 = output_schema54659_55396;
var G__54677_55425 = cljs.core.deref(output_checker54662_55399);
var G__54678_55426 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54674_55422,G__54675_55423,G__54676_55424,G__54677_55425,G__54678_55426) : schema.core.fn_validator.call(null,G__54674_55422,G__54675_55423,G__54676_55424,G__54677_55425,G__54678_55426));
} else {
var temp__5754__auto___55429 = (function (){var fexpr__54679 = cljs.core.deref(output_checker54662_55399);
return (fexpr__54679.cljs$core$IFn$_invoke$arity$1 ? fexpr__54679.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54679.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55429)){
var error__51712__auto___55430 = temp__5754__auto___55429;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55430], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54659_55396,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55430], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema54659_55396,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54660_55397], null)));

var ufv___55433 = schema.utils.use_fn_validation;
var output_schema54680_55434 = schema.core.maybe(schema.core.Str);
var input_schema54681_55435 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54682_55436 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54681_55435);
}),null));
var output_checker54683_55437 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54680_55434);
}),null));
var ret__53619__auto___55446 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__54684){
var validate__51710__auto__ = cljs.core.deref(ufv___55433);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55448 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54684], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54685_55449 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54686_55450 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54687_55451 = input_schema54681_55435;
var G__54688_55452 = cljs.core.deref(input_checker54682_55436);
var G__54689_55453 = args__51711__auto___55448;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54685_55449,G__54686_55450,G__54687_55451,G__54688_55452,G__54689_55453) : schema.core.fn_validator.call(null,G__54685_55449,G__54686_55450,G__54687_55451,G__54688_55452,G__54689_55453));
} else {
var temp__5754__auto___55455 = (function (){var fexpr__54690 = cljs.core.deref(input_checker54682_55436);
return (fexpr__54690.cljs$core$IFn$_invoke$arity$1 ? fexpr__54690.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55448) : fexpr__54690.call(null,args__51711__auto___55448));
})();
if(cljs.core.truth_(temp__5754__auto___55455)){
var error__51712__auto___55456 = temp__5754__auto___55455;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55456], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54681_55435,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55448,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55456], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54684;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4613__auto___55457 = len;
var i_55458 = (0);
while(true){
if((i_55458 < n__4613__auto___55457)){
var b_55463 = ((ba[i_55458]) & (255));
var j_55464 = ((2) * i_55458);
(ca[j_55464] = (function (){var G__54692 = (b_55463 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__54692) : hex_chars.call(null,G__54692));
})());

(ca[(j_55464 + (1))] = (function (){var G__54693 = (b_55463 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__54693) : hex_chars.call(null,G__54693));
})());

var G__55468 = (i_55458 + (1));
i_55458 = G__55468;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54694_55470 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54695_55471 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54696_55472 = output_schema54680_55434;
var G__54697_55473 = cljs.core.deref(output_checker54683_55437);
var G__54698_55474 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54694_55470,G__54695_55471,G__54696_55472,G__54697_55473,G__54698_55474) : schema.core.fn_validator.call(null,G__54694_55470,G__54695_55471,G__54696_55472,G__54697_55473,G__54698_55474));
} else {
var temp__5754__auto___55477 = (function (){var fexpr__54699 = cljs.core.deref(output_checker54683_55437);
return (fexpr__54699.cljs$core$IFn$_invoke$arity$1 ? fexpr__54699.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54699.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55477)){
var error__51712__auto___55479 = temp__5754__auto___55477;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55479], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54680_55434,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55479], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema54680_55434,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54681_55435], null)));

deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
return parseInt(ch,(16));
});
var ufv___55482 = schema.utils.use_fn_validation;
var output_schema54703_55483 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54704_55484 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54705_55485 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54704_55484);
}),null));
var output_checker54706_55486 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54703_55483);
}),null));
var ret__53619__auto___55488 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__54707){
var validate__51710__auto__ = cljs.core.deref(ufv___55482);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55489 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54707], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54708_55490 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54709_55491 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54710_55492 = input_schema54704_55484;
var G__54711_55493 = cljs.core.deref(input_checker54705_55485);
var G__54712_55494 = args__51711__auto___55489;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54708_55490,G__54709_55491,G__54710_55492,G__54711_55493,G__54712_55494) : schema.core.fn_validator.call(null,G__54708_55490,G__54709_55491,G__54710_55492,G__54711_55493,G__54712_55494));
} else {
var temp__5754__auto___55503 = (function (){var fexpr__54714 = cljs.core.deref(input_checker54705_55485);
return (fexpr__54714.cljs$core$IFn$_invoke$arity$1 ? fexpr__54714.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55489) : fexpr__54714.call(null,args__51711__auto___55489));
})();
if(cljs.core.truth_(temp__5754__auto___55503)){
var error__51712__auto___55504 = temp__5754__auto___55503;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55504], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54704_55484,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55489,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55504], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var s = G__54707;
while(true){
if(cljs.core.truth_(s)){
var ba_len = (cljs.core.count(s) / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4613__auto___55507 = ba_len;
var i_55508 = (0);
while(true){
if((i_55508 < n__4613__auto___55507)){
var j_55509 = ((2) * i_55508);
(ba[i_55508] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_55509)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_55509 + (1))))));

var G__55510 = (i_55508 + (1));
i_55508 = G__55510;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54716_55511 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54717_55512 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54718_55513 = output_schema54703_55483;
var G__54719_55514 = cljs.core.deref(output_checker54706_55486);
var G__54720_55515 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54716_55511,G__54717_55512,G__54718_55513,G__54719_55514,G__54720_55515) : schema.core.fn_validator.call(null,G__54716_55511,G__54717_55512,G__54718_55513,G__54719_55514,G__54720_55515));
} else {
var temp__5754__auto___55516 = (function (){var fexpr__54721 = cljs.core.deref(output_checker54706_55486);
return (fexpr__54721.cljs$core$IFn$_invoke$arity$1 ? fexpr__54721.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54721.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55516)){
var error__51712__auto___55517 = temp__5754__auto___55516;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55517], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54703_55483,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55517], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema54703_55483,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54704_55484], null)));

var ufv___55528 = schema.utils.use_fn_validation;
var output_schema54722_55529 = deercreeklabs.baracus.ByteArray;
var input_schema54723_55530 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54724_55531 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54723_55530);
}),null));
var output_checker54725_55532 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54722_55529);
}),null));
var ret__53619__auto___55534 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__54726){
var validate__51710__auto__ = cljs.core.deref(ufv___55528);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___55535 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54726], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54728_55536 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54729_55537 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54730_55538 = input_schema54723_55530;
var G__54731_55539 = cljs.core.deref(input_checker54724_55531);
var G__54732_55541 = args__51711__auto___55535;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54728_55536,G__54729_55537,G__54730_55538,G__54731_55539,G__54732_55541) : schema.core.fn_validator.call(null,G__54728_55536,G__54729_55537,G__54730_55538,G__54731_55539,G__54732_55541));
} else {
var temp__5754__auto___55542 = (function (){var fexpr__54733 = cljs.core.deref(input_checker54724_55531);
return (fexpr__54733.cljs$core$IFn$_invoke$arity$1 ? fexpr__54733.cljs$core$IFn$_invoke$arity$1(args__51711__auto___55535) : fexpr__54733.call(null,args__51711__auto___55535));
})();
if(cljs.core.truth_(temp__5754__auto___55542)){
var error__51712__auto___55544 = temp__5754__auto___55542;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55544], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54723_55530,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___55535,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55544], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var ba = G__54726;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54735_55556 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54736_55557 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54737_55558 = output_schema54722_55529;
var G__54738_55559 = cljs.core.deref(output_checker54725_55532);
var G__54739_55560 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54735_55556,G__54736_55557,G__54737_55558,G__54738_55559,G__54739_55560) : schema.core.fn_validator.call(null,G__54735_55556,G__54736_55557,G__54737_55558,G__54738_55559,G__54739_55560));
} else {
var temp__5754__auto___55561 = (function (){var fexpr__54740 = cljs.core.deref(output_checker54725_55532);
return (fexpr__54740.cljs$core$IFn$_invoke$arity$1 ? fexpr__54740.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__54740.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___55561)){
var error__51712__auto___55562 = temp__5754__auto___55561;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___55562], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54722_55529,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___55562], null));
} else {
}
}
} else {
}

return o__51713__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema54722_55529,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54723_55530], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
