goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44080 = arguments.length;
switch (G__44080) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44083 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44083 = (function (f,blockable,meta44084){
this.f = f;
this.blockable = blockable;
this.meta44084 = meta44084;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44085,meta44084__$1){
var self__ = this;
var _44085__$1 = this;
return (new cljs.core.async.t_cljs$core$async44083(self__.f,self__.blockable,meta44084__$1));
}));

(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44085){
var self__ = this;
var _44085__$1 = this;
return self__.meta44084;
}));

(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44083.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44083.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44084","meta44084",-1157946401,null)], null);
}));

(cljs.core.async.t_cljs$core$async44083.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44083.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44083");

(cljs.core.async.t_cljs$core$async44083.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44083");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44083.
 */
cljs.core.async.__GT_t_cljs$core$async44083 = (function cljs$core$async$__GT_t_cljs$core$async44083(f__$1,blockable__$1,meta44084){
return (new cljs.core.async.t_cljs$core$async44083(f__$1,blockable__$1,meta44084));
});

}

return (new cljs.core.async.t_cljs$core$async44083(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44127 = arguments.length;
switch (G__44127) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44135 = arguments.length;
switch (G__44135) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44145 = arguments.length;
switch (G__44145) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47887 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47887) : fn1.call(null,val_47887));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47887) : fn1.call(null,val_47887));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44161 = arguments.length;
switch (G__44161) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5752__auto__)){
var ret = temp__5752__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5752__auto__)){
var retb = temp__5752__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___47904 = n;
var x_47906 = (0);
while(true){
if((x_47906 < n__4613__auto___47904)){
(a[x_47906] = x_47906);

var G__47908 = (x_47906 + (1));
x_47906 = G__47908;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44183 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44183 = (function (flag,meta44184){
this.flag = flag;
this.meta44184 = meta44184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44185,meta44184__$1){
var self__ = this;
var _44185__$1 = this;
return (new cljs.core.async.t_cljs$core$async44183(self__.flag,meta44184__$1));
}));

(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44185){
var self__ = this;
var _44185__$1 = this;
return self__.meta44184;
}));

(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44183.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44184","meta44184",-1171196335,null)], null);
}));

(cljs.core.async.t_cljs$core$async44183.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44183");

(cljs.core.async.t_cljs$core$async44183.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44183");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44183.
 */
cljs.core.async.__GT_t_cljs$core$async44183 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44183(flag__$1,meta44184){
return (new cljs.core.async.t_cljs$core$async44183(flag__$1,meta44184));
});

}

return (new cljs.core.async.t_cljs$core$async44183(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44187 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44187 = (function (flag,cb,meta44188){
this.flag = flag;
this.cb = cb;
this.meta44188 = meta44188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44189,meta44188__$1){
var self__ = this;
var _44189__$1 = this;
return (new cljs.core.async.t_cljs$core$async44187(self__.flag,self__.cb,meta44188__$1));
}));

(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44189){
var self__ = this;
var _44189__$1 = this;
return self__.meta44188;
}));

(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44187.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44188","meta44188",653220897,null)], null);
}));

(cljs.core.async.t_cljs$core$async44187.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44187");

(cljs.core.async.t_cljs$core$async44187.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44187");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44187.
 */
cljs.core.async.__GT_t_cljs$core$async44187 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44187(flag__$1,cb__$1,meta44188){
return (new cljs.core.async.t_cljs$core$async44187(flag__$1,cb__$1,meta44188));
});

}

return (new cljs.core.async.t_cljs$core$async44187(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44202_SHARP_){
var G__44207 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44202_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44207) : fret.call(null,G__44207));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44203_SHARP_){
var G__44211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44203_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44211) : fret.call(null,G__44211));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47936 = (i + (1));
i = G__47936;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5754__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5754__auto__)){
var got = temp__5754__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47937 = arguments.length;
var i__4737__auto___47938 = (0);
while(true){
if((i__4737__auto___47938 < len__4736__auto___47937)){
args__4742__auto__.push((arguments[i__4737__auto___47938]));

var G__47939 = (i__4737__auto___47938 + (1));
i__4737__auto___47938 = G__47939;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44233){
var map__44235 = p__44233;
var map__44235__$1 = (((((!((map__44235 == null))))?(((((map__44235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44235):map__44235);
var opts = map__44235__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44224){
var G__44225 = cljs.core.first(seq44224);
var seq44224__$1 = cljs.core.next(seq44224);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44225,seq44224__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44262 = arguments.length;
switch (G__44262) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43974__auto___47954 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_44471){
var state_val_44478 = (state_44471[(1)]);
if((state_val_44478 === (7))){
var inst_44464 = (state_44471[(2)]);
var state_44471__$1 = state_44471;
var statearr_44486_47955 = state_44471__$1;
(statearr_44486_47955[(2)] = inst_44464);

(statearr_44486_47955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (1))){
var state_44471__$1 = state_44471;
var statearr_44488_47956 = state_44471__$1;
(statearr_44488_47956[(2)] = null);

(statearr_44488_47956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (4))){
var inst_44446 = (state_44471[(7)]);
var inst_44446__$1 = (state_44471[(2)]);
var inst_44448 = (inst_44446__$1 == null);
var state_44471__$1 = (function (){var statearr_44489 = state_44471;
(statearr_44489[(7)] = inst_44446__$1);

return statearr_44489;
})();
if(cljs.core.truth_(inst_44448)){
var statearr_44490_47958 = state_44471__$1;
(statearr_44490_47958[(1)] = (5));

} else {
var statearr_44491_47959 = state_44471__$1;
(statearr_44491_47959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (13))){
var state_44471__$1 = state_44471;
var statearr_44492_47960 = state_44471__$1;
(statearr_44492_47960[(2)] = null);

(statearr_44492_47960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (6))){
var inst_44446 = (state_44471[(7)]);
var state_44471__$1 = state_44471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44471__$1,(11),to,inst_44446);
} else {
if((state_val_44478 === (3))){
var inst_44466 = (state_44471[(2)]);
var state_44471__$1 = state_44471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44471__$1,inst_44466);
} else {
if((state_val_44478 === (12))){
var state_44471__$1 = state_44471;
var statearr_44506_47961 = state_44471__$1;
(statearr_44506_47961[(2)] = null);

(statearr_44506_47961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (2))){
var state_44471__$1 = state_44471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44471__$1,(4),from);
} else {
if((state_val_44478 === (11))){
var inst_44457 = (state_44471[(2)]);
var state_44471__$1 = state_44471;
if(cljs.core.truth_(inst_44457)){
var statearr_44515_47962 = state_44471__$1;
(statearr_44515_47962[(1)] = (12));

} else {
var statearr_44523_47964 = state_44471__$1;
(statearr_44523_47964[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (9))){
var state_44471__$1 = state_44471;
var statearr_44525_47965 = state_44471__$1;
(statearr_44525_47965[(2)] = null);

(statearr_44525_47965[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (5))){
var state_44471__$1 = state_44471;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44529_47966 = state_44471__$1;
(statearr_44529_47966[(1)] = (8));

} else {
var statearr_44530_47967 = state_44471__$1;
(statearr_44530_47967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (14))){
var inst_44462 = (state_44471[(2)]);
var state_44471__$1 = state_44471;
var statearr_44531_47968 = state_44471__$1;
(statearr_44531_47968[(2)] = inst_44462);

(statearr_44531_47968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (10))){
var inst_44454 = (state_44471[(2)]);
var state_44471__$1 = state_44471;
var statearr_44533_47971 = state_44471__$1;
(statearr_44533_47971[(2)] = inst_44454);

(statearr_44533_47971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44478 === (8))){
var inst_44451 = cljs.core.async.close_BANG_(to);
var state_44471__$1 = state_44471;
var statearr_44534_47973 = state_44471__$1;
(statearr_44534_47973[(2)] = inst_44451);

(statearr_44534_47973[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_44536 = [null,null,null,null,null,null,null,null];
(statearr_44536[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_44536[(1)] = (1));

return statearr_44536;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_44471){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44471);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44537){var ex__43598__auto__ = e44537;
var statearr_44538_47980 = state_44471;
(statearr_44538_47980[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44471[(4)]))){
var statearr_44539_47981 = state_44471;
(statearr_44539_47981[(1)] = cljs.core.first((state_44471[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47982 = state_44471;
state_44471 = G__47982;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_44471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_44471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_44540 = f__43975__auto__();
(statearr_44540[(6)] = c__43974__auto___47954);

return statearr_44540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44552){
var vec__44554 = p__44552;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44554,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44554,(1),null);
var job = vec__44554;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43974__auto___47985 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_44561){
var state_val_44562 = (state_44561[(1)]);
if((state_val_44562 === (1))){
var state_44561__$1 = state_44561;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44561__$1,(2),res,v);
} else {
if((state_val_44562 === (2))){
var inst_44558 = (state_44561[(2)]);
var inst_44559 = cljs.core.async.close_BANG_(res);
var state_44561__$1 = (function (){var statearr_44572 = state_44561;
(statearr_44572[(7)] = inst_44558);

return statearr_44572;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44561__$1,inst_44559);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_44574 = [null,null,null,null,null,null,null,null];
(statearr_44574[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__);

(statearr_44574[(1)] = (1));

return statearr_44574;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1 = (function (state_44561){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44561);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44575){var ex__43598__auto__ = e44575;
var statearr_44576_47991 = state_44561;
(statearr_44576_47991[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44561[(4)]))){
var statearr_44577_47995 = state_44561;
(statearr_44577_47995[(1)] = cljs.core.first((state_44561[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47999 = state_44561;
state_44561 = G__47999;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = function(state_44561){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1.call(this,state_44561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_44588 = f__43975__auto__();
(statearr_44588[(6)] = c__43974__auto___47985);

return statearr_44588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44606){
var vec__44607 = p__44606;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44607,(1),null);
var job = vec__44607;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___48007 = n;
var __48008 = (0);
while(true){
if((__48008 < n__4613__auto___48007)){
var G__44611_48009 = type;
var G__44611_48010__$1 = (((G__44611_48009 instanceof cljs.core.Keyword))?G__44611_48009.fqn:null);
switch (G__44611_48010__$1) {
case "compute":
var c__43974__auto___48014 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48008,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = ((function (__48008,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function (state_44628){
var state_val_44629 = (state_44628[(1)]);
if((state_val_44629 === (1))){
var state_44628__$1 = state_44628;
var statearr_44640_48033 = state_44628__$1;
(statearr_44640_48033[(2)] = null);

(statearr_44640_48033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44629 === (2))){
var state_44628__$1 = state_44628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44628__$1,(4),jobs);
} else {
if((state_val_44629 === (3))){
var inst_44626 = (state_44628[(2)]);
var state_44628__$1 = state_44628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44628__$1,inst_44626);
} else {
if((state_val_44629 === (4))){
var inst_44617 = (state_44628[(2)]);
var inst_44619 = process(inst_44617);
var state_44628__$1 = state_44628;
if(cljs.core.truth_(inst_44619)){
var statearr_44649_48044 = state_44628__$1;
(statearr_44649_48044[(1)] = (5));

} else {
var statearr_44657_48046 = state_44628__$1;
(statearr_44657_48046[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44629 === (5))){
var state_44628__$1 = state_44628;
var statearr_44661_48047 = state_44628__$1;
(statearr_44661_48047[(2)] = null);

(statearr_44661_48047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44629 === (6))){
var state_44628__$1 = state_44628;
var statearr_44664_48048 = state_44628__$1;
(statearr_44664_48048[(2)] = null);

(statearr_44664_48048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44629 === (7))){
var inst_44624 = (state_44628[(2)]);
var state_44628__$1 = state_44628;
var statearr_44665_48049 = state_44628__$1;
(statearr_44665_48049[(2)] = inst_44624);

(statearr_44665_48049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48008,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
;
return ((function (__48008,switch__43594__auto__,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_44666 = [null,null,null,null,null,null,null];
(statearr_44666[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__);

(statearr_44666[(1)] = (1));

return statearr_44666;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1 = (function (state_44628){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44628);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44667){var ex__43598__auto__ = e44667;
var statearr_44669_48058 = state_44628;
(statearr_44669_48058[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44628[(4)]))){
var statearr_44670_48061 = state_44628;
(statearr_44670_48061[(1)] = cljs.core.first((state_44628[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48062 = state_44628;
state_44628 = G__48062;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = function(state_44628){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1.call(this,state_44628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__;
})()
;})(__48008,switch__43594__auto__,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
})();
var state__43976__auto__ = (function (){var statearr_44672 = f__43975__auto__();
(statearr_44672[(6)] = c__43974__auto___48014);

return statearr_44672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
});})(__48008,c__43974__auto___48014,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
);


break;
case "async":
var c__43974__auto___48067 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48008,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = ((function (__48008,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function (state_44692){
var state_val_44693 = (state_44692[(1)]);
if((state_val_44693 === (1))){
var state_44692__$1 = state_44692;
var statearr_44710_48073 = state_44692__$1;
(statearr_44710_48073[(2)] = null);

(statearr_44710_48073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44693 === (2))){
var state_44692__$1 = state_44692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44692__$1,(4),jobs);
} else {
if((state_val_44693 === (3))){
var inst_44690 = (state_44692[(2)]);
var state_44692__$1 = state_44692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44692__$1,inst_44690);
} else {
if((state_val_44693 === (4))){
var inst_44678 = (state_44692[(2)]);
var inst_44683 = async(inst_44678);
var state_44692__$1 = state_44692;
if(cljs.core.truth_(inst_44683)){
var statearr_44723_48075 = state_44692__$1;
(statearr_44723_48075[(1)] = (5));

} else {
var statearr_44724_48077 = state_44692__$1;
(statearr_44724_48077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44693 === (5))){
var state_44692__$1 = state_44692;
var statearr_44725_48079 = state_44692__$1;
(statearr_44725_48079[(2)] = null);

(statearr_44725_48079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44693 === (6))){
var state_44692__$1 = state_44692;
var statearr_44726_48080 = state_44692__$1;
(statearr_44726_48080[(2)] = null);

(statearr_44726_48080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44693 === (7))){
var inst_44688 = (state_44692[(2)]);
var state_44692__$1 = state_44692;
var statearr_44733_48081 = state_44692__$1;
(statearr_44733_48081[(2)] = inst_44688);

(statearr_44733_48081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48008,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
;
return ((function (__48008,switch__43594__auto__,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_44734 = [null,null,null,null,null,null,null];
(statearr_44734[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__);

(statearr_44734[(1)] = (1));

return statearr_44734;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1 = (function (state_44692){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44692);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44735){var ex__43598__auto__ = e44735;
var statearr_44736_48088 = state_44692;
(statearr_44736_48088[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44692[(4)]))){
var statearr_44737_48089 = state_44692;
(statearr_44737_48089[(1)] = cljs.core.first((state_44692[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48090 = state_44692;
state_44692 = G__48090;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = function(state_44692){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1.call(this,state_44692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__;
})()
;})(__48008,switch__43594__auto__,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
})();
var state__43976__auto__ = (function (){var statearr_44740 = f__43975__auto__();
(statearr_44740[(6)] = c__43974__auto___48067);

return statearr_44740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
});})(__48008,c__43974__auto___48067,G__44611_48009,G__44611_48010__$1,n__4613__auto___48007,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44611_48010__$1)].join('')));

}

var G__48094 = (__48008 + (1));
__48008 = G__48094;
continue;
} else {
}
break;
}

var c__43974__auto___48095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_44778){
var state_val_44779 = (state_44778[(1)]);
if((state_val_44779 === (7))){
var inst_44773 = (state_44778[(2)]);
var state_44778__$1 = state_44778;
var statearr_44783_48098 = state_44778__$1;
(statearr_44783_48098[(2)] = inst_44773);

(statearr_44783_48098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44779 === (1))){
var state_44778__$1 = state_44778;
var statearr_44784_48100 = state_44778__$1;
(statearr_44784_48100[(2)] = null);

(statearr_44784_48100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44779 === (4))){
var inst_44744 = (state_44778[(7)]);
var inst_44744__$1 = (state_44778[(2)]);
var inst_44745 = (inst_44744__$1 == null);
var state_44778__$1 = (function (){var statearr_44790 = state_44778;
(statearr_44790[(7)] = inst_44744__$1);

return statearr_44790;
})();
if(cljs.core.truth_(inst_44745)){
var statearr_44793_48101 = state_44778__$1;
(statearr_44793_48101[(1)] = (5));

} else {
var statearr_44794_48102 = state_44778__$1;
(statearr_44794_48102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44779 === (6))){
var inst_44744 = (state_44778[(7)]);
var inst_44753 = (state_44778[(8)]);
var inst_44753__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44765 = [inst_44744,inst_44753__$1];
var inst_44766 = (new cljs.core.PersistentVector(null,2,(5),inst_44764,inst_44765,null));
var state_44778__$1 = (function (){var statearr_44800 = state_44778;
(statearr_44800[(8)] = inst_44753__$1);

return statearr_44800;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44778__$1,(8),jobs,inst_44766);
} else {
if((state_val_44779 === (3))){
var inst_44775 = (state_44778[(2)]);
var state_44778__$1 = state_44778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44778__$1,inst_44775);
} else {
if((state_val_44779 === (2))){
var state_44778__$1 = state_44778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44778__$1,(4),from);
} else {
if((state_val_44779 === (9))){
var inst_44770 = (state_44778[(2)]);
var state_44778__$1 = (function (){var statearr_44807 = state_44778;
(statearr_44807[(9)] = inst_44770);

return statearr_44807;
})();
var statearr_44812_48111 = state_44778__$1;
(statearr_44812_48111[(2)] = null);

(statearr_44812_48111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44779 === (5))){
var inst_44748 = cljs.core.async.close_BANG_(jobs);
var state_44778__$1 = state_44778;
var statearr_44813_48114 = state_44778__$1;
(statearr_44813_48114[(2)] = inst_44748);

(statearr_44813_48114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44779 === (8))){
var inst_44753 = (state_44778[(8)]);
var inst_44768 = (state_44778[(2)]);
var state_44778__$1 = (function (){var statearr_44814 = state_44778;
(statearr_44814[(10)] = inst_44768);

return statearr_44814;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44778__$1,(9),results,inst_44753);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_44818 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44818[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__);

(statearr_44818[(1)] = (1));

return statearr_44818;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1 = (function (state_44778){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44778);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44820){var ex__43598__auto__ = e44820;
var statearr_44822_48121 = state_44778;
(statearr_44822_48121[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44778[(4)]))){
var statearr_44824_48124 = state_44778;
(statearr_44824_48124[(1)] = cljs.core.first((state_44778[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48125 = state_44778;
state_44778 = G__48125;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = function(state_44778){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1.call(this,state_44778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_44826 = f__43975__auto__();
(statearr_44826[(6)] = c__43974__auto___48095);

return statearr_44826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_44869){
var state_val_44870 = (state_44869[(1)]);
if((state_val_44870 === (7))){
var inst_44865 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
var statearr_44878_48137 = state_44869__$1;
(statearr_44878_48137[(2)] = inst_44865);

(statearr_44878_48137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (20))){
var state_44869__$1 = state_44869;
var statearr_44879_48140 = state_44869__$1;
(statearr_44879_48140[(2)] = null);

(statearr_44879_48140[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (1))){
var state_44869__$1 = state_44869;
var statearr_44880_48145 = state_44869__$1;
(statearr_44880_48145[(2)] = null);

(statearr_44880_48145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (4))){
var inst_44830 = (state_44869[(7)]);
var inst_44830__$1 = (state_44869[(2)]);
var inst_44831 = (inst_44830__$1 == null);
var state_44869__$1 = (function (){var statearr_44882 = state_44869;
(statearr_44882[(7)] = inst_44830__$1);

return statearr_44882;
})();
if(cljs.core.truth_(inst_44831)){
var statearr_44883_48154 = state_44869__$1;
(statearr_44883_48154[(1)] = (5));

} else {
var statearr_44884_48155 = state_44869__$1;
(statearr_44884_48155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (15))){
var inst_44843 = (state_44869[(8)]);
var state_44869__$1 = state_44869;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44869__$1,(18),to,inst_44843);
} else {
if((state_val_44870 === (21))){
var inst_44860 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
var statearr_44887_48157 = state_44869__$1;
(statearr_44887_48157[(2)] = inst_44860);

(statearr_44887_48157[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (13))){
var inst_44862 = (state_44869[(2)]);
var state_44869__$1 = (function (){var statearr_44891 = state_44869;
(statearr_44891[(9)] = inst_44862);

return statearr_44891;
})();
var statearr_44892_48167 = state_44869__$1;
(statearr_44892_48167[(2)] = null);

(statearr_44892_48167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (6))){
var inst_44830 = (state_44869[(7)]);
var state_44869__$1 = state_44869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44869__$1,(11),inst_44830);
} else {
if((state_val_44870 === (17))){
var inst_44852 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
if(cljs.core.truth_(inst_44852)){
var statearr_44894_48172 = state_44869__$1;
(statearr_44894_48172[(1)] = (19));

} else {
var statearr_44896_48173 = state_44869__$1;
(statearr_44896_48173[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (3))){
var inst_44867 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44869__$1,inst_44867);
} else {
if((state_val_44870 === (12))){
var inst_44840 = (state_44869[(10)]);
var state_44869__$1 = state_44869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44869__$1,(14),inst_44840);
} else {
if((state_val_44870 === (2))){
var state_44869__$1 = state_44869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44869__$1,(4),results);
} else {
if((state_val_44870 === (19))){
var state_44869__$1 = state_44869;
var statearr_44900_48179 = state_44869__$1;
(statearr_44900_48179[(2)] = null);

(statearr_44900_48179[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (11))){
var inst_44840 = (state_44869[(2)]);
var state_44869__$1 = (function (){var statearr_44902 = state_44869;
(statearr_44902[(10)] = inst_44840);

return statearr_44902;
})();
var statearr_44911_48182 = state_44869__$1;
(statearr_44911_48182[(2)] = null);

(statearr_44911_48182[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (9))){
var state_44869__$1 = state_44869;
var statearr_44912_48185 = state_44869__$1;
(statearr_44912_48185[(2)] = null);

(statearr_44912_48185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (5))){
var state_44869__$1 = state_44869;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44913_48188 = state_44869__$1;
(statearr_44913_48188[(1)] = (8));

} else {
var statearr_44916_48189 = state_44869__$1;
(statearr_44916_48189[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (14))){
var inst_44843 = (state_44869[(8)]);
var inst_44843__$1 = (state_44869[(2)]);
var inst_44845 = (inst_44843__$1 == null);
var inst_44846 = cljs.core.not(inst_44845);
var state_44869__$1 = (function (){var statearr_44920 = state_44869;
(statearr_44920[(8)] = inst_44843__$1);

return statearr_44920;
})();
if(inst_44846){
var statearr_44921_48192 = state_44869__$1;
(statearr_44921_48192[(1)] = (15));

} else {
var statearr_44924_48194 = state_44869__$1;
(statearr_44924_48194[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (16))){
var state_44869__$1 = state_44869;
var statearr_44927_48195 = state_44869__$1;
(statearr_44927_48195[(2)] = false);

(statearr_44927_48195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (10))){
var inst_44837 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
var statearr_44930_48197 = state_44869__$1;
(statearr_44930_48197[(2)] = inst_44837);

(statearr_44930_48197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (18))){
var inst_44849 = (state_44869[(2)]);
var state_44869__$1 = state_44869;
var statearr_44931_48202 = state_44869__$1;
(statearr_44931_48202[(2)] = inst_44849);

(statearr_44931_48202[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44870 === (8))){
var inst_44834 = cljs.core.async.close_BANG_(to);
var state_44869__$1 = state_44869;
var statearr_44933_48203 = state_44869__$1;
(statearr_44933_48203[(2)] = inst_44834);

(statearr_44933_48203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_44942 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44942[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__);

(statearr_44942[(1)] = (1));

return statearr_44942;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1 = (function (state_44869){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_44869);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e44944){var ex__43598__auto__ = e44944;
var statearr_44946_48212 = state_44869;
(statearr_44946_48212[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_44869[(4)]))){
var statearr_44948_48213 = state_44869;
(statearr_44948_48213[(1)] = cljs.core.first((state_44869[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48215 = state_44869;
state_44869 = G__48215;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__ = function(state_44869){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1.call(this,state_44869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_44950 = f__43975__auto__();
(statearr_44950[(6)] = c__43974__auto__);

return statearr_44950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44957 = arguments.length;
switch (G__44957) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44973 = arguments.length;
switch (G__44973) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44990 = arguments.length;
switch (G__44990) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43974__auto___48257 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_45021){
var state_val_45022 = (state_45021[(1)]);
if((state_val_45022 === (7))){
var inst_45017 = (state_45021[(2)]);
var state_45021__$1 = state_45021;
var statearr_45027_48261 = state_45021__$1;
(statearr_45027_48261[(2)] = inst_45017);

(statearr_45027_48261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (1))){
var state_45021__$1 = state_45021;
var statearr_45030_48263 = state_45021__$1;
(statearr_45030_48263[(2)] = null);

(statearr_45030_48263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (4))){
var inst_44998 = (state_45021[(7)]);
var inst_44998__$1 = (state_45021[(2)]);
var inst_44999 = (inst_44998__$1 == null);
var state_45021__$1 = (function (){var statearr_45032 = state_45021;
(statearr_45032[(7)] = inst_44998__$1);

return statearr_45032;
})();
if(cljs.core.truth_(inst_44999)){
var statearr_45033_48271 = state_45021__$1;
(statearr_45033_48271[(1)] = (5));

} else {
var statearr_45034_48272 = state_45021__$1;
(statearr_45034_48272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (13))){
var state_45021__$1 = state_45021;
var statearr_45036_48276 = state_45021__$1;
(statearr_45036_48276[(2)] = null);

(statearr_45036_48276[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (6))){
var inst_44998 = (state_45021[(7)]);
var inst_45004 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44998) : p.call(null,inst_44998));
var state_45021__$1 = state_45021;
if(cljs.core.truth_(inst_45004)){
var statearr_45045_48278 = state_45021__$1;
(statearr_45045_48278[(1)] = (9));

} else {
var statearr_45047_48279 = state_45021__$1;
(statearr_45047_48279[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (3))){
var inst_45019 = (state_45021[(2)]);
var state_45021__$1 = state_45021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45021__$1,inst_45019);
} else {
if((state_val_45022 === (12))){
var state_45021__$1 = state_45021;
var statearr_45051_48285 = state_45021__$1;
(statearr_45051_48285[(2)] = null);

(statearr_45051_48285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (2))){
var state_45021__$1 = state_45021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45021__$1,(4),ch);
} else {
if((state_val_45022 === (11))){
var inst_44998 = (state_45021[(7)]);
var inst_45008 = (state_45021[(2)]);
var state_45021__$1 = state_45021;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45021__$1,(8),inst_45008,inst_44998);
} else {
if((state_val_45022 === (9))){
var state_45021__$1 = state_45021;
var statearr_45059_48286 = state_45021__$1;
(statearr_45059_48286[(2)] = tc);

(statearr_45059_48286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (5))){
var inst_45001 = cljs.core.async.close_BANG_(tc);
var inst_45002 = cljs.core.async.close_BANG_(fc);
var state_45021__$1 = (function (){var statearr_45061 = state_45021;
(statearr_45061[(8)] = inst_45001);

return statearr_45061;
})();
var statearr_45063_48287 = state_45021__$1;
(statearr_45063_48287[(2)] = inst_45002);

(statearr_45063_48287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (14))){
var inst_45015 = (state_45021[(2)]);
var state_45021__$1 = state_45021;
var statearr_45065_48291 = state_45021__$1;
(statearr_45065_48291[(2)] = inst_45015);

(statearr_45065_48291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (10))){
var state_45021__$1 = state_45021;
var statearr_45068_48292 = state_45021__$1;
(statearr_45068_48292[(2)] = fc);

(statearr_45068_48292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45022 === (8))){
var inst_45010 = (state_45021[(2)]);
var state_45021__$1 = state_45021;
if(cljs.core.truth_(inst_45010)){
var statearr_45073_48297 = state_45021__$1;
(statearr_45073_48297[(1)] = (12));

} else {
var statearr_45075_48298 = state_45021__$1;
(statearr_45075_48298[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_45079 = [null,null,null,null,null,null,null,null,null];
(statearr_45079[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_45079[(1)] = (1));

return statearr_45079;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_45021){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_45021);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e45080){var ex__43598__auto__ = e45080;
var statearr_45082_48310 = state_45021;
(statearr_45082_48310[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_45021[(4)]))){
var statearr_45083_48313 = state_45021;
(statearr_45083_48313[(1)] = cljs.core.first((state_45021[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48318 = state_45021;
state_45021 = G__48318;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_45021){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_45021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_45086 = f__43975__auto__();
(statearr_45086[(6)] = c__43974__auto___48257);

return statearr_45086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_45125){
var state_val_45126 = (state_45125[(1)]);
if((state_val_45126 === (7))){
var inst_45116 = (state_45125[(2)]);
var state_45125__$1 = state_45125;
var statearr_45131_48326 = state_45125__$1;
(statearr_45131_48326[(2)] = inst_45116);

(statearr_45131_48326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (1))){
var inst_45099 = init;
var inst_45100 = inst_45099;
var state_45125__$1 = (function (){var statearr_45133 = state_45125;
(statearr_45133[(7)] = inst_45100);

return statearr_45133;
})();
var statearr_45134_48334 = state_45125__$1;
(statearr_45134_48334[(2)] = null);

(statearr_45134_48334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (4))){
var inst_45103 = (state_45125[(8)]);
var inst_45103__$1 = (state_45125[(2)]);
var inst_45104 = (inst_45103__$1 == null);
var state_45125__$1 = (function (){var statearr_45137 = state_45125;
(statearr_45137[(8)] = inst_45103__$1);

return statearr_45137;
})();
if(cljs.core.truth_(inst_45104)){
var statearr_45138_48340 = state_45125__$1;
(statearr_45138_48340[(1)] = (5));

} else {
var statearr_45140_48341 = state_45125__$1;
(statearr_45140_48341[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (6))){
var inst_45107 = (state_45125[(9)]);
var inst_45100 = (state_45125[(7)]);
var inst_45103 = (state_45125[(8)]);
var inst_45107__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45100,inst_45103) : f.call(null,inst_45100,inst_45103));
var inst_45108 = cljs.core.reduced_QMARK_(inst_45107__$1);
var state_45125__$1 = (function (){var statearr_45142 = state_45125;
(statearr_45142[(9)] = inst_45107__$1);

return statearr_45142;
})();
if(inst_45108){
var statearr_45145_48349 = state_45125__$1;
(statearr_45145_48349[(1)] = (8));

} else {
var statearr_45146_48350 = state_45125__$1;
(statearr_45146_48350[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (3))){
var inst_45118 = (state_45125[(2)]);
var state_45125__$1 = state_45125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45125__$1,inst_45118);
} else {
if((state_val_45126 === (2))){
var state_45125__$1 = state_45125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45125__$1,(4),ch);
} else {
if((state_val_45126 === (9))){
var inst_45107 = (state_45125[(9)]);
var inst_45100 = inst_45107;
var state_45125__$1 = (function (){var statearr_45149 = state_45125;
(statearr_45149[(7)] = inst_45100);

return statearr_45149;
})();
var statearr_45150_48351 = state_45125__$1;
(statearr_45150_48351[(2)] = null);

(statearr_45150_48351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (5))){
var inst_45100 = (state_45125[(7)]);
var state_45125__$1 = state_45125;
var statearr_45152_48354 = state_45125__$1;
(statearr_45152_48354[(2)] = inst_45100);

(statearr_45152_48354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (10))){
var inst_45114 = (state_45125[(2)]);
var state_45125__$1 = state_45125;
var statearr_45153_48356 = state_45125__$1;
(statearr_45153_48356[(2)] = inst_45114);

(statearr_45153_48356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45126 === (8))){
var inst_45107 = (state_45125[(9)]);
var inst_45110 = cljs.core.deref(inst_45107);
var state_45125__$1 = state_45125;
var statearr_45154_48361 = state_45125__$1;
(statearr_45154_48361[(2)] = inst_45110);

(statearr_45154_48361[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43595__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43595__auto____0 = (function (){
var statearr_45162 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45162[(0)] = cljs$core$async$reduce_$_state_machine__43595__auto__);

(statearr_45162[(1)] = (1));

return statearr_45162;
});
var cljs$core$async$reduce_$_state_machine__43595__auto____1 = (function (state_45125){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_45125);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e45164){var ex__43598__auto__ = e45164;
var statearr_45165_48368 = state_45125;
(statearr_45165_48368[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_45125[(4)]))){
var statearr_45168_48370 = state_45125;
(statearr_45168_48370[(1)] = cljs.core.first((state_45125[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48372 = state_45125;
state_45125 = G__48372;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43595__auto__ = function(state_45125){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43595__auto____1.call(this,state_45125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43595__auto____0;
cljs$core$async$reduce_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43595__auto____1;
return cljs$core$async$reduce_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_45172 = f__43975__auto__();
(statearr_45172[(6)] = c__43974__auto__);

return statearr_45172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_45182){
var state_val_45183 = (state_45182[(1)]);
if((state_val_45183 === (1))){
var inst_45177 = cljs.core.async.reduce(f__$1,init,ch);
var state_45182__$1 = state_45182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45182__$1,(2),inst_45177);
} else {
if((state_val_45183 === (2))){
var inst_45179 = (state_45182[(2)]);
var inst_45180 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45179) : f__$1.call(null,inst_45179));
var state_45182__$1 = state_45182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45182__$1,inst_45180);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43595__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43595__auto____0 = (function (){
var statearr_45186 = [null,null,null,null,null,null,null];
(statearr_45186[(0)] = cljs$core$async$transduce_$_state_machine__43595__auto__);

(statearr_45186[(1)] = (1));

return statearr_45186;
});
var cljs$core$async$transduce_$_state_machine__43595__auto____1 = (function (state_45182){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_45182);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e45187){var ex__43598__auto__ = e45187;
var statearr_45190_48390 = state_45182;
(statearr_45190_48390[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_45182[(4)]))){
var statearr_45193_48391 = state_45182;
(statearr_45193_48391[(1)] = cljs.core.first((state_45182[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48396 = state_45182;
state_45182 = G__48396;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43595__auto__ = function(state_45182){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43595__auto____1.call(this,state_45182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43595__auto____0;
cljs$core$async$transduce_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43595__auto____1;
return cljs$core$async$transduce_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_45198 = f__43975__auto__();
(statearr_45198[(6)] = c__43974__auto__);

return statearr_45198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45210 = arguments.length;
switch (G__45210) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_45239){
var state_val_45240 = (state_45239[(1)]);
if((state_val_45240 === (7))){
var inst_45220 = (state_45239[(2)]);
var state_45239__$1 = state_45239;
var statearr_45248_48408 = state_45239__$1;
(statearr_45248_48408[(2)] = inst_45220);

(statearr_45248_48408[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (1))){
var inst_45211 = cljs.core.seq(coll);
var inst_45212 = inst_45211;
var state_45239__$1 = (function (){var statearr_45253 = state_45239;
(statearr_45253[(7)] = inst_45212);

return statearr_45253;
})();
var statearr_45254_48414 = state_45239__$1;
(statearr_45254_48414[(2)] = null);

(statearr_45254_48414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (4))){
var inst_45212 = (state_45239[(7)]);
var inst_45218 = cljs.core.first(inst_45212);
var state_45239__$1 = state_45239;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45239__$1,(7),ch,inst_45218);
} else {
if((state_val_45240 === (13))){
var inst_45233 = (state_45239[(2)]);
var state_45239__$1 = state_45239;
var statearr_45258_48419 = state_45239__$1;
(statearr_45258_48419[(2)] = inst_45233);

(statearr_45258_48419[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (6))){
var inst_45223 = (state_45239[(2)]);
var state_45239__$1 = state_45239;
if(cljs.core.truth_(inst_45223)){
var statearr_45263_48420 = state_45239__$1;
(statearr_45263_48420[(1)] = (8));

} else {
var statearr_45264_48424 = state_45239__$1;
(statearr_45264_48424[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (3))){
var inst_45237 = (state_45239[(2)]);
var state_45239__$1 = state_45239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45239__$1,inst_45237);
} else {
if((state_val_45240 === (12))){
var state_45239__$1 = state_45239;
var statearr_45272_48428 = state_45239__$1;
(statearr_45272_48428[(2)] = null);

(statearr_45272_48428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (2))){
var inst_45212 = (state_45239[(7)]);
var state_45239__$1 = state_45239;
if(cljs.core.truth_(inst_45212)){
var statearr_45273_48430 = state_45239__$1;
(statearr_45273_48430[(1)] = (4));

} else {
var statearr_45274_48431 = state_45239__$1;
(statearr_45274_48431[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (11))){
var inst_45230 = cljs.core.async.close_BANG_(ch);
var state_45239__$1 = state_45239;
var statearr_45275_48436 = state_45239__$1;
(statearr_45275_48436[(2)] = inst_45230);

(statearr_45275_48436[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (9))){
var state_45239__$1 = state_45239;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45276_48439 = state_45239__$1;
(statearr_45276_48439[(1)] = (11));

} else {
var statearr_45277_48440 = state_45239__$1;
(statearr_45277_48440[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (5))){
var inst_45212 = (state_45239[(7)]);
var state_45239__$1 = state_45239;
var statearr_45281_48445 = state_45239__$1;
(statearr_45281_48445[(2)] = inst_45212);

(statearr_45281_48445[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (10))){
var inst_45235 = (state_45239[(2)]);
var state_45239__$1 = state_45239;
var statearr_45283_48448 = state_45239__$1;
(statearr_45283_48448[(2)] = inst_45235);

(statearr_45283_48448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45240 === (8))){
var inst_45212 = (state_45239[(7)]);
var inst_45226 = cljs.core.next(inst_45212);
var inst_45212__$1 = inst_45226;
var state_45239__$1 = (function (){var statearr_45287 = state_45239;
(statearr_45287[(7)] = inst_45212__$1);

return statearr_45287;
})();
var statearr_45289_48458 = state_45239__$1;
(statearr_45289_48458[(2)] = null);

(statearr_45289_48458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_45290 = [null,null,null,null,null,null,null,null];
(statearr_45290[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_45290[(1)] = (1));

return statearr_45290;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_45239){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_45239);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e45291){var ex__43598__auto__ = e45291;
var statearr_45292_48467 = state_45239;
(statearr_45292_48467[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_45239[(4)]))){
var statearr_45293_48470 = state_45239;
(statearr_45293_48470[(1)] = cljs.core.first((state_45239[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48472 = state_45239;
state_45239 = G__48472;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_45239){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_45239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_45296 = f__43975__auto__();
(statearr_45296[(6)] = c__43974__auto__);

return statearr_45296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45301 = arguments.length;
switch (G__45301) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_48478 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_48478(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_48479 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_48479(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_48488 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_48488(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_48502 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_48502(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45337 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45337 = (function (ch,cs,meta45338){
this.ch = ch;
this.cs = cs;
this.meta45338 = meta45338;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45339,meta45338__$1){
var self__ = this;
var _45339__$1 = this;
return (new cljs.core.async.t_cljs$core$async45337(self__.ch,self__.cs,meta45338__$1));
}));

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45339){
var self__ = this;
var _45339__$1 = this;
return self__.meta45338;
}));

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45337.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45337.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45338","meta45338",-321627486,null)], null);
}));

(cljs.core.async.t_cljs$core$async45337.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45337.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45337");

(cljs.core.async.t_cljs$core$async45337.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45337");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45337.
 */
cljs.core.async.__GT_t_cljs$core$async45337 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45337(ch__$1,cs__$1,meta45338){
return (new cljs.core.async.t_cljs$core$async45337(ch__$1,cs__$1,meta45338));
});

}

return (new cljs.core.async.t_cljs$core$async45337(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43974__auto___48521 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_45527){
var state_val_45529 = (state_45527[(1)]);
if((state_val_45529 === (7))){
var inst_45521 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45532_48522 = state_45527__$1;
(statearr_45532_48522[(2)] = inst_45521);

(statearr_45532_48522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (20))){
var inst_45409 = (state_45527[(7)]);
var inst_45428 = cljs.core.first(inst_45409);
var inst_45429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45428,(0),null);
var inst_45430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45428,(1),null);
var state_45527__$1 = (function (){var statearr_45538 = state_45527;
(statearr_45538[(8)] = inst_45429);

return statearr_45538;
})();
if(cljs.core.truth_(inst_45430)){
var statearr_45539_48531 = state_45527__$1;
(statearr_45539_48531[(1)] = (22));

} else {
var statearr_45540_48532 = state_45527__$1;
(statearr_45540_48532[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (27))){
var inst_45372 = (state_45527[(9)]);
var inst_45473 = (state_45527[(10)]);
var inst_45463 = (state_45527[(11)]);
var inst_45465 = (state_45527[(12)]);
var inst_45473__$1 = cljs.core._nth(inst_45463,inst_45465);
var inst_45475 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45473__$1,inst_45372,done);
var state_45527__$1 = (function (){var statearr_45543 = state_45527;
(statearr_45543[(10)] = inst_45473__$1);

return statearr_45543;
})();
if(cljs.core.truth_(inst_45475)){
var statearr_45548_48537 = state_45527__$1;
(statearr_45548_48537[(1)] = (30));

} else {
var statearr_45549_48538 = state_45527__$1;
(statearr_45549_48538[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (1))){
var state_45527__$1 = state_45527;
var statearr_45552_48539 = state_45527__$1;
(statearr_45552_48539[(2)] = null);

(statearr_45552_48539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (24))){
var inst_45409 = (state_45527[(7)]);
var inst_45435 = (state_45527[(2)]);
var inst_45436 = cljs.core.next(inst_45409);
var inst_45382 = inst_45436;
var inst_45383 = null;
var inst_45384 = (0);
var inst_45385 = (0);
var state_45527__$1 = (function (){var statearr_45555 = state_45527;
(statearr_45555[(13)] = inst_45435);

(statearr_45555[(14)] = inst_45384);

(statearr_45555[(15)] = inst_45385);

(statearr_45555[(16)] = inst_45382);

(statearr_45555[(17)] = inst_45383);

return statearr_45555;
})();
var statearr_45556_48542 = state_45527__$1;
(statearr_45556_48542[(2)] = null);

(statearr_45556_48542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (39))){
var state_45527__$1 = state_45527;
var statearr_45565_48549 = state_45527__$1;
(statearr_45565_48549[(2)] = null);

(statearr_45565_48549[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (4))){
var inst_45372 = (state_45527[(9)]);
var inst_45372__$1 = (state_45527[(2)]);
var inst_45373 = (inst_45372__$1 == null);
var state_45527__$1 = (function (){var statearr_45566 = state_45527;
(statearr_45566[(9)] = inst_45372__$1);

return statearr_45566;
})();
if(cljs.core.truth_(inst_45373)){
var statearr_45568_48552 = state_45527__$1;
(statearr_45568_48552[(1)] = (5));

} else {
var statearr_45571_48553 = state_45527__$1;
(statearr_45571_48553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (15))){
var inst_45384 = (state_45527[(14)]);
var inst_45385 = (state_45527[(15)]);
var inst_45382 = (state_45527[(16)]);
var inst_45383 = (state_45527[(17)]);
var inst_45405 = (state_45527[(2)]);
var inst_45406 = (inst_45385 + (1));
var tmp45558 = inst_45384;
var tmp45559 = inst_45382;
var tmp45560 = inst_45383;
var inst_45382__$1 = tmp45559;
var inst_45383__$1 = tmp45560;
var inst_45384__$1 = tmp45558;
var inst_45385__$1 = inst_45406;
var state_45527__$1 = (function (){var statearr_45577 = state_45527;
(statearr_45577[(14)] = inst_45384__$1);

(statearr_45577[(18)] = inst_45405);

(statearr_45577[(15)] = inst_45385__$1);

(statearr_45577[(16)] = inst_45382__$1);

(statearr_45577[(17)] = inst_45383__$1);

return statearr_45577;
})();
var statearr_45579_48558 = state_45527__$1;
(statearr_45579_48558[(2)] = null);

(statearr_45579_48558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (21))){
var inst_45439 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45586_48559 = state_45527__$1;
(statearr_45586_48559[(2)] = inst_45439);

(statearr_45586_48559[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (31))){
var inst_45473 = (state_45527[(10)]);
var inst_45479 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45473);
var state_45527__$1 = state_45527;
var statearr_45588_48564 = state_45527__$1;
(statearr_45588_48564[(2)] = inst_45479);

(statearr_45588_48564[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (32))){
var inst_45463 = (state_45527[(11)]);
var inst_45465 = (state_45527[(12)]);
var inst_45462 = (state_45527[(19)]);
var inst_45464 = (state_45527[(20)]);
var inst_45481 = (state_45527[(2)]);
var inst_45482 = (inst_45465 + (1));
var tmp45581 = inst_45463;
var tmp45582 = inst_45462;
var tmp45583 = inst_45464;
var inst_45462__$1 = tmp45582;
var inst_45463__$1 = tmp45581;
var inst_45464__$1 = tmp45583;
var inst_45465__$1 = inst_45482;
var state_45527__$1 = (function (){var statearr_45591 = state_45527;
(statearr_45591[(21)] = inst_45481);

(statearr_45591[(11)] = inst_45463__$1);

(statearr_45591[(12)] = inst_45465__$1);

(statearr_45591[(19)] = inst_45462__$1);

(statearr_45591[(20)] = inst_45464__$1);

return statearr_45591;
})();
var statearr_45596_48576 = state_45527__$1;
(statearr_45596_48576[(2)] = null);

(statearr_45596_48576[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (40))){
var inst_45494 = (state_45527[(22)]);
var inst_45498 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45494);
var state_45527__$1 = state_45527;
var statearr_45601_48577 = state_45527__$1;
(statearr_45601_48577[(2)] = inst_45498);

(statearr_45601_48577[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (33))){
var inst_45485 = (state_45527[(23)]);
var inst_45487 = cljs.core.chunked_seq_QMARK_(inst_45485);
var state_45527__$1 = state_45527;
if(inst_45487){
var statearr_45603_48579 = state_45527__$1;
(statearr_45603_48579[(1)] = (36));

} else {
var statearr_45604_48580 = state_45527__$1;
(statearr_45604_48580[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (13))){
var inst_45399 = (state_45527[(24)]);
var inst_45402 = cljs.core.async.close_BANG_(inst_45399);
var state_45527__$1 = state_45527;
var statearr_45612_48581 = state_45527__$1;
(statearr_45612_48581[(2)] = inst_45402);

(statearr_45612_48581[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (22))){
var inst_45429 = (state_45527[(8)]);
var inst_45432 = cljs.core.async.close_BANG_(inst_45429);
var state_45527__$1 = state_45527;
var statearr_45616_48582 = state_45527__$1;
(statearr_45616_48582[(2)] = inst_45432);

(statearr_45616_48582[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (36))){
var inst_45485 = (state_45527[(23)]);
var inst_45489 = cljs.core.chunk_first(inst_45485);
var inst_45490 = cljs.core.chunk_rest(inst_45485);
var inst_45491 = cljs.core.count(inst_45489);
var inst_45462 = inst_45490;
var inst_45463 = inst_45489;
var inst_45464 = inst_45491;
var inst_45465 = (0);
var state_45527__$1 = (function (){var statearr_45621 = state_45527;
(statearr_45621[(11)] = inst_45463);

(statearr_45621[(12)] = inst_45465);

(statearr_45621[(19)] = inst_45462);

(statearr_45621[(20)] = inst_45464);

return statearr_45621;
})();
var statearr_45622_48583 = state_45527__$1;
(statearr_45622_48583[(2)] = null);

(statearr_45622_48583[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (41))){
var inst_45485 = (state_45527[(23)]);
var inst_45500 = (state_45527[(2)]);
var inst_45501 = cljs.core.next(inst_45485);
var inst_45462 = inst_45501;
var inst_45463 = null;
var inst_45464 = (0);
var inst_45465 = (0);
var state_45527__$1 = (function (){var statearr_45626 = state_45527;
(statearr_45626[(25)] = inst_45500);

(statearr_45626[(11)] = inst_45463);

(statearr_45626[(12)] = inst_45465);

(statearr_45626[(19)] = inst_45462);

(statearr_45626[(20)] = inst_45464);

return statearr_45626;
})();
var statearr_45627_48584 = state_45527__$1;
(statearr_45627_48584[(2)] = null);

(statearr_45627_48584[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (43))){
var state_45527__$1 = state_45527;
var statearr_45632_48586 = state_45527__$1;
(statearr_45632_48586[(2)] = null);

(statearr_45632_48586[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (29))){
var inst_45509 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45633_48587 = state_45527__$1;
(statearr_45633_48587[(2)] = inst_45509);

(statearr_45633_48587[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (44))){
var inst_45518 = (state_45527[(2)]);
var state_45527__$1 = (function (){var statearr_45634 = state_45527;
(statearr_45634[(26)] = inst_45518);

return statearr_45634;
})();
var statearr_45636_48589 = state_45527__$1;
(statearr_45636_48589[(2)] = null);

(statearr_45636_48589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (6))){
var inst_45453 = (state_45527[(27)]);
var inst_45452 = cljs.core.deref(cs);
var inst_45453__$1 = cljs.core.keys(inst_45452);
var inst_45455 = cljs.core.count(inst_45453__$1);
var inst_45456 = cljs.core.reset_BANG_(dctr,inst_45455);
var inst_45461 = cljs.core.seq(inst_45453__$1);
var inst_45462 = inst_45461;
var inst_45463 = null;
var inst_45464 = (0);
var inst_45465 = (0);
var state_45527__$1 = (function (){var statearr_45639 = state_45527;
(statearr_45639[(27)] = inst_45453__$1);

(statearr_45639[(11)] = inst_45463);

(statearr_45639[(12)] = inst_45465);

(statearr_45639[(19)] = inst_45462);

(statearr_45639[(28)] = inst_45456);

(statearr_45639[(20)] = inst_45464);

return statearr_45639;
})();
var statearr_45640_48596 = state_45527__$1;
(statearr_45640_48596[(2)] = null);

(statearr_45640_48596[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (28))){
var inst_45485 = (state_45527[(23)]);
var inst_45462 = (state_45527[(19)]);
var inst_45485__$1 = cljs.core.seq(inst_45462);
var state_45527__$1 = (function (){var statearr_45645 = state_45527;
(statearr_45645[(23)] = inst_45485__$1);

return statearr_45645;
})();
if(inst_45485__$1){
var statearr_45646_48599 = state_45527__$1;
(statearr_45646_48599[(1)] = (33));

} else {
var statearr_45647_48600 = state_45527__$1;
(statearr_45647_48600[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (25))){
var inst_45465 = (state_45527[(12)]);
var inst_45464 = (state_45527[(20)]);
var inst_45467 = (inst_45465 < inst_45464);
var inst_45468 = inst_45467;
var state_45527__$1 = state_45527;
if(cljs.core.truth_(inst_45468)){
var statearr_45649_48603 = state_45527__$1;
(statearr_45649_48603[(1)] = (27));

} else {
var statearr_45650_48604 = state_45527__$1;
(statearr_45650_48604[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (34))){
var state_45527__$1 = state_45527;
var statearr_45651_48605 = state_45527__$1;
(statearr_45651_48605[(2)] = null);

(statearr_45651_48605[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (17))){
var state_45527__$1 = state_45527;
var statearr_45652_48606 = state_45527__$1;
(statearr_45652_48606[(2)] = null);

(statearr_45652_48606[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (3))){
var inst_45523 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45527__$1,inst_45523);
} else {
if((state_val_45529 === (12))){
var inst_45444 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45657_48610 = state_45527__$1;
(statearr_45657_48610[(2)] = inst_45444);

(statearr_45657_48610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (2))){
var state_45527__$1 = state_45527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45527__$1,(4),ch);
} else {
if((state_val_45529 === (23))){
var state_45527__$1 = state_45527;
var statearr_45659_48612 = state_45527__$1;
(statearr_45659_48612[(2)] = null);

(statearr_45659_48612[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (35))){
var inst_45507 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45660_48614 = state_45527__$1;
(statearr_45660_48614[(2)] = inst_45507);

(statearr_45660_48614[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (19))){
var inst_45409 = (state_45527[(7)]);
var inst_45416 = cljs.core.chunk_first(inst_45409);
var inst_45417 = cljs.core.chunk_rest(inst_45409);
var inst_45418 = cljs.core.count(inst_45416);
var inst_45382 = inst_45417;
var inst_45383 = inst_45416;
var inst_45384 = inst_45418;
var inst_45385 = (0);
var state_45527__$1 = (function (){var statearr_45664 = state_45527;
(statearr_45664[(14)] = inst_45384);

(statearr_45664[(15)] = inst_45385);

(statearr_45664[(16)] = inst_45382);

(statearr_45664[(17)] = inst_45383);

return statearr_45664;
})();
var statearr_45667_48617 = state_45527__$1;
(statearr_45667_48617[(2)] = null);

(statearr_45667_48617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (11))){
var inst_45409 = (state_45527[(7)]);
var inst_45382 = (state_45527[(16)]);
var inst_45409__$1 = cljs.core.seq(inst_45382);
var state_45527__$1 = (function (){var statearr_45673 = state_45527;
(statearr_45673[(7)] = inst_45409__$1);

return statearr_45673;
})();
if(inst_45409__$1){
var statearr_45674_48622 = state_45527__$1;
(statearr_45674_48622[(1)] = (16));

} else {
var statearr_45675_48623 = state_45527__$1;
(statearr_45675_48623[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (9))){
var inst_45449 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45678_48624 = state_45527__$1;
(statearr_45678_48624[(2)] = inst_45449);

(statearr_45678_48624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (5))){
var inst_45380 = cljs.core.deref(cs);
var inst_45381 = cljs.core.seq(inst_45380);
var inst_45382 = inst_45381;
var inst_45383 = null;
var inst_45384 = (0);
var inst_45385 = (0);
var state_45527__$1 = (function (){var statearr_45680 = state_45527;
(statearr_45680[(14)] = inst_45384);

(statearr_45680[(15)] = inst_45385);

(statearr_45680[(16)] = inst_45382);

(statearr_45680[(17)] = inst_45383);

return statearr_45680;
})();
var statearr_45682_48629 = state_45527__$1;
(statearr_45682_48629[(2)] = null);

(statearr_45682_48629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (14))){
var state_45527__$1 = state_45527;
var statearr_45683_48631 = state_45527__$1;
(statearr_45683_48631[(2)] = null);

(statearr_45683_48631[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (45))){
var inst_45515 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45685_48635 = state_45527__$1;
(statearr_45685_48635[(2)] = inst_45515);

(statearr_45685_48635[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (26))){
var inst_45453 = (state_45527[(27)]);
var inst_45511 = (state_45527[(2)]);
var inst_45512 = cljs.core.seq(inst_45453);
var state_45527__$1 = (function (){var statearr_45692 = state_45527;
(statearr_45692[(29)] = inst_45511);

return statearr_45692;
})();
if(inst_45512){
var statearr_45695_48636 = state_45527__$1;
(statearr_45695_48636[(1)] = (42));

} else {
var statearr_45697_48637 = state_45527__$1;
(statearr_45697_48637[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (16))){
var inst_45409 = (state_45527[(7)]);
var inst_45412 = cljs.core.chunked_seq_QMARK_(inst_45409);
var state_45527__$1 = state_45527;
if(inst_45412){
var statearr_45700_48638 = state_45527__$1;
(statearr_45700_48638[(1)] = (19));

} else {
var statearr_45701_48639 = state_45527__$1;
(statearr_45701_48639[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (38))){
var inst_45504 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45704_48641 = state_45527__$1;
(statearr_45704_48641[(2)] = inst_45504);

(statearr_45704_48641[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (30))){
var state_45527__$1 = state_45527;
var statearr_45707_48642 = state_45527__$1;
(statearr_45707_48642[(2)] = null);

(statearr_45707_48642[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (10))){
var inst_45385 = (state_45527[(15)]);
var inst_45383 = (state_45527[(17)]);
var inst_45398 = cljs.core._nth(inst_45383,inst_45385);
var inst_45399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45398,(0),null);
var inst_45400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45398,(1),null);
var state_45527__$1 = (function (){var statearr_45709 = state_45527;
(statearr_45709[(24)] = inst_45399);

return statearr_45709;
})();
if(cljs.core.truth_(inst_45400)){
var statearr_45710_48647 = state_45527__$1;
(statearr_45710_48647[(1)] = (13));

} else {
var statearr_45711_48648 = state_45527__$1;
(statearr_45711_48648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (18))){
var inst_45442 = (state_45527[(2)]);
var state_45527__$1 = state_45527;
var statearr_45717_48649 = state_45527__$1;
(statearr_45717_48649[(2)] = inst_45442);

(statearr_45717_48649[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (42))){
var state_45527__$1 = state_45527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45527__$1,(45),dchan);
} else {
if((state_val_45529 === (37))){
var inst_45372 = (state_45527[(9)]);
var inst_45485 = (state_45527[(23)]);
var inst_45494 = (state_45527[(22)]);
var inst_45494__$1 = cljs.core.first(inst_45485);
var inst_45495 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45494__$1,inst_45372,done);
var state_45527__$1 = (function (){var statearr_45725 = state_45527;
(statearr_45725[(22)] = inst_45494__$1);

return statearr_45725;
})();
if(cljs.core.truth_(inst_45495)){
var statearr_45726_48651 = state_45527__$1;
(statearr_45726_48651[(1)] = (39));

} else {
var statearr_45730_48652 = state_45527__$1;
(statearr_45730_48652[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45529 === (8))){
var inst_45384 = (state_45527[(14)]);
var inst_45385 = (state_45527[(15)]);
var inst_45392 = (inst_45385 < inst_45384);
var inst_45393 = inst_45392;
var state_45527__$1 = state_45527;
if(cljs.core.truth_(inst_45393)){
var statearr_45732_48654 = state_45527__$1;
(statearr_45732_48654[(1)] = (10));

} else {
var statearr_45733_48655 = state_45527__$1;
(statearr_45733_48655[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43595__auto__ = null;
var cljs$core$async$mult_$_state_machine__43595__auto____0 = (function (){
var statearr_45740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45740[(0)] = cljs$core$async$mult_$_state_machine__43595__auto__);

(statearr_45740[(1)] = (1));

return statearr_45740;
});
var cljs$core$async$mult_$_state_machine__43595__auto____1 = (function (state_45527){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_45527);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e45746){var ex__43598__auto__ = e45746;
var statearr_45747_48658 = state_45527;
(statearr_45747_48658[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_45527[(4)]))){
var statearr_45749_48660 = state_45527;
(statearr_45749_48660[(1)] = cljs.core.first((state_45527[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48662 = state_45527;
state_45527 = G__48662;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43595__auto__ = function(state_45527){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43595__auto____1.call(this,state_45527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43595__auto____0;
cljs$core$async$mult_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43595__auto____1;
return cljs$core$async$mult_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_45752 = f__43975__auto__();
(statearr_45752[(6)] = c__43974__auto___48521);

return statearr_45752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45765 = arguments.length;
switch (G__45765) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_48673 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_48673(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_48677 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_48677(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_48680 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_48680(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_48682 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_48682(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_48689 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_48689(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48698 = arguments.length;
var i__4737__auto___48699 = (0);
while(true){
if((i__4737__auto___48699 < len__4736__auto___48698)){
args__4742__auto__.push((arguments[i__4737__auto___48699]));

var G__48700 = (i__4737__auto___48699 + (1));
i__4737__auto___48699 = G__48700;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45850){
var map__45851 = p__45850;
var map__45851__$1 = (((((!((map__45851 == null))))?(((((map__45851.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45851.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45851):map__45851);
var opts = map__45851__$1;
var statearr_45858_48706 = state;
(statearr_45858_48706[(1)] = cont_block);


var temp__5754__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45861_48707 = state;
(statearr_45861_48707[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5754__auto__)){
var cb = temp__5754__auto__;
var statearr_45864_48708 = state;
(statearr_45864_48708[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45835){
var G__45837 = cljs.core.first(seq45835);
var seq45835__$1 = cljs.core.next(seq45835);
var G__45838 = cljs.core.first(seq45835__$1);
var seq45835__$2 = cljs.core.next(seq45835__$1);
var G__45839 = cljs.core.first(seq45835__$2);
var seq45835__$3 = cljs.core.next(seq45835__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45837,G__45838,G__45839,seq45835__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45905 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45905 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45906){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45906 = meta45906;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45907,meta45906__$1){
var self__ = this;
var _45907__$1 = this;
return (new cljs.core.async.t_cljs$core$async45905(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45906__$1));
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45907){
var self__ = this;
var _45907__$1 = this;
return self__.meta45906;
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45905.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45905.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45906","meta45906",-1308520363,null)], null);
}));

(cljs.core.async.t_cljs$core$async45905.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45905.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45905");

(cljs.core.async.t_cljs$core$async45905.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45905");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45905.
 */
cljs.core.async.__GT_t_cljs$core$async45905 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45905(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45906){
return (new cljs.core.async.t_cljs$core$async45905(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45906));
});

}

return (new cljs.core.async.t_cljs$core$async45905(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43974__auto___48734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_46233){
var state_val_46236 = (state_46233[(1)]);
if((state_val_46236 === (7))){
var inst_46106 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46244_48735 = state_46233__$1;
(statearr_46244_48735[(2)] = inst_46106);

(statearr_46244_48735[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (20))){
var inst_46120 = (state_46233[(7)]);
var state_46233__$1 = state_46233;
var statearr_46249_48736 = state_46233__$1;
(statearr_46249_48736[(2)] = inst_46120);

(statearr_46249_48736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (27))){
var state_46233__$1 = state_46233;
var statearr_46251_48738 = state_46233__$1;
(statearr_46251_48738[(2)] = null);

(statearr_46251_48738[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (1))){
var inst_46041 = (state_46233[(8)]);
var inst_46041__$1 = calc_state();
var inst_46095 = (inst_46041__$1 == null);
var inst_46096 = cljs.core.not(inst_46095);
var state_46233__$1 = (function (){var statearr_46262 = state_46233;
(statearr_46262[(8)] = inst_46041__$1);

return statearr_46262;
})();
if(inst_46096){
var statearr_46265_48741 = state_46233__$1;
(statearr_46265_48741[(1)] = (2));

} else {
var statearr_46270_48742 = state_46233__$1;
(statearr_46270_48742[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (24))){
var inst_46161 = (state_46233[(9)]);
var inst_46151 = (state_46233[(10)]);
var inst_46191 = (state_46233[(11)]);
var inst_46191__$1 = (inst_46151.cljs$core$IFn$_invoke$arity$1 ? inst_46151.cljs$core$IFn$_invoke$arity$1(inst_46161) : inst_46151.call(null,inst_46161));
var state_46233__$1 = (function (){var statearr_46275 = state_46233;
(statearr_46275[(11)] = inst_46191__$1);

return statearr_46275;
})();
if(cljs.core.truth_(inst_46191__$1)){
var statearr_46277_48743 = state_46233__$1;
(statearr_46277_48743[(1)] = (29));

} else {
var statearr_46278_48744 = state_46233__$1;
(statearr_46278_48744[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (4))){
var inst_46109 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46109)){
var statearr_46284_48749 = state_46233__$1;
(statearr_46284_48749[(1)] = (8));

} else {
var statearr_46285_48750 = state_46233__$1;
(statearr_46285_48750[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (15))){
var inst_46143 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46143)){
var statearr_46288_48754 = state_46233__$1;
(statearr_46288_48754[(1)] = (19));

} else {
var statearr_46289_48755 = state_46233__$1;
(statearr_46289_48755[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (21))){
var inst_46149 = (state_46233[(12)]);
var inst_46149__$1 = (state_46233[(2)]);
var inst_46151 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46149__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46149__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46149__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46233__$1 = (function (){var statearr_46299 = state_46233;
(statearr_46299[(10)] = inst_46151);

(statearr_46299[(13)] = inst_46152);

(statearr_46299[(12)] = inst_46149__$1);

return statearr_46299;
})();
return cljs.core.async.ioc_alts_BANG_(state_46233__$1,(22),inst_46153);
} else {
if((state_val_46236 === (31))){
var inst_46202 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46202)){
var statearr_46305_48756 = state_46233__$1;
(statearr_46305_48756[(1)] = (32));

} else {
var statearr_46310_48757 = state_46233__$1;
(statearr_46310_48757[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (32))){
var inst_46159 = (state_46233[(14)]);
var state_46233__$1 = state_46233;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46233__$1,(35),out,inst_46159);
} else {
if((state_val_46236 === (33))){
var inst_46149 = (state_46233[(12)]);
var inst_46120 = inst_46149;
var state_46233__$1 = (function (){var statearr_46326 = state_46233;
(statearr_46326[(7)] = inst_46120);

return statearr_46326;
})();
var statearr_46330_48762 = state_46233__$1;
(statearr_46330_48762[(2)] = null);

(statearr_46330_48762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (13))){
var inst_46120 = (state_46233[(7)]);
var inst_46130 = inst_46120.cljs$lang$protocol_mask$partition0$;
var inst_46131 = (inst_46130 & (64));
var inst_46132 = inst_46120.cljs$core$ISeq$;
var inst_46133 = (cljs.core.PROTOCOL_SENTINEL === inst_46132);
var inst_46134 = ((inst_46131) || (inst_46133));
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46134)){
var statearr_46338_48763 = state_46233__$1;
(statearr_46338_48763[(1)] = (16));

} else {
var statearr_46339_48764 = state_46233__$1;
(statearr_46339_48764[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (22))){
var inst_46161 = (state_46233[(9)]);
var inst_46159 = (state_46233[(14)]);
var inst_46158 = (state_46233[(2)]);
var inst_46159__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46158,(0),null);
var inst_46161__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46158,(1),null);
var inst_46165 = (inst_46159__$1 == null);
var inst_46166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46161__$1,change);
var inst_46167 = ((inst_46165) || (inst_46166));
var state_46233__$1 = (function (){var statearr_46352 = state_46233;
(statearr_46352[(9)] = inst_46161__$1);

(statearr_46352[(14)] = inst_46159__$1);

return statearr_46352;
})();
if(cljs.core.truth_(inst_46167)){
var statearr_46360_48768 = state_46233__$1;
(statearr_46360_48768[(1)] = (23));

} else {
var statearr_46365_48769 = state_46233__$1;
(statearr_46365_48769[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (36))){
var inst_46149 = (state_46233[(12)]);
var inst_46120 = inst_46149;
var state_46233__$1 = (function (){var statearr_46379 = state_46233;
(statearr_46379[(7)] = inst_46120);

return statearr_46379;
})();
var statearr_46384_48770 = state_46233__$1;
(statearr_46384_48770[(2)] = null);

(statearr_46384_48770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (29))){
var inst_46191 = (state_46233[(11)]);
var state_46233__$1 = state_46233;
var statearr_46395_48771 = state_46233__$1;
(statearr_46395_48771[(2)] = inst_46191);

(statearr_46395_48771[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (6))){
var state_46233__$1 = state_46233;
var statearr_46406_48776 = state_46233__$1;
(statearr_46406_48776[(2)] = false);

(statearr_46406_48776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (28))){
var inst_46177 = (state_46233[(2)]);
var inst_46178 = calc_state();
var inst_46120 = inst_46178;
var state_46233__$1 = (function (){var statearr_46417 = state_46233;
(statearr_46417[(15)] = inst_46177);

(statearr_46417[(7)] = inst_46120);

return statearr_46417;
})();
var statearr_46426_48796 = state_46233__$1;
(statearr_46426_48796[(2)] = null);

(statearr_46426_48796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (25))){
var inst_46223 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46431_48802 = state_46233__$1;
(statearr_46431_48802[(2)] = inst_46223);

(statearr_46431_48802[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (34))){
var inst_46221 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46435_48808 = state_46233__$1;
(statearr_46435_48808[(2)] = inst_46221);

(statearr_46435_48808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (17))){
var state_46233__$1 = state_46233;
var statearr_46437_48809 = state_46233__$1;
(statearr_46437_48809[(2)] = false);

(statearr_46437_48809[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (3))){
var state_46233__$1 = state_46233;
var statearr_46438_48811 = state_46233__$1;
(statearr_46438_48811[(2)] = false);

(statearr_46438_48811[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (12))){
var inst_46226 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46233__$1,inst_46226);
} else {
if((state_val_46236 === (2))){
var inst_46041 = (state_46233[(8)]);
var inst_46098 = inst_46041.cljs$lang$protocol_mask$partition0$;
var inst_46099 = (inst_46098 & (64));
var inst_46100 = inst_46041.cljs$core$ISeq$;
var inst_46101 = (cljs.core.PROTOCOL_SENTINEL === inst_46100);
var inst_46102 = ((inst_46099) || (inst_46101));
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46102)){
var statearr_46443_48821 = state_46233__$1;
(statearr_46443_48821[(1)] = (5));

} else {
var statearr_46444_48822 = state_46233__$1;
(statearr_46444_48822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (23))){
var inst_46159 = (state_46233[(14)]);
var inst_46172 = (inst_46159 == null);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46172)){
var statearr_46447_48825 = state_46233__$1;
(statearr_46447_48825[(1)] = (26));

} else {
var statearr_46448_48826 = state_46233__$1;
(statearr_46448_48826[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (35))){
var inst_46208 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46208)){
var statearr_46449_48834 = state_46233__$1;
(statearr_46449_48834[(1)] = (36));

} else {
var statearr_46450_48841 = state_46233__$1;
(statearr_46450_48841[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (19))){
var inst_46120 = (state_46233[(7)]);
var inst_46145 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46120);
var state_46233__$1 = state_46233;
var statearr_46455_48846 = state_46233__$1;
(statearr_46455_48846[(2)] = inst_46145);

(statearr_46455_48846[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (11))){
var inst_46120 = (state_46233[(7)]);
var inst_46124 = (inst_46120 == null);
var inst_46125 = cljs.core.not(inst_46124);
var state_46233__$1 = state_46233;
if(inst_46125){
var statearr_46456_48852 = state_46233__$1;
(statearr_46456_48852[(1)] = (13));

} else {
var statearr_46457_48858 = state_46233__$1;
(statearr_46457_48858[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (9))){
var inst_46041 = (state_46233[(8)]);
var state_46233__$1 = state_46233;
var statearr_46458_48867 = state_46233__$1;
(statearr_46458_48867[(2)] = inst_46041);

(statearr_46458_48867[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (5))){
var state_46233__$1 = state_46233;
var statearr_46463_48879 = state_46233__$1;
(statearr_46463_48879[(2)] = true);

(statearr_46463_48879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (14))){
var state_46233__$1 = state_46233;
var statearr_46468_48881 = state_46233__$1;
(statearr_46468_48881[(2)] = false);

(statearr_46468_48881[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (26))){
var inst_46161 = (state_46233[(9)]);
var inst_46174 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46161);
var state_46233__$1 = state_46233;
var statearr_46476_48883 = state_46233__$1;
(statearr_46476_48883[(2)] = inst_46174);

(statearr_46476_48883[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (16))){
var state_46233__$1 = state_46233;
var statearr_46481_48891 = state_46233__$1;
(statearr_46481_48891[(2)] = true);

(statearr_46481_48891[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (38))){
var inst_46217 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46486_48896 = state_46233__$1;
(statearr_46486_48896[(2)] = inst_46217);

(statearr_46486_48896[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (30))){
var inst_46161 = (state_46233[(9)]);
var inst_46151 = (state_46233[(10)]);
var inst_46152 = (state_46233[(13)]);
var inst_46197 = cljs.core.empty_QMARK_(inst_46151);
var inst_46198 = (inst_46152.cljs$core$IFn$_invoke$arity$1 ? inst_46152.cljs$core$IFn$_invoke$arity$1(inst_46161) : inst_46152.call(null,inst_46161));
var inst_46199 = cljs.core.not(inst_46198);
var inst_46200 = ((inst_46197) && (inst_46199));
var state_46233__$1 = state_46233;
var statearr_46490_48908 = state_46233__$1;
(statearr_46490_48908[(2)] = inst_46200);

(statearr_46490_48908[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (10))){
var inst_46041 = (state_46233[(8)]);
var inst_46114 = (state_46233[(2)]);
var inst_46116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46114,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46114,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46114,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46120 = inst_46041;
var state_46233__$1 = (function (){var statearr_46494 = state_46233;
(statearr_46494[(16)] = inst_46119);

(statearr_46494[(7)] = inst_46120);

(statearr_46494[(17)] = inst_46116);

(statearr_46494[(18)] = inst_46117);

return statearr_46494;
})();
var statearr_46497_48918 = state_46233__$1;
(statearr_46497_48918[(2)] = null);

(statearr_46497_48918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (18))){
var inst_46140 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46498_48929 = state_46233__$1;
(statearr_46498_48929[(2)] = inst_46140);

(statearr_46498_48929[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (37))){
var state_46233__$1 = state_46233;
var statearr_46502_48931 = state_46233__$1;
(statearr_46502_48931[(2)] = null);

(statearr_46502_48931[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46236 === (8))){
var inst_46041 = (state_46233[(8)]);
var inst_46111 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46041);
var state_46233__$1 = state_46233;
var statearr_46503_48934 = state_46233__$1;
(statearr_46503_48934[(2)] = inst_46111);

(statearr_46503_48934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43595__auto__ = null;
var cljs$core$async$mix_$_state_machine__43595__auto____0 = (function (){
var statearr_46505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46505[(0)] = cljs$core$async$mix_$_state_machine__43595__auto__);

(statearr_46505[(1)] = (1));

return statearr_46505;
});
var cljs$core$async$mix_$_state_machine__43595__auto____1 = (function (state_46233){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_46233);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e46507){var ex__43598__auto__ = e46507;
var statearr_46508_48940 = state_46233;
(statearr_46508_48940[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_46233[(4)]))){
var statearr_46509_48941 = state_46233;
(statearr_46509_48941[(1)] = cljs.core.first((state_46233[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48944 = state_46233;
state_46233 = G__48944;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43595__auto__ = function(state_46233){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43595__auto____1.call(this,state_46233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43595__auto____0;
cljs$core$async$mix_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43595__auto____1;
return cljs$core$async$mix_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_46511 = f__43975__auto__();
(statearr_46511[(6)] = c__43974__auto___48734);

return statearr_46511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_48957 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_48957(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_48961 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_48961(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_48970 = (function() {
var G__48971 = null;
var G__48971__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__48971__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__48971 = function(p,v){
switch(arguments.length){
case 1:
return G__48971__1.call(this,p);
case 2:
return G__48971__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48971.cljs$core$IFn$_invoke$arity$1 = G__48971__1;
G__48971.cljs$core$IFn$_invoke$arity$2 = G__48971__2;
return G__48971;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46545 = arguments.length;
switch (G__46545) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48970(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48970(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46558 = arguments.length;
switch (G__46558) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46553_SHARP_){
if(cljs.core.truth_((p1__46553_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46553_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46553_SHARP_.call(null,topic)))){
return p1__46553_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46553_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46566 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46566 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46567){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46567 = meta46567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46568,meta46567__$1){
var self__ = this;
var _46568__$1 = this;
return (new cljs.core.async.t_cljs$core$async46566(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46567__$1));
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46568){
var self__ = this;
var _46568__$1 = this;
return self__.meta46567;
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5754__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5754__auto__)){
var m = temp__5754__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46566.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46566.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46567","meta46567",1385730716,null)], null);
}));

(cljs.core.async.t_cljs$core$async46566.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46566.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46566");

(cljs.core.async.t_cljs$core$async46566.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46566");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46566.
 */
cljs.core.async.__GT_t_cljs$core$async46566 = (function cljs$core$async$__GT_t_cljs$core$async46566(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46567){
return (new cljs.core.async.t_cljs$core$async46566(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46567));
});

}

return (new cljs.core.async.t_cljs$core$async46566(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43974__auto___49033 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_46690){
var state_val_46691 = (state_46690[(1)]);
if((state_val_46691 === (7))){
var inst_46686 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46693_49034 = state_46690__$1;
(statearr_46693_49034[(2)] = inst_46686);

(statearr_46693_49034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (20))){
var state_46690__$1 = state_46690;
var statearr_46699_49036 = state_46690__$1;
(statearr_46699_49036[(2)] = null);

(statearr_46699_49036[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (1))){
var state_46690__$1 = state_46690;
var statearr_46701_49037 = state_46690__$1;
(statearr_46701_49037[(2)] = null);

(statearr_46701_49037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (24))){
var inst_46669 = (state_46690[(7)]);
var inst_46678 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46669);
var state_46690__$1 = state_46690;
var statearr_46706_49039 = state_46690__$1;
(statearr_46706_49039[(2)] = inst_46678);

(statearr_46706_49039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (4))){
var inst_46612 = (state_46690[(8)]);
var inst_46612__$1 = (state_46690[(2)]);
var inst_46613 = (inst_46612__$1 == null);
var state_46690__$1 = (function (){var statearr_46709 = state_46690;
(statearr_46709[(8)] = inst_46612__$1);

return statearr_46709;
})();
if(cljs.core.truth_(inst_46613)){
var statearr_46714_49043 = state_46690__$1;
(statearr_46714_49043[(1)] = (5));

} else {
var statearr_46715_49044 = state_46690__$1;
(statearr_46715_49044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (15))){
var inst_46663 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46721_49045 = state_46690__$1;
(statearr_46721_49045[(2)] = inst_46663);

(statearr_46721_49045[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (21))){
var inst_46683 = (state_46690[(2)]);
var state_46690__$1 = (function (){var statearr_46724 = state_46690;
(statearr_46724[(9)] = inst_46683);

return statearr_46724;
})();
var statearr_46725_49046 = state_46690__$1;
(statearr_46725_49046[(2)] = null);

(statearr_46725_49046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (13))){
var inst_46642 = (state_46690[(10)]);
var inst_46645 = cljs.core.chunked_seq_QMARK_(inst_46642);
var state_46690__$1 = state_46690;
if(inst_46645){
var statearr_46727_49047 = state_46690__$1;
(statearr_46727_49047[(1)] = (16));

} else {
var statearr_46728_49052 = state_46690__$1;
(statearr_46728_49052[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (22))){
var inst_46675 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
if(cljs.core.truth_(inst_46675)){
var statearr_46733_49054 = state_46690__$1;
(statearr_46733_49054[(1)] = (23));

} else {
var statearr_46734_49062 = state_46690__$1;
(statearr_46734_49062[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (6))){
var inst_46669 = (state_46690[(7)]);
var inst_46612 = (state_46690[(8)]);
var inst_46671 = (state_46690[(11)]);
var inst_46669__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46612) : topic_fn.call(null,inst_46612));
var inst_46670 = cljs.core.deref(mults);
var inst_46671__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46670,inst_46669__$1);
var state_46690__$1 = (function (){var statearr_46735 = state_46690;
(statearr_46735[(7)] = inst_46669__$1);

(statearr_46735[(11)] = inst_46671__$1);

return statearr_46735;
})();
if(cljs.core.truth_(inst_46671__$1)){
var statearr_46736_49075 = state_46690__$1;
(statearr_46736_49075[(1)] = (19));

} else {
var statearr_46737_49076 = state_46690__$1;
(statearr_46737_49076[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (25))){
var inst_46680 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46738_49078 = state_46690__$1;
(statearr_46738_49078[(2)] = inst_46680);

(statearr_46738_49078[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (17))){
var inst_46642 = (state_46690[(10)]);
var inst_46654 = cljs.core.first(inst_46642);
var inst_46655 = cljs.core.async.muxch_STAR_(inst_46654);
var inst_46656 = cljs.core.async.close_BANG_(inst_46655);
var inst_46657 = cljs.core.next(inst_46642);
var inst_46625 = inst_46657;
var inst_46626 = null;
var inst_46627 = (0);
var inst_46628 = (0);
var state_46690__$1 = (function (){var statearr_46741 = state_46690;
(statearr_46741[(12)] = inst_46656);

(statearr_46741[(13)] = inst_46626);

(statearr_46741[(14)] = inst_46628);

(statearr_46741[(15)] = inst_46627);

(statearr_46741[(16)] = inst_46625);

return statearr_46741;
})();
var statearr_46744_49079 = state_46690__$1;
(statearr_46744_49079[(2)] = null);

(statearr_46744_49079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (3))){
var inst_46688 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46690__$1,inst_46688);
} else {
if((state_val_46691 === (12))){
var inst_46665 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46745_49089 = state_46690__$1;
(statearr_46745_49089[(2)] = inst_46665);

(statearr_46745_49089[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (2))){
var state_46690__$1 = state_46690;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46690__$1,(4),ch);
} else {
if((state_val_46691 === (23))){
var state_46690__$1 = state_46690;
var statearr_46748_49106 = state_46690__$1;
(statearr_46748_49106[(2)] = null);

(statearr_46748_49106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (19))){
var inst_46612 = (state_46690[(8)]);
var inst_46671 = (state_46690[(11)]);
var inst_46673 = cljs.core.async.muxch_STAR_(inst_46671);
var state_46690__$1 = state_46690;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46690__$1,(22),inst_46673,inst_46612);
} else {
if((state_val_46691 === (11))){
var inst_46625 = (state_46690[(16)]);
var inst_46642 = (state_46690[(10)]);
var inst_46642__$1 = cljs.core.seq(inst_46625);
var state_46690__$1 = (function (){var statearr_46752 = state_46690;
(statearr_46752[(10)] = inst_46642__$1);

return statearr_46752;
})();
if(inst_46642__$1){
var statearr_46753_49120 = state_46690__$1;
(statearr_46753_49120[(1)] = (13));

} else {
var statearr_46754_49121 = state_46690__$1;
(statearr_46754_49121[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (9))){
var inst_46667 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46756_49128 = state_46690__$1;
(statearr_46756_49128[(2)] = inst_46667);

(statearr_46756_49128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (5))){
var inst_46622 = cljs.core.deref(mults);
var inst_46623 = cljs.core.vals(inst_46622);
var inst_46624 = cljs.core.seq(inst_46623);
var inst_46625 = inst_46624;
var inst_46626 = null;
var inst_46627 = (0);
var inst_46628 = (0);
var state_46690__$1 = (function (){var statearr_46758 = state_46690;
(statearr_46758[(13)] = inst_46626);

(statearr_46758[(14)] = inst_46628);

(statearr_46758[(15)] = inst_46627);

(statearr_46758[(16)] = inst_46625);

return statearr_46758;
})();
var statearr_46759_49144 = state_46690__$1;
(statearr_46759_49144[(2)] = null);

(statearr_46759_49144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (14))){
var state_46690__$1 = state_46690;
var statearr_46763_49149 = state_46690__$1;
(statearr_46763_49149[(2)] = null);

(statearr_46763_49149[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (16))){
var inst_46642 = (state_46690[(10)]);
var inst_46647 = cljs.core.chunk_first(inst_46642);
var inst_46648 = cljs.core.chunk_rest(inst_46642);
var inst_46649 = cljs.core.count(inst_46647);
var inst_46625 = inst_46648;
var inst_46626 = inst_46647;
var inst_46627 = inst_46649;
var inst_46628 = (0);
var state_46690__$1 = (function (){var statearr_46764 = state_46690;
(statearr_46764[(13)] = inst_46626);

(statearr_46764[(14)] = inst_46628);

(statearr_46764[(15)] = inst_46627);

(statearr_46764[(16)] = inst_46625);

return statearr_46764;
})();
var statearr_46765_49163 = state_46690__$1;
(statearr_46765_49163[(2)] = null);

(statearr_46765_49163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (10))){
var inst_46626 = (state_46690[(13)]);
var inst_46628 = (state_46690[(14)]);
var inst_46627 = (state_46690[(15)]);
var inst_46625 = (state_46690[(16)]);
var inst_46635 = cljs.core._nth(inst_46626,inst_46628);
var inst_46636 = cljs.core.async.muxch_STAR_(inst_46635);
var inst_46637 = cljs.core.async.close_BANG_(inst_46636);
var inst_46638 = (inst_46628 + (1));
var tmp46760 = inst_46626;
var tmp46761 = inst_46627;
var tmp46762 = inst_46625;
var inst_46625__$1 = tmp46762;
var inst_46626__$1 = tmp46760;
var inst_46627__$1 = tmp46761;
var inst_46628__$1 = inst_46638;
var state_46690__$1 = (function (){var statearr_46767 = state_46690;
(statearr_46767[(13)] = inst_46626__$1);

(statearr_46767[(17)] = inst_46637);

(statearr_46767[(14)] = inst_46628__$1);

(statearr_46767[(15)] = inst_46627__$1);

(statearr_46767[(16)] = inst_46625__$1);

return statearr_46767;
})();
var statearr_46769_49178 = state_46690__$1;
(statearr_46769_49178[(2)] = null);

(statearr_46769_49178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (18))){
var inst_46660 = (state_46690[(2)]);
var state_46690__$1 = state_46690;
var statearr_46771_49185 = state_46690__$1;
(statearr_46771_49185[(2)] = inst_46660);

(statearr_46771_49185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46691 === (8))){
var inst_46628 = (state_46690[(14)]);
var inst_46627 = (state_46690[(15)]);
var inst_46631 = (inst_46628 < inst_46627);
var inst_46632 = inst_46631;
var state_46690__$1 = state_46690;
if(cljs.core.truth_(inst_46632)){
var statearr_46772_49190 = state_46690__$1;
(statearr_46772_49190[(1)] = (10));

} else {
var statearr_46773_49192 = state_46690__$1;
(statearr_46773_49192[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_46774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46774[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_46774[(1)] = (1));

return statearr_46774;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_46690){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_46690);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e46778){var ex__43598__auto__ = e46778;
var statearr_46780_49196 = state_46690;
(statearr_46780_49196[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_46690[(4)]))){
var statearr_46781_49199 = state_46690;
(statearr_46781_49199[(1)] = cljs.core.first((state_46690[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49200 = state_46690;
state_46690 = G__49200;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_46690){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_46690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_46785 = f__43975__auto__();
(statearr_46785[(6)] = c__43974__auto___49033);

return statearr_46785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46800 = arguments.length;
switch (G__46800) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46814 = arguments.length;
switch (G__46814) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46824 = arguments.length;
switch (G__46824) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43974__auto___49208 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_46883){
var state_val_46884 = (state_46883[(1)]);
if((state_val_46884 === (7))){
var state_46883__$1 = state_46883;
var statearr_46889_49211 = state_46883__$1;
(statearr_46889_49211[(2)] = null);

(statearr_46889_49211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (1))){
var state_46883__$1 = state_46883;
var statearr_46890_49212 = state_46883__$1;
(statearr_46890_49212[(2)] = null);

(statearr_46890_49212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (4))){
var inst_46830 = (state_46883[(7)]);
var inst_46831 = (state_46883[(8)]);
var inst_46833 = (inst_46831 < inst_46830);
var state_46883__$1 = state_46883;
if(cljs.core.truth_(inst_46833)){
var statearr_46891_49221 = state_46883__$1;
(statearr_46891_49221[(1)] = (6));

} else {
var statearr_46892_49222 = state_46883__$1;
(statearr_46892_49222[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (15))){
var inst_46864 = (state_46883[(9)]);
var inst_46869 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46864);
var state_46883__$1 = state_46883;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46883__$1,(17),out,inst_46869);
} else {
if((state_val_46884 === (13))){
var inst_46864 = (state_46883[(9)]);
var inst_46864__$1 = (state_46883[(2)]);
var inst_46865 = cljs.core.some(cljs.core.nil_QMARK_,inst_46864__$1);
var state_46883__$1 = (function (){var statearr_46893 = state_46883;
(statearr_46893[(9)] = inst_46864__$1);

return statearr_46893;
})();
if(cljs.core.truth_(inst_46865)){
var statearr_46894_49230 = state_46883__$1;
(statearr_46894_49230[(1)] = (14));

} else {
var statearr_46895_49231 = state_46883__$1;
(statearr_46895_49231[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (6))){
var state_46883__$1 = state_46883;
var statearr_46896_49233 = state_46883__$1;
(statearr_46896_49233[(2)] = null);

(statearr_46896_49233[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (17))){
var inst_46871 = (state_46883[(2)]);
var state_46883__$1 = (function (){var statearr_46901 = state_46883;
(statearr_46901[(10)] = inst_46871);

return statearr_46901;
})();
var statearr_46904_49234 = state_46883__$1;
(statearr_46904_49234[(2)] = null);

(statearr_46904_49234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (3))){
var inst_46876 = (state_46883[(2)]);
var state_46883__$1 = state_46883;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46883__$1,inst_46876);
} else {
if((state_val_46884 === (12))){
var _ = (function (){var statearr_46905 = state_46883;
(statearr_46905[(4)] = cljs.core.rest((state_46883[(4)])));

return statearr_46905;
})();
var state_46883__$1 = state_46883;
var ex46898 = (state_46883__$1[(2)]);
var statearr_46906_49239 = state_46883__$1;
(statearr_46906_49239[(5)] = ex46898);


if((ex46898 instanceof Object)){
var statearr_46910_49240 = state_46883__$1;
(statearr_46910_49240[(1)] = (11));

(statearr_46910_49240[(5)] = null);

} else {
throw ex46898;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (2))){
var inst_46829 = cljs.core.reset_BANG_(dctr,cnt);
var inst_46830 = cnt;
var inst_46831 = (0);
var state_46883__$1 = (function (){var statearr_46921 = state_46883;
(statearr_46921[(11)] = inst_46829);

(statearr_46921[(7)] = inst_46830);

(statearr_46921[(8)] = inst_46831);

return statearr_46921;
})();
var statearr_46923_49244 = state_46883__$1;
(statearr_46923_49244[(2)] = null);

(statearr_46923_49244[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (11))){
var inst_46839 = (state_46883[(2)]);
var inst_46844 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46883__$1 = (function (){var statearr_46924 = state_46883;
(statearr_46924[(12)] = inst_46839);

return statearr_46924;
})();
var statearr_46925_49245 = state_46883__$1;
(statearr_46925_49245[(2)] = inst_46844);

(statearr_46925_49245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (9))){
var inst_46831 = (state_46883[(8)]);
var _ = (function (){var statearr_46927 = state_46883;
(statearr_46927[(4)] = cljs.core.cons((12),(state_46883[(4)])));

return statearr_46927;
})();
var inst_46850 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_46831) : chs__$1.call(null,inst_46831));
var inst_46851 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_46831) : done.call(null,inst_46831));
var inst_46852 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46850,inst_46851);
var ___$1 = (function (){var statearr_46929 = state_46883;
(statearr_46929[(4)] = cljs.core.rest((state_46883[(4)])));

return statearr_46929;
})();
var state_46883__$1 = state_46883;
var statearr_46931_49251 = state_46883__$1;
(statearr_46931_49251[(2)] = inst_46852);

(statearr_46931_49251[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (5))){
var inst_46862 = (state_46883[(2)]);
var state_46883__$1 = (function (){var statearr_46932 = state_46883;
(statearr_46932[(13)] = inst_46862);

return statearr_46932;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46883__$1,(13),dchan);
} else {
if((state_val_46884 === (14))){
var inst_46867 = cljs.core.async.close_BANG_(out);
var state_46883__$1 = state_46883;
var statearr_46935_49254 = state_46883__$1;
(statearr_46935_49254[(2)] = inst_46867);

(statearr_46935_49254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (16))){
var inst_46874 = (state_46883[(2)]);
var state_46883__$1 = state_46883;
var statearr_46938_49258 = state_46883__$1;
(statearr_46938_49258[(2)] = inst_46874);

(statearr_46938_49258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (10))){
var inst_46831 = (state_46883[(8)]);
var inst_46855 = (state_46883[(2)]);
var inst_46856 = (inst_46831 + (1));
var inst_46831__$1 = inst_46856;
var state_46883__$1 = (function (){var statearr_46940 = state_46883;
(statearr_46940[(14)] = inst_46855);

(statearr_46940[(8)] = inst_46831__$1);

return statearr_46940;
})();
var statearr_46941_49259 = state_46883__$1;
(statearr_46941_49259[(2)] = null);

(statearr_46941_49259[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46884 === (8))){
var inst_46860 = (state_46883[(2)]);
var state_46883__$1 = state_46883;
var statearr_46942_49260 = state_46883__$1;
(statearr_46942_49260[(2)] = inst_46860);

(statearr_46942_49260[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_46943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46943[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_46943[(1)] = (1));

return statearr_46943;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_46883){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_46883);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e46944){var ex__43598__auto__ = e46944;
var statearr_46945_49264 = state_46883;
(statearr_46945_49264[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_46883[(4)]))){
var statearr_46948_49266 = state_46883;
(statearr_46948_49266[(1)] = cljs.core.first((state_46883[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49270 = state_46883;
state_46883 = G__49270;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_46883){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_46883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_46950 = f__43975__auto__();
(statearr_46950[(6)] = c__43974__auto___49208);

return statearr_46950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46953 = arguments.length;
switch (G__46953) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_46988){
var state_val_46989 = (state_46988[(1)]);
if((state_val_46989 === (7))){
var inst_46967 = (state_46988[(7)]);
var inst_46966 = (state_46988[(8)]);
var inst_46966__$1 = (state_46988[(2)]);
var inst_46967__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46966__$1,(0),null);
var inst_46968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46966__$1,(1),null);
var inst_46969 = (inst_46967__$1 == null);
var state_46988__$1 = (function (){var statearr_46992 = state_46988;
(statearr_46992[(7)] = inst_46967__$1);

(statearr_46992[(9)] = inst_46968);

(statearr_46992[(8)] = inst_46966__$1);

return statearr_46992;
})();
if(cljs.core.truth_(inst_46969)){
var statearr_46993_49284 = state_46988__$1;
(statearr_46993_49284[(1)] = (8));

} else {
var statearr_46994_49285 = state_46988__$1;
(statearr_46994_49285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (1))){
var inst_46956 = cljs.core.vec(chs);
var inst_46957 = inst_46956;
var state_46988__$1 = (function (){var statearr_46995 = state_46988;
(statearr_46995[(10)] = inst_46957);

return statearr_46995;
})();
var statearr_46996_49291 = state_46988__$1;
(statearr_46996_49291[(2)] = null);

(statearr_46996_49291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (4))){
var inst_46957 = (state_46988[(10)]);
var state_46988__$1 = state_46988;
return cljs.core.async.ioc_alts_BANG_(state_46988__$1,(7),inst_46957);
} else {
if((state_val_46989 === (6))){
var inst_46983 = (state_46988[(2)]);
var state_46988__$1 = state_46988;
var statearr_46997_49298 = state_46988__$1;
(statearr_46997_49298[(2)] = inst_46983);

(statearr_46997_49298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (3))){
var inst_46985 = (state_46988[(2)]);
var state_46988__$1 = state_46988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46988__$1,inst_46985);
} else {
if((state_val_46989 === (2))){
var inst_46957 = (state_46988[(10)]);
var inst_46959 = cljs.core.count(inst_46957);
var inst_46960 = (inst_46959 > (0));
var state_46988__$1 = state_46988;
if(cljs.core.truth_(inst_46960)){
var statearr_46999_49303 = state_46988__$1;
(statearr_46999_49303[(1)] = (4));

} else {
var statearr_47003_49307 = state_46988__$1;
(statearr_47003_49307[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (11))){
var inst_46957 = (state_46988[(10)]);
var inst_46976 = (state_46988[(2)]);
var tmp46998 = inst_46957;
var inst_46957__$1 = tmp46998;
var state_46988__$1 = (function (){var statearr_47004 = state_46988;
(statearr_47004[(11)] = inst_46976);

(statearr_47004[(10)] = inst_46957__$1);

return statearr_47004;
})();
var statearr_47005_49311 = state_46988__$1;
(statearr_47005_49311[(2)] = null);

(statearr_47005_49311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (9))){
var inst_46967 = (state_46988[(7)]);
var state_46988__$1 = state_46988;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46988__$1,(11),out,inst_46967);
} else {
if((state_val_46989 === (5))){
var inst_46981 = cljs.core.async.close_BANG_(out);
var state_46988__$1 = state_46988;
var statearr_47010_49315 = state_46988__$1;
(statearr_47010_49315[(2)] = inst_46981);

(statearr_47010_49315[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (10))){
var inst_46979 = (state_46988[(2)]);
var state_46988__$1 = state_46988;
var statearr_47011_49318 = state_46988__$1;
(statearr_47011_49318[(2)] = inst_46979);

(statearr_47011_49318[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46989 === (8))){
var inst_46967 = (state_46988[(7)]);
var inst_46968 = (state_46988[(9)]);
var inst_46957 = (state_46988[(10)]);
var inst_46966 = (state_46988[(8)]);
var inst_46971 = (function (){var cs = inst_46957;
var vec__46962 = inst_46966;
var v = inst_46967;
var c = inst_46968;
return (function (p1__46951_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46951_SHARP_);
});
})();
var inst_46972 = cljs.core.filterv(inst_46971,inst_46957);
var inst_46957__$1 = inst_46972;
var state_46988__$1 = (function (){var statearr_47012 = state_46988;
(statearr_47012[(10)] = inst_46957__$1);

return statearr_47012;
})();
var statearr_47013_49322 = state_46988__$1;
(statearr_47013_49322[(2)] = null);

(statearr_47013_49322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47014 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47014[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47014[(1)] = (1));

return statearr_47014;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_46988){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_46988);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47015){var ex__43598__auto__ = e47015;
var statearr_47016_49324 = state_46988;
(statearr_47016_49324[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_46988[(4)]))){
var statearr_47017_49325 = state_46988;
(statearr_47017_49325[(1)] = cljs.core.first((state_46988[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49326 = state_46988;
state_46988 = G__49326;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_46988){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_46988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47022 = f__43975__auto__();
(statearr_47022[(6)] = c__43974__auto___49283);

return statearr_47022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47033 = arguments.length;
switch (G__47033) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49331 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47073){
var state_val_47074 = (state_47073[(1)]);
if((state_val_47074 === (7))){
var inst_47055 = (state_47073[(7)]);
var inst_47055__$1 = (state_47073[(2)]);
var inst_47056 = (inst_47055__$1 == null);
var inst_47057 = cljs.core.not(inst_47056);
var state_47073__$1 = (function (){var statearr_47082 = state_47073;
(statearr_47082[(7)] = inst_47055__$1);

return statearr_47082;
})();
if(inst_47057){
var statearr_47083_49332 = state_47073__$1;
(statearr_47083_49332[(1)] = (8));

} else {
var statearr_47084_49333 = state_47073__$1;
(statearr_47084_49333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (1))){
var inst_47044 = (0);
var state_47073__$1 = (function (){var statearr_47091 = state_47073;
(statearr_47091[(8)] = inst_47044);

return statearr_47091;
})();
var statearr_47094_49336 = state_47073__$1;
(statearr_47094_49336[(2)] = null);

(statearr_47094_49336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (4))){
var state_47073__$1 = state_47073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47073__$1,(7),ch);
} else {
if((state_val_47074 === (6))){
var inst_47068 = (state_47073[(2)]);
var state_47073__$1 = state_47073;
var statearr_47111_49337 = state_47073__$1;
(statearr_47111_49337[(2)] = inst_47068);

(statearr_47111_49337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (3))){
var inst_47070 = (state_47073[(2)]);
var inst_47071 = cljs.core.async.close_BANG_(out);
var state_47073__$1 = (function (){var statearr_47112 = state_47073;
(statearr_47112[(9)] = inst_47070);

return statearr_47112;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47073__$1,inst_47071);
} else {
if((state_val_47074 === (2))){
var inst_47044 = (state_47073[(8)]);
var inst_47046 = (inst_47044 < n);
var state_47073__$1 = state_47073;
if(cljs.core.truth_(inst_47046)){
var statearr_47115_49341 = state_47073__$1;
(statearr_47115_49341[(1)] = (4));

} else {
var statearr_47116_49342 = state_47073__$1;
(statearr_47116_49342[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (11))){
var inst_47044 = (state_47073[(8)]);
var inst_47060 = (state_47073[(2)]);
var inst_47061 = (inst_47044 + (1));
var inst_47044__$1 = inst_47061;
var state_47073__$1 = (function (){var statearr_47117 = state_47073;
(statearr_47117[(8)] = inst_47044__$1);

(statearr_47117[(10)] = inst_47060);

return statearr_47117;
})();
var statearr_47118_49343 = state_47073__$1;
(statearr_47118_49343[(2)] = null);

(statearr_47118_49343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (9))){
var state_47073__$1 = state_47073;
var statearr_47120_49344 = state_47073__$1;
(statearr_47120_49344[(2)] = null);

(statearr_47120_49344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (5))){
var state_47073__$1 = state_47073;
var statearr_47121_49345 = state_47073__$1;
(statearr_47121_49345[(2)] = null);

(statearr_47121_49345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (10))){
var inst_47065 = (state_47073[(2)]);
var state_47073__$1 = state_47073;
var statearr_47124_49346 = state_47073__$1;
(statearr_47124_49346[(2)] = inst_47065);

(statearr_47124_49346[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47074 === (8))){
var inst_47055 = (state_47073[(7)]);
var state_47073__$1 = state_47073;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47073__$1,(11),out,inst_47055);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47126 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47126[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47126[(1)] = (1));

return statearr_47126;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_47073){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47073);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47127){var ex__43598__auto__ = e47127;
var statearr_47128_49350 = state_47073;
(statearr_47128_49350[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47073[(4)]))){
var statearr_47129_49351 = state_47073;
(statearr_47129_49351[(1)] = cljs.core.first((state_47073[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49352 = state_47073;
state_47073 = G__49352;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_47073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_47073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47133 = f__43975__auto__();
(statearr_47133[(6)] = c__43974__auto___49331);

return statearr_47133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47140 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47140 = (function (f,ch,meta47141){
this.f = f;
this.ch = ch;
this.meta47141 = meta47141;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47142,meta47141__$1){
var self__ = this;
var _47142__$1 = this;
return (new cljs.core.async.t_cljs$core$async47140(self__.f,self__.ch,meta47141__$1));
}));

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47142){
var self__ = this;
var _47142__$1 = this;
return self__.meta47141;
}));

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47161 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47161 = (function (f,ch,meta47141,_,fn1,meta47162){
this.f = f;
this.ch = ch;
this.meta47141 = meta47141;
this._ = _;
this.fn1 = fn1;
this.meta47162 = meta47162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47163,meta47162__$1){
var self__ = this;
var _47163__$1 = this;
return (new cljs.core.async.t_cljs$core$async47161(self__.f,self__.ch,self__.meta47141,self__._,self__.fn1,meta47162__$1));
}));

(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47163){
var self__ = this;
var _47163__$1 = this;
return self__.meta47162;
}));

(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47161.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47138_SHARP_){
var G__47168 = (((p1__47138_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47138_SHARP_) : self__.f.call(null,p1__47138_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47168) : f1.call(null,G__47168));
});
}));

(cljs.core.async.t_cljs$core$async47161.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47141","meta47141",-436825489,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47140","cljs.core.async/t_cljs$core$async47140",-752423763,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47162","meta47162",1962044057,null)], null);
}));

(cljs.core.async.t_cljs$core$async47161.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47161.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47161");

(cljs.core.async.t_cljs$core$async47161.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47161");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47161.
 */
cljs.core.async.__GT_t_cljs$core$async47161 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47161(f__$1,ch__$1,meta47141__$1,___$2,fn1__$1,meta47162){
return (new cljs.core.async.t_cljs$core$async47161(f__$1,ch__$1,meta47141__$1,___$2,fn1__$1,meta47162));
});

}

return (new cljs.core.async.t_cljs$core$async47161(self__.f,self__.ch,self__.meta47141,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47179 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47179) : self__.f.call(null,G__47179));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47140.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47140.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47141","meta47141",-436825489,null)], null);
}));

(cljs.core.async.t_cljs$core$async47140.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47140.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47140");

(cljs.core.async.t_cljs$core$async47140.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47140");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47140.
 */
cljs.core.async.__GT_t_cljs$core$async47140 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47140(f__$1,ch__$1,meta47141){
return (new cljs.core.async.t_cljs$core$async47140(f__$1,ch__$1,meta47141));
});

}

return (new cljs.core.async.t_cljs$core$async47140(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47188 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47188 = (function (f,ch,meta47189){
this.f = f;
this.ch = ch;
this.meta47189 = meta47189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47190,meta47189__$1){
var self__ = this;
var _47190__$1 = this;
return (new cljs.core.async.t_cljs$core$async47188(self__.f,self__.ch,meta47189__$1));
}));

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47190){
var self__ = this;
var _47190__$1 = this;
return self__.meta47189;
}));

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47188.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47188.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47189","meta47189",-326356156,null)], null);
}));

(cljs.core.async.t_cljs$core$async47188.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47188.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47188");

(cljs.core.async.t_cljs$core$async47188.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47188");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47188.
 */
cljs.core.async.__GT_t_cljs$core$async47188 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47188(f__$1,ch__$1,meta47189){
return (new cljs.core.async.t_cljs$core$async47188(f__$1,ch__$1,meta47189));
});

}

return (new cljs.core.async.t_cljs$core$async47188(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47214 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47214 = (function (p,ch,meta47215){
this.p = p;
this.ch = ch;
this.meta47215 = meta47215;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47216,meta47215__$1){
var self__ = this;
var _47216__$1 = this;
return (new cljs.core.async.t_cljs$core$async47214(self__.p,self__.ch,meta47215__$1));
}));

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47216){
var self__ = this;
var _47216__$1 = this;
return self__.meta47215;
}));

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47214.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47214.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47215","meta47215",-1874631864,null)], null);
}));

(cljs.core.async.t_cljs$core$async47214.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47214.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47214");

(cljs.core.async.t_cljs$core$async47214.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47214");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47214.
 */
cljs.core.async.__GT_t_cljs$core$async47214 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47214(p__$1,ch__$1,meta47215){
return (new cljs.core.async.t_cljs$core$async47214(p__$1,ch__$1,meta47215));
});

}

return (new cljs.core.async.t_cljs$core$async47214(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47225 = arguments.length;
switch (G__47225) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47255){
var state_val_47256 = (state_47255[(1)]);
if((state_val_47256 === (7))){
var inst_47251 = (state_47255[(2)]);
var state_47255__$1 = state_47255;
var statearr_47259_49400 = state_47255__$1;
(statearr_47259_49400[(2)] = inst_47251);

(statearr_47259_49400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (1))){
var state_47255__$1 = state_47255;
var statearr_47260_49402 = state_47255__$1;
(statearr_47260_49402[(2)] = null);

(statearr_47260_49402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (4))){
var inst_47237 = (state_47255[(7)]);
var inst_47237__$1 = (state_47255[(2)]);
var inst_47238 = (inst_47237__$1 == null);
var state_47255__$1 = (function (){var statearr_47261 = state_47255;
(statearr_47261[(7)] = inst_47237__$1);

return statearr_47261;
})();
if(cljs.core.truth_(inst_47238)){
var statearr_47262_49417 = state_47255__$1;
(statearr_47262_49417[(1)] = (5));

} else {
var statearr_47263_49418 = state_47255__$1;
(statearr_47263_49418[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (6))){
var inst_47237 = (state_47255[(7)]);
var inst_47242 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47237) : p.call(null,inst_47237));
var state_47255__$1 = state_47255;
if(cljs.core.truth_(inst_47242)){
var statearr_47264_49419 = state_47255__$1;
(statearr_47264_49419[(1)] = (8));

} else {
var statearr_47265_49422 = state_47255__$1;
(statearr_47265_49422[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (3))){
var inst_47253 = (state_47255[(2)]);
var state_47255__$1 = state_47255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47255__$1,inst_47253);
} else {
if((state_val_47256 === (2))){
var state_47255__$1 = state_47255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47255__$1,(4),ch);
} else {
if((state_val_47256 === (11))){
var inst_47245 = (state_47255[(2)]);
var state_47255__$1 = state_47255;
var statearr_47266_49430 = state_47255__$1;
(statearr_47266_49430[(2)] = inst_47245);

(statearr_47266_49430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (9))){
var state_47255__$1 = state_47255;
var statearr_47267_49434 = state_47255__$1;
(statearr_47267_49434[(2)] = null);

(statearr_47267_49434[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (5))){
var inst_47240 = cljs.core.async.close_BANG_(out);
var state_47255__$1 = state_47255;
var statearr_47272_49435 = state_47255__$1;
(statearr_47272_49435[(2)] = inst_47240);

(statearr_47272_49435[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (10))){
var inst_47248 = (state_47255[(2)]);
var state_47255__$1 = (function (){var statearr_47273 = state_47255;
(statearr_47273[(8)] = inst_47248);

return statearr_47273;
})();
var statearr_47274_49437 = state_47255__$1;
(statearr_47274_49437[(2)] = null);

(statearr_47274_49437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47256 === (8))){
var inst_47237 = (state_47255[(7)]);
var state_47255__$1 = state_47255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47255__$1,(11),out,inst_47237);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47277 = [null,null,null,null,null,null,null,null,null];
(statearr_47277[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47277[(1)] = (1));

return statearr_47277;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_47255){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47255);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47278){var ex__43598__auto__ = e47278;
var statearr_47279_49442 = state_47255;
(statearr_47279_49442[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47255[(4)]))){
var statearr_47280_49444 = state_47255;
(statearr_47280_49444[(1)] = cljs.core.first((state_47255[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49446 = state_47255;
state_47255 = G__49446;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_47255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_47255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47289 = f__43975__auto__();
(statearr_47289[(6)] = c__43974__auto___49399);

return statearr_47289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__47295 = arguments.length;
switch (G__47295) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47416){
var state_val_47417 = (state_47416[(1)]);
if((state_val_47417 === (7))){
var inst_47408 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
var statearr_47428_49461 = state_47416__$1;
(statearr_47428_49461[(2)] = inst_47408);

(statearr_47428_49461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (20))){
var inst_47368 = (state_47416[(7)]);
var inst_47389 = (state_47416[(2)]);
var inst_47390 = cljs.core.next(inst_47368);
var inst_47346 = inst_47390;
var inst_47347 = null;
var inst_47348 = (0);
var inst_47349 = (0);
var state_47416__$1 = (function (){var statearr_47434 = state_47416;
(statearr_47434[(8)] = inst_47349);

(statearr_47434[(9)] = inst_47347);

(statearr_47434[(10)] = inst_47348);

(statearr_47434[(11)] = inst_47346);

(statearr_47434[(12)] = inst_47389);

return statearr_47434;
})();
var statearr_47441_49468 = state_47416__$1;
(statearr_47441_49468[(2)] = null);

(statearr_47441_49468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (1))){
var state_47416__$1 = state_47416;
var statearr_47442_49470 = state_47416__$1;
(statearr_47442_49470[(2)] = null);

(statearr_47442_49470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (4))){
var inst_47332 = (state_47416[(13)]);
var inst_47332__$1 = (state_47416[(2)]);
var inst_47333 = (inst_47332__$1 == null);
var state_47416__$1 = (function (){var statearr_47443 = state_47416;
(statearr_47443[(13)] = inst_47332__$1);

return statearr_47443;
})();
if(cljs.core.truth_(inst_47333)){
var statearr_47444_49471 = state_47416__$1;
(statearr_47444_49471[(1)] = (5));

} else {
var statearr_47445_49472 = state_47416__$1;
(statearr_47445_49472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (15))){
var state_47416__$1 = state_47416;
var statearr_47451_49473 = state_47416__$1;
(statearr_47451_49473[(2)] = null);

(statearr_47451_49473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (21))){
var state_47416__$1 = state_47416;
var statearr_47452_49474 = state_47416__$1;
(statearr_47452_49474[(2)] = null);

(statearr_47452_49474[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (13))){
var inst_47349 = (state_47416[(8)]);
var inst_47347 = (state_47416[(9)]);
var inst_47348 = (state_47416[(10)]);
var inst_47346 = (state_47416[(11)]);
var inst_47356 = (state_47416[(2)]);
var inst_47357 = (inst_47349 + (1));
var tmp47446 = inst_47347;
var tmp47447 = inst_47348;
var tmp47448 = inst_47346;
var inst_47346__$1 = tmp47448;
var inst_47347__$1 = tmp47446;
var inst_47348__$1 = tmp47447;
var inst_47349__$1 = inst_47357;
var state_47416__$1 = (function (){var statearr_47453 = state_47416;
(statearr_47453[(8)] = inst_47349__$1);

(statearr_47453[(9)] = inst_47347__$1);

(statearr_47453[(10)] = inst_47348__$1);

(statearr_47453[(11)] = inst_47346__$1);

(statearr_47453[(14)] = inst_47356);

return statearr_47453;
})();
var statearr_47454_49477 = state_47416__$1;
(statearr_47454_49477[(2)] = null);

(statearr_47454_49477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (22))){
var state_47416__$1 = state_47416;
var statearr_47455_49478 = state_47416__$1;
(statearr_47455_49478[(2)] = null);

(statearr_47455_49478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (6))){
var inst_47332 = (state_47416[(13)]);
var inst_47341 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47332) : f.call(null,inst_47332));
var inst_47342 = cljs.core.seq(inst_47341);
var inst_47346 = inst_47342;
var inst_47347 = null;
var inst_47348 = (0);
var inst_47349 = (0);
var state_47416__$1 = (function (){var statearr_47456 = state_47416;
(statearr_47456[(8)] = inst_47349);

(statearr_47456[(9)] = inst_47347);

(statearr_47456[(10)] = inst_47348);

(statearr_47456[(11)] = inst_47346);

return statearr_47456;
})();
var statearr_47457_49486 = state_47416__$1;
(statearr_47457_49486[(2)] = null);

(statearr_47457_49486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (17))){
var inst_47368 = (state_47416[(7)]);
var inst_47375 = cljs.core.chunk_first(inst_47368);
var inst_47376 = cljs.core.chunk_rest(inst_47368);
var inst_47377 = cljs.core.count(inst_47375);
var inst_47346 = inst_47376;
var inst_47347 = inst_47375;
var inst_47348 = inst_47377;
var inst_47349 = (0);
var state_47416__$1 = (function (){var statearr_47459 = state_47416;
(statearr_47459[(8)] = inst_47349);

(statearr_47459[(9)] = inst_47347);

(statearr_47459[(10)] = inst_47348);

(statearr_47459[(11)] = inst_47346);

return statearr_47459;
})();
var statearr_47460_49488 = state_47416__$1;
(statearr_47460_49488[(2)] = null);

(statearr_47460_49488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (3))){
var inst_47410 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47416__$1,inst_47410);
} else {
if((state_val_47417 === (12))){
var inst_47398 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
var statearr_47461_49493 = state_47416__$1;
(statearr_47461_49493[(2)] = inst_47398);

(statearr_47461_49493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (2))){
var state_47416__$1 = state_47416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47416__$1,(4),in$);
} else {
if((state_val_47417 === (23))){
var inst_47406 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
var statearr_47465_49494 = state_47416__$1;
(statearr_47465_49494[(2)] = inst_47406);

(statearr_47465_49494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (19))){
var inst_47393 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
var statearr_47466_49496 = state_47416__$1;
(statearr_47466_49496[(2)] = inst_47393);

(statearr_47466_49496[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (11))){
var inst_47368 = (state_47416[(7)]);
var inst_47346 = (state_47416[(11)]);
var inst_47368__$1 = cljs.core.seq(inst_47346);
var state_47416__$1 = (function (){var statearr_47467 = state_47416;
(statearr_47467[(7)] = inst_47368__$1);

return statearr_47467;
})();
if(inst_47368__$1){
var statearr_47468_49497 = state_47416__$1;
(statearr_47468_49497[(1)] = (14));

} else {
var statearr_47471_49498 = state_47416__$1;
(statearr_47471_49498[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (9))){
var inst_47400 = (state_47416[(2)]);
var inst_47401 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47416__$1 = (function (){var statearr_47472 = state_47416;
(statearr_47472[(15)] = inst_47400);

return statearr_47472;
})();
if(cljs.core.truth_(inst_47401)){
var statearr_47473_49499 = state_47416__$1;
(statearr_47473_49499[(1)] = (21));

} else {
var statearr_47474_49500 = state_47416__$1;
(statearr_47474_49500[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (5))){
var inst_47335 = cljs.core.async.close_BANG_(out);
var state_47416__$1 = state_47416;
var statearr_47475_49501 = state_47416__$1;
(statearr_47475_49501[(2)] = inst_47335);

(statearr_47475_49501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (14))){
var inst_47368 = (state_47416[(7)]);
var inst_47373 = cljs.core.chunked_seq_QMARK_(inst_47368);
var state_47416__$1 = state_47416;
if(inst_47373){
var statearr_47476_49510 = state_47416__$1;
(statearr_47476_49510[(1)] = (17));

} else {
var statearr_47477_49512 = state_47416__$1;
(statearr_47477_49512[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (16))){
var inst_47396 = (state_47416[(2)]);
var state_47416__$1 = state_47416;
var statearr_47481_49513 = state_47416__$1;
(statearr_47481_49513[(2)] = inst_47396);

(statearr_47481_49513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47417 === (10))){
var inst_47349 = (state_47416[(8)]);
var inst_47347 = (state_47416[(9)]);
var inst_47354 = cljs.core._nth(inst_47347,inst_47349);
var state_47416__$1 = state_47416;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47416__$1,(13),out,inst_47354);
} else {
if((state_val_47417 === (18))){
var inst_47368 = (state_47416[(7)]);
var inst_47384 = cljs.core.first(inst_47368);
var state_47416__$1 = state_47416;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47416__$1,(20),out,inst_47384);
} else {
if((state_val_47417 === (8))){
var inst_47349 = (state_47416[(8)]);
var inst_47348 = (state_47416[(10)]);
var inst_47351 = (inst_47349 < inst_47348);
var inst_47352 = inst_47351;
var state_47416__$1 = state_47416;
if(cljs.core.truth_(inst_47352)){
var statearr_47482_49516 = state_47416__$1;
(statearr_47482_49516[(1)] = (10));

} else {
var statearr_47484_49517 = state_47416__$1;
(statearr_47484_49517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____0 = (function (){
var statearr_47489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47489[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__);

(statearr_47489[(1)] = (1));

return statearr_47489;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____1 = (function (state_47416){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47416);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47490){var ex__43598__auto__ = e47490;
var statearr_47491_49519 = state_47416;
(statearr_47491_49519[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47416[(4)]))){
var statearr_47493_49520 = state_47416;
(statearr_47493_49520[(1)] = cljs.core.first((state_47416[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49521 = state_47416;
state_47416 = G__49521;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__ = function(state_47416){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____1.call(this,state_47416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43595__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47498 = f__43975__auto__();
(statearr_47498[(6)] = c__43974__auto__);

return statearr_47498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47511 = arguments.length;
switch (G__47511) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47517 = arguments.length;
switch (G__47517) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47527 = arguments.length;
switch (G__47527) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49529 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47552){
var state_val_47553 = (state_47552[(1)]);
if((state_val_47553 === (7))){
var inst_47546 = (state_47552[(2)]);
var state_47552__$1 = state_47552;
var statearr_47554_49530 = state_47552__$1;
(statearr_47554_49530[(2)] = inst_47546);

(statearr_47554_49530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (1))){
var inst_47528 = null;
var state_47552__$1 = (function (){var statearr_47556 = state_47552;
(statearr_47556[(7)] = inst_47528);

return statearr_47556;
})();
var statearr_47558_49531 = state_47552__$1;
(statearr_47558_49531[(2)] = null);

(statearr_47558_49531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (4))){
var inst_47531 = (state_47552[(8)]);
var inst_47531__$1 = (state_47552[(2)]);
var inst_47532 = (inst_47531__$1 == null);
var inst_47533 = cljs.core.not(inst_47532);
var state_47552__$1 = (function (){var statearr_47561 = state_47552;
(statearr_47561[(8)] = inst_47531__$1);

return statearr_47561;
})();
if(inst_47533){
var statearr_47563_49532 = state_47552__$1;
(statearr_47563_49532[(1)] = (5));

} else {
var statearr_47564_49537 = state_47552__$1;
(statearr_47564_49537[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (6))){
var state_47552__$1 = state_47552;
var statearr_47566_49538 = state_47552__$1;
(statearr_47566_49538[(2)] = null);

(statearr_47566_49538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (3))){
var inst_47549 = (state_47552[(2)]);
var inst_47550 = cljs.core.async.close_BANG_(out);
var state_47552__$1 = (function (){var statearr_47568 = state_47552;
(statearr_47568[(9)] = inst_47549);

return statearr_47568;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47552__$1,inst_47550);
} else {
if((state_val_47553 === (2))){
var state_47552__$1 = state_47552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47552__$1,(4),ch);
} else {
if((state_val_47553 === (11))){
var inst_47531 = (state_47552[(8)]);
var inst_47540 = (state_47552[(2)]);
var inst_47528 = inst_47531;
var state_47552__$1 = (function (){var statearr_47569 = state_47552;
(statearr_47569[(10)] = inst_47540);

(statearr_47569[(7)] = inst_47528);

return statearr_47569;
})();
var statearr_47570_49550 = state_47552__$1;
(statearr_47570_49550[(2)] = null);

(statearr_47570_49550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (9))){
var inst_47531 = (state_47552[(8)]);
var state_47552__$1 = state_47552;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47552__$1,(11),out,inst_47531);
} else {
if((state_val_47553 === (5))){
var inst_47528 = (state_47552[(7)]);
var inst_47531 = (state_47552[(8)]);
var inst_47535 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47531,inst_47528);
var state_47552__$1 = state_47552;
if(inst_47535){
var statearr_47572_49557 = state_47552__$1;
(statearr_47572_49557[(1)] = (8));

} else {
var statearr_47573_49561 = state_47552__$1;
(statearr_47573_49561[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (10))){
var inst_47543 = (state_47552[(2)]);
var state_47552__$1 = state_47552;
var statearr_47574_49562 = state_47552__$1;
(statearr_47574_49562[(2)] = inst_47543);

(statearr_47574_49562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47553 === (8))){
var inst_47528 = (state_47552[(7)]);
var tmp47571 = inst_47528;
var inst_47528__$1 = tmp47571;
var state_47552__$1 = (function (){var statearr_47584 = state_47552;
(statearr_47584[(7)] = inst_47528__$1);

return statearr_47584;
})();
var statearr_47585_49567 = state_47552__$1;
(statearr_47585_49567[(2)] = null);

(statearr_47585_49567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47586 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47586[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47586[(1)] = (1));

return statearr_47586;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_47552){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47552);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47588){var ex__43598__auto__ = e47588;
var statearr_47589_49585 = state_47552;
(statearr_47589_49585[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47552[(4)]))){
var statearr_47591_49586 = state_47552;
(statearr_47591_49586[(1)] = cljs.core.first((state_47552[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49590 = state_47552;
state_47552 = G__49590;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_47552){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_47552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47594 = f__43975__auto__();
(statearr_47594[(6)] = c__43974__auto___49529);

return statearr_47594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47596 = arguments.length;
switch (G__47596) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47643){
var state_val_47644 = (state_47643[(1)]);
if((state_val_47644 === (7))){
var inst_47639 = (state_47643[(2)]);
var state_47643__$1 = state_47643;
var statearr_47657_49609 = state_47643__$1;
(statearr_47657_49609[(2)] = inst_47639);

(statearr_47657_49609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (1))){
var inst_47601 = (new Array(n));
var inst_47602 = inst_47601;
var inst_47603 = (0);
var state_47643__$1 = (function (){var statearr_47666 = state_47643;
(statearr_47666[(7)] = inst_47602);

(statearr_47666[(8)] = inst_47603);

return statearr_47666;
})();
var statearr_47669_49610 = state_47643__$1;
(statearr_47669_49610[(2)] = null);

(statearr_47669_49610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (4))){
var inst_47606 = (state_47643[(9)]);
var inst_47606__$1 = (state_47643[(2)]);
var inst_47607 = (inst_47606__$1 == null);
var inst_47608 = cljs.core.not(inst_47607);
var state_47643__$1 = (function (){var statearr_47674 = state_47643;
(statearr_47674[(9)] = inst_47606__$1);

return statearr_47674;
})();
if(inst_47608){
var statearr_47677_49614 = state_47643__$1;
(statearr_47677_49614[(1)] = (5));

} else {
var statearr_47678_49615 = state_47643__$1;
(statearr_47678_49615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (15))){
var inst_47633 = (state_47643[(2)]);
var state_47643__$1 = state_47643;
var statearr_47681_49620 = state_47643__$1;
(statearr_47681_49620[(2)] = inst_47633);

(statearr_47681_49620[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (13))){
var state_47643__$1 = state_47643;
var statearr_47684_49621 = state_47643__$1;
(statearr_47684_49621[(2)] = null);

(statearr_47684_49621[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (6))){
var inst_47603 = (state_47643[(8)]);
var inst_47629 = (inst_47603 > (0));
var state_47643__$1 = state_47643;
if(cljs.core.truth_(inst_47629)){
var statearr_47687_49623 = state_47643__$1;
(statearr_47687_49623[(1)] = (12));

} else {
var statearr_47688_49625 = state_47643__$1;
(statearr_47688_49625[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (3))){
var inst_47641 = (state_47643[(2)]);
var state_47643__$1 = state_47643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47643__$1,inst_47641);
} else {
if((state_val_47644 === (12))){
var inst_47602 = (state_47643[(7)]);
var inst_47631 = cljs.core.vec(inst_47602);
var state_47643__$1 = state_47643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47643__$1,(15),out,inst_47631);
} else {
if((state_val_47644 === (2))){
var state_47643__$1 = state_47643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47643__$1,(4),ch);
} else {
if((state_val_47644 === (11))){
var inst_47623 = (state_47643[(2)]);
var inst_47624 = (new Array(n));
var inst_47602 = inst_47624;
var inst_47603 = (0);
var state_47643__$1 = (function (){var statearr_47695 = state_47643;
(statearr_47695[(7)] = inst_47602);

(statearr_47695[(8)] = inst_47603);

(statearr_47695[(10)] = inst_47623);

return statearr_47695;
})();
var statearr_47696_49629 = state_47643__$1;
(statearr_47696_49629[(2)] = null);

(statearr_47696_49629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (9))){
var inst_47602 = (state_47643[(7)]);
var inst_47621 = cljs.core.vec(inst_47602);
var state_47643__$1 = state_47643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47643__$1,(11),out,inst_47621);
} else {
if((state_val_47644 === (5))){
var inst_47606 = (state_47643[(9)]);
var inst_47602 = (state_47643[(7)]);
var inst_47611 = (state_47643[(11)]);
var inst_47603 = (state_47643[(8)]);
var inst_47610 = (inst_47602[inst_47603] = inst_47606);
var inst_47611__$1 = (inst_47603 + (1));
var inst_47612 = (inst_47611__$1 < n);
var state_47643__$1 = (function (){var statearr_47697 = state_47643;
(statearr_47697[(12)] = inst_47610);

(statearr_47697[(11)] = inst_47611__$1);

return statearr_47697;
})();
if(cljs.core.truth_(inst_47612)){
var statearr_47698_49633 = state_47643__$1;
(statearr_47698_49633[(1)] = (8));

} else {
var statearr_47699_49634 = state_47643__$1;
(statearr_47699_49634[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (14))){
var inst_47636 = (state_47643[(2)]);
var inst_47637 = cljs.core.async.close_BANG_(out);
var state_47643__$1 = (function (){var statearr_47703 = state_47643;
(statearr_47703[(13)] = inst_47636);

return statearr_47703;
})();
var statearr_47704_49636 = state_47643__$1;
(statearr_47704_49636[(2)] = inst_47637);

(statearr_47704_49636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (10))){
var inst_47627 = (state_47643[(2)]);
var state_47643__$1 = state_47643;
var statearr_47707_49644 = state_47643__$1;
(statearr_47707_49644[(2)] = inst_47627);

(statearr_47707_49644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47644 === (8))){
var inst_47602 = (state_47643[(7)]);
var inst_47611 = (state_47643[(11)]);
var tmp47702 = inst_47602;
var inst_47602__$1 = tmp47702;
var inst_47603 = inst_47611;
var state_47643__$1 = (function (){var statearr_47717 = state_47643;
(statearr_47717[(7)] = inst_47602__$1);

(statearr_47717[(8)] = inst_47603);

return statearr_47717;
})();
var statearr_47719_49650 = state_47643__$1;
(statearr_47719_49650[(2)] = null);

(statearr_47719_49650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47721 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47721[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47721[(1)] = (1));

return statearr_47721;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_47643){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47643);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47722){var ex__43598__auto__ = e47722;
var statearr_47725_49659 = state_47643;
(statearr_47725_49659[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47643[(4)]))){
var statearr_47726_49661 = state_47643;
(statearr_47726_49661[(1)] = cljs.core.first((state_47643[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49663 = state_47643;
state_47643 = G__49663;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_47643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_47643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47727 = f__43975__auto__();
(statearr_47727[(6)] = c__43974__auto___49604);

return statearr_47727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47742 = arguments.length;
switch (G__47742) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43974__auto___49667 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_47804){
var state_val_47805 = (state_47804[(1)]);
if((state_val_47805 === (7))){
var inst_47800 = (state_47804[(2)]);
var state_47804__$1 = state_47804;
var statearr_47810_49669 = state_47804__$1;
(statearr_47810_49669[(2)] = inst_47800);

(statearr_47810_49669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (1))){
var inst_47758 = [];
var inst_47759 = inst_47758;
var inst_47760 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47804__$1 = (function (){var statearr_47814 = state_47804;
(statearr_47814[(7)] = inst_47759);

(statearr_47814[(8)] = inst_47760);

return statearr_47814;
})();
var statearr_47818_49671 = state_47804__$1;
(statearr_47818_49671[(2)] = null);

(statearr_47818_49671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (4))){
var inst_47763 = (state_47804[(9)]);
var inst_47763__$1 = (state_47804[(2)]);
var inst_47764 = (inst_47763__$1 == null);
var inst_47765 = cljs.core.not(inst_47764);
var state_47804__$1 = (function (){var statearr_47820 = state_47804;
(statearr_47820[(9)] = inst_47763__$1);

return statearr_47820;
})();
if(inst_47765){
var statearr_47821_49674 = state_47804__$1;
(statearr_47821_49674[(1)] = (5));

} else {
var statearr_47822_49675 = state_47804__$1;
(statearr_47822_49675[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (15))){
var inst_47794 = (state_47804[(2)]);
var state_47804__$1 = state_47804;
var statearr_47823_49676 = state_47804__$1;
(statearr_47823_49676[(2)] = inst_47794);

(statearr_47823_49676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (13))){
var state_47804__$1 = state_47804;
var statearr_47826_49678 = state_47804__$1;
(statearr_47826_49678[(2)] = null);

(statearr_47826_49678[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (6))){
var inst_47759 = (state_47804[(7)]);
var inst_47789 = inst_47759.length;
var inst_47790 = (inst_47789 > (0));
var state_47804__$1 = state_47804;
if(cljs.core.truth_(inst_47790)){
var statearr_47827_49681 = state_47804__$1;
(statearr_47827_49681[(1)] = (12));

} else {
var statearr_47828_49682 = state_47804__$1;
(statearr_47828_49682[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (3))){
var inst_47802 = (state_47804[(2)]);
var state_47804__$1 = state_47804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47804__$1,inst_47802);
} else {
if((state_val_47805 === (12))){
var inst_47759 = (state_47804[(7)]);
var inst_47792 = cljs.core.vec(inst_47759);
var state_47804__$1 = state_47804;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47804__$1,(15),out,inst_47792);
} else {
if((state_val_47805 === (2))){
var state_47804__$1 = state_47804;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47804__$1,(4),ch);
} else {
if((state_val_47805 === (11))){
var inst_47763 = (state_47804[(9)]);
var inst_47770 = (state_47804[(10)]);
var inst_47782 = (state_47804[(2)]);
var inst_47783 = [];
var inst_47784 = inst_47783.push(inst_47763);
var inst_47759 = inst_47783;
var inst_47760 = inst_47770;
var state_47804__$1 = (function (){var statearr_47833 = state_47804;
(statearr_47833[(7)] = inst_47759);

(statearr_47833[(8)] = inst_47760);

(statearr_47833[(11)] = inst_47782);

(statearr_47833[(12)] = inst_47784);

return statearr_47833;
})();
var statearr_47834_49689 = state_47804__$1;
(statearr_47834_49689[(2)] = null);

(statearr_47834_49689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (9))){
var inst_47759 = (state_47804[(7)]);
var inst_47780 = cljs.core.vec(inst_47759);
var state_47804__$1 = state_47804;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47804__$1,(11),out,inst_47780);
} else {
if((state_val_47805 === (5))){
var inst_47763 = (state_47804[(9)]);
var inst_47760 = (state_47804[(8)]);
var inst_47770 = (state_47804[(10)]);
var inst_47770__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47763) : f.call(null,inst_47763));
var inst_47772 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47770__$1,inst_47760);
var inst_47773 = cljs.core.keyword_identical_QMARK_(inst_47760,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_47774 = ((inst_47772) || (inst_47773));
var state_47804__$1 = (function (){var statearr_47835 = state_47804;
(statearr_47835[(10)] = inst_47770__$1);

return statearr_47835;
})();
if(cljs.core.truth_(inst_47774)){
var statearr_47837_49694 = state_47804__$1;
(statearr_47837_49694[(1)] = (8));

} else {
var statearr_47838_49697 = state_47804__$1;
(statearr_47838_49697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (14))){
var inst_47797 = (state_47804[(2)]);
var inst_47798 = cljs.core.async.close_BANG_(out);
var state_47804__$1 = (function (){var statearr_47847 = state_47804;
(statearr_47847[(13)] = inst_47797);

return statearr_47847;
})();
var statearr_47849_49699 = state_47804__$1;
(statearr_47849_49699[(2)] = inst_47798);

(statearr_47849_49699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (10))){
var inst_47787 = (state_47804[(2)]);
var state_47804__$1 = state_47804;
var statearr_47850_49701 = state_47804__$1;
(statearr_47850_49701[(2)] = inst_47787);

(statearr_47850_49701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47805 === (8))){
var inst_47763 = (state_47804[(9)]);
var inst_47759 = (state_47804[(7)]);
var inst_47770 = (state_47804[(10)]);
var inst_47777 = inst_47759.push(inst_47763);
var tmp47839 = inst_47759;
var inst_47759__$1 = tmp47839;
var inst_47760 = inst_47770;
var state_47804__$1 = (function (){var statearr_47851 = state_47804;
(statearr_47851[(7)] = inst_47759__$1);

(statearr_47851[(8)] = inst_47760);

(statearr_47851[(14)] = inst_47777);

return statearr_47851;
})();
var statearr_47852_49706 = state_47804__$1;
(statearr_47852_49706[(2)] = null);

(statearr_47852_49706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43595__auto__ = null;
var cljs$core$async$state_machine__43595__auto____0 = (function (){
var statearr_47854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47854[(0)] = cljs$core$async$state_machine__43595__auto__);

(statearr_47854[(1)] = (1));

return statearr_47854;
});
var cljs$core$async$state_machine__43595__auto____1 = (function (state_47804){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_47804);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e47855){var ex__43598__auto__ = e47855;
var statearr_47856_49711 = state_47804;
(statearr_47856_49711[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_47804[(4)]))){
var statearr_47857_49713 = state_47804;
(statearr_47857_49713[(1)] = cljs.core.first((state_47804[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49714 = state_47804;
state_47804 = G__49714;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
cljs$core$async$state_machine__43595__auto__ = function(state_47804){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43595__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43595__auto____1.call(this,state_47804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43595__auto____0;
cljs$core$async$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43595__auto____1;
return cljs$core$async$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_47858 = f__43975__auto__();
(statearr_47858[(6)] = c__43974__auto___49667);

return statearr_47858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
