# declatests

```clojure
(ns some.test.util
  (:require [some.datomic.db :refer [*conn*]]
            [declatests.core :refer [->->graphql-query ->->pull-query]]
            [declatests.extras :refer :all]))

(def back-refs {:line/_order :order/lines})
  
(def enums #{:order/type :line/type})

(def fragments
  ;;; these can also be keywords, instead of symbols.
  {'...order_scalars #{:order/id
                       :order/created-at}
   '...line_scalars #{:line/id
                      :line/description}})

(def ->graphql-query (->->graphql-query fragments))
(def ->pull-query (->->pull-query fragments back-refs))

(defn ->actual [actual]
  (->> actual
       ;; Use what you want...
       decode-ids
       rm-edges-and-nodes-from-data
       rm-nils
       sort-maps))

(defn ->expected [expected]
  (->> expected
       ;; Use what you want...
       (update-enums *conn* enums)
       rm-datomic-junk
       dates->strings
       (back-refs->forward-refs back-refs)
       rm-namespaces
       vals->strings
       snake_case_all
       sort-seqs
       rm-edges-and-nodes-from-data
       sort-maps))
```

```clojure
(ns some.test.core_test
  (:require [some.test.util :refer [->graphql-query ->pull-query ->expected ->actual]]))

(deftest order-with-lines-test
  (let [orders (make-orders-and-lines ...)
        query #{[:orders
                 #{[:edges
                    #{[:node
                       #{'...order_scalars
                          #{[:edges
                             #{[:node
                                #{'...line_scalars}]}]}}]}]}]}
        expected (->expected (d/pull-many conn (->pull-query query) (map :db/id orders)))
        actual (->actual (com.walmartlabs.lacinia/execute (->graphql-query query) {} nil nil))]
    (is (= expected actual))))
```

outputs:
```clojure
(def query #{[:orders
              #{[:edges
                 #{[:node
                    #{'...order_scalars
                       #{[:edges
                          #{[:node
                             #{'...line_scalars}]}]}}]}]}]})

(println (->pull-query query))
{
  orders{
    edges {
      node {
        lines {
          edges {
            node{
              id,
              description
            }
          }
        },
        id,
        created_at
      }
    }
  }
}

(->graphql-query query)
[{:lines [:line/id :line/description]} :order/id :order/created-at]
```

TODO:
* Finished decoursin/declatest-example
* rename to declatest
* Change hash-set to vector
* Make a better README
* Add tests