(ns lens.mdr.item-ref
  (:require
    #?(:clj [clojure.spec :as s]
       :cljs [cljs.spec :as s])
            [lens.mdr.item-def]
            [lens.mdr.item-group-def]
            [odm.item-ref]))

;; A UUID v5 as combination of item-group-def-id and item-oid
(s/def ::id
  uuid?)

(s/def ::item-group-def
  :lens.mdr/item-group-def)

(s/def ::item-def
  :lens.mdr/item-def)

(s/def :lens.mdr/item-ref
  (s/merge
    (s/keys :req [::id ::item-group-def ::item-def])
    :odm/item-ref))
