/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import org.pcollections.Empty;
import org.pcollections.PCollection;
import org.pcollections.PQueue;
import org.pcollections.PStack;

public class AmortizedPQueue<E>
extends AbstractQueue<E>
implements PQueue<E> {
    private static final AmortizedPQueue<Object> EMPTY = new AmortizedPQueue();
    private final PStack<E> front;
    private final PStack<E> back;

    public static <E> AmortizedPQueue<E> empty() {
        return EMPTY;
    }

    private AmortizedPQueue() {
        this.front = Empty.stack();
        this.back = Empty.stack();
    }

    private AmortizedPQueue(AmortizedPQueue<E> amortizedPQueue, E e) {
        if (amortizedPQueue.front.size() == 0) {
            this.front = amortizedPQueue.front.plus(e);
            this.back = amortizedPQueue.back;
        } else {
            this.front = amortizedPQueue.front;
            this.back = amortizedPQueue.back.plus(e);
        }
    }

    private AmortizedPQueue(PStack<E> pStack, PStack<E> pStack2) {
        this.front = pStack;
        this.back = pStack2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private PQueue<E> queue;
            {
                this.queue = AmortizedPQueue.this;
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public E next() {
                Object e = this.queue.peek();
                this.queue = this.queue.minus();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.front.size() + this.back.size();
    }

    @Override
    public E peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.front.get(0);
    }

    @Override
    public AmortizedPQueue<E> minus() {
        if (this.size() == 0) {
            return this;
        }
        int n = this.front.size();
        if (n == 0) {
            return new AmortizedPQueue(Empty.stack().plusAll(this.back), Empty.stack()).minus();
        }
        if (n == 1) {
            return new AmortizedPQueue(Empty.stack().plusAll(this.back), Empty.stack());
        }
        return new AmortizedPQueue<E>(this.front.minus(0), this.back);
    }

    @Override
    public AmortizedPQueue<E> plus(E e) {
        return new AmortizedPQueue<E>(this, e);
    }

    @Override
    public AmortizedPQueue<E> plusAll(Collection<? extends E> collection) {
        PQueue<E> pQueue = this;
        for (E e : collection) {
            pQueue = pQueue.plus((Object)e);
        }
        return pQueue;
    }

    @Override
    public PCollection<E> minus(Object object) {
        return Empty.vector().plusAll(this).minus(object);
    }

    @Override
    public PCollection<E> minusAll(Collection<?> collection) {
        return Empty.vector().plusAll(this).minusAll(collection);
    }

    @Override
    public boolean offer(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] stringArray) {
        PQueue pQueue = new AmortizedPQueue();
        PQueue pQueue2 = pQueue = ((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)pQueue).plus((Object)1)).minus()).minus()).plus((Object)2)).plus((Object)3)).plus((Object)4)).plus((Object)5)).minus()).plus((Object)6)).plus((Object)7);
        System.out.println("    \t" + ((AmortizedPQueue)pQueue).front + " " + ((AmortizedPQueue)pQueue).back);
        while (((AmortizedPQueue)pQueue).size() > 0) {
            int n = (Integer)((AmortizedPQueue)pQueue).peek();
            pQueue = ((AmortizedPQueue)pQueue).minus();
            System.out.println(n + " <- \t" + ((AmortizedPQueue)pQueue).front + " " + ((AmortizedPQueue)pQueue).back);
        }
        System.out.println(pQueue2);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }
}

