/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.GraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.plist.PListGraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.pcollections.PSet;

public class GraphLayoutFactory {
    private Schema schema;
    private GreqlEvaluatorFacade evaluator;
    private GraphLayout currentGraphLayout;
    private GraphLayoutReader reader;
    private File graphLayoutFile;

    public GraphLayoutFactory(GreqlEvaluatorFacade greqlEvaluatorFacade) {
        this.evaluator = greqlEvaluatorFacade;
        this.schema = greqlEvaluatorFacade.getSchema();
    }

    public void setPListGraphLayoutFilename(File file) {
        this.graphLayoutFile = file;
        this.reader = new PListGraphLayoutReader(this.evaluator);
    }

    public GraphLayout createGraphLayout() {
        try {
            this.createAndLoadGraphLayoutFromFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        return this.currentGraphLayout;
    }

    public void createAndLoadGraphLayoutFromFile() throws FileNotFoundException {
        this.validate();
        this.initializeProcessingStructures();
        this.loadFromFile();
        this.applyHierarchieToTypeDefinitions();
        this.evaluateElementDefinitions();
    }

    private void loadFromFile() throws FileNotFoundException {
        if (this.reader == null) {
            return;
        }
        this.reader.startProcessing(this.graphLayoutFile, this.currentGraphLayout);
    }

    private void validate() {
        if (this.schema == null || this.evaluator == null) {
            throw new RuntimeException("The Schema, GreqlEvaluator or both are not set.");
        }
    }

    private void initializeProcessingStructures() {
        this.currentGraphLayout = new GraphLayout();
        this.currentGraphLayout.setSchema(this.schema);
        this.currentGraphLayout.initiateAllTypeDefinitions();
        this.setDefaultVertexLayout();
        this.setDefaultEdgeLayout();
    }

    private void setDefaultVertexLayout() {
        TypeDefinition typeDefinition = this.currentGraphLayout.getTypeDefinition(this.schema.getGraphClass().getDefaultVertexClass());
        typeDefinition.setAttribute("label", "'{{v' ++ id(el) ++ (printElementSequenceIndices ? ' (' ++ elementSequenceIndex ++ ')'  : '') ++ ' | ' ++ typeName(el) ++ '}|' ++ joinWithCollection(\"\\l\", from attr:attributeNames(el) reportSet (attr ++ ' = ' ++ (shortenStrings ? shortenString(toDotString(attrVal), 17) : toDotString(attrVal) ++ (printDomainNames ? ': ' ++ attributeType(el, attr) : ''))) end where attrVal := getValue(el, attr)) ++ '}'");
        typeDefinition.setAttribute("shape", "'record'");
        typeDefinition.setAttribute("color", "'#999999'");
        typeDefinition.setAttribute("fontsize", "14");
        typeDefinition.setAttribute("fontname", "'Sans Serif'");
        typeDefinition.setAttribute("margin", "'0.02,0.005'");
    }

    private void setDefaultEdgeLayout() {
        TypeDefinition typeDefinition = this.currentGraphLayout.getTypeDefinition(this.schema.getGraphClass().getDefaultEdgeClass());
        typeDefinition.setAttribute("color", "'gray'");
        typeDefinition.setAttribute("label", "'e' ++ id(el) ++ ' : ' ++ typeName(el) ++ (printElementSequenceIndices ? ' (' ++ elementSequenceIndex ++ ')'  : '') ++ (printEdgeAttributes ? '\\n' ++ joinWithCollection('\\l', from attr:attributeNames(el) reportSet ((abbreviateEdgeAttributeNames ? abbreviateString(attr) : attr) ++ ' = ' ++ (shortenStrings ? shortenString(toDotString(attrVal), 17) : toDotString(attrVal) ++ (printDomainNames ? ': ' ++ attributeType(el, attr) : ''))) end where attrVal := getValue(el, attr)) : '')");
        typeDefinition.setAttribute("arrowhead", "((sharedThis)? 'odiamond' :(compositeThis)? 'diamond': '') ++ 'normal'");
        typeDefinition.setAttribute("arrowtail", "(sharedThat) ? 'odiamond' :(compositeThat) ? 'diamond' : 'none'");
        typeDefinition.setAttribute("taillabel", "((printIncidenceIndices) ? alphaIncidenceNumber(el) : '') ++ ((printIncidenceIndices and printRolenames and nequals(alphaRolename(el), '')) ? '; ' : '') ++ ((printRolenames) ? alphaRolename(el) : '')");
        typeDefinition.setAttribute("headlabel", "((printIncidenceIndices) ? omegaIncidenceNumber(el) : '') ++ ((printIncidenceIndices and printRolenames and nequals(omegaRolename(el), '')) ? '; ' : '') ++ ((printRolenames) ? omegaRolename(el) : '')");
        typeDefinition.setAttribute("dir", "'both'");
        typeDefinition.setAttribute("fontsize", "14");
        typeDefinition.setAttribute("fontname", "'Sans Serif'");
        typeDefinition.setAttribute("labelfontsize", "10");
        typeDefinition.setAttribute("labelfontname", "'Sans Serif'");
    }

    private void applyHierarchieToTypeDefinitions() {
        this.applyHierarchie(this.currentGraphLayout.vertexTypeDefinitions, true);
        this.applyHierarchie(this.currentGraphLayout.edgeTypeDefinitions, false);
    }

    private <T extends GraphElementClass<?, ?>> void applyHierarchie(Map<T, TypeDefinition> map, boolean bl) {
        ArrayList<GraphElementClass<VertexClass, Vertex>> arrayList = new ArrayList<GraphElementClass<VertexClass, Vertex>>();
        if (bl) {
            arrayList.addAll(this.schema.getGraphClass().getVertexClasses());
        } else {
            arrayList.addAll(this.schema.getGraphClass().getEdgeClasses());
        }
        for (Map.Entry<T, TypeDefinition> entry : map.entrySet()) {
            GraphElementClass graphElementClass = (GraphElementClass)entry.getKey();
            ArrayList<GraphElementClass<VertexClass, Vertex>> arrayList2 = new ArrayList<GraphElementClass<VertexClass, Vertex>>(arrayList);
            arrayList2.retainAll(graphElementClass.getAllSuperClasses());
            if (bl) {
                arrayList2.add(0, graphElementClass.getGraphClass().getDefaultVertexClass());
            } else {
                arrayList2.add(0, graphElementClass.getGraphClass().getDefaultEdgeClass());
            }
            Collections.reverse(arrayList2);
            for (AttributedElementClass attributedElementClass : arrayList2) {
                Definition definition = map.get(attributedElementClass);
                entry.getValue().addNonExistingAttributes(definition);
            }
        }
    }

    private void evaluateElementDefinitions() {
        for (ElementDefinition elementDefinition : this.currentGraphLayout.elementDefinitions) {
            Object object = this.evaluator.evaluate(elementDefinition.getGreqlString());
            if (object instanceof PSet) {
                PSet pSet = (PSet)object;
                this.evaluateJValueSet(pSet, elementDefinition);
                continue;
            }
            if (!(object instanceof GraphElement)) continue;
            this.addGraphElementToElementDefinition(elementDefinition, (GraphElement)object);
        }
    }

    private void evaluateJValueSet(PSet<GraphElement<?, ?>> pSet, ElementDefinition elementDefinition) {
        for (GraphElement graphElement : pSet) {
            this.addGraphElementToElementDefinition(elementDefinition, graphElement);
        }
    }

    private void addGraphElementToElementDefinition(ElementDefinition elementDefinition, GraphElement<?, ?> graphElement) {
        if (graphElement != null) {
            elementDefinition.add(graphElement);
            this.currentGraphLayout.attributedElementsDefinedByElementDefinitions.add(graphElement);
        }
    }
}

