/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.csv2tg;

import de.uni_koblenz.ist.utilities.csvreader.CsvReader;
import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.InternalAttributedElement;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Csv2Tg
implements FilenameFilter {
    private static final String CLI_OPTION_OUTPUT_FILE = "output";
    private static final String CLI_OPTION_CSV_FILES = "input";
    private static final String CLI_OPTION_SCHEMA = "schema";
    private static final Object COMMENT_STRING = "#";
    private Schema schema;
    private String[] csvFiles;
    private Map<VertexClass, CsvReader> vertexInstances;
    private Map<EdgeClass, CsvReader> edgeInstances;
    private Map<CsvReader, String> reader2FilenameMap;
    private CsvReader currentReader;
    private String outputFile;
    private Graph graph;
    private Map<String, Vertex> vertices;

    public static void main(String[] stringArray) throws GraphIOException {
        Csv2Tg csv2Tg = new Csv2Tg();
        csv2Tg.getOptions(stringArray);
        csv2Tg.process();
        System.out.println("Fini.");
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    protected final CommandLine processCommandLineOptions(String[] stringArray) {
        OptionHandler optionHandler = this.createOptionHandler();
        return optionHandler.parse(stringArray);
    }

    protected void getOptions(String[] stringArray) throws GraphIOException {
        CommandLine commandLine = this.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        this.setSchema(commandLine.getOptionValue(CLI_OPTION_SCHEMA));
        this.setCsvFiles(commandLine.getOptionValues(CLI_OPTION_CSV_FILES));
        this.setOutputFile(commandLine.getOptionValue(CLI_OPTION_OUTPUT_FILE));
    }

    private void setSchema(String string) throws GraphIOException {
        System.out.print("Loading Schema ... ");
        Schema schema = GraphIO.loadSchemaFromFile(string);
        if (!this.isCompiled(schema)) {
            System.out.print("compiling ... ");
            schema.compile(CodeGeneratorConfiguration.MINIMAL);
        }
        this.setSchema(schema);
        System.out.println("done.");
    }

    private boolean isCompiled(Schema schema) {
        try {
            Class.forName(schema.getQualifiedName(), true, SchemaClassManager.instance(schema.getQualifiedName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    protected final OptionHandler createOptionHandler() {
        String string = "java " + this.getClass().getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("s", CLI_OPTION_SCHEMA, true, "(required): the schema according to which the graph should be constructed.");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("i", CLI_OPTION_CSV_FILES, true, "(required): set of csv-file containing vertex / edge instance informations.");
        option2.setRequired(true);
        option2.setArgs(-2);
        option2.setArgName("files_or_folder");
        option2.setValueSeparator(' ');
        optionHandler.addOption(option2);
        Option option3 = new Option("o", CLI_OPTION_OUTPUT_FILE, true, "(required): the output file name, or empty for stdout");
        option3.setRequired(true);
        option3.setArgName("file");
        optionHandler.addOption(option3);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        this.setUp();
        try {
            this.loadCsvFiles();
            this.processVertexFiles();
            this.processEdgeFiles();
            System.out.println("Finished Processing.");
            System.out.print("Saving Graph ...");
            GraphIO.saveGraphToFile(this.graph, this.outputFile, null);
            System.out.print("done.");
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            noSuchAttributeException.printStackTrace();
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("An error occured while processing " + this.currentReader.getLineNumber() + " in file \"" + this.reader2FilenameMap.get(this.currentReader) + "\".");
            iOException.printStackTrace();
        }
        finally {
            try {
                this.tearDown();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setUp() {
        this.vertices = new HashMap<String, Vertex>();
        this.vertexInstances = new HashMap<VertexClass, CsvReader>();
        this.edgeInstances = new HashMap<EdgeClass, CsvReader>();
        this.reader2FilenameMap = new HashMap<CsvReader, String>();
        this.graph = this.schema.createGraph(ImplementationType.GENERIC);
    }

    private void tearDown() throws IOException {
        this.vertices = null;
        this.graph = null;
        this.closeAllReader(this.vertexInstances.values());
        this.closeAllReader(this.edgeInstances.values());
        this.vertexInstances = null;
        this.edgeInstances = null;
        this.reader2FilenameMap = null;
    }

    private void closeAllReader(Collection<CsvReader> collection) throws IOException {
        for (CsvReader csvReader : collection) {
            csvReader.close();
        }
    }

    private void processEdgeFiles() throws NoSuchAttributeException, IOException, GraphIOException {
        for (Map.Entry<EdgeClass, CsvReader> entry : this.edgeInstances.entrySet()) {
            this.currentReader = entry.getValue();
            System.out.println("\tprocessing file: " + this.reader2FilenameMap.get(this.currentReader));
            while (this.currentReader.readRecord()) {
                this.createEdge(this.currentReader, entry.getKey());
            }
        }
    }

    private void processVertexFiles() throws NoSuchAttributeException, IOException, GraphIOException {
        for (Map.Entry<VertexClass, CsvReader> entry : this.vertexInstances.entrySet()) {
            this.currentReader = entry.getValue();
            while (this.currentReader.readRecord()) {
                this.createVertex(this.currentReader, entry.getKey());
            }
            System.out.println("\tprocessing file: " + this.reader2FilenameMap.get(this.currentReader));
        }
    }

    private void loadCsvFiles() throws NoSuchAttributeException, GraphIOException, IOException {
        for (String string : this.csvFiles) {
            this.loadCsvFile(string);
        }
    }

    private void loadCsvFile(String string) throws NoSuchAttributeException, GraphIOException, IOException {
        CsvReader csvReader = this.openCvsFile(string);
        this.reader2FilenameMap.put(csvReader, string);
        String string2 = csvReader.getFieldNames().get(0);
        Object t = this.schema.getAttributedElementClass(string2);
        if (t instanceof VertexClass) {
            this.vertexInstances.put((VertexClass)t, csvReader);
        } else {
            this.edgeInstances.put((EdgeClass)t, csvReader);
        }
    }

    private CsvReader openCvsFile(String string) {
        try {
            CsvReader csvReader = new CsvReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8")), 1);
            return csvReader;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("An error occured while opening the file \"" + string + "\".", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while opening the file \"" + string + "\".", iOException);
        }
    }

    private void createVertex(CsvReader csvReader, VertexClass vertexClass) throws NoSuchAttributeException, GraphIOException {
        Object t = this.graph.createVertex(vertexClass);
        this.insertAttribute((AttributedElement<?, ?>)t, csvReader, 1);
        String string = csvReader.getFieldAt(0);
        if (this.vertices.containsKey(string)) {
            throw new RuntimeException("The unique name \"" + string + "\" isn't in fact unique. This error occured while " + "processing the file \"" + this.reader2FilenameMap.get(csvReader) + "\".");
        }
        this.vertices.put(string, (Vertex)t);
    }

    private void createEdge(CsvReader csvReader, EdgeClass edgeClass) throws NoSuchAttributeException, GraphIOException {
        Vertex vertex = this.getVertex(csvReader, 1);
        Vertex vertex2 = this.getVertex(csvReader, 2);
        Object t = this.graph.createEdge(edgeClass, vertex, vertex2);
        this.insertAttribute((AttributedElement<?, ?>)t, csvReader, 3);
    }

    private void insertAttribute(AttributedElement<?, ?> attributedElement, CsvReader csvReader, int n) throws NoSuchAttributeException, GraphIOException {
        List<String> list = csvReader.getFieldNames();
        for (int i = n; i < list.size(); ++i) {
            String string = list.get(i);
            String string2 = csvReader.getFieldAt(i);
            if (string.equals(COMMENT_STRING) || string2.isEmpty()) continue;
            String string3 = this.transformCsvStringValue(string2);
            try {
                ((InternalAttributedElement)((Object)attributedElement)).readAttributeValueFromString(string, string3);
                continue;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new RuntimeException("The attribute \"" + string + "\" with value \"" + string3 + "\" in line " + i + " is not a valid attribute name for " + attributedElement.getGraphClass().getQualifiedName(), noSuchAttributeException);
            }
        }
    }

    private String transformCsvStringValue(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = GraphIO.toUtfString(string.substring(1, string.length() - 1).replace("\\\"", "\""));
        }
        return string;
    }

    private Vertex getVertex(CsvReader csvReader, int n) {
        String string = csvReader.getFieldAt(n);
        Vertex vertex = this.vertices.get(string);
        if (vertex == null) {
            throw new RuntimeException("Couldn't find vertex \"" + string + "\" in line: " + csvReader.getLineNumber() + "in file \"" + this.reader2FilenameMap.get(csvReader) + "\".");
        }
        return vertex;
    }

    public String[] getCsvFiles() {
        return this.csvFiles;
    }

    public void setCsvFiles(String[] stringArray) {
        this.csvFiles = this.getFilesInFolder(stringArray);
    }

    private String[] getFilesInFolder(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            File file = new File(string).getAbsoluteFile();
            if (!file.exists()) {
                throw new RuntimeException("File or folder \"" + string + "\" does not exist!");
            }
            if (file.isDirectory()) {
                for (File file2 : file.listFiles(this)) {
                    hashSet.add(file2.getAbsolutePath());
                }
                continue;
            }
            hashSet.add(file.getAbsolutePath());
        }
        if (hashSet.isEmpty()) {
            throw new RuntimeException("No csv-files to convert to a tg-file.");
        }
        String[] stringArray2 = new String[hashSet.size()];
        return hashSet.toArray(stringArray2);
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    @Override
    public boolean accept(File file, String string) {
        return string.endsWith(".csv");
    }
}

