/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.TreeSet;

public class EdgeCodeGenerator
extends AttributedElementCodeGenerator<EdgeClass, Edge> {
    public EdgeCodeGenerator(EdgeClass edgeClass, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(edgeClass, string, codeGeneratorConfiguration);
        this.rootBlock.setVariable("graphElementClass", "Edge");
        this.rootBlock.setVariable("schemaElementClass", "EdgeClass");
        for (EdgeClass edgeClass2 : edgeClass.getDirectSuperClasses().plus(edgeClass.getGraphClass().getDefaultEdgeClass())) {
            this.interfaces.add(edgeClass2.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "EdgeClass";
    }

    @Override
    protected CodeBlock createHeader() {
        CodeList codeList = new CodeList();
        EdgeClass edgeClass = (EdgeClass)this.aec;
        codeList.setVariable("fromVertexClass", edgeClass.getFrom().getVertexClass().getQualifiedName());
        codeList.setVariable("toVertexClass", edgeClass.getTo().getVertexClass().getQualifiedName());
        codeList.setVariable("fromRoleName", edgeClass.getFrom().getRolename());
        codeList.setVariable("toRoleName", edgeClass.getTo().getRolename());
        codeList.setVariable("ecName", edgeClass.getQualifiedName());
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("/**");
        codeSnippet.add(" * FromVertexClass: #fromVertexClass#");
        codeSnippet.add(" * FromRoleName : #fromRoleName#");
        codeSnippet.add(" * ToVertexClass: #toVertexClass#");
        codeSnippet.add(" * ToRoleName : #toRoleName#");
        codeSnippet.add(" */");
        codeList.addNoIndent(codeSnippet);
        codeList.addNoIndent(super.createHeader());
        return codeList;
    }

    @Override
    protected CodeBlock createConstructor() {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.Vertex");
        codeList.addNoIndent(new CodeSnippet(true, "public #simpleClassName#Impl(int id, #jgPackage#.Graph g, Vertex alpha, Vertex omega) {", "\tsuper(id, g, alpha, omega);"));
        if (this.hasDefaultAttributeValues()) {
            codeList.addNoIndent(new CodeSnippet("\t((de.uni_koblenz.jgralab.impl.InternalAttributedElement) this).internalInitializeAttributesWithDefaultValues();"));
        }
        codeList.add(this.createSpecialConstructorCode());
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createSpecialConstructorCode() {
        if (this.currentCycle.isStdImpl()) {
            return new CodeSnippet("((#jgImplPackage#.InternalGraph) graph).addEdge(this, alpha, omega);");
        }
        return super.createSpecialConstructorCode();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            this.rootBlock.setVariable("baseClassName", "EdgeImpl");
            this.addImports("#jgImplStdPackage#.#baseClassName#");
        }
        if (this.config.hasTypeSpecificMethodsSupport() && !this.currentCycle.isClassOnly()) {
            codeList.add(this.createNextEdgeMethods());
            codeList.add(this.createNextIncidenceMethods());
        }
        if (this.currentCycle.isStdImpl()) {
            codeList.add(this.createGetAggregationKindMethod());
            codeList.add(this.createGetAlphaAggregationKindMethod());
            codeList.add(this.createGetOmegaAggregationKindMethod());
            codeList.add(this.createReversedEdgeMethod());
        }
        codeList.add(this.createGetAlphaOmegaOverrides());
        return codeList;
    }

    private CodeBlock createReversedEdgeMethod() {
        CodeSnippet codeSnippet = new CodeSnippet(true, "protected #jgImplPackage#.ReversedEdgeBaseImpl createReversedEdge() {");
        if (this.currentCycle.isStdImpl()) {
            this.addImports("#schemaImplStdPackage#.Reversed#simpleClassName#Impl");
        }
        codeSnippet.add("\treturn new Reversed#simpleClassName#Impl(this, graph);");
        codeSnippet.add("}");
        return codeSnippet;
    }

    private CodeBlock createGetAlphaOmegaOverrides() {
        CodeSnippet codeSnippet = new CodeSnippet();
        EdgeClass edgeClass = (EdgeClass)this.aec;
        VertexClass vertexClass = edgeClass.getFrom().getVertexClass();
        VertexClass vertexClass2 = edgeClass.getTo().getVertexClass();
        codeSnippet.setVariable("fromVertexClass", vertexClass.getSimpleName());
        codeSnippet.setVariable("toVertexClass", vertexClass2.getSimpleName());
        if (!vertexClass.isDefaultGraphElementClass()) {
            this.addImports(this.schemaRootPackageName + "." + vertexClass.getQualifiedName());
        }
        if (!vertexClass2.isDefaultGraphElementClass()) {
            this.addImports(this.schemaRootPackageName + "." + vertexClass2.getQualifiedName());
        }
        if (this.currentCycle.isAbstract()) {
            if (!vertexClass.isDefaultGraphElementClass()) {
                codeSnippet.add("public #fromVertexClass# getAlpha();");
            }
            if (!vertexClass2.isDefaultGraphElementClass()) {
                codeSnippet.add("public #toVertexClass# getOmega();");
            }
        } else {
            if (!vertexClass.isDefaultGraphElementClass()) {
                codeSnippet.add("public #fromVertexClass# getAlpha() {");
                codeSnippet.add("\treturn (#fromVertexClass#) super.getAlpha();");
                codeSnippet.add("}");
            }
            if (!vertexClass2.isDefaultGraphElementClass()) {
                codeSnippet.add("public #toVertexClass# getOmega() {");
                codeSnippet.add("\treturn (#toVertexClass#) super.getOmega();");
                codeSnippet.add("}");
            }
        }
        return codeSnippet;
    }

    private CodeBlock createNextEdgeMethods() {
        CodeList codeList = new CodeList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        treeSet.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (AttributedElementClass attributedElementClass : treeSet) {
                EdgeClass edgeClass = (EdgeClass)attributedElementClass;
                codeList.addNoIndent(this.createNextEdgeMethod(edgeClass));
            }
        }
        return codeList;
    }

    private CodeBlock createNextEdgeMethod(EdgeClass edgeClass) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("ecQualifiedName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        codeSnippet.setVariable("ecCamelName", EdgeCodeGenerator.camelCase(edgeClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", "");
        codeSnippet.setVariable("actualParams", "");
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * @return the next #ecQualifiedName# edge in the global edge sequence");
            codeSnippet.add(" */", "public #ecQualifiedName# getNext#ecCamelName#InGraph(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public #ecQualifiedName# getNext#ecCamelName#InGraph(#formalParams#) {", "\treturn (#ecQualifiedName#)getNextEdge(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createNextIncidenceMethods() {
        CodeList codeList = new CodeList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        treeSet.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (GraphElementClass graphElementClass : treeSet) {
                this.addImports("#jgPackage#.EdgeDirection");
                EdgeClass edgeClass = (EdgeClass)graphElementClass;
                codeList.addNoIndent(this.createNextIncidenceMethod(edgeClass, false));
                codeList.addNoIndent(this.createNextIncidenceMethod(edgeClass, true));
            }
        }
        return codeList;
    }

    private CodeBlock createNextIncidenceMethod(EdgeClass edgeClass, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("ecQualifiedName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        codeSnippet.setVariable("ecCamelName", EdgeCodeGenerator.camelCase(edgeClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", bl ? "EdgeDirection orientation" : "");
        codeSnippet.setVariable("actualParams", bl ? ", orientation" : "");
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * @return the next edge of class #ecQualifiedName# at the \"this\" vertex");
            if (bl) {
                codeSnippet.add(" * @param orientation the orientation of the edge");
            }
            codeSnippet.add(" */", "public #ecQualifiedName# getNext#ecCamelName#Incidence(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public #ecQualifiedName# getNext#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecQualifiedName#)getNextIncidence(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createGetAggregationKindMethod() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        EdgeClass edgeClass = (EdgeClass)this.aec;
        String string = "NONE";
        if (edgeClass.getTo().getAggregationKind() == AggregationKind.COMPOSITE || edgeClass.getFrom().getAggregationKind() == AggregationKind.COMPOSITE) {
            string = "COMPOSITE";
        } else if (edgeClass.getTo().getAggregationKind() == AggregationKind.SHARED || edgeClass.getFrom().getAggregationKind() == AggregationKind.SHARED) {
            string = "SHARED";
        }
        codeSnippet.setVariable("semantics", string);
        codeSnippet.add("public de.uni_koblenz.jgralab.schema.AggregationKind getAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return codeSnippet;
    }

    private CodeBlock createGetAlphaAggregationKindMethod() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        EdgeClass edgeClass = (EdgeClass)this.aec;
        codeSnippet.setVariable("semantics", edgeClass.getFrom().getAggregationKind().toString());
        codeSnippet.add("@Override", "public de.uni_koblenz.jgralab.schema.AggregationKind getAlphaAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return codeSnippet;
    }

    private CodeBlock createGetOmegaAggregationKindMethod() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        EdgeClass edgeClass = (EdgeClass)this.aec;
        codeSnippet.setVariable("semantics", edgeClass.getTo().getAggregationKind().toString());
        codeSnippet.add("@Override", "public de.uni_koblenz.jgralab.schema.AggregationKind getOmegaAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return codeSnippet;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        CodeSnippet codeSnippet = new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# EC = #schemaPackageName#.#schemaName#.instance().getGraphClass().getEdgeClass(\"#ecQualifiedName#\");");
        codeSnippet.setVariable("ecQualifiedName", ((EdgeClass)this.aec).getQualifiedName());
        return codeSnippet;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.EC;", "}");
    }
}

