/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.AddSubClass;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class AddSubClasses
extends Transformation<GraphElementClass<?, ?>> {
    private GraphElementClass<?, ?> superClass;
    private GraphElementClass<?, ?>[] subClasses;

    public AddSubClasses(Context context, VertexClass vertexClass, VertexClass ... vertexClassArray) {
        super(context);
        this.superClass = vertexClass;
        this.subClasses = vertexClassArray;
        if (vertexClassArray.length < 1) {
            throw new GReTLException(context, "No subclasses given!");
        }
    }

    public AddSubClasses(Context context, EdgeClass edgeClass, EdgeClass ... edgeClassArray) {
        super(context);
        this.superClass = edgeClass;
        this.subClasses = edgeClassArray;
        if (edgeClassArray.length < 1) {
            throw new GReTLException(context, "No subclasses given!");
        }
    }

    public static AddSubClasses parseAndCreate(ExecuteTransformation executeTransformation) {
        GraphElementClass<?, ?> graphElementClass = executeTransformation.matchGraphElementClass();
        if (graphElementClass instanceof VertexClass) {
            VertexClass[] vertexClassArray = executeTransformation.matchVertexClassArray();
            return new AddSubClasses(executeTransformation.context, (VertexClass)graphElementClass, vertexClassArray);
        }
        EdgeClass[] edgeClassArray = executeTransformation.matchEdgeClassArray();
        return new AddSubClasses(executeTransformation.context, (EdgeClass)graphElementClass, edgeClassArray);
    }

    @Override
    protected GraphElementClass<?, ?> transform() {
        for (GraphElementClass<?, ?> graphElementClass : this.subClasses) {
            if (this.superClass instanceof VertexClass) {
                new AddSubClass(this.context, (VertexClass)this.superClass, (VertexClass)graphElementClass).execute();
                continue;
            }
            new AddSubClass(this.context, (EdgeClass)this.superClass, (EdgeClass)graphElementClass).execute();
        }
        return this.superClass;
    }
}

