/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.schema;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import org.pcollections.PMap;
import org.pcollections.PVector;

public class Attributes
extends Function {
    public Attributes() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"cls"}, description="Returns the attribute names and domains of the specified schema class in terms of a vector containing one map per attribute with the keys name and domain.", categories={Function.Category.SCHEMA_ACCESS})
    public PVector<PMap<String, String>> evaluate(AttributedElementClass<?, ?> attributedElementClass) {
        PVector<PMap<String, String>> pVector = JGraLab.vector();
        for (Attribute attribute : attributedElementClass.getAttributeList()) {
            PMap<String, String> pMap = JGraLab.map();
            pMap = pMap.plus("name", attribute.getName()).plus("domain", attribute.getDomain().getQualifiedName());
            pVector = pVector.plus(pMap);
        }
        return pVector;
    }

    @Description(params={"el"}, description="Returns the attribute names and domains of the specified element in terms of a vector containing one map per attribute with the keys name and domain.", categories={Function.Category.SCHEMA_ACCESS})
    public PVector<PMap<String, String>> evaluate(AttributedElement<?, ?> attributedElement) {
        return this.evaluate((AttributedElementClass<?, ?>)attributedElement.getAttributedElementClass());
    }
}

