/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.plist;

import de.uni_koblenz.ist.utilities.plist.PList;
import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;

class PListProcessor
extends XmlProcessor {
    private PListDict dict;
    private Stack<StackEntry> objectStack;

    PListProcessor() {
    }

    @Override
    protected void startElement(String string) throws XMLStreamException {
        if (this.objectStack == null) {
            throw new IllegalStateException("startElement called before startDocument");
        }
        StackEntry stackEntry = new StackEntry();
        stackEntry.tag = string;
        if (stackEntry.tag.equals("dict")) {
            stackEntry.dict = new PListDict();
        } else if (stackEntry.tag.equals("array")) {
            stackEntry.array = new Vector();
        }
        this.objectStack.push(stackEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endElement(String string, StringBuilder stringBuilder) throws XMLStreamException {
        if (this.objectStack == null) {
            throw new IllegalStateException("endElement called before startDocument");
        }
        StackEntry stackEntry = this.objectStack.pop();
        StackEntry stackEntry2 = null;
        if (this.objectStack.size() > 0) {
            stackEntry2 = this.objectStack.peek();
        }
        if (stackEntry.tag.equals("string")) {
            stackEntry.value = stringBuilder.toString();
        } else if (stackEntry.tag.equals("key")) {
            stackEntry2.lastKey = stringBuilder.toString();
        } else if (stackEntry.tag.equals("integer")) {
            stackEntry.value = Integer.parseInt(stringBuilder.toString());
        } else if (stackEntry.tag.equals("real")) {
            stackEntry.value = Double.parseDouble(stringBuilder.toString());
        } else if (stackEntry.tag.equals("date")) {
            try {
                DateFormat dateFormat = PList.dateFormat;
                synchronized (dateFormat) {
                    stackEntry.value = PList.dateFormat.parse(stringBuilder.toString());
                }
            }
            catch (ParseException parseException) {
                stackEntry.value = null;
            }
        } else {
            if (stackEntry.tag.equals("data")) {
                throw new XMLStreamException("property list element 'data' not yet implemented");
            }
            if (stackEntry.tag.equals("true")) {
                stackEntry.value = true;
            } else if (stackEntry.tag.equals("false")) {
                stackEntry.value = false;
            } else if (stackEntry.tag.equals("dict")) {
                stackEntry.value = stackEntry.dict;
            } else if (stackEntry.tag.equals("array")) {
                stackEntry.value = stackEntry.array;
            }
        }
        if (stackEntry2 != null) {
            if (stackEntry2.dict != null && stackEntry2.lastKey != null && !stackEntry.tag.equals("key")) {
                stackEntry2.dict.put(stackEntry2.lastKey, stackEntry.value);
                stackEntry2.lastKey = null;
            } else if (stackEntry2.array != null) {
                stackEntry2.array.add(stackEntry.value);
            } else if (stackEntry2.tag.equals("plist")) {
                this.dict = (PListDict)stackEntry.value;
            }
        }
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        if (this.objectStack != null) {
            throw new IllegalStateException("startDocument called multiple times");
        }
        this.objectStack = new Stack();
    }

    @Override
    protected void endDocument() throws XMLStreamException {
        if (this.objectStack == null) {
            throw new IllegalStateException("endDocument called before startDocument");
        }
        this.objectStack = null;
    }

    public PListDict getDict() {
        return this.dict;
    }

    private static class StackEntry {
        String tag;
        String lastKey;
        PListDict dict;
        Vector<Object> array;
        Object value;

        private StackEntry() {
        }
    }
}

