/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasBaseDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasKeyDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.HasValueDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.SetDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDefaultPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.DefinesGraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SchemaGraph2Schema {
    private static final EdgeDirection OUTGOING = EdgeDirection.OUT;
    private de.uni_koblenz.jgralab.schema.Schema schema;
    private Schema gSchema;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gGraphElementClasses;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gTempVertexClasses;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> gTempEdgeClasses;
    private ArrayList<Domain> gDomains;
    private HashMap<de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass, IncidenceClass> incidenceMap;
    private ArrayList<de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> gSuperEdgeClasses;
    private GraphClass graphClass;
    private boolean workInProgress = false;
    private final HashSet<String> rdNames = new HashSet();

    private void setUp() {
        this.incidenceMap = new HashMap();
        this.gGraphElementClasses = new ArrayList();
        this.gTempVertexClasses = new ArrayList();
        this.gTempEdgeClasses = new ArrayList();
        this.gDomains = new ArrayList();
        this.gSuperEdgeClasses = new ArrayList();
    }

    private void tearDown() {
        this.incidenceMap = null;
        this.gSchema = null;
        this.schema = null;
        this.graphClass = null;
        this.gGraphElementClasses = null;
        this.gDomains = null;
        this.gSuperEdgeClasses = null;
    }

    public de.uni_koblenz.jgralab.schema.Schema convert(SchemaGraph schemaGraph) {
        de.uni_koblenz.jgralab.schema.Schema schema = null;
        if (!this.workInProgress) {
            this.workInProgress = true;
            this.setUp();
            this.createSchema(schemaGraph);
            this.createGraphClass();
            this.retrieveAllGraphElementClassesAndDomains();
            this.createAllDomains();
            this.createAllGraphElementClasses();
            this.linkSuperClasses();
            this.addAllPackageComments(schemaGraph);
            schema = this.schema;
            schema.finish();
            this.tearDown();
            this.workInProgress = false;
        }
        return schema;
    }

    private void addAllPackageComments(SchemaGraph schemaGraph) {
        for (de.uni_koblenz.jgralab.grumlschema.structure.Package package_ : schemaGraph.getPackageVertices()) {
            if (package_.getFirstAnnotatesIncidence() == null) continue;
            Package package_2 = this.schema.getPackage(package_.get_qualifiedName());
            for (Comment comment : package_.get_comments()) {
                package_2.addComment(comment.get_text());
            }
        }
    }

    private void createSchema(SchemaGraph schemaGraph) {
        this.gSchema = schemaGraph.getFirstSchema();
        assert (this.gSchema != null) : "FIXME! The Schema of the SchemaGraph should be null.";
        String string = this.gSchema.get_name();
        String string2 = this.gSchema.get_packagePrefix();
        assert (string != null && string2 != null) : "One of attributes \"name\" or \"packagePrefix\" is null";
        this.schema = new SchemaImpl(string, string2);
        assert (this.schema.getName().equals(string) && this.schema.getPackagePrefix().equals(string2)) : "The attribute \"name\" or \"packagePrefix\" is not equal.";
    }

    private void createGraphClass() {
        assert (this.gSchema != null) : "FIXME! The Schema of the SchemaGraph shouldn't be null.";
        DefinesGraphClass definesGraphClass = this.gSchema.getFirstDefinesGraphClassIncidence(OUTGOING);
        assert (definesGraphClass != null) : "FIXME! No \"DefinesGraphClass\" edge defined.";
        assert (definesGraphClass.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.GraphClass) : "FIXME! That is not an instance of \"GraphClass\"";
        de.uni_koblenz.jgralab.grumlschema.structure.GraphClass graphClass = (de.uni_koblenz.jgralab.grumlschema.structure.GraphClass)definesGraphClass.getThat();
        assert (definesGraphClass.getNextDefinesGraphClassIncidence(OUTGOING) == null) : "FIXME! There is more than one GraphClass defined.";
        this.graphClass = this.schema.createGraphClass(graphClass.get_qualifiedName());
        this.createAllAttributes(this.graphClass, graphClass);
        this.createAllConstraints(this.graphClass, graphClass);
        if (graphClass.getFirstAnnotatesIncidence() != null) {
            for (String string : this.createComments(graphClass)) {
                this.graphClass.addComment(string);
            }
        }
        assert (this.graphClass.getQualifiedName().equals(graphClass.get_qualifiedName())) : "FIXME! The attribute \"qualifiedName\" is different.";
    }

    private void retrieveAllGraphElementClassesAndDomains() {
        assert (this.gSchema != null) : "FIXME! The given Schema of the SchemaGraph shouldn't be null.";
        ContainsDefaultPackage containsDefaultPackage = this.gSchema.getFirstContainsDefaultPackageIncidence(OUTGOING);
        assert (containsDefaultPackage != null) : "No \"ContainsDefaultPackage\" edge defined.";
        assert (containsDefaultPackage.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.Package) : "FIXME! That should be an instance of \"Package\".";
        de.uni_koblenz.jgralab.grumlschema.structure.Package package_ = (de.uni_koblenz.jgralab.grumlschema.structure.Package)containsDefaultPackage.getThat();
        assert (containsDefaultPackage.getNextContainsDefaultPackageIncidence(OUTGOING) == null) : "FIXME! There should be only one \"ContainsDefaultPackage\".";
        this.getAllGraphElementClassesAndDomains(package_);
        this.gGraphElementClasses.addAll(this.gTempVertexClasses);
        this.gGraphElementClasses.addAll(this.gTempEdgeClasses);
    }

    private void getAllGraphElementClassesAndDomains(de.uni_koblenz.jgralab.grumlschema.structure.Package package_) {
        this.getAllDomains(package_);
        this.getAllGraphElementClasses(package_);
        for (ContainsSubPackage containsSubPackage : package_.getContainsSubPackageIncidences(OUTGOING)) {
            assert (containsSubPackage != null && containsSubPackage.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.Package) : "FIXME! That should be an instance of Package.";
            this.getAllGraphElementClassesAndDomains(containsSubPackage.getOmega());
        }
    }

    private void getAllGraphElementClasses(de.uni_koblenz.jgralab.grumlschema.structure.Package package_) {
        for (ContainsGraphElementClass containsGraphElementClass : package_.getContainsGraphElementClassIncidences(OUTGOING)) {
            assert (containsGraphElementClass != null && containsGraphElementClass.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass) : "FIXME! That should be an instance of GraphElementClass";
            de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass = (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass)containsGraphElementClass.getThat();
            if (graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
                this.gTempVertexClasses.add(graphElementClass);
            } else {
                this.gTempEdgeClasses.add(graphElementClass);
            }
            if (!(graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) || ((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)graphElementClass).getDegree(SpecializesEdgeClass.EC, EdgeDirection.OUT) != 0) continue;
            this.gSuperEdgeClasses.add((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)graphElementClass);
        }
    }

    private void getAllDomains(de.uni_koblenz.jgralab.grumlschema.structure.Package package_) {
        for (ContainsDomain containsDomain : package_.getContainsDomainIncidences(OUTGOING)) {
            assert (containsDomain.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
            this.gDomains.add(containsDomain.getOmega());
        }
    }

    private void createAllDomains() {
        for (Domain domain : this.gDomains) {
            assert (domain != null) : "Domain is null.";
            this.createDomain(domain);
        }
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(Domain domain) {
        String string = domain.get_qualifiedName();
        de.uni_koblenz.jgralab.schema.Domain domain2 = this.schema.getDomain(string);
        if (domain2 == null) {
            if (domain instanceof EnumDomain) {
                domain2 = this.createDomain((EnumDomain)domain);
            } else if (domain instanceof MapDomain) {
                domain2 = this.createDomain((MapDomain)domain);
            } else if (domain instanceof CollectionDomain) {
                domain2 = this.createDomain((CollectionDomain)domain);
            } else if (domain instanceof RecordDomain) {
                if (this.rdNames.contains(string)) {
                    throw new RuntimeException("Cyclic dependency in record domains: " + this.rdNames);
                }
                this.rdNames.add(string);
                domain2 = this.createDomain((RecordDomain)domain);
                this.rdNames.remove(string);
            }
            if (domain.getFirstAnnotatesIncidence() != null) {
                for (String string2 : this.createComments(domain)) {
                    domain2.addComment(string2);
                }
            }
        }
        if (domain2 == null) {
            throw new GraphException("FIXME! No \"Domain\" has been created.");
        }
        assert (domain2.getQualifiedName().equals(string)) : "FIXME! The attribute \"QualifiedName\" is different (expected " + string + ", got " + domain2.getQualifiedName() + ")";
        return domain2;
    }

    private String[] createComments(NamedElement namedElement) {
        String[] stringArray = new String[namedElement.getDegree(Annotates.EC)];
        int n = 0;
        for (Annotates annotates : namedElement.getAnnotatesIncidences()) {
            Comment comment = (Comment)annotates.getThat();
            assert (comment != null) : "FIXME! There are no comments.";
            assert (n < stringArray.length) : "There are more comments than expected.";
            stringArray[n++] = comment.get_text();
        }
        return stringArray;
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(EnumDomain enumDomain) {
        return this.schema.createEnumDomain(enumDomain.get_qualifiedName(), enumDomain.get_enumConstants());
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(RecordDomain recordDomain) {
        ArrayList<RecordDomain.RecordComponent> arrayList = new ArrayList<RecordDomain.RecordComponent>();
        for (HasRecordDomainComponent hasRecordDomainComponent : recordDomain.getHasRecordDomainComponentIncidences(OUTGOING)) {
            assert (hasRecordDomainComponent != null && hasRecordDomainComponent.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
            arrayList.add(new RecordDomain.RecordComponent(hasRecordDomainComponent.get_name(), this.queryDomain((Domain)hasRecordDomainComponent.getThat())));
        }
        return this.schema.createRecordDomain(recordDomain.get_qualifiedName(), arrayList);
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(CollectionDomain collectionDomain) {
        assert (collectionDomain != null) : "FIXME! The given Domain shouldn't be null.";
        HasBaseDomain hasBaseDomain = collectionDomain.getFirstHasBaseDomainIncidence(OUTGOING);
        assert (hasBaseDomain != null) : "FIXME! No \"HasBaseDomain\" has been defined.";
        assert (hasBaseDomain.getThat() instanceof Domain) : "FIXME! That should be an instance of Domain.";
        Domain domain = (Domain)hasBaseDomain.getThat();
        assert (hasBaseDomain.getNextHasBaseDomainIncidence(OUTGOING) == null) : "FIXME! There is more than one \"HasBaseDomain\" defined.";
        return collectionDomain instanceof SetDomain ? this.schema.createSetDomain(this.queryDomain(domain)) : this.schema.createListDomain(this.queryDomain(domain));
    }

    private de.uni_koblenz.jgralab.schema.Domain createDomain(MapDomain mapDomain) {
        HasKeyDomain hasKeyDomain = mapDomain.getFirstHasKeyDomainIncidence(OUTGOING);
        assert (hasKeyDomain != null) : "No \"HasKeyDomain\" has been defined.";
        assert (hasKeyDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
        Domain domain = (Domain)hasKeyDomain.getThat();
        assert (hasKeyDomain.getNextHasKeyDomainIncidence(OUTGOING) == null) : "There is more than one \"HasKeyDomain\" defined.";
        HasValueDomain hasValueDomain = mapDomain.getFirstHasValueDomainIncidence(OUTGOING);
        assert (hasValueDomain != null) : "No \"HasValueDomain\" has been defined.";
        assert (hasValueDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
        Domain domain2 = (Domain)hasValueDomain.getThat();
        assert (hasValueDomain.getNextHasValueDomainIncidence(OUTGOING) == null) : "There is more than one \"HasValueDomain\" defined.";
        return this.schema.createMapDomain(this.queryDomain(domain), this.queryDomain(domain2));
    }

    private void createAllGraphElementClasses() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass : this.gGraphElementClasses) {
            if (!(graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)) continue;
            this.createGraphElementClass(graphElementClass);
        }
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass : this.gGraphElementClasses) {
            if (!(graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) continue;
            this.createGraphElementClass(graphElementClass);
        }
    }

    private GraphElementClass<?, ?> createGraphElementClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass) {
        GraphElementClass<VertexClass, Vertex> graphElementClass2 = null;
        if (graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
            graphElementClass2 = this.graphClass.createVertexClass(graphElementClass.get_qualifiedName());
        } else if (graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
            String[] stringArray = (String[])graphElementClass;
            GoesTo goesTo = stringArray.getFirstGoesToIncidence(OUTGOING);
            assert (goesTo != null) : "No \"To\" edge has been defined.";
            ComesFrom comesFrom = stringArray.getFirstComesFromIncidence(OUTGOING);
            assert (comesFrom != null) : "No \"From\" edge has been defined.";
            graphElementClass2 = this.createEdgeClass(graphElementClass, (de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass)goesTo.getThat(), (de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass)comesFrom.getThat());
            assert (goesTo.getNextGoesToIncidence(OUTGOING) == null && comesFrom.getNextComesFromIncidence(OUTGOING) == null) : "There is more than one To or From edge defined.";
        }
        assert (graphElementClass2 != null) : "FIXME! No GraphElementClass has been created.";
        graphElementClass2.setAbstract(graphElementClass.is_abstract());
        assert (graphElementClass2.isAbstract() == graphElementClass.is_abstract()) : "FIXME! The attribute \"isAbstract\" is not equal.";
        this.createAllAttributes(graphElementClass2, graphElementClass);
        this.createAllConstraints(graphElementClass2, graphElementClass);
        if (graphElementClass.getFirstAnnotatesIncidence() != null) {
            for (String string : this.createComments(graphElementClass)) {
                graphElementClass2.addComment(string);
            }
        }
        return graphElementClass2;
    }

    private EdgeClass createEdgeClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass incidenceClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass incidenceClass2) {
        assert (graphElementClass != null) : "The given EdgeClass of the SchemaGraph is null";
        assert (incidenceClass != null) : "No IncidenceClass for the 'to' end";
        assert (incidenceClass.getFirstEndsAtIncidence() != null) : "No target VertexClass at the 'to' end";
        assert (incidenceClass2 != null) : "No IncidenceClass for the 'from' end";
        assert (incidenceClass2.getFirstEndsAtIncidence() != null) : "No target VertexClass at the 'from' end";
        VertexClass vertexClass = this.queryVertexClass((de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)incidenceClass.getFirstEndsAtIncidence().getThat());
        int n = incidenceClass.get_min();
        int n2 = incidenceClass.get_max();
        String string = incidenceClass.get_roleName();
        AggregationKind aggregationKind = AggregationKind.valueOf(incidenceClass.get_aggregation().toString());
        VertexClass vertexClass2 = this.queryVertexClass((de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat());
        int n3 = incidenceClass2.get_min();
        int n4 = incidenceClass2.get_max();
        String string2 = incidenceClass2.get_roleName();
        AggregationKind aggregationKind2 = AggregationKind.valueOf(incidenceClass2.get_aggregation().toString());
        String string3 = graphElementClass.get_qualifiedName();
        EdgeClass edgeClass = this.graphClass.createEdgeClass(string3, vertexClass2, n3, n4, string2, aggregationKind2, vertexClass, n, n2, string, aggregationKind);
        assert (edgeClass != null) : "No EdgeClass was created.";
        assert (edgeClass.getFrom() != null) : "No from IncidenceClass was created.";
        assert (edgeClass.getTo() != null) : "No to IncidenceClass was created.";
        this.incidenceMap.put(incidenceClass2, edgeClass.getFrom());
        this.incidenceMap.put(incidenceClass, edgeClass.getTo());
        return edgeClass;
    }

    private void createAllConstraints(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> attributedElementClass, AttributedElementClass attributedElementClass2) {
        for (HasConstraint hasConstraint : attributedElementClass2.getHasConstraintIncidences(OUTGOING)) {
            assert (hasConstraint != null && hasConstraint.getThat() instanceof Constraint) : "FIXME! That should be an instance of Constraint.";
            Constraint constraint = (Constraint)hasConstraint.getThat();
            attributedElementClass.addConstraint(new ConstraintImpl(constraint.get_message(), constraint.get_predicateQuery(), constraint.get_offendingElementsQuery()));
        }
    }

    private void createAllAttributes(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> attributedElementClass, AttributedElementClass attributedElementClass2) {
        for (HasAttribute hasAttribute : attributedElementClass2.getHasAttributeIncidences(OUTGOING)) {
            assert (hasAttribute != null && hasAttribute.getThat() instanceof Attribute) : "That should be an instance of Attribute.";
            Attribute attribute = (Attribute)hasAttribute.getThat();
            assert (attribute.get_name() != null) : "The name of the Attribute is null.";
            HasDomain hasDomain = attribute.getFirstHasDomainIncidence(OUTGOING);
            assert (hasDomain != null) : "No \"HasDomain\" edge has been defined.";
            assert (hasDomain.getThat() instanceof Domain) : "That should be an instance of Domain.";
            attributedElementClass.createAttribute(attribute.get_name(), this.queryDomain((Domain)hasDomain.getThat()), attribute.get_defaultValue());
            assert (hasDomain.getNextHasDomainIncidence(OUTGOING) == null);
        }
    }

    private void linkSuperClasses() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass : this.gGraphElementClasses) {
            Object t = this.schema.getAttributedElementClass(graphElementClass.get_qualifiedName());
            assert (t != null) : "FIXME! No AttributedElementClass object found.";
            if (graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) {
                assert (t instanceof VertexClass) : "AttributeElementClass object of Schema is not an instance of an VertexClass.";
                this.linkSuperClasses((VertexClass)t, (de.uni_koblenz.jgralab.grumlschema.structure.VertexClass)graphElementClass);
                continue;
            }
            assert (graphElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) : "GraphElementClass object of the SchemaGraph is not an instance of EdgeClass.";
            assert (t instanceof EdgeClass) : "GraphElementClass object of the Schema is not an instance of EdgeClass.";
            this.linkSuperClasses((EdgeClass)t, (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)graphElementClass);
        }
    }

    private void linkSuperClasses(EdgeClass edgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2) {
        ArrayList<EdgeClass> arrayList = new ArrayList<EdgeClass>();
        for (SpecializesEdgeClass comparable : edgeClass2.getSpecializesEdgeClassIncidences(OUTGOING)) {
            assert (comparable != null && comparable.getThat() instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) : "That should be an instance of EdgeClass.";
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass3 = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)comparable.getThat();
            Object t = this.schema.getAttributedElementClass(edgeClass3.get_qualifiedName());
            assert (t instanceof EdgeClass) : "The retrieved superclass is not an instance of EdgeClass.";
            arrayList.add((EdgeClass)t);
        }
        for (EdgeClass edgeClass4 : arrayList) {
            edgeClass.addSuperClass(edgeClass4);
            ((IncidenceClassImpl)edgeClass.getFrom()).addSubsettedIncidenceClass(edgeClass4.getFrom());
            ((IncidenceClassImpl)edgeClass.getTo()).addSubsettedIncidenceClass(edgeClass4.getTo());
        }
    }

    private void linkSuperClasses(VertexClass vertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass vertexClass2) {
        ArrayList<VertexClass> arrayList = new ArrayList<VertexClass>();
        for (SpecializesVertexClass comparable : vertexClass2.getSpecializesVertexClassIncidences(OUTGOING)) {
            assert (comparable.getOmega() instanceof de.uni_koblenz.jgralab.grumlschema.structure.VertexClass) : "That should be an instance of VertexClass.";
            de.uni_koblenz.jgralab.grumlschema.structure.VertexClass vertexClass3 = comparable.getOmega();
            Object t = this.schema.getAttributedElementClass(vertexClass3.get_qualifiedName());
            assert (t instanceof VertexClass) : "The retrieved superclass is not an instance of VertexClass.";
            arrayList.add((VertexClass)t);
        }
        for (VertexClass vertexClass4 : arrayList) {
            vertexClass.addSuperClass(vertexClass4);
        }
    }

    private VertexClass queryVertexClass(de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass graphElementClass) {
        Object t = this.schema.getAttributedElementClass(graphElementClass.get_qualifiedName());
        return t instanceof VertexClass ? (VertexClass)t : null;
    }

    private de.uni_koblenz.jgralab.schema.Domain queryDomain(Domain domain) {
        de.uni_koblenz.jgralab.schema.Domain domain2 = this.schema.getDomain(domain.get_qualifiedName());
        if (domain2 == null) {
            domain2 = this.createDomain(domain);
        }
        return domain2;
    }
}

