/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.CompositeDomain;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.List;
import java.util.Stack;

public class SchemaCodeGenerator
extends CodeGenerator {
    private final Schema schema;

    public SchemaCodeGenerator(Schema schema, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(string, "", codeGeneratorConfiguration);
        this.schema = schema;
        this.rootBlock.setVariable("simpleClassName", schema.getName());
        this.rootBlock.setVariable("baseClassName", "SchemaImpl");
        this.rootBlock.setVariable("isClassOnly", "true");
        this.rootBlock.setVariable("gcName", schema.getGraphClass().getQualifiedName());
        this.rootBlock.setVariable("gcCamelName", SchemaCodeGenerator.camelCase(schema.getGraphClass().getQualifiedName()));
        this.rootBlock.setVariable("gcImplName", schema.getGraphClass().getQualifiedName() + "Impl");
    }

    @Override
    protected CodeBlock createHeader() {
        this.addImports("#jgSchemaImplPackage#.#baseClassName#");
        this.addImports("#jgSchemaPackage#.VertexClass");
        this.addImports("#jgSchemaPackage#.EdgeClass");
        this.addImports("java.lang.ref.WeakReference");
        CodeSnippet codeSnippet = new CodeSnippet(true, "/**", " * The schema #simpleClassName# is implemented following the singleton pattern.", " * To get the instance, use the static method <code>instance()</code>.", " */", "public class #simpleClassName# extends #baseClassName# {");
        return codeSnippet;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            codeList.add(this.createConstructor());
            codeList.add(this.createGetDefaultGraphFactoryMethod());
            codeList.add(this.createGraphFactoryMethods());
            codeList.add(this.createReopenMethod());
        }
        return codeList;
    }

    private CodeBlock createGetDefaultGraphFactoryMethod() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public #jgPackage#.GraphFactory createDefaultGraphFactory(#jgPackage#.ImplementationType implementationType) {"));
        codeList.add(new CodeSnippet("switch(implementationType) {"));
        codeList.add(new CodeSnippet("\tcase GENERIC:", "\t\treturn new #jgImplPackage#.generic.GenericGraphFactoryImpl(this);"));
        codeList.add(new CodeSnippet("\tcase STANDARD:", "\t\treturn new #schemaImplStdPackage#.#gcCamelName#FactoryImpl();"));
        codeList.add(new CodeSnippet("}", "throw new UnsupportedOperationException(\"No \" + implementationType + \" support compiled.\");"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    private CodeBlock createGraphFactoryMethods() {
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.ImplementationType implType) {", "\treturn create#gcCamelName#(implType, null, 100, 100);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.", " *", " * @param vMax initial vertex count", " * @param eMax initial edge count", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.ImplementationType implType, String id, int vMax, int eMax) {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn factory.createGraph(getGraphClass(), id, vMax, eMax);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.GraphFactory factory) {", "\treturn factory.createGraph(getGraphClass(), null, 100, 100);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.GraphFactory factory, String id, int vMax, int eMax) {", "\treturn factory.createGraph(getGraphClass(), id, vMax, eMax);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(#jgPackage#.ImplementationType.STANDARD);", "\treturn load#gcCamelName#(filename, factory, null);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(#jgPackage#.ImplementationType.STANDARD);", "\treturn load#gcCamelName#(filename, factory, pf);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ImplementationType implType) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn load#gcCamelName#(filename, factory, null);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "", "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ImplementationType implType, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn load#gcCamelName#(filename, factory, pf);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.GraphFactory factory) throws GraphIOException {", "\treturn GraphIO.loadGraphFromFile(filename, factory, null);", "}"));
        codeList.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.GraphFactory factory, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\treturn GraphIO.loadGraphFromFile(filename, factory, pf);", "}"));
        return codeList;
    }

    private CodeBlock createConstructor() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "/**", " * reference to the singleton instance", " */", "static WeakReference<#simpleClassName#> theInstance = new WeakReference<#simpleClassName#>(null);", "", "/**", " * @return the singleton instance of #simpleClassName#", " */", "public static synchronized #simpleClassName# instance() {", "\t#simpleClassName# s = theInstance.get();", "\tif (s != null) {", "\t\treturn s;", "\t}", "\ts = new #simpleClassName#();", "\ttheInstance = new WeakReference<#simpleClassName#>(s);", "\treturn s;", "}", "", "/**", " * Creates a #simpleClassName# and builds its schema classes.", " * This constructor is private. Use the <code>instance()</code> method", " * to access the schema.", " */", "private #simpleClassName#() {", "\tsuper(\"#simpleClassName#\", \"#schemaPackage#\");"));
        codeList.add(this.createEnumDomains());
        codeList.add(this.createCompositeDomains());
        codeList.add(this.createGraphClass());
        codeList.add(this.createPackageComments());
        codeList.addNoIndent(new CodeSnippet(true, "\tfinish();", "}"));
        return codeList;
    }

    private CodeBlock createPackageComments() {
        CodeList codeList = new CodeList();
        Package package_ = this.schema.getDefaultPackage();
        Stack<Package> stack = new Stack<Package>();
        stack.push(package_);
        boolean bl = false;
        while (!stack.isEmpty()) {
            package_ = (Package)stack.pop();
            for (Package package_2 : package_.getSubPackages()) {
                stack.push(package_2);
            }
            List<String> list = package_.getComments();
            if (list.isEmpty()) continue;
            if (!bl) {
                codeList.addNoIndent(new CodeSnippet(true, "{"));
                bl = true;
            }
            for (String string : list) {
                codeList.add(new CodeSnippet("getPackage(\"" + package_.getQualifiedName() + "\").addComment(\"" + SchemaCodeGenerator.stringQuote(string) + "\");"));
            }
        }
        if (bl) {
            codeList.addNoIndent(new CodeSnippet(false, "}"));
        }
        return codeList;
    }

    private CodeBlock createGraphClass() {
        GraphClass graphClass = this.schema.getGraphClass();
        CodeList codeList = new CodeList();
        this.addImports("#jgSchemaPackage#.GraphClass");
        codeList.setVariable("gcVariable", "gc");
        codeList.setVariable("aecVariable", "gc");
        codeList.setVariable("gcAbstract", graphClass.isAbstract() ? "true" : "false");
        codeList.addNoIndent(new CodeSnippet(true, "{", "\tGraphClass #gcVariable# = createGraphClass(\"#gcName#\");"));
        codeList.addNoIndent(this.createAttributes(graphClass));
        codeList.addNoIndent(this.createConstraints(graphClass));
        codeList.addNoIndent(this.createComments("gc", graphClass));
        codeList.addNoIndent(this.createVertexClasses(graphClass));
        codeList.addNoIndent(this.createEdgeClasses(graphClass));
        codeList.addNoIndent(new CodeSnippet(false, "}"));
        return codeList;
    }

    private CodeBlock createComments(String string, NamedElement namedElement) {
        CodeList codeList = new CodeList();
        codeList.setVariable("namedElement", string);
        for (String string2 : namedElement.getComments()) {
            codeList.addNoIndent(new CodeSnippet("#namedElement#.addComment(" + GraphIO.toUtfString(string2) + ");"));
        }
        return codeList;
    }

    private CodeBlock createEdgeClasses(GraphClass graphClass) {
        CodeList codeList = new CodeList();
        for (EdgeClass edgeClass : this.schema.getGraphClass().getEdgeClasses()) {
            codeList.addNoIndent(this.createEdgeClass(edgeClass));
        }
        return codeList;
    }

    private CodeBlock createEdgeClass(EdgeClass edgeClass) {
        CodeList codeList = new CodeList();
        this.addImports("#jgSchemaPackage#.EdgeClass");
        codeList.setVariable("ecType", "EdgeClass");
        codeList.setVariable("ecName", edgeClass.getQualifiedName());
        codeList.setVariable("aecVariable", this.gecVarName(edgeClass));
        codeList.setVariable("ecAbstract", edgeClass.isAbstract() ? "true" : "false");
        codeList.setVariable("fromClass", this.gecVarName(edgeClass.getFrom().getVertexClass()));
        codeList.setVariable("fromRole", edgeClass.getFrom().getRolename());
        codeList.setVariable("toClass", this.gecVarName(edgeClass.getTo().getVertexClass()));
        codeList.setVariable("toRole", edgeClass.getTo().getRolename());
        codeList.setVariable("toAggregation", AggregationKind.class.getCanonicalName() + "." + edgeClass.getTo().getAggregationKind().toString());
        codeList.setVariable("fromAggregation", AggregationKind.class.getCanonicalName() + "." + edgeClass.getFrom().getAggregationKind().toString());
        codeList.setVariable("fromPart", "#fromClass#, " + edgeClass.getFrom().getMin() + ", " + edgeClass.getFrom().getMax() + ", \"#fromRole#\"" + ", #fromAggregation#");
        codeList.setVariable("toPart", "#toClass#, " + edgeClass.getTo().getMin() + ", " + edgeClass.getTo().getMax() + ", \"#toRole#\"" + ", #toAggregation#");
        codeList.addNoIndent(new CodeSnippet(true, "\t#ecType# #aecVariable# = #gcVariable#.create#ecType#(\"#ecName#\",", "\t\t#fromPart#,", "\t\t#toPart#);", "\t#aecVariable#.setAbstract(#ecAbstract#);"));
        for (EdgeClass edgeClass2 : edgeClass.getDirectSuperClasses()) {
            CodeSnippet codeSnippet = new CodeSnippet("#aecVariable#.addSuperClass(#superClassName#);");
            codeSnippet.setVariable("superClassName", this.gecVarName(edgeClass2));
            codeList.add(codeSnippet);
        }
        codeList.add(this.createAttributes(edgeClass));
        codeList.add(this.createConstraints(edgeClass));
        codeList.add(this.createComments(this.gecVarName(edgeClass), edgeClass));
        return codeList;
    }

    private CodeBlock createVertexClasses(GraphClass graphClass) {
        CodeList codeList = new CodeList();
        for (VertexClass vertexClass : this.schema.getGraphClass().getVertexClasses()) {
            codeList.addNoIndent(this.createVertexClass(vertexClass));
        }
        return codeList;
    }

    private String gecVarName(GraphElementClass<?, ?> graphElementClass) {
        StringBuilder stringBuilder = new StringBuilder();
        if (graphElementClass instanceof VertexClass) {
            stringBuilder.append("vc_");
        } else {
            stringBuilder.append("ec_");
        }
        stringBuilder.append(graphElementClass.getUniqueName());
        return stringBuilder.toString();
    }

    private CodeBlock createVertexClass(VertexClass vertexClass) {
        CodeList codeList = new CodeList();
        codeList.setVariable("vcName", vertexClass.getQualifiedName());
        codeList.setVariable("aecVariable", this.gecVarName(vertexClass));
        codeList.setVariable("vcAbstract", vertexClass.isAbstract() ? "true" : "false");
        codeList.addNoIndent(new CodeSnippet(true, "\tVertexClass #aecVariable# = #gcVariable#.createVertexClass(\"#vcName#\");", "\t#aecVariable#.setAbstract(#vcAbstract#);"));
        for (VertexClass vertexClass2 : vertexClass.getDirectSuperClasses()) {
            CodeSnippet codeSnippet = new CodeSnippet("#aecVariable#.addSuperClass(#superClassName#);");
            codeSnippet.setVariable("superClassName", this.gecVarName(vertexClass2));
            codeList.add(codeSnippet);
        }
        codeList.add(this.createAttributes(vertexClass));
        codeList.add(this.createConstraints(vertexClass));
        codeList.add(this.createComments(this.gecVarName(vertexClass), vertexClass));
        return codeList;
    }

    private CodeBlock createAttributes(AttributedElementClass<?, ?> attributedElementClass) {
        CodeList codeList = new CodeList();
        List<Attribute> list = attributedElementClass instanceof GraphElementClass ? ((GraphElementClass)attributedElementClass).getOwnAttributeList() : attributedElementClass.getAttributeList();
        for (Attribute attribute : list) {
            CodeSnippet codeSnippet = new CodeSnippet(false, "#aecVariable#.createAttribute(\"#attrName#\", getDomain(\"#domainName#\"), #defaultValue#);");
            codeSnippet.setVariable("attrName", attribute.getName());
            codeSnippet.setVariable("domainName", attribute.getDomain().getQualifiedName());
            codeSnippet.setVariable("aecName", attributedElementClass.getQualifiedName());
            if (attribute.getDefaultValueAsString() == null) {
                codeSnippet.setVariable("defaultValue", "null");
            } else {
                String string = attribute.getDefaultValueAsString().replaceAll("([\\\"])", "\\\\$1");
                string = string.replaceAll("#", "\\u0023");
                codeSnippet.setVariable("defaultValue", "\"" + string + "\"");
            }
            codeList.addNoIndent(codeSnippet);
        }
        return codeList;
    }

    private CodeBlock createConstraints(AttributedElementClass<?, ?> attributedElementClass) {
        CodeList codeList = new CodeList();
        for (Constraint constraint : attributedElementClass.getConstraints()) {
            this.addImports("#jgSchemaImplPackage#.ConstraintImpl");
            CodeSnippet codeSnippet = new CodeSnippet(false, new String[0]);
            codeSnippet.add("#aecVariable#.addConstraint(new ConstraintImpl(#message#, #predicate#, #offendingElements#));");
            codeSnippet.setVariable("message", "\"" + SchemaCodeGenerator.stringQuote(constraint.getMessage()) + "\"");
            codeSnippet.setVariable("predicate", "\"" + SchemaCodeGenerator.stringQuote(constraint.getPredicate()) + "\"");
            if (constraint.getOffendingElementsQuery() != null) {
                codeSnippet.setVariable("offendingElements", "\"" + SchemaCodeGenerator.stringQuote(constraint.getOffendingElementsQuery()) + "\"");
            } else {
                codeSnippet.setVariable("offendingElements", "null");
            }
            codeList.addNoIndent(codeSnippet);
        }
        return codeList;
    }

    private CodeBlock createEnumDomains() {
        CodeList codeList = new CodeList();
        for (EnumDomain enumDomain : this.schema.getEnumDomains()) {
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            codeSnippet.setVariable("domName", enumDomain.getQualifiedName());
            codeList.addNoIndent(codeSnippet);
            this.addImports("#jgSchemaPackage#.EnumDomain");
            codeSnippet.add("{", "\tEnumDomain dom = createEnumDomain(\"#domName#\");");
            for (String string : enumDomain.getConsts()) {
                codeSnippet.add("\tdom.addConst(\"" + string + "\");");
            }
            codeList.add(this.createComments("dom", enumDomain));
            codeList.addNoIndent(new CodeSnippet("}"));
        }
        return codeList;
    }

    private CodeBlock createCompositeDomains() {
        CodeList codeList = new CodeList();
        for (CompositeDomain compositeDomain : this.schema.getCompositeDomains()) {
            CompositeDomain compositeDomain2;
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            codeSnippet.setVariable("domName", compositeDomain.getQualifiedName());
            codeList.addNoIndent(codeSnippet);
            if (compositeDomain instanceof ListDomain) {
                codeSnippet.setVariable("componentDomainName", ((ListDomain)compositeDomain).getBaseDomain().getQualifiedName());
                codeSnippet.add("createListDomain(getDomain(\"#componentDomainName#\"));");
                continue;
            }
            if (compositeDomain instanceof SetDomain) {
                codeSnippet.setVariable("componentDomainName", ((SetDomain)compositeDomain).getBaseDomain().getQualifiedName());
                codeSnippet.add("createSetDomain(getDomain(\"#componentDomainName#\"));");
                continue;
            }
            if (compositeDomain instanceof MapDomain) {
                compositeDomain2 = (MapDomain)compositeDomain;
                codeSnippet.setVariable("keyDomainName", compositeDomain2.getKeyDomain().getQualifiedName());
                codeSnippet.setVariable("valueDomainName", compositeDomain2.getValueDomain().getQualifiedName());
                codeSnippet.add("createMapDomain(getDomain(\"#keyDomainName#\"), getDomain(\"#valueDomainName#\"));");
                continue;
            }
            if (compositeDomain instanceof RecordDomain) {
                this.addImports("#jgSchemaPackage#.RecordDomain");
                codeSnippet.add("{", "\tRecordDomain dom = createRecordDomain(\"#domName#\");");
                compositeDomain2 = (RecordDomain)compositeDomain;
                for (RecordDomain.RecordComponent recordComponent : compositeDomain2.getComponents()) {
                    codeSnippet.add("\tdom.addComponent(\"" + recordComponent.getName() + "\", getDomain(\"" + recordComponent.getDomain().getQualifiedName() + "\"));");
                }
                codeList.add(this.createComments("dom", compositeDomain2));
                codeList.addNoIndent(new CodeSnippet("}"));
                continue;
            }
            throw new RuntimeException("FIXME!");
        }
        return codeList;
    }

    private CodeBlock createReopenMethod() {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("", "@Override", "public boolean reopen() {", "\tthrow new UnsupportedOperationException(\"Cannot reopen a compiled Schema.\");", "}");
        return codeSnippet;
    }
}

