/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.HashSet;
import java.util.TreeSet;

public class GraphCodeGenerator
extends AttributedElementCodeGenerator<GraphClass, Graph> {
    public GraphCodeGenerator(GraphClass graphClass, String string, String string2, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(graphClass, string, codeGeneratorConfiguration);
        this.rootBlock.setVariable("graphElementClass", "Graph");
        this.rootBlock.setVariable("schemaElementClass", "GraphClass");
        this.rootBlock.setVariable("schemaName", string2);
        this.rootBlock.setVariable("theGraph", "this");
        this.interfaces.add("Graph");
    }

    @Override
    protected String getSchemaTypeName() {
        return "GraphClass";
    }

    @Override
    protected CodeBlock createHeader() {
        return super.createHeader();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            this.addImports("#jgImplStdPackage#.#baseClassName#");
            this.rootBlock.setVariable("baseClassName", "GraphImpl");
        }
        codeList.add(this.createGraphElementClassMethods());
        codeList.add(this.createEdgeIteratorMethods());
        codeList.add(this.createVertexIteratorMethods());
        return codeList;
    }

    @Override
    protected CodeBlock createConstructor() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.setVariable("createSuffix", "STANDARD");
        }
        codeSnippet.add("/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#() {", "\tthis(null);", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(int vMax, int eMax) {", "\tthis(null, vMax, eMax);", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(java.lang.String id, int vMax, int eMax) {", "\tsuper(id, #javaClassName#.GC, vMax, eMax);", "\t((de.uni_koblenz.jgralab.impl.InternalAttributedElement) this).internalInitializeAttributesWithDefaultValues();", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(java.lang.String id) {", "\tsuper(id, #javaClassName#.GC);", "\t((de.uni_koblenz.jgralab.impl.InternalAttributedElement) this).internalInitializeAttributesWithDefaultValues();", "}");
        return codeSnippet;
    }

    private CodeBlock createGraphElementClassMethods() {
        CodeList codeList = new CodeList();
        GraphClass graphClass = (GraphClass)this.aec;
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(graphClass.getGraphElementClasses());
        for (GraphElementClass graphElementClass : treeSet) {
            CodeList codeList2 = new CodeList();
            codeList.addNoIndent(codeList2);
            codeList2.addNoIndent(new CodeSnippet(true, "// ------------------------ Code for #ecQualifiedName# ------------------------"));
            codeList2.setVariable("ecSimpleName", graphElementClass.getSimpleName());
            codeList2.setVariable("ecUniqueName", graphElementClass.getUniqueName());
            codeList2.setVariable("ecQualifiedName", graphElementClass.getQualifiedName());
            codeList2.setVariable("ecJavaClassName", this.schemaRootPackageName + "." + graphElementClass.getQualifiedName());
            codeList2.setVariable("ecType", graphElementClass instanceof VertexClass ? "Vertex" : "Edge");
            codeList2.setVariable("ecTypeInComment", graphElementClass instanceof VertexClass ? "vertex" : "edge");
            codeList2.setVariable("ecTypeAecConstant", graphElementClass instanceof VertexClass ? "VC" : "EC");
            codeList2.setVariable("ecCamelName", GraphCodeGenerator.camelCase(graphElementClass.getUniqueName()));
            codeList2.setVariable("ecImplName", graphElementClass.isAbstract() ? "**ERROR**" : GraphCodeGenerator.camelCase(graphElementClass.getQualifiedName()) + "Impl");
            codeList2.addNoIndent(this.createGetFirstMethods(graphElementClass));
            codeList2.addNoIndent(this.createFactoryMethods(graphElementClass));
        }
        return codeList;
    }

    private CodeBlock createGetFirstMethods(GraphElementClass<?, ?> graphElementClass) {
        CodeList codeList = new CodeList();
        if (this.config.hasTypeSpecificMethodsSupport()) {
            codeList.addNoIndent(this.createGetFirstMethod(graphElementClass));
        }
        return codeList;
    }

    private CodeBlock createGetFirstMethod(GraphElementClass<?, ?> graphElementClass) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * @return the first #ecSimpleName# #ecTypeInComment# in this graph");
            codeSnippet.add(" */", "public #ecJavaClassName# getFirst#ecCamelName#();");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public #ecJavaClassName# getFirst#ecCamelName#() {", "\treturn (#ecJavaClassName#)getFirst#ecType#(#ecJavaClassName#.#ecTypeAecConstant#);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createFactoryMethods(GraphElementClass<?, ?> graphElementClass) {
        if (graphElementClass.isAbstract()) {
            return null;
        }
        CodeList codeList = new CodeList();
        codeList.addNoIndent(this.createFactoryMethod(graphElementClass, false));
        if (this.currentCycle.isStdImpl()) {
            codeList.addNoIndent(this.createFactoryMethod(graphElementClass, true));
        }
        return codeList;
    }

    private CodeBlock createFactoryMethod(GraphElementClass<?, ?> graphElementClass, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * Creates a new #ecUniqueName# #ecTypeInComment# in this graph.", " *");
            if (bl) {
                codeSnippet.add(" * @param id the <code>id</code> of the #ecTypeInComment#");
            }
            if (graphElementClass instanceof EdgeClass) {
                codeSnippet.add(" * @param alpha the start vertex of the edge", " * @param omega the target vertex of the edge");
            }
            codeSnippet.add("*/", "public #ecJavaClassName# create#ecCamelName#(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public #ecJavaClassName# create#ecCamelName#(#formalParams#) {", "\treturn graphFactory.<#ecJavaClassName#> create#ecType#(#ecJavaClassName#.#ecTypeAecConstant#, #newActualParams#, this#additionalParams#);", "}");
            codeSnippet.setVariable("additionalParams", "");
        }
        if (graphElementClass instanceof EdgeClass) {
            EdgeClass edgeClass = (EdgeClass)graphElementClass;
            String string = edgeClass.getFrom().getVertexClass().getQualifiedName();
            String string2 = edgeClass.getTo().getVertexClass().getQualifiedName();
            if (string.equals("Vertex")) {
                codeSnippet.setVariable("fromClass", "#jgPackage#.Vertex");
            } else {
                codeSnippet.setVariable("fromClass", "#schemaPackage#." + string);
            }
            if (string2.equals("Vertex")) {
                codeSnippet.setVariable("toClass", "#jgPackage#.Vertex");
            } else {
                codeSnippet.setVariable("toClass", "#schemaPackage#." + string2);
            }
            codeSnippet.setVariable("formalParams", (bl ? "int id, " : "") + "#fromClass# alpha, #toClass# omega");
            codeSnippet.setVariable("addActualParams", ", alpha, omega");
            codeSnippet.setVariable("additionalParams", ", alpha, omega");
        } else {
            codeSnippet.setVariable("formalParams", bl ? "int id" : "");
            codeSnippet.setVariable("addActualParams", "");
        }
        codeSnippet.setVariable("newActualParams", bl ? "id" : "0");
        return codeSnippet;
    }

    private CodeBlock createEdgeIteratorMethods() {
        GraphClass graphClass = (GraphClass)this.aec;
        CodeList codeList = new CodeList();
        if (!this.config.hasTypeSpecificMethodsSupport()) {
            return codeList;
        }
        for (EdgeClass edgeClass : graphClass.getEdgeClasses()) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.EdgeIterable");
            }
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            codeList.addNoIndent(codeSnippet);
            codeSnippet.setVariable("edgeUniqueName", GraphCodeGenerator.camelCase(edgeClass.getUniqueName()));
            codeSnippet.setVariable("edgeQualifiedName", edgeClass.getQualifiedName());
            codeSnippet.setVariable("edgeJavaClassName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
            if (this.currentCycle.isAbstract()) {
                codeSnippet.add("/**");
                codeSnippet.add(" * @return an Iterable for all edges of this graph that are of type #edgeQualifiedName# or subtypes.");
                codeSnippet.add(" */");
                codeSnippet.add("public Iterable<#edgeJavaClassName#> get#edgeUniqueName#Edges();");
            }
            if (this.currentCycle.isStdImpl()) {
                codeSnippet.add("public Iterable<#edgeJavaClassName#> get#edgeUniqueName#Edges() {");
                codeSnippet.add("\treturn new EdgeIterable<#edgeJavaClassName#>(this, #edgeJavaClassName#.EC);");
                codeSnippet.add("}");
            }
            codeSnippet.add("");
        }
        return codeList;
    }

    private CodeBlock createVertexIteratorMethods() {
        GraphClass graphClass = (GraphClass)this.aec;
        CodeList codeList = new CodeList();
        if (!this.config.hasTypeSpecificMethodsSupport()) {
            return codeList;
        }
        HashSet<VertexClass> hashSet = new HashSet<VertexClass>();
        hashSet.addAll(graphClass.getVertexClasses());
        for (VertexClass vertexClass : hashSet) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.VertexIterable");
            }
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            codeList.addNoIndent(codeSnippet);
            codeSnippet.setVariable("vertexQualifiedName", vertexClass.getQualifiedName());
            codeSnippet.setVariable("vertexJavaClassName", "#schemaPackage#." + vertexClass.getQualifiedName());
            codeSnippet.setVariable("vertexCamelName", GraphCodeGenerator.camelCase(vertexClass.getUniqueName()));
            if (this.currentCycle.isAbstract()) {
                codeSnippet.add("/**");
                codeSnippet.add(" * @return an Iterable for all vertices of this graph that are of type #vertexQualifiedName# or subtypes.");
                codeSnippet.add(" */");
                codeSnippet.add("public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices();");
                codeSnippet.add("", "public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices(#jgPackage#.VertexFilter<#vertexJavaClassName#> filter);");
            }
            if (this.currentCycle.isStdImpl()) {
                codeSnippet.add("public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices() {");
                codeSnippet.add("\treturn new VertexIterable<#vertexJavaClassName#>(this, #vertexJavaClassName#.VC, null);");
                codeSnippet.add("}");
                codeSnippet.add("", "public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices(#jgPackage#.VertexFilter<#vertexJavaClassName#> filter) {");
                codeSnippet.add("\treturn new VertexIterable<#vertexJavaClassName#>(this, #vertexJavaClassName#.VC, filter);");
                codeSnippet.add("}");
            }
            codeSnippet.add("");
        }
        return codeList;
    }

    @Override
    protected void addCheckValidityCode(CodeSnippet codeSnippet) {
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        return new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# GC = #schemaPackageName#.#schemaName#.instance().getGraphClass();");
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.GC;", "}");
    }
}

