/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.codegenerator.ImportCodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryJavaSourceFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public abstract class CodeGenerator {
    private final List<GenerationCycle> cycles;
    private int cycleCount = 0;
    private static Logger logger = Logger.getLogger(CodeGenerator.class.getName());
    protected CodeList rootBlock;
    private final ImportCodeSnippet imports;
    protected String schemaRootPackageName;
    protected CodeGeneratorConfiguration config;
    protected GenerationCycle currentCycle;

    public CodeGenerator(String string, String string2, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        this.schemaRootPackageName = string;
        this.config = codeGeneratorConfiguration;
        this.rootBlock = new CodeList(null);
        this.rootBlock.setVariable("jgPackage", "de.uni_koblenz.jgralab");
        this.rootBlock.setVariable("jgTransPackage", "de.uni_koblenz.jgralab.trans");
        this.rootBlock.setVariable("jgImplPackage", "de.uni_koblenz.jgralab.impl");
        this.rootBlock.setVariable("jgImplStdPackage", "de.uni_koblenz.jgralab.impl.std");
        this.rootBlock.setVariable("jgImplTransPackage", "de.uni_koblenz.jgralab.impl.trans");
        this.rootBlock.setVariable("jgImplDbPackage", "de.uni_koblenz.jgralab.impl.db");
        this.rootBlock.setVariable("jgSchemaPackage", "de.uni_koblenz.jgralab.schema");
        this.rootBlock.setVariable("jgSchemaImplPackage", "de.uni_koblenz.jgralab.schema.impl");
        this.rootBlock.setVariable("token", "de.uni_koblenz.jgralab.impl.TgLexer.Token");
        if (string2 != null && !string2.equals("")) {
            this.rootBlock.setVariable("schemaPackage", string + "." + string2);
            this.rootBlock.setVariable("schemaImplStdPackage", string + ".impl.std." + string2);
            this.rootBlock.setVariable("schemaImplTransPackage", string + ".impl.trans." + string2);
            this.rootBlock.setVariable("schemaImplDbPackage", string + ".impl.db." + string2);
        } else {
            this.rootBlock.setVariable("schemaPackage", string);
            this.rootBlock.setVariable("schemaImplStdPackage", string + ".impl.std");
            this.rootBlock.setVariable("schemaImplTransPackage", string + ".impl.trans");
            this.rootBlock.setVariable("schemaImplDbPackage", string + ".impl.db");
        }
        this.rootBlock.setVariable("isClassOnly", "false");
        this.rootBlock.setVariable("isImplementationClassOnly", "false");
        this.rootBlock.setVariable("isAbstractClass", "false");
        this.imports = new ImportCodeSnippet();
        this.cycles = GenerationCycle.filter(codeGeneratorConfiguration);
    }

    protected abstract CodeBlock createHeader();

    protected abstract CodeBlock createBody();

    protected CodeBlock createFooter() {
        return new CodeSnippet("}");
    }

    public static CodeBlock createDisclaimer() {
        return new CodeSnippet("/*", " * This code was generated automatically.", " * Do NOT edit this file, changes will be lost.", " * Instead, change and commit the underlying schema.", " */");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCodeToFile(String string, String string2, String string3) throws GraphIOException {
        string3 = string3.replace(".", File.separator);
        File file = new File(string + string3);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new GraphIOException("'" + file.getAbsolutePath() + "' exists but is not a directory");
            }
        } else if (!file.mkdirs()) {
            throw new GraphIOException("Couldn't create directory hierachy for '" + file + "'.");
        }
        File file2 = null;
        try {
            file2 = new File(file.getAbsolutePath() + File.separator + string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            try {
                bufferedWriter.write(this.rootBlock.getCode());
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new GraphIOException("Unable to create file " + file2.getAbsolutePath(), iOException);
        }
    }

    public void createFiles(String string) throws GraphIOException {
        String string2 = this.rootBlock.getVariable("simpleClassName");
        String string3 = this.rootBlock.getVariable("schemaPackage");
        String string4 = this.rootBlock.getVariable("simpleImplClassName");
        String string5 = "";
        logger.finer("createFiles(\"" + string + "\")");
        logger.finer(" - simpleClassName=" + string2);
        logger.finer(" - schemaPackage=" + string3);
        logger.finer(" - simpleImplClassName=" + string4);
        this.currentCycle = this.getNextCycle();
        while (this.currentCycle != null) {
            this.createCode();
            if (this.currentCycle.isAbstract()) {
                logger.finer("Creating interface for class: " + string2);
                logger.finer("Writing file to: " + string + "/" + string3);
            }
            if (this.currentCycle.isStdImpl()) {
                if (this.currentCycle.isStdImpl()) {
                    string5 = this.rootBlock.getVariable("schemaImplStdPackage");
                    logger.finer(" - schemaImplStdPackage=" + string5);
                }
                this.writeCodeToFile(string, string4 + ".java", string5);
            } else {
                this.writeCodeToFile(string, string2 + ".java", string3);
            }
            this.currentCycle = this.getNextCycle();
        }
    }

    public void createCode() {
        this.imports.clear();
        this.rootBlock.clear();
        this.rootBlock.addNoIndent(CodeGenerator.createDisclaimer());
        this.rootBlock.addNoIndent(this.createPackageDeclaration());
        CodeBlock codeBlock = this.createHeader();
        CodeBlock codeBlock2 = this.createBody();
        CodeBlock codeBlock3 = this.createFooter();
        this.rootBlock.addNoIndent(this.imports);
        this.rootBlock.addNoIndent(codeBlock);
        this.rootBlock.addNoIndent(codeBlock2);
        this.rootBlock.addNoIndent(codeBlock3);
    }

    protected CodeBlock createPackageDeclaration() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (this.rootBlock.getVariable("isClassOnly").equals("true")) {
            codeSnippet.add("package #schemaPackage#;");
        } else {
            switch (this.currentCycle) {
                case ABSTRACT: {
                    codeSnippet.add("package #schemaPackage#;");
                    break;
                }
                case STDIMPL: {
                    codeSnippet.add("package #schemaImplStdPackage#;");
                    break;
                }
                case CLASSONLY: {
                    codeSnippet.add("package #schemaPackage#;");
                }
            }
        }
        return codeSnippet;
    }

    protected void addImports(String ... stringArray) {
        this.imports.add(stringArray);
    }

    public static String camelCase(String string) {
        if (string.length() < 1) {
            return string;
        }
        if (string.length() < 2) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String stringQuote(String string) {
        return string.replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    public Vector<InMemoryJavaSourceFile> createJavaSources() {
        String string = this.rootBlock.getVariable("simpleClassName");
        String string2 = this.rootBlock.getVariable("simpleImplClassName");
        Vector<InMemoryJavaSourceFile> vector = new Vector<InMemoryJavaSourceFile>(2);
        this.currentCycle = this.getNextCycle();
        while (this.currentCycle != null) {
            this.createCode();
            if (this.currentCycle.isStdImpl()) {
                vector.add(new InMemoryJavaSourceFile(string2, this.rootBlock.getCode()));
            } else {
                vector.add(new InMemoryJavaSourceFile(string, this.rootBlock.getCode()));
            }
            this.currentCycle = this.getNextCycle();
        }
        return vector;
    }

    private GenerationCycle getNextCycle() {
        if (this.cycleCount >= this.cycles.size()) {
            return null;
        }
        GenerationCycle generationCycle = this.cycles.get(this.cycleCount);
        if (this.rootBlock.getVariable("isAbstractClass").equals("true") && !generationCycle.isAbstract()) {
            this.cycleCount = 0;
            return null;
        }
        if (this.rootBlock.getVariable("isImplementationClassOnly").equals("true") && generationCycle.isAbstract()) {
            ++this.cycleCount;
            return this.getNextCycle();
        }
        if (this.rootBlock.getVariable("isClassOnly").equals("true")) {
            this.cycleCount = GenerationCycle.CLASSONLY.ordinal() + 1;
            return GenerationCycle.CLASSONLY;
        }
        if (this.rootBlock.getVariable("isClassOnly").equals("false") && generationCycle.isClassOnly()) {
            this.cycleCount = 0;
            return null;
        }
        ++this.cycleCount;
        return generationCycle;
    }

    protected static enum GenerationCycle {
        ABSTRACT,
        STDIMPL,
        CLASSONLY;


        protected static List<GenerationCycle> filter(CodeGeneratorConfiguration codeGeneratorConfiguration) {
            ArrayList<GenerationCycle> arrayList = new ArrayList<GenerationCycle>();
            arrayList.add(ABSTRACT);
            arrayList.add(STDIMPL);
            arrayList.add(CLASSONLY);
            return arrayList;
        }

        protected boolean isStdImpl() {
            return this == STDIMPL;
        }

        protected boolean isAbstract() {
            return this == ABSTRACT;
        }

        protected boolean isClassOnly() {
            return this == CLASSONLY;
        }
    }
}

