/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import java.io.PrintStream;

public class FreeIndexList {
    private int[] runs;
    private int free;
    private int used;
    private int runCount;

    public FreeIndexList(int n) {
        assert (n > 0);
        this.runs = new int[16];
        this.free = n;
        this.used = 0;
        this.runs[0] = n;
        this.runCount = 1;
        assert (this.isHealthy());
    }

    public int allocateIndex() {
        if (this.free == 0) {
            return 0;
        }
        assert (this.runCount > 0);
        int n = 0;
        if (this.runs[0] > 0) {
            n = 1;
            this.runs[0] = this.runs[0] - 1;
            if (this.runs[0] == 0) {
                if (this.runCount > 1) {
                    System.arraycopy(this.runs, 1, this.runs, 0, this.runCount - 1);
                    this.runs[--this.runCount] = 0;
                    this.runs[0] = this.runs[0] - 1;
                } else {
                    this.runs[0] = -1;
                }
            } else {
                if (this.runCount >= this.runs.length) {
                    int[] nArray = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, nArray, 1, this.runs.length);
                    this.runs = nArray;
                } else {
                    System.arraycopy(this.runs, 0, this.runs, 1, this.runCount);
                }
                ++this.runCount;
                this.runs[0] = -1;
            }
        } else {
            assert (this.runCount >= 2);
            n = -this.runs[0] + 1;
            this.runs[0] = this.runs[0] - 1;
            this.runs[1] = this.runs[1] - 1;
            if (this.runs[1] == 0) {
                if (this.runCount > 2) {
                    assert (this.runs[2] < 0);
                    this.runs[0] = this.runs[0] + this.runs[2];
                    System.arraycopy(this.runs, 3, this.runs, 1, this.runCount - 3);
                    this.runs[--this.runCount] = 0;
                    this.runs[--this.runCount] = 0;
                } else {
                    assert (this.runs[this.runCount - 1] == 0);
                    --this.runCount;
                }
            }
        }
        --this.free;
        ++this.used;
        assert (this.isHealthy());
        return n;
    }

    public int allocateIndex(int n) {
        if (this.free == 0) {
            return 0;
        }
        assert (this.runCount > 0);
        assert (n > 0);
        assert (n <= this.used + this.free);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        do {
            n3 = n4;
        } while (n2 < this.runCount && (n4 += this.runs[++n2] < 0 ? -this.runs[n2] : this.runs[n2]) < n);
        if (n2 >= this.runCount) {
            return 0;
        }
        assert (this.runs[n2] > 0) : "The id " + n + " is already in use.";
        if (n == n3 + 1 && n2 > 0 || n == 1) {
            int n5 = n2;
            this.runs[n5] = this.runs[n5] - 1;
            if (this.runs[n2] == 0) {
                this.deleteRun(n2);
                if (this.runCount == 0) {
                    ++this.runCount;
                } else if (n2 > 0) {
                    // empty if block
                }
            } else if (n2 == 0) {
                this.insertNewRun(0);
            } else {
                --n2;
            }
            int n6 = --n2;
            this.runs[n6] = this.runs[n6] - 1;
        } else if (n == n4) {
            if (n2 + 1 == this.runCount) {
                this.insertNewRun(n2 + 1);
            }
            int n7 = n2 + 1;
            this.runs[n7] = this.runs[n7] - 1;
            int n8 = n2;
            this.runs[n8] = this.runs[n8] - 1;
            if (this.runs[n2] == 0) {
                this.deleteRun(n2);
            }
        } else {
            this.insertNewRun(n2);
            this.insertNewRun(n2);
            this.runs[n2] = n - 1 - n3;
            this.runs[n2 + 1] = -1;
            this.runs[n2 + 2] = n4 - n;
        }
        --this.free;
        ++this.used;
        assert (this.isHealthy());
        return n;
    }

    private void deleteRun(int n) {
        assert (this.runs[n] == 0);
        if (n < this.runCount - 1) {
            if (n == 0) {
                if (this.runCount > 1) {
                    System.arraycopy(this.runs, 1, this.runs, 0, this.runCount - n - 1);
                }
            } else {
                int n2 = n - 1;
                this.runs[n2] = this.runs[n2] + this.runs[n + 1];
                this.runs[n + 1] = 0;
                if (n + 1 < this.runCount - 1) {
                    System.arraycopy(this.runs, n + 2, this.runs, n, this.runCount - n - 2);
                }
                --this.runCount;
                this.runs[this.runCount] = 0;
            }
        }
        --this.runCount;
        this.runs[this.runCount] = 0;
    }

    private void insertNewRun(int n) {
        int[] nArray = this.runs;
        if (this.runCount >= this.runs.length) {
            this.runs = new int[this.runs.length * 2];
            System.arraycopy(nArray, 0, this.runs, 0, n);
        }
        if (n < this.runCount) {
            System.arraycopy(nArray, n, this.runs, n + 1, Math.min(this.runCount, nArray.length) - n);
        }
        this.runs[n] = 0;
        ++this.runCount;
    }

    public void freeIndex(int n) {
        this.freeRange(n, 1);
    }

    public void freeRange(int n, int n2) {
        int n3;
        assert (this.runCount > 0);
        assert (n > 0);
        assert (n2 > 0);
        assert (n + n2 - 1 <= this.used + this.free);
        int n4 = 0;
        int n5 = 0;
        do {
            n3 = n4 + 1;
        } while (n > (n4 += Math.abs(this.runs[n5])) && ++n5 < this.runCount);
        assert (n5 < this.runCount) : "freeRange: index " + n + " out of range 1.." + (this.used + this.free);
        assert (this.runs[n5] < 0);
        if (n == n3) {
            assert (n2 <= -this.runs[n5]);
            if (n5 == 0) {
                if (n2 == -this.runs[0]) {
                    if (this.runCount == 1) {
                        this.runs[0] = n2;
                    } else {
                        System.arraycopy(this.runs, 1, this.runs, 0, this.runCount - 1);
                        assert (this.runs[0] > 0);
                        this.runs[--this.runCount] = 0;
                        this.runs[0] = this.runs[0] + n2;
                    }
                } else {
                    if (this.runCount == this.runs.length) {
                        int[] nArray = new int[this.runs.length * 2];
                        System.arraycopy(this.runs, 0, nArray, 1, this.runCount);
                        this.runs = nArray;
                    } else {
                        System.arraycopy(this.runs, 0, this.runs, 1, this.runCount);
                    }
                    ++this.runCount;
                    this.runs[0] = n2;
                    this.runs[1] = this.runs[1] + n2;
                }
            } else {
                assert (this.runs[n5 - 1] > 0);
                if (n2 == -this.runs[n5]) {
                    int n6 = n5 - 1;
                    this.runs[n6] = this.runs[n6] + n2;
                    if (n5 == this.runCount - 1) {
                        this.runs[--this.runCount] = 0;
                    } else {
                        int n7 = n5 - 1;
                        this.runs[n7] = this.runs[n7] + this.runs[n5 + 1];
                        System.arraycopy(this.runs, n5 + 2, this.runs, n5, this.runCount - n5 - 2);
                        this.runs[--this.runCount] = 0;
                        this.runs[--this.runCount] = 0;
                    }
                } else {
                    int n8 = n5 - 1;
                    this.runs[n8] = this.runs[n8] + n2;
                    int n9 = n5;
                    this.runs[n9] = this.runs[n9] + n2;
                }
            }
        } else if (n == n4) {
            assert (n2 == 1);
            if (n5 == this.runCount - 1) {
                if (this.runCount == this.runs.length) {
                    int[] nArray = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, nArray, 0, this.runCount);
                    this.runs = nArray;
                }
                int n10 = n5;
                this.runs[n10] = this.runs[n10] + n2;
                this.runs[this.runCount++] = n2;
            } else {
                assert (this.runs[n5 + 1] > 0);
                int n11 = n5;
                this.runs[n11] = this.runs[n11] + n2;
                assert (this.runs[n5] < 0);
                int n12 = n5 + 1;
                this.runs[n12] = this.runs[n12] + n2;
            }
        } else {
            assert (n - n3 + n2 <= -this.runs[n5]);
            if (n + n2 == n4 + 1) {
                if (n5 == this.runCount - 1) {
                    if (this.runCount == this.runs.length) {
                        int[] nArray = new int[this.runs.length * 2];
                        System.arraycopy(this.runs, 0, nArray, 0, this.runCount);
                        this.runs = nArray;
                    }
                    int n13 = n5;
                    this.runs[n13] = this.runs[n13] + n2;
                    this.runs[this.runCount++] = n2;
                } else {
                    assert (this.runs[n5 + 1] > 0);
                    int n14 = n5;
                    this.runs[n14] = this.runs[n14] + n2;
                    int n15 = n5 + 1;
                    this.runs[n15] = this.runs[n15] + n2;
                }
                assert (this.runs[n5] < 0);
            } else {
                int n16 = this.runs[n5];
                if (this.runCount + 2 > this.runs.length) {
                    int[] nArray = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, nArray, 0, n5);
                    System.arraycopy(this.runs, n5 + 1, nArray, n5 + 3, this.runCount - n5 - 1);
                    this.runs = nArray;
                } else {
                    System.arraycopy(this.runs, n5 + 1, this.runs, n5 + 3, this.runCount - n5 - 1);
                }
                this.runCount += 2;
                this.runs[n5] = -(n - n3);
                this.runs[n5 + 1] = n2;
                this.runs[n5 + 2] = n16 + (n - n3) + n2;
            }
        }
        this.used -= n2;
        this.free += n2;
        assert (this.isHealthy());
    }

    private void printArray(PrintStream printStream) {
        printStream.println("---------------------------------------------------");
        printStream.println(this);
        printStream.println("free=" + this.free + ", used=" + this.used + ", length=" + this.runs.length + ", runCount=" + this.runCount);
        printStream.print(" [");
        for (int n : this.runs) {
            printStream.print(" " + n);
        }
        printStream.println(" ]");
        printStream.println("---------------------------------------------------");
        printStream.flush();
    }

    public void reinitialize(Object[] objectArray) {
        int n = 1;
        this.free = 0;
        this.used = 0;
        this.runCount = 0;
        while (n < objectArray.length) {
            int[] nArray;
            int n2 = 0;
            while (n < objectArray.length && objectArray[n] != null) {
                ++n;
                ++n2;
            }
            if (n2 > 0) {
                if (this.runCount == this.runs.length) {
                    nArray = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, nArray, 0, this.runCount);
                    this.runs = nArray;
                }
                this.runs[this.runCount++] = -n2;
                this.used += n2;
            }
            n2 = 0;
            while (n < objectArray.length && objectArray[n] == null) {
                ++n;
                ++n2;
            }
            if (n2 <= 0) continue;
            if (this.runCount == this.runs.length) {
                nArray = new int[this.runs.length * 2];
                System.arraycopy(this.runs, 0, nArray, 0, this.runCount);
                this.runs = nArray;
            }
            this.runs[this.runCount++] = n2;
            this.free += n2;
        }
        assert (this.used + this.free + 1 == objectArray.length);
        assert (this.isHealthy());
    }

    private boolean isHealthy() {
        int n;
        assert (this.runCount > 0);
        assert (this.free >= 0);
        assert (this.used >= 0);
        int n2 = 0;
        for (n = 0; n < this.runCount; ++n) {
            assert (this.runs[n] != 0) : "runs[" + n + "] must be != 0";
            if (n > 0) assert (this.runs[n - 1] > 0 && this.runs[n] < 0 || this.runs[n - 1] < 0 && this.runs[n] > 0) : "used and free runs must alternate";
            n2 += Math.abs(this.runs[n]);
        }
        for (n = this.runCount; n < this.runs.length; ++n) {
            assert (this.runs[n] == 0) : "runs[" + n + "] must be == 0";
        }
        assert (n2 == this.used + this.free);
        return true;
    }

    public int getFree() {
        return this.free;
    }

    public int getSize() {
        return this.used + this.free;
    }

    public int getUsed() {
        return this.used;
    }

    public void expandBy(int n) {
        assert (n > 0);
        if (this.runs[this.runCount - 1] > 0) {
            int n2 = this.runCount - 1;
            this.runs[n2] = this.runs[n2] + n;
        } else {
            if (this.runCount == this.runs.length) {
                int[] nArray = new int[this.runs.length * 2];
                System.arraycopy(this.runs, 0, nArray, 0, this.runCount);
                this.runs = nArray;
            }
            this.runs[this.runCount++] = n;
        }
        this.free += n;
        assert (this.isHealthy());
    }

    public boolean isFragmented() {
        return this.runCount > 2 || this.runCount == 2 && this.runs[0] > 0;
    }
}

