/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.pcollections.ArrayPMap;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class HTMLOutputWriter
extends DefaultWriter {
    private boolean createElementLinks = false;
    private boolean useCss = true;
    private PrintWriter out;

    public HTMLOutputWriter() {
        this(null);
    }

    public HTMLOutputWriter(Graph graph) {
        super(graph);
    }

    @Override
    public void writeValue(Object object, File file) throws IOException, SerialisingException {
        this.out = null;
        try {
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            this.writeValue(object);
        }
        catch (SerialisingException serialisingException) {
            throw serialisingException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SerialisingException("Unhandled Exception", this.rootValue, exception);
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
    }

    public boolean isCreateElementLinks() {
        return this.createElementLinks;
    }

    public void setCreateElementLinks(boolean bl) {
        this.createElementLinks = bl;
    }

    public boolean isUseCss() {
        return this.useCss;
    }

    public void setUseCss(boolean bl) {
        this.useCss = bl;
    }

    @Override
    protected void write(Object object) throws IOException {
        try {
            super.write(object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SerialisingException serialisingException) {
            throw serialisingException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected Exception", exception);
        }
    }

    @Override
    protected void writePathSystem(PathSystem pathSystem) throws Exception {
        this.writeDefaultObject(pathSystem);
    }

    private String htmlQuote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    protected void pre() throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
    }

    @Override
    protected void post() throws IOException {
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void inter() throws IOException {
        this.out.println("</td></tr><tr><td>");
    }

    @Override
    protected void writeTuple(Tuple tuple) throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
        boolean bl = true;
        for (Object object : tuple) {
            if (bl) {
                bl = false;
            } else {
                this.out.println("</td><td>");
            }
            this.write(object);
        }
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void writeRecord(Record record) throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
        boolean bl = true;
        for (String string : record.getComponentNames()) {
            if (bl) {
                bl = false;
            } else {
                this.out.println("</td><td>");
            }
            this.out.println(string + ": ");
            this.write(record.getComponent(string));
        }
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void writeTable(Table<?> table) throws IOException {
        this.out.print(this.table(1, 2) + "<tr><th>");
        boolean bl = true;
        for (Object object : table.getTitles()) {
            if (bl) {
                bl = false;
            } else {
                this.out.print("</th><th>");
            }
            this.write(object);
        }
        this.out.println("</th></tr>");
        for (Object object : table) {
            this.out.println("<tr><td>");
            if (object instanceof Tuple) {
                bl = true;
                for (Object object2 : (Tuple)object) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.out.println("</td><td>");
                    }
                    this.write(object2);
                }
            } else {
                this.write(object);
            }
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
    }

    @Override
    protected void writePath(Path path) throws IOException {
        boolean bl = true;
        this.pre();
        PVector<Edge> pVector = path.getEdgeTrace();
        PVector<Vertex> pVector2 = path.getVertexTrace();
        for (int i = 0; i < pVector2.size() - 1; ++i) {
            if (bl) {
                bl = false;
                this.write(pVector2.get(i));
            }
            this.inter();
            this.write(pVector.get(i));
            this.inter();
            this.write(pVector2.get(i + 1));
        }
        this.post();
    }

    @Override
    protected void writeVertex(Vertex vertex) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"v" + vertex.getId() + "\">v" + vertex.getId() + ": " + vertex.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println("v" + vertex.getId() + ": " + vertex.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeEdge(Edge edge) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"e" + edge.getId() + "\">e" + edge.getId() + ": " + edge.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println("e" + edge.getId() + ": " + edge.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeInteger(Integer n) throws IOException {
        this.out.println(n.toString());
    }

    @Override
    protected void writeLong(Long l) throws IOException {
        this.out.println(l.toString());
    }

    @Override
    protected void writeDouble(Double d) throws IOException {
        this.out.println(d.toString());
    }

    @Override
    protected void writeString(String string) throws IOException {
        this.out.println(this.htmlQuote(string));
    }

    @Override
    protected void writeEnum(Enum<?> enum_) throws IOException {
        String string = enum_.toString();
        this.out.println(string);
    }

    @Override
    protected void writeGraph(Graph graph) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"g" + graph.getId() + "\">" + graph.getId() + ": " + graph.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println(graph.getId() + ": " + graph.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeBoolean(Boolean bl) throws IOException {
        if (bl != null) {
            this.out.println(bl.toString());
        } else {
            this.out.println("null");
        }
    }

    @Override
    protected void writeDefaultObject(Object object) throws IOException {
        this.out.println("<pre>");
        this.out.println(this.htmlQuote(object.toString()));
        this.out.println("</pre>");
    }

    @Override
    protected void writeAttributedElementClass(AttributedElementClass<?, ?> attributedElementClass) throws IOException {
        this.out.println(attributedElementClass.getQualifiedName());
    }

    @Override
    protected void writePVector(PVector<?> pVector) throws Exception {
        if (pVector.size() > 0 && pVector.get(0) instanceof Tuple) {
            this.writeTableOfTuples(pVector);
        } else {
            super.writePVector(pVector);
        }
    }

    private void writeTableOfTuples(PCollection<?> pCollection) throws IOException {
        this.out.print(this.table(1, 2));
        boolean bl = true;
        for (Object e : pCollection) {
            this.out.println("<tr><td>");
            if (e instanceof Tuple) {
                bl = true;
                for (Object object : (Tuple)e) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.out.println("</td><td>");
                    }
                    this.write(object);
                }
            } else {
                this.write(e);
            }
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
    }

    @Override
    protected void writePSet(PSet<?> pSet) throws Exception {
        if (pSet.size() > 0 && pSet instanceof POrderedSet && ((POrderedSet)pSet).get(0) instanceof Tuple) {
            this.writeTableOfTuples(pSet);
            return;
        }
        super.writePSet(pSet);
    }

    @Override
    protected void writePMap(PMap<?, ?> pMap) throws Exception {
        this.out.print(this.table(1, 2));
        if (pMap instanceof ArrayPMap) {
            ArrayPMap arrayPMap = (ArrayPMap)pMap;
            for (Map.Entry entry : arrayPMap) {
                this.out.print("<tr><td>");
                this.write(entry.getKey());
                this.out.print("</td><td>");
                this.write(entry.getValue());
                this.out.print("</td></tr>");
            }
        } else {
            for (Map.Entry entry : pMap.entrySet()) {
                this.out.print("<tr><td>");
                this.write(entry.getKey());
                this.out.print("</td><td>");
                this.write(entry.getValue());
                this.out.print("</td></tr>");
            }
        }
        this.out.print("</table>");
    }

    @Override
    protected void head() throws IOException {
        this.out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
        if (this.useCss) {
            this.out.println("<style type=\"text/css\">");
            this.out.println("table { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("td { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("th { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("</style>\n");
        }
        this.out.println("</head><body>");
        if (this.getGraph() != null) {
            this.out.print("<p>Graph id: " + this.getGraph().getId() + "</p>");
        }
        this.out.print("<p>Result size: ");
        if (this.rootValue instanceof PCollection) {
            this.out.println(Integer.toString(((PCollection)this.rootValue).size()));
        } else {
            this.out.println("1");
        }
        this.out.println("</p><hr/>");
    }

    private String table(int n, int n2) {
        return this.table(n, n2, 0);
    }

    private String table(int n, int n2, int n3) {
        return "<table border=\"" + n + "\" cellpadding=\"" + n2 + "\" cellspacing=\"" + n3 + "\">";
    }

    @Override
    protected void writeUndefined() throws Exception {
        this.out.print("&not;");
    }

    @Override
    protected void foot() throws IOException {
        this.out.println("</body></html>");
    }
}

