/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.And;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Or;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import java.util.ArrayList;

public class Not
extends Formula {
    protected Formula formula;

    public Not(GreqlQuery greqlQuery, Formula formula) {
        super(greqlQuery);
        this.formula = formula;
    }

    @Override
    public String toString() {
        return "~" + this.formula;
    }

    @Override
    public Expression toExpression() {
        GreqlGraph greqlGraph = this.query.getQueryGraph();
        FunctionApplication functionApplication = greqlGraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("not", greqlGraph);
        greqlGraph.createIsFunctionIdOf(functionId, functionApplication);
        greqlGraph.createIsArgumentOf(this.formula.toExpression(), functionApplication);
        return functionApplication;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        return this.formula.getNonConstantTermExpressions();
    }

    @Override
    protected Formula calculateReplacementFormula(Expression expression, Literal literal) {
        return new Not(this.query, this.formula.calculateReplacementFormula(expression, literal));
    }

    @Override
    public Formula simplify() {
        Formula formula = this.formula.simplify();
        if (formula instanceof True) {
            return new False(this.query);
        }
        if (formula instanceof False) {
            return new True(this.query);
        }
        if (formula instanceof Not) {
            Not not = (Not)formula;
            return not.formula.simplify();
        }
        if (formula instanceof And) {
            And and = (And)formula;
            Formula formula2 = and.leftHandSide;
            Formula formula3 = and.rightHandSide;
            return new Or(this.query, new Not(this.query, formula2), new Not(this.query, formula3)).simplify();
        }
        if (formula instanceof Or) {
            Or or = (Or)formula;
            Formula formula4 = or.leftHandSide;
            Formula formula5 = or.rightHandSide;
            return new And(this.query, new Not(this.query, formula4), new Not(this.query, formula5)).simplify();
        }
        return new Not(this.query, formula);
    }

    @Override
    public double getSelectivity() {
        double d = 1.0 - this.formula.getSelectivity();
        logger.finer("selectivity[" + this + "] = " + d);
        return d;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Not) {
            Not not = (Not)object;
            return this.formula.equals(not.formula);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 23;
        int n2 = 37;
        return n * n2 + this.formula.hashCode();
    }
}

