/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import org.pcollections.PCollection;

@NeedsGraphArgument
public class VertexSetSubgraph
extends Function {
    @Description(params={"graph", "vertexSet"}, description="Returns the subgraph induced by the vertex set, i.e. the vertices in vertexSet together with all edges between vertices in vertexSet.", categories={Function.Category.GRAPH})
    public VertexSetSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, PCollection<Vertex> pCollection) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Vertex vertex : pCollection) {
            subGraphMarker.mark(vertex);
        }
        for (Vertex vertex : pCollection) {
            for (Edge edge = vertex.getFirstIncidence(EdgeDirection.OUT); edge != null; edge = edge.getNextIncidence(EdgeDirection.OUT)) {
                if (!subGraphMarker.isMarked(edge.getThat())) continue;
                subGraphMarker.mark(edge);
            }
        }
        return subGraphMarker;
    }
}

