/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.plist;

import de.uni_koblenz.ist.utilities.plist.PList;
import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.plist.PListException;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.AbstractGraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;

public class PListGraphLayoutReader
extends AbstractGraphLayoutReader {
    public PListGraphLayoutReader(GreqlEvaluatorFacade greqlEvaluatorFacade) {
        super(greqlEvaluatorFacade);
    }

    @Override
    public void startProcessing(File file, GraphLayout graphLayout) throws FileNotFoundException {
        this.startProcessing(file.getPath(), graphLayout);
    }

    @Override
    public void startProcessing(String string, GraphLayout graphLayout) throws FileNotFoundException {
        this.graphLayout = graphLayout;
        try {
            PList pList = new PList(string);
            PListDict pListDict = pList.getDict();
            this.readOut(pListDict);
        }
        catch (PListException pListException) {
            pListException.printStackTrace();
        }
    }

    private void readOut(PListDict pListDict) {
        for (Map.Entry<String, Object> entry : pListDict.entrySet()) {
            String string = entry.getKey();
            if (this.isGlobalVariable(string)) {
                this.processGlobalVariable(string, pListDict.getString(string, "''"));
                continue;
            }
            this.definitionStarted(string);
            this.processDefinitionAttributes(pListDict.getDict(string));
            this.definitionEnded();
        }
    }

    private void processDefinitionAttributes(PListDict pListDict) {
        for (Map.Entry<String, Object> entry : pListDict.entrySet()) {
            this.processDefinitionAttribute(entry.getKey(), entry.getValue().toString());
        }
    }
}

