/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import java.util.Vector;

public class CodeSnippet
extends CodeBlock {
    protected Vector<String> lines;
    protected boolean wantsNewLine;

    public CodeSnippet() {
        this((CodeList)null, new String[0]);
    }

    public CodeSnippet(String ... stringArray) {
        this(null, false, stringArray);
    }

    public CodeSnippet(boolean bl, String ... stringArray) {
        this(null, bl, stringArray);
    }

    public CodeSnippet(CodeList codeList, String ... stringArray) {
        this(codeList, false, stringArray);
    }

    public CodeSnippet(CodeList codeList, boolean bl, String ... stringArray) {
        super(codeList);
        this.wantsNewLine = bl;
        this.lines = new Vector();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.lines.add(string);
            }
        }
    }

    public void setNewLine(boolean bl) {
        this.wantsNewLine = bl;
    }

    public void add(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.lines.add(string);
            }
        }
    }

    @Override
    public String getCode(int n) {
        if (this.lines.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.wantsNewLine) {
            stringBuilder.append("\n");
        }
        for (String string : this.lines) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('\t');
            }
            if (string.length() > 0) {
                stringBuilder.append(this.replaceVariables(string));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public int size() {
        return this.lines.size();
    }
}

