/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class VertexIterator<V extends Vertex>
implements Iterator<V> {
    protected V current = null;
    protected InternalGraph graph = null;
    protected VertexClass schemaVc;
    protected long vertexListVersion;
    private VertexFilter<V> filter;

    public VertexIterator(InternalGraph internalGraph, VertexClass vertexClass, VertexFilter<V> vertexFilter) {
        this.graph = internalGraph;
        this.schemaVc = vertexClass;
        this.filter = vertexFilter;
        this.vertexListVersion = internalGraph.getVertexListVersion();
        Vertex vertex = this.current = vertexClass == null ? this.graph.getFirstVertex() : this.graph.getFirstVertex(vertexClass);
        if (this.current != null && vertexFilter != null && !vertexFilter.accepts(this.current)) {
            this.getNext();
        }
    }

    @Override
    public V next() {
        if (this.graph.isVertexListModified(this.vertexListVersion)) {
            throw new ConcurrentModificationException("The vertex list of the graph has been modified - the iterator is not longer valid");
        }
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        V v = this.current;
        this.current = this.getNext();
        return v;
    }

    private V getNext() {
        do {
            Vertex vertex = this.current = this.schemaVc == null ? this.current.getNextVertex() : this.current.getNextVertex(this.schemaVc);
        } while (this.current != null && this.filter != null && !this.filter.accepts(this.current));
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("It is not allowed to remove vertices during iteration.");
    }
}

